/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.awt.Rectangle;
import javax.swing.ListCellRenderer;
import oracle.ide.Context;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateArb;
import oracle.jdeveloper.ceditor.template.TemplateController;
import oracle.jdeveloper.ceditor.template.TemplateHintCellRenderer;
import oracle.jdeveloper.ceditor.template.TemplateItem;
import oracle.jdeveloper.ceditor.template.TemplateListData;

final class TemplateListInsight
extends AbstractInsight
implements InsightProvider {
    private BasicEditorPane _editor;
    private Context _context;
    private int _lastOffset;
    private TemplateListData asData;
    private Rectangle asRect;

    TemplateListInsight(Context context, TemplateItem[] templateChoices, String filter, Rectangle importRect) {
        this._context = context;
        this._editor = TemplateController.getEditor(context);
        this.asData = new TemplateListData(templateChoices, filter);
        this.asRect = importRect;
    }

    public void install(BasicEditorPane editor) {
        super.install(editor);
        this._lastOffset = this._editor.getCaretPosition();
    }

    public void deinstall(BasicEditorPane editor) {
        super.deinstall(editor);
    }

    protected InsightProvider createInsightProvider() {
        return this;
    }

    public boolean isInsightTriggerChar(char typedChar) {
        return false;
    }

    public void characterTyped(BasicEditorPane editorPane, int offset, char typedChar) {
        this._lastOffset = this._editor.getCaretPosition();
        this.asData.charTyped(typedChar);
        this.updateInsight();
    }

    public Rectangle getShowRectangle() {
        return this.asRect;
    }

    public void hideInsight() {
        super.hideInsight();
        if (TemplateController._templateInsight != null) {
            this._editor.deinstallPlugin((EditorPlugin)TemplateController._templateInsight);
        }
        TemplateController._templateInsight = null;
    }

    protected int[] getPreferredLocations() {
        return AbstractInsight.COMPLETION_LOCATIONS;
    }

    public InsightData getInsightData(BasicEditorPane editorPane) {
        return this.asData;
    }

    public InsightData updateInsightData(BasicEditorPane editorPane, InsightData lastData) {
        if (this._editor.getCaretPosition() < this._lastOffset - 1 || this._editor.getCaretPosition() > this._lastOffset + 1) {
            return null;
        }
        return lastData;
    }

    public InsightView getInsightView() {
        return new ListInsightView((ListCellRenderer)new TemplateHintCellRenderer());
    }

    public boolean invokeAction(String actionKey) {
        if (actionKey.equals("insert-break")) {
            return this.handleCompleteCommand(this._editor);
        }
        if (actionKey.equals("delete-previous")) {
            boolean result = super.invokeAction(actionKey);
            this._lastOffset = this._editor.getCaretPosition();
            if (this.asData.backSpace()) {
                this.updateInsight();
            }
            return result;
        }
        return super.invokeAction(actionKey);
    }

    protected boolean handleCompleteCommand(BasicEditorPane editor) {
        super.handleCompleteCommand(editor);
        this.hideInsight();
        int templateSnippetStart = -1;
        int templateSnippetEnd = -1;
        try {
            try {
                Template t = this.asData.getTemplate();
                String curFilter = this.asData.getFilter();
                String tshort = t.getShortcut();
                int end = this._editor.getCaretPosition();
                this._editor.beginEdit(new EditDescriptor(TemplateArb.getString(16)));
                int start = end - curFilter.length();
                this._editor.select(start, end);
                this._editor.replaceSelection(tshort);
                templateSnippetStart = start;
                templateSnippetEnd = end + tshort.length() - curFilter.length();
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl = false;
                this._editor.endEdit();
                if (templateSnippetStart > 0 && templateSnippetEnd > 0) {
                    TemplateController.replaceTemplateNameWithTemplateCode(this._editor, this._context, templateSnippetStart, templateSnippetEnd);
                }
                return bl;
            }
        }
        finally {
            this._editor.endEdit();
            if (templateSnippetStart > 0 && templateSnippetEnd > 0) {
                TemplateController.replaceTemplateNameWithTemplateCode(this._editor, this._context, templateSnippetStart, templateSnippetEnd);
            }
        }
        return true;
    }
}

