/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.io.File;
import oracle.ide.migration.Migrator;
import oracle.jdeveloper.ceditor.template.TemplateArb;
import oracle.jdeveloper.ceditor.template.Templates;

public class TemplateMigrator
implements Migrator {
    private static final int CATEGORY_TEMPLATES = 0;
    private boolean _isSelected;

    private void $init$() {
        this._isSelected = true;
    }

    public boolean canMigrate(int category, File sourceDir) {
        boolean ret = false;
        switch (category) {
            case 0: {
                File file = new File(sourceDir, "java.tpl");
                if (!file.exists() || !file.canRead()) break;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public String getDescription(int category) {
        String ret = null;
        switch (category) {
            case 0: {
                ret = TemplateArb.getString(19);
                break;
            }
        }
        return ret;
    }

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public boolean isSelected(int category) {
        return category == 0 && this._isSelected;
    }

    public String[] migrate(File sourceDir, File destDir) {
        if (!this.isSelected(0)) {
            return null;
        }
        Templates oldTemplates = new Templates();
        Templates newTemplates = new Templates();
        File oldFile = new File(sourceDir, "java.tpl");
        oldTemplates.load(oldFile);
        File newFile = new File(destDir, "java.tpl");
        newTemplates.load(newFile);
        oldTemplates.merge(newTemplates);
        oldTemplates.save(newFile);
        return new String[0];
    }

    public void setSelected(int category, boolean selected) {
        if (category == 0) {
            this._isSelected = selected;
        }
    }

    public TemplateMigrator() {
        this.$init$();
    }
}

