/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.io.PrintWriter;
import java.util.ArrayList;
import oracle.jdeveloper.ceditor.template.DefaultVariableProcessor;
import oracle.jdeveloper.ceditor.template.HintChoice;
import oracle.jdeveloper.ceditor.template.TemplateContext;
import oracle.jdeveloper.ceditor.template.TemplateVariableProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateVariable
implements Comparable {
    public static final String XML_VARIABLE = "variable";
    public static final String XML_NAME = "name";
    public static final String XML_TYPE = "type";
    public static final String XML_VALUE = "value";
    public static final String XML_ISEDIT = "editable";
    private static ArrayList _registeredProcessors = new ArrayList();
    private String _name;
    private String _type;
    private String _defValue;
    private boolean _editable;
    private TemplateVariableProcessor _processor;

    private void $init$() {
        this._processor = null;
    }

    public TemplateVariable(String name, String type, String defValue, boolean editable) {
        this.$init$();
        this._name = name;
        this._type = type;
        this._defValue = defValue;
        this._editable = editable;
    }

    public TemplateVariable(TemplateVariable org) {
        this(org._name, org._type, org._defValue, org._editable);
    }

    public int compareTo(Object o) {
        TemplateVariable t = (TemplateVariable)o;
        return this._name.compareTo(t._name);
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public void setDefValue(String defValue) {
        this._defValue = defValue;
    }

    public String getDefValue() {
        return this._defValue;
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public static void registerVariableProcessor(TemplateVariableProcessor processor) {
        _registeredProcessors.add(0, processor);
    }

    static {
        TemplateVariable.registerVariableProcessor(new DefaultVariableProcessor());
    }

    private void checkProcessor(TemplateContext ctx) {
        if (this._processor == null) {
            int i = 0;
            while (i < _registeredProcessors.size()) {
                TemplateVariableProcessor proc = (TemplateVariableProcessor)_registeredProcessors.get(i);
                if (proc.canProcessVariable(ctx, this)) {
                    this._processor = proc;
                    return;
                }
                ++i;
            }
            System.out.println("Warning can't find variable processor for " + this.getType());
        }
    }

    public String arrayToList(Object[] objs) {
        if (objs == null) {
            return "<NULL_LIST>";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < objs.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(objs[i]);
            ++i;
        }
        return sb.toString();
    }

    public HintChoice[] getHints(TemplateContext ctx, int offset) {
        this.checkProcessor(ctx);
        return this._processor.getHints(ctx, this, offset);
    }

    public boolean isCalculatedField(TemplateContext ctx) {
        this.checkProcessor(ctx);
        return this._processor.canProcessVariable(ctx, this);
    }

    public String guessValue(TemplateContext ctx, int offset) {
        return this.guessValue(ctx, offset, null);
    }

    public String guessValue(TemplateContext ctx, int offset, String oldValue) {
        this.checkProcessor(ctx);
        return this._processor.guessValue(ctx, this, offset, oldValue);
    }

    public void toXML(PrintWriter out) {
        out.println("  <variable>");
        out.println("    <name><![CDATA[" + this._name + "]]></" + XML_NAME + ">");
        out.println("    <type><![CDATA[" + this._type + "]]></" + XML_TYPE + ">");
        out.println("    <value><![CDATA[" + this._defValue + "]]></" + XML_VALUE + ">");
        out.println("    <editable>" + this._editable + "</" + XML_ISEDIT + ">");
        out.println("  </variable>");
    }
}

