/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.ChangeEventSource;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateVariable;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class Templates
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "code-template-options";
    static final String TEMPLATES_FILE = "java.tpl";
    private static final String LANGAGE = "java";
    static final String XML_TEMPLATE = "template";
    static final String XML_ITEM = "item";
    static final String XML_ABBR = "abbr";
    static final String XML_TEXT = "text";
    static final String XML_TEXT1 = "text1";
    static final String XML_TEXT2 = "text2";
    static final String XML_IMPORT = "import";
    static final String XML_VARIABLES = "variables";
    static final String XML_DESCR = "descr";
    private ArrayList _templates;
    private int _nLongestShortcut;
    private static final String END_VARIABLE = "$end$";

    Templates() {
    }

    protected final void copyToImpl(Templates copy) {
        int n = this.getTemplateCount();
        copy._templates = new ArrayList(n);
        int i = 0;
        while (i < n) {
            Template tThis = this.getTemplate(i);
            Template tCopy = (Template)tThis.copyTo(null);
            copy._templates.add(tCopy);
            ++i;
        }
        copy.postModification();
        copy.fireChangeEvent();
    }

    void toXML(PrintWriter out) {
        out.println("<template langage=\"java\">");
        int n = this.getTemplateCount();
        int i = 0;
        while (i < n) {
            Template t = this.getTemplate(i);
            t.toXML(out);
            ++i;
        }
        out.println("</template>");
    }

    int getTemplateCount() {
        return this._templates.size();
    }

    Template getTemplate(int nPos) {
        return (Template)this._templates.get(nPos);
    }

    public Template[] getSortedTemplates() {
        Template[] res = new Template[this._templates.size()];
        res = this._templates.toArray(res);
        Arrays.sort(res, new 1());
        return res;
    }

    private int getTemplatePosByShortcut(String shortcut) {
        int i = 0;
        while (i < this._templates.size()) {
            Template template = (Template)this._templates.get(i);
            if (shortcut.equalsIgnoreCase(template.getShortcut())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int addTemplate(Template t) {
        int nPos = this.searchTemplatePosEndingWith(t.getShortcut());
        if (nPos == -1) {
            nPos = this.getTemplateCount();
            this._templates.add(t);
        } else {
            this._templates.set(nPos, t);
        }
        return nPos;
    }

    void removeTemplate(Template t) {
        int nPos = this.searchTemplatePosEndingWith(t.getShortcut());
        this.removeTemplate(nPos);
    }

    void removeTemplate(int nPos) {
        if (nPos != -1) {
            this._templates.remove(nPos);
        }
    }

    private void postModification() {
        Collections.sort(this._templates, new 2());
        this.recalcLongestShortcut();
    }

    private void recalcLongestShortcut() {
        Template template;
        String shortcut;
        this._nLongestShortcut = 0;
        if (this._templates.size() != 0 && (shortcut = (template = this.getTemplate(0)).getShortcut()) != null) {
            this._nLongestShortcut = shortcut.length();
        }
    }

    void load() {
        ExtensionRegistry er = ExtensionRegistry.getOracleRegistry();
        URL url = er.getSystemDirectory("oracle.jdeveloper");
        File f = new File(url.getPath(), TEMPLATES_FILE);
        this.load(f);
    }

    void save() {
        ExtensionRegistry er = ExtensionRegistry.getOracleRegistry();
        URL url = er.getSystemDirectory("oracle.jdeveloper");
        File f = new File(url.getPath(), TEMPLATES_FILE);
        this.save(f);
    }

    void load(File f) {
        this._templates = new ArrayList();
        this._nLongestShortcut = 0;
        try {
            try {
                FileInputStream is = new FileInputStream(f);
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                DOMParser domParser = new DOMParser();
                domParser.setPreserveWhitespace(false);
                domParser.setDoctype(new DTD());
                domParser.parse((Reader)br);
                br.close();
                XMLDocument xdoc = domParser.getDocument();
                Element root = xdoc.getDocumentElement();
                this.loadTemplates(root);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.postModification();
        }
    }

    void save(File f) {
        try {
            FileWriter fw = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter out = new PrintWriter(bw);
            this.toXML(out);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadTemplates(Element root) {
        NodeList nodes = root.getElementsByTagName(XML_ITEM);
        int n = nodes.getLength();
        int i = 0;
        while (i < n) {
            Element item = (Element)nodes.item(i);
            this.loadTemplate(item);
            ++i;
        }
    }

    private void loadTemplate(Element item) {
        String sAbbr = this.getValue(item, XML_ABBR);
        if (sAbbr != null) {
            String sDesc = this.getValue(item, XML_DESCR);
            String sText = this.getValue(item, XML_TEXT);
            if (sText == null) {
                String sText2;
                String sText1 = this.getValue(item, XML_TEXT1);
                if (sText1 == null) {
                    sText1 = "";
                }
                if ((sText2 = this.getValue(item, XML_TEXT2)) != null && sText1.indexOf(END_VARIABLE) == -1) {
                    sText1 = sText1 + END_VARIABLE + sText2;
                }
                sText = sText1;
            }
            Template t = new Template(sAbbr, sDesc, sText);
            NodeList nodes = item.getElementsByTagName(XML_IMPORT);
            int n = nodes.getLength();
            int i = 0;
            while (i < n) {
                Node nImport = nodes.item(i);
                String s = this.getValue(nImport);
                if (s != null) {
                    t.addImport(s);
                }
                ++i;
            }
            nodes = item.getElementsByTagName("variable");
            n = nodes.getLength();
            int i2 = 0;
            while (i2 < n) {
                Element varitem = (Element)nodes.item(i2);
                String name = this.getValue(varitem, "name");
                String type = this.getValue(varitem, "type");
                String value = this.getValue(varitem, "value");
                String editable = this.getValue(varitem, "editable");
                t.addVariable(new TemplateVariable(name, type, value, editable.equals("true")));
                ++i2;
            }
            this._templates.add(t);
        }
    }

    private String getValue(Element item, String s) {
        String sRet = null;
        NodeList nodes = item.getElementsByTagName(s);
        if (nodes.getLength() > 0) {
            Node n = nodes.item(0);
            sRet = this.getValue(n);
        }
        return sRet;
    }

    private String getValue(Node n) {
        Node nChild;
        String sRet = null;
        if (n != null && (nChild = n.getFirstChild()) != null) {
            sRet = nChild.getNodeValue();
        }
        return sRet;
    }

    int getLongestShortcut() {
        return this._nLongestShortcut;
    }

    int searchTemplatePosEndingWith(String sText) {
        int n = this._templates.size();
        int i = 0;
        while (i < n) {
            Template t = (Template)this._templates.get(i);
            String shortcut = t.getShortcut();
            if (sText.endsWith(shortcut)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int searchTemplatePos(String sText) {
        int n = this._templates.size();
        int i = 0;
        while (i < n) {
            Template t = (Template)this._templates.get(i);
            String shortcut = t.getShortcut();
            if (sText.equals(shortcut)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    Template findTemplate(String sText) {
        Template ret = null;
        int nPos = this.searchTemplatePos(sText);
        if (nPos != -1) {
            ret = this.getTemplate(nPos);
        }
        return ret;
    }

    Template findTemplateEndingWith(String sText) {
        Template ret = null;
        int nPos = this.searchTemplatePosEndingWith(sText);
        if (nPos != -1) {
            ret = this.getTemplate(nPos);
        }
        return ret;
    }

    boolean isDuplicateShortcut(Template t) {
        int count = 0;
        String shortcut = t.getShortcut();
        int n = this._templates.size();
        int i = 0;
        while (i < n && count < 2) {
            Template template = (Template)this._templates.get(i);
            if (template.getShortcut().equals(shortcut)) {
                ++count;
            }
            ++i;
        }
        return count >= 2;
    }

    boolean updateValidities() {
        int n = this._templates.size();
        boolean[] wasValid = new boolean[n];
        int i = 0;
        while (i < n) {
            Template template = (Template)this._templates.get(i);
            wasValid[i] = template.isValid();
            template.setValid(true);
            ++i;
        }
        int i2 = 0;
        while (i2 < n) {
            Template t1 = (Template)this._templates.get(i2);
            String shortcut1 = t1.getShortcut();
            int j = i2 + 1;
            while (j < n) {
                Template t2 = (Template)this._templates.get(j);
                String shortcut2 = t2.getShortcut();
                if (shortcut1.equals(shortcut2)) {
                    t1.setValid(false);
                    t2.setValid(false);
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < n) {
            Template template = (Template)this._templates.get(i3);
            if (wasValid[i3] != template.isValid()) {
                return true;
            }
            ++i3;
        }
        return false;
    }

    void merge(Templates other) {
        int i = 0;
        while (i < other._templates.size()) {
            Template template = (Template)other._templates.get(i);
            String shortcut = template.getShortcut();
            int templatePosByShortcut = this.getTemplatePosByShortcut(shortcut);
            if (templatePosByShortcut == -1) {
                this.addTemplate(template);
            }
            ++i;
        }
    }

    public Object copyTo(Object target) {
        Templates copy = target != null ? (Templates)((Object)target) : new Templates();
        this.copyToImpl(copy);
        return copy;
    }

    final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Template t1 = (Template)o1;
            Template t2 = (Template)o2;
            String s1 = t1.getShortcut();
            String s2 = t2.getShortcut();
            return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
        }
    }

    final class 2
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Template t1 = (Template)o1;
            Template t2 = (Template)o2;
            return t2.getShortcut().length() - t1.getShortcut().length();
        }
    }
}

