/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import oracle.jdeveloper.ceditor.template.ConfigPanel;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateArb;
import oracle.jdeveloper.ceditor.template.TemplateVariable;

class VariableDataModel
extends AbstractTableModel {
    private Template _currentTemplate;
    private ConfigPanel _configPanel;

    public VariableDataModel(Template t) {
        this._currentTemplate = t;
    }

    public void setTemplate(Template t) {
        this._currentTemplate = t;
        this.fireTableDataChanged();
    }

    public void setConfigPanel(ConfigPanel p) {
        this._configPanel = p;
    }

    public int getRowCount() {
        if (this._currentTemplate == null) {
            return 0;
        }
        return this._currentTemplate.getVariables().size();
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return TemplateArb.getString(13);
            }
            case 1: {
                return TemplateArb.getString(17);
            }
            case 2: {
                return TemplateArb.getString(14);
            }
            case 3: {
                return TemplateArb.getString(11);
            }
        }
        return "Unknown";
    }

    public boolean isCellEditable(int row, int col) {
        return col >= 1;
    }

    public void setValueAt(Object value, int row, int col) {
        if (row >= this._currentTemplate.getVariables().size()) {
            return;
        }
        TemplateVariable var = (TemplateVariable)this._currentTemplate.getVariables().get(row);
        switch (col) {
            case 0: {
                return;
            }
            case 1: {
                if (this.checkTypeValidity((String)value)) {
                    var.setType((String)value);
                }
                return;
            }
            case 2: {
                var.setDefValue((String)value);
                return;
            }
            case 3: {
                var.setEditable((Boolean)value);
                return;
            }
        }
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public Object getValueAt(int row, int column) {
        TemplateVariable var = (TemplateVariable)this._currentTemplate.getVariables().get(row);
        switch (column) {
            case 0: {
                return var.getName();
            }
            case 1: {
                return var.getType();
            }
            case 2: {
                return var.getDefValue();
            }
            case 3: {
                if (var.isEditable()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        return "Unknown";
    }

    private boolean checkTypeValidity(String type) {
        int index = type.indexOf(40);
        if (index == -1) {
            return true;
        }
        String parameter = type.substring(index + 1, type.length() - 1);
        if ("".equals(parameter)) {
            return true;
        }
        int lastIndex = parameter.length() - 1;
        if (parameter.charAt(0) == '$' && parameter.charAt(lastIndex) == '$') {
            String name = parameter.substring(1, lastIndex);
            if (this._currentTemplate.getVariable(name) == null) {
                JOptionPane.showMessageDialog(this._configPanel, "Variable not found: " + name, TemplateArb.getString(20), 2);
                return false;
            }
        } else {
            if (parameter.charAt(0) == '$' || parameter.charAt(lastIndex) == '$') {
                JOptionPane.showMessageDialog(this._configPanel, "Invalid type: " + parameter, TemplateArb.getString(20), 2);
                return false;
            }
            Pattern regex = Pattern.compile("[a-zA-Z]\\w*");
            if (parameter.indexOf(46) < 0) {
                JOptionPane.showMessageDialog(this._configPanel, "Not a fully qualified name: " + parameter, TemplateArb.getString(20), 2);
                return false;
            }
            String[] names = parameter.split("\\.");
            int i = 0;
            while (i < names.length) {
                String name = names[i];
                if (!regex.matcher(name).matches()) {
                    JOptionPane.showMessageDialog(this._configPanel, "Invalid package name: " + parameter, TemplateArb.getString(20), 2);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

