/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cmd;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Command;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.StringUtil;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.project.NewProjectPanel;

public class NewEmptyProjectCommand
extends Command {
    private static List initializers;
    public static final String WORKSPACE_PACKAGE_COUNTER_PROPERTY = "packageCounter";

    public NewEmptyProjectCommand() {
        super(3);
    }

    public final int doit() throws Exception {
        Context ctx = this.getContext();
        Assert.check((ctx != null && ctx.getWorkspace() != null ? 1 : 0) != 0);
        NewProjectPanel newProjectPanel = new NewProjectPanel();
        newProjectPanel.setContext(ctx);
        1 runnable = new 1(this, newProjectPanel, ctx);
        URL projectURL = newProjectPanel.getProjectURL(runnable);
        if (projectURL == null) {
            return 1;
        }
        return 0;
    }

    public static Project createProjectInWorkspace(URL projectURL, Workspace workspace) throws IllegalAccessException, InstantiationException {
        return NewEmptyProjectCommand.createProjectInWorkspace(projectURL, workspace, null);
    }

    public static Project createProjectInWorkspace(URL projectURL, Workspace workspace, String defaultPackage) throws IllegalAccessException, InstantiationException {
        Project origProj = (Project)NodeFactory.find((URL)projectURL);
        Project newProject = NewEmptyProjectCommand.createProject(projectURL);
        if (newProject != null) {
            NewEmptyProjectCommand.initializeProjectSettings(newProject, workspace, defaultPackage);
            if (origProj != null) {
                try {
                    origProj.close();
                    NewEmptyProjectCommand.setPackage(newProject, defaultPackage, workspace);
                    newProject.save();
                    newProject.close();
                    origProj.open();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                newProject = origProj;
                NodeFactory.recache((URL)projectURL, (URL)projectURL, (Node)newProject);
            }
            if (workspace != null) {
                workspace.add((Element)newProject, true);
            }
        } else {
            NewEmptyProjectCommand._showError(projectURL);
        }
        return newProject;
    }

    public static void initializeProjectSettings(Project project, Workspace workspace, String defaultPackage) {
        Project final_newProject = project;
        project.applyBatchChanges((Runnable)new 2(final_newProject, workspace, defaultPackage));
    }

    public static Project createProject(URL projectURL) throws IllegalAccessException, InstantiationException {
        Project newProject;
        Project defProject = Ide.getDefaultProject();
        if (defProject != null) {
            if (defProject.isDirty()) {
                try {
                    defProject.save();
                }
                catch (IOException ex) {
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    if (mainWindow != null) {
                        ExceptionDialog.showExceptionDialog((Window)mainWindow, (Exception)ex);
                    }
                    throw new InstantiationException();
                }
            }
            newProject = (Project)NodeFactory.clone((Node)defProject, (URL)projectURL);
        } else {
            newProject = (Project)NodeFactory.findOrCreate(Project.class, (URL)projectURL);
        }
        return newProject;
    }

    public static String getProjectPackage(Workspace workspace) {
        ApplicationContent content = ApplicationContent.getInstance((Workspace)workspace);
        String appPackagePrefix = content.getAppPackagePrefix();
        Project defProject = Ide.getDefaultProject();
        String pkgName = defProject != null ? JavaProject.getInstance((Project)defProject).getDefaultPackage() : ModelArb.getString((int)27);
        return appPackagePrefix != null && appPackagePrefix.length() > 0 ? appPackagePrefix + '.' + pkgName : pkgName;
    }

    public static void setProjectPackage(String pkgName, Project newProject, Workspace wksp) {
        if (pkgName == null) {
            pkgName = "";
        }
        newProject.getProperties().putString("defaultPackage", pkgName);
        JavaProject.getInstance((Project)newProject).setMostRecentPackage(pkgName);
    }

    public static synchronized void registerProjectInitializer(ProjectInitializer init) {
        if (initializers == null) {
            initializers = new ArrayList();
        }
        if (!initializers.contains(init)) {
            initializers.add(init);
        }
    }

    public static synchronized void unregisterProjectInitializer(ProjectInitializer init) {
        if (initializers != null) {
            initializers.remove(init);
        }
    }

    private static void _showError(URL projectURL) {
        String fileName = URLFileSystem.getPlatformPathName((URL)projectURL);
        if (fileName.length() > 80) {
            fileName = ComponentArb.format((int)30, (Object)StringUtil.truncateFileNameForMessage((String)fileName));
        }
        String msg = ComponentArb.format((int)21, (Object)WizardsArb.getString(32), (Object)fileName);
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow != null) {
            MessageDialog.error((Component)mainWindow, (Object)msg, (String)ComponentArb.getString((int)32), null);
        } else {
            System.err.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeProject(Project proj, Workspace workspace) {
        ProjectInitializer[] inits = null;
        Class<NewEmptyProjectCommand> clazz = NewEmptyProjectCommand.class;
        synchronized (NewEmptyProjectCommand.class) {
            if (initializers != null) {
                inits = initializers.toArray(new ProjectInitializer[initializers.size()]);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (inits != null) {
                int i = 0;
                while (i < inits.length) {
                    inits[i].initializeProject(proj, workspace);
                    ++i;
                }
            }
            return;
        }
    }

    private static void setPackage(Project project, String packageName, Workspace workspace) {
        String pkg = null;
        if (packageName != null) {
            pkg = packageName;
        } else if (workspace != null) {
            ApplicationContent content = ApplicationContent.getInstance((Workspace)workspace);
            pkg = content.getAppPackagePrefix();
        }
        if (pkg == null) {
            pkg = JavaProject.generateDefaultPackageName((Project)project);
        }
        NewEmptyProjectCommand.setProjectPackage(pkg, project, workspace);
    }

    static void maS$initializeProject(Project project, Workspace workspace) {
        NewEmptyProjectCommand.initializeProject(project, workspace);
    }

    static void maS$setPackage(Project project, String string, Workspace workspace) {
        NewEmptyProjectCommand.setPackage(project, string, workspace);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ NewProjectPanel v$newProjectPanel;
        private final /* synthetic */ Context v$ctx;
        final /* synthetic */ NewEmptyProjectCommand this$0;

        public void run() {
            block5: {
                try {
                    URL projURL = this.v$newProjectPanel.getFileURL(false);
                    if (projURL == null) break block5;
                    try {
                        Workspace wksp = this.v$ctx.getWorkspace();
                        Project newProj = NewEmptyProjectCommand.createProjectInWorkspace(projURL, wksp);
                        if (newProj != null) {
                            newProj.save();
                            this.v$ctx.setProject(newProj);
                        }
                    }
                    catch (Exception e) {
                        ExceptionDialog.showExceptionDialog((Component)((Object)this.v$newProjectPanel), (Throwable)e, (String)("An error occured creating the project " + URLFileSystem.getPlatformPathName((URL)projURL)));
                    }
                }
                catch (TraversalException e) {
                    e.showMessageDialog((Component)((Object)this.v$newProjectPanel));
                }
            }
        }

        public 1(NewEmptyProjectCommand newEmptyProjectCommand, NewProjectPanel newProjectPanel, Context context) {
            this.v$ctx = context;
            this.v$newProjectPanel = newProjectPanel;
            this.this$0 = newEmptyProjectCommand;
        }
    }

    static final class 2
    implements Runnable {
        private final /* synthetic */ Project v$final_newProject;
        private final /* synthetic */ Workspace v$workspace;
        private final /* synthetic */ String v$defaultPackage;

        public void run() {
            CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)this.v$final_newProject);
            optionManager.setToDefaultOptions();
            BuildSystemConfiguration buildConfig = BuildSystemConfiguration.getInstance((PropertyStorage)this.v$final_newProject);
            if (buildConfig != null) {
                buildConfig.setCurrentEncoding(IdeUtil.getIdeEncoding());
            }
            ProjectContent.initializeContentSets((Project)this.v$final_newProject);
            ProjectVersion.initializeVersions((PropertyStorage)this.v$final_newProject, (String)ProjectMigrator.MIGRATOR_NAME);
            NewEmptyProjectCommand.maS$initializeProject(this.v$final_newProject, this.v$workspace);
            NewEmptyProjectCommand.maS$setPackage(this.v$final_newProject, this.v$defaultPackage, this.v$workspace);
        }

        public 2(Project project, Workspace workspace, String string) {
            this.v$defaultPackage = string;
            this.v$workspace = workspace;
            this.v$final_newProject = project;
        }
    }

    public static interface ProjectInitializer {
        public void initializeProject(Project var1, Workspace var2);
    }
}

