/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cmt;

import java.net.URL;
import oracle.ide.model.Element;
import oracle.ide.model.ElementRecognizer;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponentManager;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.cmt.CmtModelNode;

public final class CmtElementRecognizer
extends ElementRecognizer {
    public Class recognize(URL url) {
        if (url == null || !"jdev.cmt".equals(url.getProtocol())) {
            return null;
        }
        return CmtModelNode.class;
    }

    public Element create(URL url, Project project) throws IllegalAccessException, InstantiationException {
        if (url == null || !"jdev.cmt".equals(url.getProtocol())) {
            throw new InstantiationException();
        }
        try {
            String srcSpec = url.getPath();
            URL srcURL = URLFactory.newURL((String)srcSpec);
            String query = url.getQuery();
            int i = query.lastIndexOf("&");
            String prjSpec = query.substring(0, i);
            URL prjURL = URLFactory.newURL((String)prjSpec);
            Project prjNode = (Project)NodeFactory.find((URL)prjURL);
            CmtComponents cmtMgr = CmtComponentManager.getCmtComponents(prjNode);
            CmtComponent cmtComp = cmtMgr.getComponent(srcURL);
            String name = query.substring(i + "&".length());
            CmtModelNode node = ((CmtComponentSource)cmtComp).getCmtModelNode(name);
            if (node != null) {
                CmtModelNode cmtModelNode = node;
                return cmtModelNode;
            }
            throw new InstantiationException();
        }
        catch (Exception e) {
            throw new InstantiationException();
        }
    }
}

