/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cmt;

import java.beans.PropertyEditor;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import oracle.bali.inspector.JavaBeansPropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtEvent;
import oracle.jdeveloper.cmt.CmtEventState;
import oracle.jdeveloper.cmt.CmtInspectable;
import oracle.jdeveloper.cmt.CmtProperty;
import oracle.jdeveloper.cmt.CmtPropertyEditor;
import oracle.jdeveloper.cmt.CmtPropertyID;
import oracle.jdeveloper.cmt.CmtPropertyModel;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.java.JavaManager;

public class CmtEventModel
extends CmtPropertyModel {
    private Context context;
    private String clsName;
    private String methodName;
    private JavaType[] paramTypes;

    public CmtEventModel(CmtInspectable inspectable) {
        super(inspectable);
    }

    public int getRowCount() {
        if (this._inspectable == null) {
            return 0;
        }
        CmtEventState[] states = this._inspectable.getEventStates();
        return states == null ? 0 : states.length;
    }

    public void setValueAt(Object data, int rowIndex, int colIndex) {
        CmtComponent component;
        String name;
        if (data != null && !(data instanceof String)) {
            throw new IllegalArgumentException();
        }
        String string = name = data != null ? ((String)data).trim() : null;
        if (name != null && name.length() > 0) {
            StringCharacterIterator i = new StringCharacterIterator(name);
            char c = i.first();
            if (!Character.isJavaIdentifierStart(c)) {
                throw new IllegalArgumentException();
            }
            c = i.next();
            while (c != '\uffff') {
                if (!Character.isJavaIdentifierPart(c)) {
                    throw new IllegalArgumentException();
                }
                c = i.next();
            }
        }
        data = name;
        this.context = null;
        this.clsName = null;
        this.methodName = null;
        this.paramTypes = null;
        CmtSubcomponent subcomponent = (CmtSubcomponent)this._inspectable.getTarget();
        CmtComponent cmtComponent = component = subcomponent != null ? subcomponent.getOuterComponent() : null;
        if (component != null) {
            try {
                Iterator i;
                JavaFile jFile = component.getFile();
                CmtEventState state = (CmtEventState)this.getPropertyState(rowIndex);
                CmtEvent event = (CmtEvent)state.getProperty();
                JavaMethod method = event.getListenerMethod();
                JavaClass cls = component.getType();
                this.clsName = cls.getQualifiedName();
                this.methodName = (String)data;
                Collection params = method.getParameters();
                Iterator iterator = i = params != null ? params.iterator() : null;
                if (i != null) {
                    ArrayList<JavaType> list = new ArrayList<JavaType>();
                    while (i.hasNext()) {
                        JavaVariable param = (JavaVariable)i.next();
                        list.add(param.getResolvedType());
                    }
                    this.paramTypes = list.toArray(new JavaType[list.size()]);
                }
                this.context = Context.newIdeContext((Node)NodeFactory.find((URL)jFile.getURL()));
                this.context.setProject(component.getComponents().getPackages().getProject());
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        super.setValueAt(data, rowIndex, colIndex);
    }

    public void postProcess() {
        if (this.methodName != null && this.methodName.length() > 0 && this.context != null) {
            Project prj = this.context.getProject();
            JavaManager mgr = JavaManager.getJavaManager((Project)prj);
            SourceClass cls = mgr.getSourceClass(this.clsName);
            SourceMethod method = cls.getSourceMethod(this.methodName, this.paramTypes);
            SourceBlock block = method.getBlock();
            List elems = block.getCodeElements();
            int offset = elems != null && elems.size() > 0 ? ((SourceElement)elems.get(0)).getStartOffset() : block.getStartOffset() + 1;
            Context ctx = new Context(this.context);
            ctx.setView(null);
            NavigationManager navMgr = NavigationManager.getNavigationManager();
            OffsetNavigationPoint point = new OffsetNavigationPoint(ctx, offset, 0);
            try {
                if (navMgr != null) {
                    navMgr.navigateTo((NavigationPoint)point, true);
                } else {
                    point.navigate();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected CmtPropertyState getPropertyState(int index) {
        int count;
        if (this._inspectable == null) {
            return null;
        }
        CmtEventState[] events = this._inspectable.getEventStates();
        int n = count = events == null ? 0 : events.length;
        if (index < 0 || index >= count) {
            return null;
        }
        return events[index];
    }

    protected Hashtable _getPropertyHashTable() {
        if (this._propertyHashtable == null) {
            Hashtable<CmtPropertyID, Integer> eventTable = new Hashtable<CmtPropertyID, Integer>();
            if (this._inspectable != null) {
                CmtEventState[] events = this._inspectable.getEventStates();
                int count = events == null ? 0 : events.length;
                int i = 0;
                while (i < count) {
                    eventTable.put(this._getPropertyID(i), new Integer(i));
                    ++i;
                }
            }
            this._propertyHashtable = eventTable;
        }
        return this._propertyHashtable;
    }

    protected CmtPropertyID _getPropertyID(int index) {
        if (this._ids == null) {
            CmtEventState[] events = this._inspectable != null ? this._inspectable.getEventStates() : null;
            int count = events == null ? 0 : events.length;
            this._ids = new CmtPropertyID[count];
        }
        if (this._ids[index] == null) {
            CmtProperty p;
            CmtPropertyState ps = this.getPropertyState(index);
            CmtProperty cmtProperty = p = ps != null ? ps.getProperty() : null;
            if (p != null) {
                this._ids[index] = new CmtPropertyID(p.getName(), p.getPropertyType(), p.isBound(), p.isConstrained());
            }
        }
        return this._ids[index];
    }

    private int eventCount() {
        CmtEventState[] events = this._inspectable != null ? this._inspectable.getEventStates() : null;
        return events == null ? 0 : events.length;
    }

    protected PropertyEditorAdapter _getPropertyEditorFactory(int index) {
        if (this._factories == null) {
            this._factories = new PropertyEditorAdapter[this.eventCount()];
        }
        if (this._factories[index] == null) {
            PropertyEditor e;
            CmtPropertyState s = this.getPropertyState(index);
            CmtProperty p = s != null ? s.getProperty() : null;
            PropertyEditor propertyEditor = e = p != null ? p.getEditor() : null;
            if (e != null) {
                if (e instanceof CmtPropertyEditor) {
                    ((CmtPropertyEditor)e).setPropertyState(s);
                }
                this._factories[index] = new PropertyEditorAdapter(e, p.getPropertyType());
            }
        }
        return this._factories[index];
    }

    protected JavaBeansPropertyEditorAdapter inspectorPropertyEditor(int index) {
        if (this.propertyEditorAdapters == null) {
            this.propertyEditorAdapters = new JavaBeansPropertyEditorAdapter[this.eventCount()];
        }
        if (this.propertyEditorAdapters[index] == null) {
            PropertyEditor javaBeansPropertyEditor;
            CmtPropertyState propertyState = this.getPropertyState(index);
            CmtProperty property = propertyState != null ? propertyState.getProperty() : null;
            PropertyEditor propertyEditor = javaBeansPropertyEditor = property != null ? property.getEditor() : null;
            if (javaBeansPropertyEditor != null) {
                if (javaBeansPropertyEditor instanceof CmtPropertyEditor) {
                    CmtPropertyEditor cmtPropertyEditor = (CmtPropertyEditor)javaBeansPropertyEditor;
                    cmtPropertyEditor.setPropertyState(propertyState);
                    propertyState.editorAttached(cmtPropertyEditor);
                }
                this.propertyEditorAdapters[index] = new JavaBeansPropertyEditorAdapter(javaBeansPropertyEditor);
            }
        }
        return this.propertyEditorAdapters[index];
    }
}

