/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cmt;

import java.beans.PropertyEditor;
import java.nio.ReadOnlyBufferException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import oracle.bali.inspector.JavaBeansPropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtInspectable;
import oracle.jdeveloper.cmt.CmtProperty;
import oracle.jdeveloper.cmt.CmtPropertyEditor;
import oracle.jdeveloper.cmt.CmtPropertyID;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.cmt.SwingGroupProvider;
import oracle.jdeveloper.model.JavaSourceNode;

public class CmtPropertyModel
extends PropertyModel {
    public static final int INDEX_COLUMN_ID = 0;
    public static final int INDEX_COLUMN_EDITOR_FACTORY = 1;
    public static final int INDEX_COLUMN_VALUE = 2;
    public static final int INDEX_COLUMN_DISPLAY_VALUE = 3;
    public static final int INDEX_COLUMN_IS_WRITABLE = 4;
    public static final int INDEX_COLUMN_DISPLAY_NAME = 5;
    public static final int INDEX_COLUMN_VALUE_CLASS = 6;
    public static final int INDEX_COLUMN_IS_READABLE = 7;
    public static final int INDEX_COLUMN_DESCRIPTION = 8;
    public static final int INDEX_COLUMN_EXPERT = 9;
    public static final int INDEX_COLUMN_HIDDEN = 10;
    public static final int INDEX_COLUMN_GROUP = 11;
    public static final int INDEX_COLUMN_NAME = 12;
    public static final int INDEX_COLUMN_HELP = 13;
    public static final int INDEX_COLUMN_EDITOR_ADAPTER = 14;
    protected static final SwingGroupProvider GROUPS = new SwingGroupProvider();
    protected static final Object[] _COLUMNS = new Object[]{PropertyModel.COLUMN_ID, PropertyModel.COLUMN_EDITOR_FACTORY, PropertyModel.COLUMN_VALUE, PropertyModel.COLUMN_DISPLAY_VALUE, PropertyModel.COLUMN_IS_WRITABLE, PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_VALUE_CLASS, PropertyModel.COLUMN_IS_READABLE, PropertyModel.COLUMN_DESCRIPTION, PropertyModel.COLUMN_IS_EXPERT, PropertyModel.COLUMN_IS_HIDDEN, PropertyModel.COLUMN_GROUP, PropertyModel.COLUMN_NAME, IdePropertyModel.COLUMN_HELP, PropertyModel.COLUMN_EDITOR_FACTORY_2};
    protected CmtInspectable _inspectable;
    protected PropertyEditorAdapter[] _factories;
    protected JavaBeansPropertyEditorAdapter[] propertyEditorAdapters;
    protected CmtPropertyID[] _ids;
    protected transient Hashtable _propertyHashtable;

    public CmtPropertyModel(CmtInspectable inspectable) {
        this._inspectable = inspectable;
    }

    public String getTargetDisplayName() {
        try {
            String type;
            CmtSubcomponent sub = (CmtSubcomponent)this._inspectable.getTarget();
            if (sub == null || sub.isStale()) {
                String string = null;
                return string;
            }
            JavaClass javaClass = sub.getDeclaredClass();
            String string = type = javaClass != null ? this.getShortClassName(javaClass.getName()) : "???";
            if (type == null) {
                type = "???";
            }
            String string2 = sub.getName() + " (" + type + ")";
            return string2;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
    }

    public Object[] getColumnMapping() {
        return _COLUMNS;
    }

    public int getColumnCount() {
        return _COLUMNS.length;
    }

    public int getRowCount() {
        if (this._inspectable == null) {
            return 0;
        }
        CmtPropertyState[] states = this._inspectable.getPropertyStates();
        return states == null ? 0 : states.length;
    }

    public Enumeration getPropertyIDs() {
        return this._getPropertyHashTable().keys();
    }

    public void invalidateValueData() {
    }

    public void setPropertyByID(int columnIndex, Object propertyID, Object data) throws Exception {
        Integer rowIndex = (Integer)this._getPropertyHashTable().get(propertyID);
        if (rowIndex == null) {
            return;
        }
        this.setValueAt(data, rowIndex, columnIndex);
    }

    public Object getPropertyByID(int columnIndex, Object propertyID) {
        Integer rowIndex = (Integer)this._getPropertyHashTable().get(propertyID);
        if (rowIndex == null) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        return this.getValueAt(rowIndex, columnIndex);
    }

    public void setValueAt(Object data, int rowIndex, int columnIndex) {
        CmtComponent component;
        CmtSubcomponent subcomponent = (CmtSubcomponent)this._inspectable.getTarget();
        CmtComponent cmtComponent = component = subcomponent != null ? subcomponent.getOuterComponent() : null;
        if (component == null || component.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (columnIndex != 2) {
            return;
        }
        CmtPropertyState propertyState = this.getPropertyState(rowIndex);
        try {
            propertyState.setValue(data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.fireTableCellUpdated(rowIndex, 2);
        SwingUtilities.invokeLater(new 1());
    }

    private void fireStructureChanged() {
        Context context = this.currentEditorContext();
        if (context == null) {
            return;
        }
        Node node = context.getNode();
        if (!(node instanceof JavaSourceNode)) {
            return;
        }
        UpdateMessage.fireStructureChanged((Subject)node);
    }

    private Context currentEditorContext() {
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager == null) {
            return null;
        }
        Editor editor = editorManager.getCurrentEditor();
        if (editor == null) {
            return null;
        }
        View editorView = editor.getViewWithoutDecoration();
        if (editorView == null) {
            return null;
        }
        return editorView.getContext();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        CmtPropertyState propertyState = this.getPropertyState(rowIndex);
        if (propertyState == null) {
            return null;
        }
        switch (columnIndex) {
            case 1: {
                return this._getPropertyEditorFactory(rowIndex);
            }
            case 0: {
                return this._getPropertyID(rowIndex);
            }
            case 2: {
                return propertyState.getValue();
            }
            case 3: {
                return propertyState.getValueText();
            }
            case 4: {
                return propertyState.getProperty().isWritable();
            }
            case 5: {
                return propertyState.getProperty().getDisplayName();
            }
            case 6: {
                return propertyState.getProperty().getPropertyType();
            }
            case 7: {
                return propertyState.getProperty().isReadable();
            }
            case 8: {
                return propertyState.getProperty().getShortDescription();
            }
            case 9: {
                return propertyState.getProperty().isExpert();
            }
            case 10: {
                return propertyState.getProperty().isHidden();
            }
            case 11: {
                CmtProperty property = propertyState.getProperty();
                return GROUPS.getGroup(property.getName(), property.getPropertyType());
            }
            case 12: {
                return propertyState.getProperty().getName();
            }
            case 13: {
                return CmtPropertyModel.getHelpInfo(propertyState);
            }
            case 14: {
                return this.inspectorPropertyEditor(rowIndex);
            }
        }
        return null;
    }

    public static HelpInfo getHelpInfo(CmtPropertyState propertyState) {
        JavaType javaType;
        JavaClass javaClass;
        CmtSubcomponent cmtSubcomponent;
        CmtSubcomponent cmtSubcomponent2 = cmtSubcomponent = propertyState != null ? propertyState.getSubcomponent() : null;
        if (cmtSubcomponent == null) {
            return null;
        }
        if (cmtSubcomponent.isProxy()) {
            javaClass = cmtSubcomponent.getRepresentedType();
        } else {
            CmtComponent cmtComponent = cmtSubcomponent.getComponent();
            JavaClass javaClass2 = javaClass = cmtComponent != null ? cmtComponent.getType() : null;
        }
        if (javaClass == null) {
            return null;
        }
        JavaType javaType2 = javaType = javaClass.isArray() ? javaClass.getComponentType() : javaClass.getResolvedType();
        if (javaType == null) {
            return null;
        }
        String className = javaType.getQualifiedName();
        if (!ModelUtil.hasLength((String)className)) {
            return null;
        }
        HelpInfo info = new HelpInfo(className, 1);
        CmtPropertyModel.updateInfoContext(info, propertyState);
        return info;
    }

    private static void updateInfoContext(HelpInfo info, CmtPropertyState propertyState) {
        String methodName = CmtPropertyModel.methodName(propertyState);
        if (!ModelUtil.hasLength((String)methodName)) {
            return;
        }
        Context context = new Context();
        context.setProperty("methodName", (Object)(methodName + "()"));
        info.setContext(context);
    }

    private static String methodName(CmtPropertyState propertyState) {
        JavaMethod javaMethod;
        CmtProperty cmtProperty = propertyState.getProperty();
        if (cmtProperty == null) {
            return null;
        }
        JavaMethod javaMethod2 = javaMethod = cmtProperty != null ? cmtProperty.getReadMethod() : null;
        if (javaMethod == null) {
            return null;
        }
        return javaMethod.getName();
    }

    protected CmtPropertyState getPropertyState(int index) {
        int count;
        if (this._inspectable == null) {
            return null;
        }
        CmtPropertyState[] properties = this._inspectable.getPropertyStates();
        int n = count = properties == null ? 0 : properties.length;
        if (index < 0 || index >= count) {
            return null;
        }
        return properties[index];
    }

    protected Hashtable _getPropertyHashTable() {
        if (this._propertyHashtable != null) {
            return this._propertyHashtable;
        }
        Hashtable<CmtPropertyID, Integer> propertyTable = new Hashtable<CmtPropertyID, Integer>();
        if (this._inspectable != null) {
            CmtPropertyState[] properties = this._inspectable.getPropertyStates();
            int numProperties = properties == null ? 0 : properties.length;
            int i = 0;
            while (i < numProperties) {
                propertyTable.put(this._getPropertyID(i), new Integer(i));
                ++i;
            }
        }
        this._propertyHashtable = propertyTable;
        return this._propertyHashtable;
    }

    protected CmtPropertyID _getPropertyID(int index) {
        if (this._ids == null) {
            CmtPropertyState[] properties = this._inspectable != null ? this._inspectable.getPropertyStates() : null;
            int numProperties = properties == null ? 0 : properties.length;
            this._ids = new CmtPropertyID[numProperties];
        }
        if (this._ids[index] == null) {
            CmtProperty property;
            CmtPropertyState ps = this.getPropertyState(index);
            CmtProperty cmtProperty = property = ps != null ? ps.getProperty() : null;
            if (property != null) {
                this._ids[index] = new CmtPropertyID(property.getName(), property.getPropertyType(), property.isBound(), property.isConstrained());
            }
        }
        return this._ids[index];
    }

    protected JavaBeansPropertyEditorAdapter inspectorPropertyEditor(int index) {
        if (this.propertyEditorAdapters == null) {
            this.propertyEditorAdapters = new JavaBeansPropertyEditorAdapter[this.propertyCount()];
        }
        if (this.propertyEditorAdapters[index] == null) {
            PropertyEditor javaBeansPropertyEditor;
            CmtPropertyState propertyState = this.getPropertyState(index);
            CmtProperty property = propertyState != null ? propertyState.getProperty() : null;
            PropertyEditor propertyEditor = javaBeansPropertyEditor = property != null ? property.getEditor() : null;
            if (javaBeansPropertyEditor != null) {
                if (javaBeansPropertyEditor instanceof CmtPropertyEditor) {
                    CmtPropertyEditor cmtPropertyEditor = (CmtPropertyEditor)javaBeansPropertyEditor;
                    cmtPropertyEditor.setPropertyState(propertyState);
                    propertyState.editorAttached(cmtPropertyEditor);
                }
                this.propertyEditorAdapters[index] = new JavaBeansPropertyEditorAdapter(javaBeansPropertyEditor);
            }
        }
        return this.propertyEditorAdapters[index];
    }

    private PropertyEditor javaBeansPropertyEditor(int index) {
        CmtPropertyState propertyState = this.getPropertyState(index);
        CmtProperty property = propertyState != null ? propertyState.getProperty() : null;
        return property != null ? property.getEditor() : null;
    }

    protected PropertyEditorAdapter _getPropertyEditorFactory(int index) {
        if (this._factories == null) {
            this._factories = new PropertyEditorAdapter[this.propertyCount()];
        }
        if (this._factories[index] == null) {
            PropertyEditor e;
            CmtPropertyState s = this.getPropertyState(index);
            CmtProperty p = s != null ? s.getProperty() : null;
            PropertyEditor propertyEditor = e = p != null ? p.getEditor() : null;
            if (e != null) {
                if (e instanceof CmtPropertyEditor) {
                    CmtPropertyEditor cmtEditor = (CmtPropertyEditor)e;
                    cmtEditor.setPropertyState(s);
                    s.editorAttached(cmtEditor);
                }
                this._factories[index] = new PropertyEditorAdapter(e, p.getPropertyType());
            }
        }
        return this._factories[index];
    }

    private int propertyCount() {
        CmtPropertyState[] properties = this._inspectable != null ? this._inspectable.getPropertyStates() : null;
        return properties == null ? 0 : properties.length;
    }

    private String getShortClassName(String fullName) {
        int index = fullName.lastIndexOf(46);
        return index >= 0 ? fullName.substring(index + 1) : fullName;
    }

    static void mav$fireStructureChanged(CmtPropertyModel cmtPropertyModel) {
        cmtPropertyModel.fireStructureChanged();
    }

    final class 1
    implements Runnable {
        public void run() {
            CmtPropertyModel.mav$fireStructureChanged(CmtPropertyModel.this);
        }
    }
}

