/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import oracle.ide.resource.IdeArb;
import oracle.jdeveloper.common.OracleButton;
import oracle.jdeveloper.common.PickerResultValidator;
import oracle.jdeveloper.common.PickerValueEncoder;
import oracle.jdeveloper.common.Res;

public class PickerPanel
extends JPanel {
    private GridBagLayout gridBagLayout1;
    protected JComboBox cmbPicker;
    protected OracleButton btnBrowse;
    protected PickerResultValidator validator;
    protected PickerValueEncoder encoder;
    protected MutableComboBoxModel model;
    protected ComboBoxEditor editor;
    private Object oldCurrentValue;
    private boolean editing;
    public static final String PROPERTY_CURRENT_VALUE = "currentValue";

    private void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.cmbPicker = new JComboBox();
        this.btnBrowse = new OracleButton();
        this.validator = null;
        this.encoder = null;
        this.model = new DefaultComboBoxModel();
        this.editing = false;
    }

    public PickerPanel() {
        this.$init$();
        try {
            this.jbInit();
            this.editor = this.cmbPicker.getEditor();
            if (this.editor != null) {
                this.editor.addActionListener(new 1());
                Component editComp = this.editor.getEditorComponent();
                editComp.addFocusListener(new 2(this, editComp));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getButtonText() {
        return this.btnBrowse.getText();
    }

    public void setButtonText(String newButtonText) {
        this.btnBrowse.setText(newButtonText);
    }

    public void setButtonMnemonic(int mnemonic) {
        this.btnBrowse.setMnemonic(mnemonic);
    }

    public int getButtonMnemonic() {
        return this.btnBrowse.getMnemonic();
    }

    public void setButtonVisible(boolean isVisible) {
        this.btnBrowse.setVisible(isVisible);
    }

    public boolean isButtonVisible() {
        return this.btnBrowse.isVisible();
    }

    public boolean isPickerEditable() {
        return this.cmbPicker.isEditable();
    }

    public void setPickerEditable(boolean newEditable) {
        this.cmbPicker.setEditable(newEditable);
    }

    public MutableComboBoxModel getPickerModel() {
        return this.model;
    }

    public void setPickerModel(MutableComboBoxModel newModel) {
        this.model = newModel;
        this.cmbPicker.setModel(newModel);
    }

    public PickerResultValidator getValidator() {
        return this.validator;
    }

    public void setValidator(PickerResultValidator newValidator) {
        this.validator = newValidator;
    }

    public PickerValueEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PickerValueEncoder newEncoder) {
        this.encoder = newEncoder;
    }

    public void addActionListener(ActionListener l) {
        this.btnBrowse.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.btnBrowse.removeActionListener(l);
    }

    public final void setBrowseResult(Object result) {
        if (result == null) {
            return;
        }
        if (this.validator == null || this.validator.isResultValid(result)) {
            Object value = this.encoder != null ? this.encoder.encodeValue(result) : result;
            this.setCurrentValue(value);
        } else {
            JOptionPane.showMessageDialog(this, this.validator.getInvalidValueMsg(result), IdeArb.getString((int)110), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addValue(Object value) {
        MutableComboBoxModel mutableComboBoxModel = this.model;
        synchronized (mutableComboBoxModel) {
            int i = 0;
            while (i < this.model.getSize()) {
                if (this.model.getElementAt(i).equals(value)) {
                    return;
                }
                ++i;
            }
            this.model.addElement(value);
        }
    }

    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        return new Dimension(Math.max(d.width, 200), d.height);
    }

    public void setEnabled(boolean enabled) {
        this.btnBrowse.setEnabled(enabled);
        this.cmbPicker.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.btnBrowse.setText(Res.getString(0));
        this.cmbPicker.setModel(this.model);
        this.cmbPicker.addItemListener(new 3());
        this.cmbPicker.addPropertyChangeListener(new 4());
        this.add((Component)this.cmbPicker, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.btnBrowse, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    private void cmbPicker_propertyChange(PropertyChangeEvent e) {
        Object newVal;
        String propName = e.getPropertyName();
        if ("model".equals(propName) && (newVal = e.getNewValue()) != this.model) {
            this.model = (MutableComboBoxModel)newVal;
        }
    }

    private void editFinished() {
        this.editing = false;
        Object result = this.editor.getItem();
        Object value = this.encoder != null ? this.encoder.encodeValue(result) : result;
        this.setCurrentValue(value);
    }

    public Object getCurrentValue() {
        if (this.editing) {
            this.editFinished();
        }
        return this.model.getSelectedItem();
    }

    public void setCurrentValue(Object newCurrentValue) {
        Object oldCurrentValue = this.getCurrentValue();
        this.addValue(newCurrentValue);
        this.model.setSelectedItem(newCurrentValue);
    }

    void cmbPicker_itemStateChanged(ItemEvent e) {
        int change = e.getStateChange();
        switch (change) {
            case 2: {
                this.oldCurrentValue = e.getItem();
                break;
            }
            case 1: {
                this.firePropertyChange(PROPERTY_CURRENT_VALUE, this.oldCurrentValue, e.getItem());
                break;
            }
        }
    }

    public void requestFocus() {
        if (this.isPickerEditable()) {
            if (this.editor != null) {
                this.editor.getEditorComponent().requestFocus();
            }
        } else {
            this.cmbPicker.requestFocus();
        }
    }

    static void mav$cmbPicker_propertyChange(PickerPanel pickerPanel, PropertyChangeEvent propertyChangeEvent) {
        pickerPanel.cmbPicker_propertyChange(propertyChangeEvent);
    }

    static void mav$editFinished(PickerPanel pickerPanel) {
        pickerPanel.editFinished();
    }

    static void wa$editing(PickerPanel pickerPanel, boolean bl) {
        pickerPanel.editing = bl;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            PickerPanel.mav$editFinished(PickerPanel.this);
        }
    }

    final class 2
    implements FocusListener {
        private final /* synthetic */ Component v$editComp;
        final /* synthetic */ PickerPanel this$0;

        public void focusGained(FocusEvent e) {
            PickerPanel.wa$editing(this.this$0, true);
        }

        public void focusLost(FocusEvent e) {
            ((JTextField)this.v$editComp).postActionEvent();
        }

        public 2(PickerPanel pickerPanel, Component component) {
            this.v$editComp = component;
            this.this$0 = pickerPanel;
        }
    }

    final class 3
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            PickerPanel.this.cmbPicker_itemStateChanged(e);
        }
    }

    final class 4
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            PickerPanel.mav$cmbPicker_propertyChange(PickerPanel.this, e);
        }
    }
}

