/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.jdeveloper.compiler.BuildNode;
import oracle.jdeveloper.compiler.Translator;

class BuildGraph {
    ArrayList buildRoots;
    HashMap buildNodes;

    private void $init$() {
        this.buildRoots = new ArrayList(5);
        this.buildNodes = new HashMap(19);
    }

    BuildGraph() {
        this.$init$();
    }

    static boolean isPreprocessor(Translator translator) {
        ArrayList in = translator.getInputTypes();
        ArrayList out = translator.getOutputTypes();
        if (in.size() >= 1 && in.size() == out.size()) {
            int i = 0;
            while (i < in.size()) {
                if (!out.contains(in.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void walkAndInsertInOrderedList(BuildNode n, ArrayList result) {
        if (n.marker == 0 && n.translator != null) {
            int i = 0;
            while (i < n.children.size()) {
                BuildNode c = (BuildNode)n.children.get(i);
                this.walkAndInsertInOrderedList(c, result);
                ++i;
            }
            n.marker = 1;
            int j = 0;
            while (j < result.size()) {
                if (result.get(j) == n.translator) break;
                ++j;
            }
            if (j >= result.size()) {
                result.add(0, n.translator);
                if (n.preProcessors != null) {
                    int k = 0;
                    while (k < n.preProcessors.size()) {
                        Translator t = (Translator)n.preProcessors.get(k);
                        if (!result.contains(t)) {
                            result.add(0, t);
                        }
                        ++k;
                    }
                }
            }
        }
    }

    public ArrayList getOrderedTranslatorList() {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.buildRoots.size()) {
            BuildNode n = (BuildNode)this.buildRoots.get(i);
            this.walkAndInsertInOrderedList(n, result);
            ++i;
        }
        Iterator e = this.buildNodes.values().iterator();
        while (e.hasNext()) {
            ((BuildNode)e.next()).marker = 0;
        }
        return result;
    }

    private boolean walkChildren(BuildNode node, int marker) {
        if (node.marker == marker) {
            System.out.println("error: walkGraph: circularity detected with node");
            return false;
        }
        node.marker = marker;
        int i = 0;
        while (i < node.children.size()) {
            if (!this.walkChildren((BuildNode)node.children.get(i), marker)) {
                return false;
            }
            ++i;
        }
        if (node.children.size() != 0 ^ node.translator != null && node.translator != null && node.translator.getOutputTypes().size() > 0 && !BuildGraph.isPreprocessor(node.translator)) {
            System.out.println("internal error: walkGraph: node with children should have a translator && node without them shouldn't have one");
        }
        node.marker = -1;
        return true;
    }

    private boolean checkGraph() {
        boolean result = true;
        int i = 0;
        while (i < this.buildRoots.size()) {
            if (!this.walkChildren((BuildNode)this.buildRoots.get(i), i + 1)) {
                result = false;
            }
            ++i;
        }
        for (BuildNode node : this.buildNodes.values()) {
            if (node.marker == 0) {
                System.out.println("checkGraph: node is not reachable");
                result = false;
            }
            node.marker = 0;
        }
        return result;
    }

    boolean rebuild(HashMap translators) {
        this.buildNodes.clear();
        this.buildRoots.clear();
        for (String ext : translators.keySet()) {
            ArrayList al = (ArrayList)translators.get(ext);
            int ti = 0;
            while (ti < al.size()) {
                Translator t = (Translator)al.get(ti);
                BuildNode node = (BuildNode)this.buildNodes.get(ext);
                if (node == null) {
                    node = new BuildNode(ext, t);
                    this.buildNodes.put(ext, node);
                    this.buildRoots.add(node);
                } else if (node != null && !node.containsTranslator(t)) {
                    node.addTranslator(t);
                }
                if (!BuildGraph.isPreprocessor(t)) {
                    ArrayList children = t.getOutputTypes();
                    int i = 0;
                    while (i < children.size()) {
                        String childExt = (String)children.get(i);
                        BuildNode child = (BuildNode)this.buildNodes.get(childExt);
                        if (child == null) {
                            child = new BuildNode(childExt, (ArrayList)translators.get(childExt));
                            this.buildNodes.put(childExt, child);
                        }
                        if (child != node) {
                            int j = 0;
                            while (j < child.parents.size()) {
                                if (child.parents.get(j) == node) break;
                                ++j;
                            }
                            if (j >= child.parents.size()) {
                                child.parents.add(node);
                            }
                            j = 0;
                            while (j < node.children.size()) {
                                if (node.children.get(j) == child) break;
                                ++j;
                            }
                            if (j >= node.children.size()) {
                                node.children.add(child);
                            }
                        }
                        ++i;
                    }
                }
                ++ti;
            }
        }
        int i = 0;
        while (i < this.buildRoots.size()) {
            BuildNode n = (BuildNode)this.buildRoots.get(i);
            if (n.parents.size() > 0) {
                this.buildRoots.remove(i);
                continue;
            }
            ++i;
        }
        return this.checkGraph() && this.buildRoots.size() > 0;
    }
}

