/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekableTree;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.JarStorage;
import oracle.jdevimpl.java.util.JavaCodePeek;
import oracle.ojc.interfaces.Storage;

public class CompilerPage
extends DefaultLogPage
implements ActiveViewListener,
Observer {
    private DefaultMutableTreeNode root;
    private DefaultTreeModel model;
    private HashMap urlOffsetMarkTable;
    private HashMap urlTreeNodeTable;
    private boolean createWorkspaceNodes;
    private boolean createProjectNodes;
    private static final int MAX_ASYNC_MESSAGES = 100;
    private static final int ASYNC_THREAD_SLEEP = 1000;
    private ArrayList asyncMessages;
    private Thread updateThread;

    private void $init$() {
        this.root = new DefaultMutableTreeNode("root");
        this.model = new DefaultTreeModel(this.root);
        this.urlOffsetMarkTable = new HashMap();
        this.urlTreeNodeTable = new HashMap();
        this.createProjectNodes = true;
        this.asyncMessages = new ArrayList(100);
        this.updateThread = null;
    }

    public CompilerPage() {
        this("CompilerPageId", CompArb.getString(73), null);
    }

    public CompilerPage(String pageId, String pageName, Icon icon, int menuOptions) {
        super(new ViewId(pageId, pageName), icon, false, menuOptions);
        this.$init$();
        this.setModel(this.model);
        this.getTree().setCellRenderer(new MessageCellRenderer(null));
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
    }

    public CompilerPage(String pageId, String pageName, Icon icon) {
        this(pageId, pageName, icon, DefaultLogPage.HIDE_FIX_SOURCE_MENU);
    }

    public void log(Object msg) {
        if (!(msg instanceof IdeLog.Message)) {
            this.requestShow();
        }
        this.logMsg(msg);
    }

    protected void setCreateWorkspaceNodes(boolean value) {
        this.createWorkspaceNodes = value;
    }

    protected void setCreateProjectNodes(boolean value) {
        this.createProjectNodes = value;
    }

    protected Icon getLeafIcon(IdeLog.Message msg) {
        if (msg != null) {
            if (msg.isWarning()) {
                return OracleIcons.getIcon((String)"warning.png");
            }
            if (msg.isError()) {
                return OracleIcons.getIcon((String)"error.png");
            }
        }
        return null;
    }

    protected String treeNodeToString(Object treeNode) {
        if (treeNode instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)treeNode).isLeaf() && (treeNode = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof MsgTreeNode && (treeNode = ((MsgTreeNode)treeNode).getMessage()) instanceof IdeLog.Message) {
            treeNode = ((IdeLog.Message)treeNode).msg;
        }
        return super.treeNodeToString(treeNode);
    }

    private void copyPartialImportWarningToClipboard(IdeLog.Message m) {
        if (m != null && IdeLog.isPartiallyUsedImportWarning(m)) {
            String msg = m.msg;
            StringBuffer sb = new StringBuffer(256);
            int i = msg.indexOf("\n");
            if (i == -1) {
                return;
            }
            i = msg.indexOf("import ", i);
            while (i > -1) {
                int j = msg.indexOf("\n", i);
                if (j == -1) {
                    sb.append(msg.substring(i));
                    sb.append("\n");
                    j = msg.length() - 1;
                } else {
                    sb.append(msg.substring(i, j + 1));
                }
                i = msg.indexOf("import ", j);
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(sb.toString()), null);
        }
    }

    protected String fixMessages(IdeLog.Message m) {
        int i;
        String msg = m.msg;
        if (IdeLog.isPartiallyUsedImportWarning(m) && (i = msg.indexOf("\n")) > -1) {
            msg = msg.substring(0, i) + " (dbl-click will copy replacement to clipboard)" + msg.substring(i);
        }
        msg = msg.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        return msg;
    }

    private Editor openPreferredEditor(Context context) {
        EditorManager editorManager = EditorManager.getEditorManager();
        try {
            Editor editor = editorManager.openEditorInFrame(CodeEditor.class, context);
            if (editor != null) {
                Editor editor2 = editor;
                return editor2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return editorManager.openDefaultEditorInFrame(context);
    }

    private Editor openPreferredEditor(URL url, Workspace wsp, Project prj) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            Context context = Context.newIdeContext((Node)node);
            context.setWorkspace(wsp);
            context.setProject(prj);
            Editor editor = this.openPreferredEditor(context);
            return editor;
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
            Assert.println((String)("oracle.jdeveloper.compiler.CompilePage.openURLInCodeEditor() - " + e.toString()));
            return null;
        }
    }

    private Editor getEditorFromTreeNode(DefaultMutableTreeNode treeNode, Workspace wsp, Project prj) {
        if (!(treeNode.getUserObject() instanceof MsgTreeNode)) {
            return null;
        }
        MsgTreeNode node = (MsgTreeNode)treeNode.getUserObject();
        Object nodeData = node.getNodeData();
        Editor result = null;
        Project lastActiveProject = Ide.getActiveProject();
        Project nodeProject = node.getProject();
        if (nodeProject != null) {
            Ide.setActiveProject((Project)nodeProject);
        }
        Workspace lastActiveWsp = Ide.getActiveWorkspace();
        Workspace nodeWsp = node.getWorkspace();
        if (nodeWsp != null) {
            Ide.setActiveWorkspace((Workspace)nodeWsp);
        }
        if (nodeData instanceof Storage) {
            EditorManager manager = EditorManager.getEditorManager();
            Storage fname = (Storage)nodeData;
            if (fname instanceof IdeStorage) {
                Context ctxt = Context.newIdeContext((Node)((IdeStorage)fname).node);
                ctxt.setWorkspace(wsp);
                ctxt.setProject(prj);
                result = this.openPreferredEditor(ctxt);
            } else if (fname instanceof JarStorage) {
                result = this.openPreferredEditor(((JarStorage)fname).getURL(), wsp, prj);
            } else {
                File file = new File(fname.getPath());
                if (file.exists()) {
                    result = this.openPreferredEditor(URLFactory.newFileURL((File)file), wsp, prj);
                }
            }
        }
        Ide.setActiveProject((Project)lastActiveProject);
        Ide.setActiveWorkspace((Workspace)lastActiveWsp);
        return result;
    }

    protected void fixObject(Object obj) {
        this.activateObject(obj);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
        MsgTreeNode msgNode = (MsgTreeNode)treeNode.getUserObject();
        msgNode.invokeFixEvent();
    }

    protected boolean canFixObject(DefaultMutableTreeNode node) {
        MsgTreeNode msgNode = (MsgTreeNode)node.getUserObject();
        return msgNode.canInvokeFixEvent();
    }

    protected JTree createTree() {
        1 tree = new 1();
        return tree;
    }

    /*
     * Unable to fully structure code
     */
    protected void activateObject(Object obj) {
        treeNode = (DefaultMutableTreeNode)obj;
        msgNode = (MsgTreeNode)treeNode.getUserObject();
        if (msgNode.invokeActivateEvent()) {
            return;
        }
        msg = msgNode.getMessage();
        this.copyPartialImportWarningToClipboard(msg);
        point = null;
        editor = this.getEditorFromTreeNode((DefaultMutableTreeNode)treeNode.getParent(), msg.workspace, msg.project);
        if (editor instanceof CodeEditor) {
            ceditor = (CodeEditor)editor;
            line = msg.line;
            col = msg.col;
            if (msgNode.offsetMark == null) {
                this.activeViewChanged(null);
            }
            if (msgNode.offsetMark != null && msgNode.getURL() != null) {
                tnode = (TextNode)NodeFactory.find((URL)msgNode.getURL());
                try {
                    try {
                        tbuf = tnode.acquireTextBuffer();
                        lmap = tbuf.getLineMap();
                        line = lmap.getLineFromOffset(msgNode.offsetMark.getOffset()) + 1;
                        if (col <= 0) ** GOTO lbl37
                        --col;
                    }
                    catch (Throwable t) {}
                }
                finally {
                    tnode.releaseTextBuffer();
                }
            } else if (line == 0 && col > 0) {
                line = ceditor.getLineFromOffset(col) + 1;
                lineStartOffset = ceditor.getLineStartOffset(line - 1);
                col = lineStartOffset < col ? col - lineStartOffset : 1;
            } else if (col > 0) {
                --col;
            }
lbl37:
            // 7 sources

            ceditor.gotoLine(line, col, IdeLog.isPartiallyUsedImportWarning(msg) != false || IdeLog.isUnusedImportWarning(msg) != false);
            Ide.getStatusBar().setText(msg.msg);
            point = new CodeNavigationPoint();
        } else if (editor != null) {
            point = new DefaultNavigationPoint();
        }
        if (point != null && (mgr = NavigationManager.getNavigationManager()) != null) {
            point.setContext(editor.getContext());
            try {
                mgr.navigateTo((NavigationPoint)point);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_com_logwindow_html");
    }

    private JTree inScopeGetTree() {
        return this.getTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logMsg(Object msg) {
        if (msg instanceof IdeLog.Message) {
            ArrayList arrayList = this.asyncMessages;
            synchronized (arrayList) {
                this.asyncMessages.add(msg);
                if (this.asyncMessages.size() == 100) {
                    this.processAsyncMsgQueue(100);
                }
            }
        } else {
            super.logMsg(msg);
        }
    }

    public void startAsynchronousLogging() {
        this.updateThread = new 2("Log Page Updater");
        this.updateThread.setPriority(this.updateThread.getPriority() - 1);
        this.updateThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAsynchronousLogging() {
        this.updateThread = null;
        ArrayList arrayList = this.asyncMessages;
        synchronized (arrayList) {
            this.asyncMessages.clear();
        }
    }

    public void finishAsynchronousLogging() {
        this.updateThread = null;
        this.processAsyncMsgQueue(-1);
        if (this.root.getChildCount() > 0) {
            this.requestShow();
        }
    }

    public boolean isShowingTree() {
        return this.getCurrentView() == this.getTree();
    }

    private void processAsyncMsgQueue(int max) {
        3 runner = new 3(this, max);
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    private void removeMessages(IdeLog.Message msg) {
        DefaultMutableTreeNode node;
        DefaultMutableTreeNode projectNode = node = this.getProjectNode(this.root, msg.project, false);
        if (node == null) {
            return;
        }
        if (msg.fname != null) {
            DefaultMutableTreeNode parent = node;
            if ((node = this.getFileNode(parent, msg.fname, false)) == null) {
                return;
            }
            if (parent.getChildCount() == 1) {
                node = parent;
            }
        }
        this.recursivelyRemoveNode(node, true);
        if (node == projectNode && msg.project != null) {
            msg.project.detach((Observer)this);
        }
    }

    private void addMsg(IdeLog.Message msg) {
        JTree tree = this.inScopeGetTree();
        if (this.getCurrentView() != tree) {
            this.setCurrentView(tree);
        }
        if (msg.isStarting()) {
            int i = this.root.getChildCount() - 1;
            while (i >= 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.root.getChildAt(i);
                if (((MsgTreeNode)child.getUserObject()).getMessage() != null) {
                    this.recursivelyRemoveNode(child, true);
                }
                --i;
            }
            return;
        }
        if (msg.isCompleted()) {
            if (this.root.getChildCount() == 0) {
                View view = Ide.getMainWindow().getLastActiveView();
                LogManager.getLogManager().removePage((LogPage)this);
                if (view == this) {
                    IdeUtil.tryToRestoreFocus(null);
                }
            }
            return;
        }
        if (msg.isRemove()) {
            this.removeMessages(msg);
            return;
        }
        if (this.root.getChildCount() == 0) {
            if (!LogManager.getLogManager().isLogVisible()) {
                LogManager.getLogManager().showLog();
            }
            if (!this.isVisible()) {
                this.requestShow();
            }
        }
        if (Ide.getMainWindow().getLastActiveView() == LogManager.getLogManager().getLogWindow()) {
            IdeUtil.tryToRestoreFocus((Component)tree);
        } else {
            this.requestShow();
        }
        DefaultMutableTreeNode parent = this.getCachedFileNode(msg.fname);
        if (parent == null) {
            parent = this.root;
            if (this.createWorkspaceNodes && msg.workspace != null) {
                parent = this.getWorkspaceNode(parent, msg.workspace.getURL(), true);
            }
            if (this.createProjectNodes && msg.project != null) {
                parent = this.getProjectNode(parent, msg.project, true);
            }
            if (msg.fname != null) {
                parent = this.getFileNode(parent, msg.fname, true);
            }
        }
        if (msg.isNoDetails()) {
            tree.makeVisible(new TreePath(parent.getPath()));
            return;
        }
        String str = this.fixMessages(msg);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new MsgTreeNode(str, msg));
        String nodeString = node.toString();
        int i = parent.getChildCount() - 1;
        while (i >= 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (child.toString().equals(nodeString)) {
                return;
            }
            --i;
        }
        if (msg.isError()) {
            int lastError = this.getLastErrorIndex(parent, false);
            if (lastError == -1) {
                if (msg.fname != null) {
                    int newIndex;
                    DefaultMutableTreeNode grandparent = (DefaultMutableTreeNode)parent.getParent();
                    int oldIndex = grandparent.getIndex(parent);
                    int lastErrorFile = this.getLastErrorIndex(grandparent, true);
                    int n = newIndex = lastErrorFile == -1 ? 0 : lastErrorFile + 1;
                    if (newIndex != oldIndex) {
                        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                        grandparent.remove(parent);
                        model.nodesWereRemoved(grandparent, new int[]{oldIndex}, new Object[]{parent});
                        grandparent.insert(parent, newIndex);
                        model.nodesWereInserted(grandparent, new int[]{newIndex});
                    }
                }
                parent.insert(node, 0);
            } else {
                parent.insert(node, lastError + 1);
            }
        } else {
            parent.add(node);
        }
        DefaultMutableTreeNode p = parent;
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        model.nodesWereInserted(p, new int[]{p.getIndex(node)});
        tree.makeVisible(new TreePath(node.getPath()));
    }

    private int getLastErrorIndex(DefaultMutableTreeNode parent, boolean checkChildren) {
        int index = -1;
        Enumeration<TreeNode> children = parent.children();
        int i = 0;
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child;
            IdeLog.Message msg;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            Object userObject = node.getUserObject();
            if (userObject instanceof MsgTreeNode && ((MsgTreeNode)userObject).getMessage() != null && ((MsgTreeNode)userObject).getMessage().isError()) {
                index = i;
            } else if (checkChildren && node.getChildCount() > 0 && (msg = ((MsgTreeNode)(child = (DefaultMutableTreeNode)node.getChildAt(0)).getUserObject()).getMessage()) != null && msg.isError()) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    private DefaultMutableTreeNode getWorkspaceNode(DefaultMutableTreeNode parent, URL workspaceURL, boolean insert) {
        DefaultMutableTreeNode workspaceNode = null;
        Enumeration<TreeNode> workspaces = parent.children();
        while (workspaces.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)workspaces.nextElement();
            URL url = ((MsgTreeNode)node.getUserObject()).getURL();
            if (!URLFileSystem.equals((URL)url, (URL)workspaceURL)) continue;
            workspaceNode = node;
            break;
        }
        if (workspaceNode == null && insert) {
            String str = CompArb.format(92, URLFileSystem.getPlatformPathName((URL)workspaceURL));
            MsgTreeNode msgNode = new MsgTreeNode(str, null);
            msgNode.setURL(workspaceURL);
            workspaceNode = new DefaultMutableTreeNode(msgNode);
            parent.add(workspaceNode);
            DefaultMutableTreeNode n = workspaceNode;
            DefaultTreeModel model = (DefaultTreeModel)this.inScopeGetTree().getModel();
            model.nodesWereInserted(parent, new int[]{parent.getIndex(n)});
        }
        return workspaceNode;
    }

    private DefaultMutableTreeNode getProjectNode(DefaultMutableTreeNode parent, Project project, boolean insert) {
        DefaultTreeModel model;
        JTree currentTree;
        URL projectURL = project.getURL();
        DefaultMutableTreeNode projectNode = null;
        Enumeration<TreeNode> projects = parent.children();
        while (projects.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)projects.nextElement();
            URL url = ((MsgTreeNode)node.getUserObject()).getURL();
            if (!URLFileSystem.equals((URL)url, (URL)projectURL)) continue;
            projectNode = node;
            break;
        }
        if (projectNode == null && insert && (currentTree = this.inScopeGetTree()) != null && (model = (DefaultTreeModel)currentTree.getModel()) != null) {
            String str = CompArb.format(17, URLFileSystem.getPlatformPathName((URL)projectURL));
            MsgTreeNode msgNode = new MsgTreeNode(str, null);
            msgNode.setURL(projectURL);
            projectNode = new DefaultMutableTreeNode(msgNode);
            parent.add(projectNode);
            DefaultMutableTreeNode n = projectNode;
            model.nodesWereInserted(parent, new int[]{parent.getIndex(n)});
            project.attach((Observer)this);
        }
        return projectNode;
    }

    private DefaultMutableTreeNode getCachedFileNode(Storage storage) {
        if (storage != null) {
            URL url = URLFactory.newURL((String)storage.getPath());
            return (DefaultMutableTreeNode)this.urlTreeNodeTable.get(url);
        }
        return null;
    }

    protected DefaultMutableTreeNode getFileNode(DefaultMutableTreeNode parent, Storage storage, boolean insert) {
        URL url = URLFactory.newURL((String)storage.getPath());
        DefaultMutableTreeNode fileNode = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(url);
        if (fileNode == null && insert) {
            MsgTreeNode msgNode = new MsgTreeNode(storage, null);
            msgNode.setURL(url);
            fileNode = new DefaultMutableTreeNode(msgNode);
            parent.add(fileNode);
            DefaultMutableTreeNode n = fileNode;
            DefaultTreeModel model = (DefaultTreeModel)this.inScopeGetTree().getModel();
            model.nodesWereInserted(parent, new int[]{parent.getIndex(n)});
            this.urlTreeNodeTable.put(url, fileNode);
        }
        return fileNode;
    }

    protected void updateTreeModel(Collection message) {
        try {
            HelpUtils.setHelpID((JComponent)this.inScopeGetTree(), (String)"f1_com_logwindow_html");
            SwingUtilities.invokeLater(new CreateLogTree(message));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setOffsetMarkTable(URL url, DefaultMutableTreeNode treeNode) {
        Node node = NodeFactory.find((URL)url);
        if (node instanceof TextNode) {
            TextNode tnode = (TextNode)node;
            try {
                try {
                    TextBuffer tbuf = tnode.acquireTextBuffer();
                    LineMap lmap = tbuf.getLineMap();
                    int tCnt = treeNode.getChildCount();
                    OffsetMark[] offsetMarks = new OffsetMark[tCnt];
                    int i = 0;
                    while (i < tCnt) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                        MsgTreeNode msgNode = (MsgTreeNode)child.getUserObject();
                        IdeLog.Message msg = msgNode.getMessage();
                        int offset = msg.line == 0 && msg.col > 0 ? msg.col : lmap.getLineStartOffset(msg.line - 1);
                        msgNode.setURL(url);
                        offsetMarks[i] = msgNode.offsetMark = tbuf.addOffsetMark(offset);
                        ++i;
                    }
                    tnode.attach((Observer)this);
                    this.urlOffsetMarkTable.put(url, offsetMarks);
                }
                catch (Throwable t) {}
            }
            finally {
                tnode.releaseTextBuffer();
            }
        }
    }

    protected void clearUrlOffsetMarkNode(Node node, OffsetMark[] offsetMarks) {
        if (node instanceof TextNode) {
            TextBuffer tbuf;
            TextNode tnode = (TextNode)node;
            if (tnode != null && tnode.isOpen() && (tbuf = tnode.acquireTextBuffer()) != null) {
                int j = 0;
                while (j < offsetMarks.length) {
                    tbuf.removeOffsetMark(offsetMarks[j]);
                    ++j;
                }
            }
            tnode.detach((Observer)this);
        }
    }

    protected void clearUrlOffsetMarkTable() {
        Set set = this.urlOffsetMarkTable.entrySet();
        if (set != null && set.size() > 0) {
            Object[] entries = set.toArray();
            int i = 0;
            while (i < entries.length) {
                Map.Entry entry = (Map.Entry)entries[i];
                URL url = (URL)entry.getKey();
                Node node = NodeFactory.find((URL)url);
                OffsetMark[] om = (OffsetMark[])entry.getValue();
                if (om != null) {
                    this.clearUrlOffsetMarkNode(node, om);
                }
                ++i;
            }
        }
        this.urlOffsetMarkTable.clear();
        this.urlTreeNodeTable.clear();
    }

    private void removeNode(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MsgTreeNode) {
            this.urlTreeNodeTable.remove(((MsgTreeNode)userObject).getURL());
        }
        node.setUserObject(null);
        this.model.removeNodeFromParent(node);
    }

    private void recursivelyRemoveNode(DefaultMutableTreeNode node, boolean itself) {
        int i = node.getChildCount();
        while (i > 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i - 1);
            if (!child.isLeaf()) {
                this.recursivelyRemoveNode(child, false);
            }
            this.removeNode(child);
            --i;
        }
        if (itself) {
            this.removeNode(node);
        }
    }

    private void clearNodes() {
        this.recursivelyRemoveNode(this.root, false);
        this.getTree().setModel(this.model);
        this.clearUrlOffsetMarkTable();
    }

    public void clearAll() {
        this.getTree().scrollRowToVisible(0);
        super.clearAll();
        this.clearNodes();
        this.logText("");
    }

    public String getToolTip() {
        return CompArb.getString(45);
    }

    public void activeViewChanged(ActiveViewEvent e) {
        View editor;
        View view = editor = e != null ? e.getNewView() : Ide.getMainWindow().getLastActiveView();
        if (editor == null || !(editor instanceof CodeEditor)) {
            return;
        }
        Context ctxt = ((CodeEditor)editor).getContext();
        if (ctxt == null || ctxt.getNode() == null || ctxt.getNode().getURL() == null) {
            return;
        }
        URL url = ctxt.getNode().getURL();
        DefaultMutableTreeNode tn = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(url);
        if (tn != null && this.urlOffsetMarkTable.get(url) == null) {
            this.setOffsetMarkTable(url, tn);
        }
    }

    public void update(Object subject, UpdateMessage change) {
        int msgID = change.getMessageID();
        if (msgID == UpdateMessage.OBJECT_RELOADED) {
            if (subject instanceof TextNode) {
                DefaultMutableTreeNode tn;
                URL url = ((TextNode)subject).getURL();
                OffsetMark[] om = (OffsetMark[])this.urlOffsetMarkTable.get(url);
                if (om != null) {
                    this.clearUrlOffsetMarkNode((Node)subject, om);
                }
                if ((tn = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(url)) != null) {
                    this.setOffsetMarkTable(url, tn);
                }
            }
            return;
        }
        if (msgID == UpdateMessage.OBJECT_CLOSED) {
            if (subject instanceof Project) {
                ((Project)subject).detach((Observer)this);
                JCompiler.invokeAsap(new 4(this, subject));
                return;
            }
            if (subject instanceof TextNode) {
                DefaultMutableTreeNode tn;
                URL url = ((TextNode)subject).getURL();
                OffsetMark[] om = (OffsetMark[])this.urlOffsetMarkTable.remove(url);
                if (om != null) {
                    this.clearUrlOffsetMarkNode((Node)subject, om);
                }
                if ((tn = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(url)) != null) {
                    int tCnt = tn.getChildCount();
                    int i = 0;
                    while (i < tCnt) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)tn.getChildAt(i);
                        MsgTreeNode msgNode = (MsgTreeNode)child.getUserObject();
                        msgNode.offsetMark = null;
                        ++i;
                    }
                }
                return;
            }
        }
    }

    static void mav$clearNodes(CompilerPage compilerPage) {
        compilerPage.clearNodes();
    }

    static void mav$addMsg(CompilerPage compilerPage, IdeLog.Message message) {
        compilerPage.addMsg(message);
    }

    static ArrayList ra$asyncMessages(CompilerPage compilerPage) {
        return compilerPage.asyncMessages;
    }

    static void mav$processAsyncMsgQueue(CompilerPage compilerPage, int n) {
        compilerPage.processAsyncMsgQueue(n);
    }

    static Thread ra$updateThread(CompilerPage compilerPage) {
        return compilerPage.updateThread;
    }

    private final class MessageCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            MsgTreeNode node;
            Icon icon;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            if (leaf && obj instanceof MsgTreeNode) {
                Icon i;
                MsgTreeNode node2 = (MsgTreeNode)obj;
                if (node2 != null && (i = CompilerPage.this.getLeafIcon(node2.getMessage())) != null) {
                    this.setIcon(i);
                }
            } else if (obj instanceof MsgTreeNode && (icon = (node = (MsgTreeNode)obj).getIcon()) != null) {
                this.setIcon(icon);
            }
            return this;
        }

        private MessageCellRenderer() {
        }

        MessageCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 1
    extends PeekableTree {
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return CompilerPage.this.treeNodeToString(value);
        }

        public Peek createPeek(TreePath tp) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
            MsgTreeNode msgNode = (MsgTreeNode)node.getUserObject();
            IdeLog.Message msg = msgNode.getMessage();
            CodePeek peek = null;
            if (msg != null && msg.fname != null) {
                try {
                    URL url = new File(msg.fname.getCanonicalPath()).toURL();
                    peek = JavaCodePeek.createCodePeek(msg.getProject(), url, msg.line, URLFileSystem.getFileName((URL)url), (JComponent)((Object)this), this.getPathBounds(tp).intersection(this.getVisibleRect()), "caret-line-highlight");
                }
                catch (MalformedURLException e) {
                    peek = null;
                }
            }
            return peek;
        }
    }

    final class 2
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (CompilerPage.ra$updateThread(CompilerPage.this) == this) {
                try {
                    Thread.sleep(1000L);
                    ArrayList arrayList = CompilerPage.ra$asyncMessages(CompilerPage.this);
                    synchronized (arrayList) {
                        if (CompilerPage.ra$asyncMessages(CompilerPage.this).size() > 0) {
                            CompilerPage.mav$processAsyncMsgQueue(CompilerPage.this, 100);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public 2(String string) {
            super(string);
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ int v$max;
        final /* synthetic */ CompilerPage this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList arrayList = CompilerPage.ra$asyncMessages(this.this$0);
            synchronized (arrayList) {
                int size = CompilerPage.ra$asyncMessages(this.this$0).size();
                int num = this.v$max > 0 && size > this.v$max ? this.v$max : size;
                int i = 0;
                while (i < num) {
                    CompilerPage.mav$addMsg(this.this$0, (IdeLog.Message)CompilerPage.ra$asyncMessages(this.this$0).remove(0));
                    ++i;
                }
            }
        }

        public 3(CompilerPage compilerPage, int n) {
            this.v$max = n;
            this.this$0 = compilerPage;
        }
    }

    final class CreateLogTree
    implements Runnable {
        private final Collection msgs;

        CreateLogTree(Collection msgs) {
            this.msgs = msgs;
        }

        public void run() {
            ArrayList<IdeLog.Message> messages = this.msgs;
            if (this.msgs == null) {
                return;
            }
            CompilerPage.mav$clearNodes(CompilerPage.this);
            ArrayList<IdeLog.Message> newMessages = new ArrayList<IdeLog.Message>(messages.size());
            for (IdeLog.Message msg : messages) {
                if (!msg.isError()) continue;
                newMessages.add(msg);
            }
            for (IdeLog.Message msg : messages) {
                if (msg.isError()) continue;
                newMessages.add(msg);
            }
            messages = newMessages;
            for (IdeLog.Message m : messages) {
                CompilerPage.mav$addMsg(CompilerPage.this, m);
            }
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ Object v$subject;
        final /* synthetic */ CompilerPage this$0;

        public void run() {
            IdeLog.Message msg = new IdeLog.Message(null, (Project)this.v$subject, null, null, 0, 0, 0, 3);
            CompilerPage.mav$addMsg(this.this$0, msg);
            msg = new IdeLog.Message(null, null, null, null, 0, 0, 0, 4);
            CompilerPage.mav$addMsg(this.this$0, msg);
        }

        public 4(CompilerPage compilerPage, Object object) {
            this.v$subject = object;
            this.this$0 = compilerPage;
        }
    }

    protected static final class MsgTreeNode {
        private Object nodeData;
        private IdeLog.Message msg;
        private URL url;
        private Icon icon;
        OffsetMark offsetMark;

        MsgTreeNode(Object nodeData, IdeLog.Message msg) {
            this.nodeData = nodeData;
            this.msg = msg;
            this.url = null;
            this.offsetMark = null;
        }

        public Object getNodeData() {
            return this.nodeData;
        }

        public IdeLog.Message getMessage() {
            return this.msg;
        }

        public Project getProject() {
            return this.msg != null ? this.msg.project : null;
        }

        public Workspace getWorkspace() {
            return this.msg != null ? this.msg.workspace : null;
        }

        public boolean invokeFixEvent() {
            if (this.msg != null && this.msg.fixEvent != null) {
                this.msg.fixEvent.fix(this.msg);
                return true;
            }
            return false;
        }

        public boolean canInvokeFixEvent() {
            if (this.msg != null && this.msg.fixEvent != null) {
                return this.msg.fixEvent.canFix(this.msg);
            }
            return false;
        }

        public boolean invokeActivateEvent() {
            if (this.msg != null && this.msg.activateEvent != null) {
                this.msg.activateEvent.activate(this.msg);
                return true;
            }
            return false;
        }

        public String toString() {
            return this.nodeData.toString();
        }

        public URL getURL() {
            return this.url;
        }

        public void setURL(URL value) {
            this.url = value;
            Node node = NodeFactory.find((URL)this.url);
            boolean uncache = false;
            if (node == null) {
                try {
                    node = NodeFactory.findOrCreate((URL)value);
                    uncache = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (node != null) {
                this.icon = node.getIcon();
            }
            if (uncache) {
                NodeFactory.uncache((URL)this.url);
            }
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

