/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.Project;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.JarStorage;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

public class Helpers {
    public static Storage createFileStorage(String pathName) {
        return new FileStorage(new File(pathName));
    }

    public static Storage createFileStorage(File file) {
        return new FileStorage(file);
    }

    public static boolean isFileStorage(Storage stor) {
        return stor instanceof FileStorage;
    }

    static String arrayToString(String[] a, String separator) {
        if (a == null) {
            return null;
        }
        int len = 0;
        int i = 0;
        while (i < a.length) {
            if (a[i] != null) {
                len += a[i].length();
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer(len += a.length == 0 ? 0 : a.length * separator.length());
        int i2 = 0;
        while (i2 < a.length) {
            if (a[i2] != null) {
                sb.append(a[i2]);
            }
            if (i2 + 1 < a.length) {
                sb.append(separator);
            }
            ++i2;
        }
        return sb.toString();
    }

    static String[] stringToArray(String s, String separator) {
        if (s == null) {
            return null;
        }
        int l = s.length();
        int i = 0;
        int n = 0;
        while (i < l) {
            int j = s.indexOf(separator, i);
            if (j < 0) {
                j = l;
            }
            if (i < j) {
                ++n;
            }
            i = j + 1;
        }
        String[] path = new String[n];
        i = 0;
        n = 0;
        while (i < l) {
            int j = s.indexOf(separator, i);
            if (j < 0) {
                j = l;
            }
            if (i < j) {
                path[n++] = s.substring(i, j);
            }
            i = j + 1;
        }
        return path;
    }

    static Storage[] stringToStorageArray(String s) {
        String[] sa = Helpers.stringToArray(s, File.pathSeparator);
        if (sa == null) {
            return null;
        }
        Storage[] path = new Storage[sa.length];
        int i = 0;
        while (i < sa.length) {
            path[i] = sa[i].endsWith(".jar") || sa[i].endsWith(".zip") ? new oracle.ojc.storage.JarStorage(new File(sa[i])) : new FileStorage(new File(sa[i]));
            ++i;
        }
        return path;
    }

    static ArrayList listOfUniqueClassPathElement(ArrayList storageList) {
        ArrayList<URL> uniqueElements = null;
        HashMap<URL, URL> map = null;
        if (storageList != null) {
            int i = 0;
            while (i < storageList.size()) {
                Storage st = (Storage)storageList.get(i);
                ArrayList l = (ArrayList)st.getProperty("dependantClassPathURLList");
                if (l != null) {
                    if (map == null) {
                        map = new HashMap<URL, URL>();
                    }
                    int j = 0;
                    while (j < l.size()) {
                        URL cp = (URL)l.get(j);
                        if (map.get(cp) == null) {
                            map.put(cp, cp);
                            if (uniqueElements == null) {
                                uniqueElements = new ArrayList<URL>();
                            }
                            uniqueElements.add(cp);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return uniqueElements;
    }

    private static void addStoragePath(HashSet seenURLs, ArrayList storagePath, URL url, boolean isFromManifestFile) {
        if (seenURLs.contains(url)) {
            return;
        }
        seenURLs.add(url);
        if (JarUtil.isJarURL((URL)url)) {
            URL jarFileUrl = JarUtil.getJarFileURL((URL)url);
            File jarFile = new File(jarFileUrl.getPath());
            if (jarFile.exists()) {
                JarStorage jarStorage = new JarStorage(url);
                if (isFromManifestFile) {
                    jarStorage.setProperty("isFromManifestFile", Boolean.TRUE);
                }
                storagePath.add(jarStorage);
                try {
                    String classPathAttr = JarUtil.getClassPath((File)jarFile);
                    if (classPathAttr != null) {
                        URL dirUrl = URLFileSystem.getParent((URL)jarFileUrl);
                        StringTokenizer st = new StringTokenizer(classPathAttr);
                        while (st.hasMoreTokens()) {
                            String classPathItemStr = st.nextToken();
                            boolean isJar = false;
                            URL classPathItemURL = URLFactory.newURL((URL)dirUrl, (String)classPathItemStr);
                            if (JarUtil.isArchive((String)classPathItemStr)) {
                                isJar = true;
                                classPathItemURL = URLFactory.newJarURL((URL)classPathItemURL, null);
                            }
                            Helpers.addStoragePath(seenURLs, storagePath, classPathItemURL, true);
                        }
                    }
                }
                catch (IOException e) {}
            }
        } else {
            File file = new File(url.getPath());
            if (file.isDirectory()) {
                storagePath.add(new DirectoryStorage(file));
            } else if (file.exists()) {
                storagePath.add(new FileStorage(file));
            }
        }
    }

    static Storage[] urlPathAndDependantPathToStorageArray(URLPath urlPath, ArrayList storageList) {
        int n;
        ArrayList cpElements = Helpers.listOfUniqueClassPathElement(storageList);
        int cpElementCnt = cpElements == null ? 0 : cpElements.size();
        URL[] urls = urlPath == null ? null : urlPath.getEntries();
        int n2 = n = urls == null ? 0 : urls.length;
        if (n + cpElementCnt == 0) {
            return null;
        }
        HashSet seenURLs = new HashSet();
        ArrayList storagePathList = new ArrayList(n + cpElementCnt);
        int i = 0;
        while (i < n) {
            Helpers.addStoragePath(seenURLs, storagePathList, urls[i], false);
            ++i;
        }
        int i2 = 0;
        while (i2 < cpElementCnt) {
            Helpers.addStoragePath(seenURLs, storagePathList, (URL)cpElements.get(i2), false);
            ++i2;
        }
        return storagePathList.toArray(new Storage[storagePathList.size()]);
    }

    static Storage[] urlPathToStorageArray(URLPath urlPath) {
        return Helpers.urlPathAndDependantPathToStorageArray(urlPath, null);
    }

    private static void addStringPath(StringBuffer path, URL url, String separator) {
        File urlFile;
        if (JarUtil.isJarURL((URL)url)) {
            url = JarUtil.getJarFileURL((URL)url);
        }
        if ((urlFile = new File(url.getPath())).exists()) {
            path.append(urlFile.getPath());
            path.append(separator);
        }
    }

    static String urlPathAndDependantPathToString(URLPath urlPath, ArrayList storageList, String separator) {
        ArrayList cpElements = Helpers.listOfUniqueClassPathElement(storageList);
        URL[] urls = urlPath == null ? null : urlPath.getEntries();
        StringBuffer path = new StringBuffer(30);
        if (urls != null) {
            int i = 0;
            while (i < urls.length) {
                Helpers.addStringPath(path, urls[i], separator);
                ++i;
            }
        }
        if (cpElements != null) {
            int i = 0;
            while (i < cpElements.size()) {
                Helpers.addStringPath(path, (URL)cpElements.get(i), separator);
                ++i;
            }
        }
        if (path.length() > 0) {
            path.deleteCharAt(path.length() - 1);
        }
        return path.toString();
    }

    static String urlPathToString(URLPath urlPath, String separator) {
        return Helpers.urlPathAndDependantPathToString(urlPath, null, separator);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static URL[] getUrlsThroughIndexer(Project prj, QueryCriteria queryCriteria) {
        IndexManager manager = IndexManager.getIndexManager();
        Index index = manager.getIndex(prj);
        BackgroundTask query = index.query(queryCriteria);
        try {
            URL[] uRLArray = (URL[])query.get();
            return uRLArray;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(CompArb.getString(82));
            catch (Exception e2) {
                JCompiler.getLogger().log(Level.SEVERE, "Unable to retrieve project content", e2);
            }
        }
        finally {
            index.release();
        }
        index.release();
        return new URL[0];
    }
}

