/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.IdeStorageMap;
import oracle.ojc.interfaces.Storage;

class IdeStorageWrapper
implements Storage {
    private Storage storage;
    private IdeStorageMap map;
    private HashMap properties;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.properties = null;
    }

    public IdeStorageWrapper(Storage storage, IdeStorageMap map) {
        this.$init$();
        this.storage = storage;
        this.map = map;
    }

    public long modDate() {
        return this.storage.modDate();
    }

    public String getName() {
        return this.storage.getName();
    }

    public String getPath() {
        return this.storage.getPath();
    }

    public String getCanonicalPath() {
        return this.storage.getCanonicalPath();
    }

    public Object getProperty(String property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(property, value);
    }

    public boolean isDirectory() {
        return this.storage.isDirectory();
    }

    public boolean isInJar() {
        return this.storage.isInJar();
    }

    public byte[] read() throws IOException {
        return this.storage.read();
    }

    public int read(byte[] buf) throws IOException {
        return this.storage.read(buf);
    }

    public void write(byte[] xs, int start, int len) throws IOException {
        this.storage.write(xs, start, len);
    }

    public String[] list() {
        URL url;
        ArrayList ideFiles;
        String[] storageFiles = this.storage.list();
        if (this.map != null && Helpers.isFileStorage(this.storage) && (ideFiles = this.map.get(url = URLFactory.newDirURL((String)this.storage.getPath()))) != null) {
            String[] merged;
            if (storageFiles == null || storageFiles.length == 0) {
                merged = ideFiles.toArray(new String[ideFiles.size()]);
            } else {
                int i = 0;
                while (i < storageFiles.length) {
                    int index = ideFiles.indexOf(storageFiles[i]);
                    if (index != -1) {
                        ideFiles.remove(index);
                    }
                    ++i;
                }
                merged = new String[storageFiles.length + ideFiles.size()];
                System.arraycopy(storageFiles, 0, merged, 0, storageFiles.length);
                int i2 = 0;
                while (i2 < ideFiles.size()) {
                    merged[storageFiles.length + i2] = (String)ideFiles.get(i2);
                    ++i2;
                }
            }
            return merged;
        }
        return storageFiles;
    }

    static {
        $assertionsDisabled = IdeStorageWrapper.class.desiredAssertionStatus() ^ true;
    }

    public int size() throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    public ArrayList listStorage() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public void open() throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public Storage open(String name) {
        File f;
        URL url;
        Node node;
        if (Helpers.isFileStorage(this.storage) && (node = NodeFactory.find((URL)(url = URLFactory.newFileURL((File)(f = new File(this.storage.getPath(), name)))))) != null && node.isDirty()) {
            return new IdeStorage(node);
        }
        return this.storage.open(name);
    }

    public Storage create(String name) throws IOException {
        Storage s = this.storage.create(name);
        if (s != null) {
            return new IdeStorageWrapper(s, this.map);
        }
        return null;
    }

    public Storage createDir(String name) throws IOException {
        Storage s = this.storage.createDir(name);
        if (s != null) {
            return new IdeStorageWrapper(s, this.map);
        }
        return null;
    }

    public void close() {
        this.storage.close();
    }

    public String toString() {
        return this.storage.toString();
    }

    public int hashCode() {
        return this.storage.hashCode();
    }

    public boolean equals(Object obj) {
        return this.storage.equals(obj);
    }
}

