/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ide.compiler.CopyListener;
import oracle.ide.compiler.PostBuilder;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.panels.Navigable;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerPage;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.compiler.OjcConfigurationPanel;
import oracle.jdeveloper.compiler.OutputStreamLogPage;
import oracle.jdeveloper.compiler.ProblemsPage;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.compiler.CompilerOptionPanel;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.jdevimpl.resource.CompilerArb;
import oracle.ojc.interfaces.Storage;

public final class JCompiler
extends Compiler
implements Addin,
ShutdownHook {
    private static final String pkgName = "oracle.jdeveloper.compiler.";
    public static final String DISABLE_FILE_NOT_IN_PROJECT_WARNING = "disableFileNotInProjectWarning";
    public static final int MAKE_SELECTED_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_SELECTED_CMD_ID");
    public static final String MAKE_SELECTED_CMD = "oracle.jdeveloper.compiler.MakeSelectedCommand";
    public static final int BUILD_SELECTED_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_SELECTED_CMD_ID");
    public static final String BUILD_SELECTED_CMD = "oracle.jdeveloper.compiler.BuildSelectedCommand";
    public static final int MAKE_WORKINGSET_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_WORKINGSET_CMD_ID");
    public static final String MAKE_WORKINGSET_CMD = "oracle.jdeveloper.compiler.MakeWorkingSetCommand";
    public static final int BUILD_WORKINGSET_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_WORKINGSET_CMD_ID");
    public static final String BUILD_WORKINGSET_CMD = "oracle.jdeveloper.compiler.BuildWorkingSetCommand";
    public static final int MAKE_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_PROJECT_CMD_ID");
    public static final String MAKE_PROJECT_CMD = "oracle.jdeveloper.compiler.MakeProjectCommand";
    public static final int BUILD_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_PROJECT_CMD_ID");
    public static final String BUILD_PROJECT_CMD = "oracle.jdeveloper.compiler.BuildProjectCommand";
    public static final int MAKE_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_WORKSPACE_CMD_ID");
    public static final String MAKE_WORKSPACE_CMD = "oracle.jdeveloper.compiler.MakeWorkspaceCommand";
    public static final int BUILD_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_WORKSPACE_CMD_ID");
    public static final String BUILD_WORKSPACE_CMD = "oracle.jdeveloper.compiler.BuildWorkspaceCommand";
    public static final int MAKE_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_FOLDER_CMD_ID");
    public static final String MAKE_FOLDER_CMD = "oracle.jdeveloper.compiler.MakeFolderCommand";
    public static final int CANCEL_BUILD_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.CANCEL_BUILD_CMD_ID");
    public static final String CANCEL_BUILD_CMD = "oracle.jdeveloper.compiler.CancelBuildCommand";
    public static final int CLEANALL_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.CLEANALL_CMD_ID");
    public static final String CLEANALL_CMD = "oracle.jdeveloper.compiler.CleanAllCommand";
    private static final String msgStart = CompArb.getString(50);
    private static final String cleanCompleted = CompArb.getString(18);
    private static final String cleanCancelled = CompArb.getString(19);
    private static final String msgSuccess = CompArb.getString(40);
    private static final String msgNothingToBuild = CompArb.getString(69);
    private static JCompiler instance;
    private LogPage outputLog;
    private LogPage errorLog;
    private LogPage userDefinedOutputLog;
    private LogPage userDefinedErrorLog;
    private Navigable compilerNavigable;
    private ArrayList buildListeners;
    private HashMap cachedProjects;
    private NodeListener cachedProjectsNL;
    ArrayList copyListeners;
    private boolean disableProjectUpdates;
    private Boolean busy;
    private final ProjectChangeListener projectChangeListener;

    private void $init$() {
        this.buildListeners = new ArrayList();
        this.cachedProjects = new HashMap();
        this.cachedProjectsNL = new 1();
        this.copyListeners = new ArrayList();
        this.disableProjectUpdates = false;
        this.busy = false;
        this.projectChangeListener = new 2();
    }

    public static JCompiler getInstance() {
        if (instance == null) {
            instance = new JCompiler();
        }
        return instance;
    }

    JCompiler() {
        this.$init$();
        instance = this;
    }

    static void invokeAsap(Runnable runnable) {
        if (!Ide.getIdeArgs().getCreateUI() || SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void projectPropertiesChangedImpl(ProjectChangeEvent e) {
        ChangeInfo[] changes = e.getChangeDetails();
        if (changes != null) {
            int i = 0;
            while (i < changes.length) {
                if (changes[i].getChangeType() == 0 || changes[i].getChangeType() == 1) {
                    Project prj = e.getProject();
                    if (prj == null || this.disableProjectUpdates) break;
                    if (prj.isDirty()) {
                        if (this.cachedProjects.isEmpty()) {
                            Project.addNodeListenerForType(Project.class, (NodeListener)this.cachedProjectsNL);
                        }
                        this.cachedProjects.put(prj, Boolean.TRUE);
                        break;
                    }
                    this.removeProjectFromCache(prj);
                    break;
                }
                ++i;
            }
        }
    }

    private void removeProjectFromCache(Project prj) {
        this.cachedProjects.remove(prj);
        if (this.cachedProjects.isEmpty()) {
            Project.removeNodeListenerForType(Project.class, (NodeListener)this.cachedProjectsNL);
        }
    }

    public boolean forceRebuildOnProject(Project prj) {
        if ((Boolean)this.cachedProjects.get(prj) == null) {
            return false;
        }
        this.removeProjectFromCache(prj);
        return true;
    }

    public void initialize() {
        Compiler.setCompiler((Compiler)this);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.addBuildSystemListener((BuildSystemListener)new 3());
        }
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdeveloper/compiler/accelerators.xml");
        this.compilerNavigable = new Navigable(CompArb.getString(73), OjcConfigurationPanel.class);
        ProjectPropertiesDialog.addPanel((Navigable)this.compilerNavigable);
        String compilerOptionPanelName = CompilerArb.getString((int)69);
        this.registerNavigable(new Navigable(compilerOptionPanelName, CompilerOptionPanel.class));
        Project.addProjectChangeListener((String)OjcConfiguration.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries", (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)JProjectPaths.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)PathsConfiguration.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    private static boolean isSilentReload() {
        EnvironOptions envOpts = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        return envOpts.getSilentReload();
    }

    public void shutdown() {
    }

    public boolean canShutdown() {
        if (!this.isBusy(null)) {
            return true;
        }
        int answer = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), CompArb.getString(36), CompArb.getString(97), 0, 3);
        if (answer == 0) {
            this.stopBuild(null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy(Context context) {
        Boolean bl = this.busy;
        synchronized (bl) {
            boolean bl2 = this.busy != false || UnifiedBuildSystem.getInstance().isAlive() || UnifiedBuildSystem.getInstance().isLocked(context);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setBusy(Context context) {
        Boolean bl = this.busy;
        synchronized (bl) {
            if (this.isBusy(context)) {
                boolean bl2 = false;
                return bl2;
            }
            this.busy = true;
            boolean bl3 = true;
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNotBusy() {
        Boolean bl = this.busy;
        synchronized (bl) {
            this.busy = false;
        }
    }

    public void stopBuild(Context context) {
        UnifiedBuildSystem.getInstance().stopBuildSystem();
    }

    void cleanAll(Context context) {
        if (this.setBusy(context)) {
            try {
                UnifiedBuildSystem.getInstance().initCleanAll(context);
            }
            finally {
                this.setNotBusy();
            }
        }
    }

    private void saveAll(boolean saveRequested) {
        if (saveRequested && Ide.getEnvironOptions().getSaveBeforeCompile()) {
            IdeUtil.runNow((Runnable)new 4());
        }
    }

    public boolean compile(Context context, boolean rebuild, boolean wait) {
        return this.compile(context, rebuild, wait, false, null, null);
    }

    public boolean compile(Context context, boolean rebuild, boolean wait, boolean save) {
        return this.compile(context, rebuild, wait, save, null, null);
    }

    public void compile(Context context, boolean rebuild, PostBuilder postBuild, boolean save) {
        5 t = new 5(this, context, rebuild, save, postBuild);
        t.start();
    }

    public boolean compile(Context context, boolean rebuild, boolean wait, OutputStream outStream, OutputStream errStream) {
        return this.compile(context, rebuild, wait, false, outStream, errStream);
    }

    private boolean compile(Context context, boolean rebuild, boolean wait, boolean save, OutputStream outStream, OutputStream errStream) {
        UnifiedBuildSystem ubs = UnifiedBuildSystem.getInstance();
        boolean result = false;
        if (!this.setBusy(context)) {
            return false;
        }
        try {
            try {
                this.userDefinedOutputLog = outStream != null ? new OutputStreamLogPage(outStream) : null;
                this.userDefinedErrorLog = errStream != null ? new OutputStreamLogPage(errStream) : null;
                if (Ide.getIdeArgs().getCreateUI()) {
                    this.saveAll(save);
                }
                result = wait && SwingUtilities.isEventDispatchThread() ? ubs.buildOnUIThread(context, rebuild) : ubs.init(context, rebuild);
                if (wait && result) {
                    ubs.join(0L);
                }
                if (result) {
                    result = ubs.getLastErrorCount() == 0;
                }
            }
            catch (InterruptedException t) {
                result = false;
            }
        }
        finally {
            this.setNotBusy();
        }
        return result;
    }

    public boolean clean(Context context, boolean throwOnFailedDelete, OutputStream outStream, OutputStream errStream) throws IOException {
        if (!this.setBusy(context)) {
            return false;
        }
        try {
            File fileOfFailedDelete;
            this.userDefinedOutputLog = outStream != null ? new OutputStreamLogPage(outStream) : null;
            this.userDefinedErrorLog = errStream != null ? new OutputStreamLogPage(errStream) : null;
            UnifiedBuildSystem ubs = UnifiedBuildSystem.getInstance();
            if (!ubs.initCleanAll(context, true, throwOnFailedDelete)) {
                boolean bl = false;
                return bl;
            }
            ubs.join(0L);
            if (throwOnFailedDelete && (fileOfFailedDelete = ubs.getFileOfFailedDelete()) != null) {
                throw new IOException(fileOfFailedDelete.getPath());
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = true;
            this.setNotBusy();
            return bl;
        }
        {
            finally {
                this.setNotBusy();
            }
        }
    }

    public boolean internalJavaCompile(Context context, ArrayList messages) throws Exception {
        boolean[] areThereErrors = new boolean[]{false};
        if (!this.setBusy(context)) {
            throw new IllegalStateException();
        }
        boolean savedValue = UnifiedBuildSystem.showCompileProgress;
        try {
            try {
                UnifiedBuildSystem.showCompileProgress = false;
                Element[] files = context.getSelection();
                ArrayList<IdeStorage> sources = new ArrayList<IdeStorage>();
                Element[] elementArray = files;
                int n = 0;
                while (n < elementArray.length) {
                    Element file = elementArray[n];
                    if (!file.getLongLabel().endsWith(".java")) {
                        throw new IllegalArgumentException();
                    }
                    sources.add(new IdeStorage((Node)file));
                    ++n;
                }
                Translator javaTranslator = UnifiedBuildSystem.getInstance().getJavaTranslator();
                if (javaTranslator == null) {
                    throw new ClassNotFoundException();
                }
                6 log = new 6(this, areThereErrors, messages);
                Project prj = context.getProject();
                if (prj == null) {
                    prj = Ide.getActiveProject();
                }
                javaTranslator.setLog(log);
                javaTranslator.translate(prj, true, sources, new ArrayList());
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
        }
        finally {
            UnifiedBuildSystem.showCompileProgress = savedValue;
            this.setNotBusy();
        }
        return areThereErrors[0] ^ true;
    }

    public int compileInThread(Thread thread, Project prj, ArrayList files, boolean rebuild) {
        UnifiedBuildSystem ubs = UnifiedBuildSystem.getInstance();
        return ubs.compileInThread(thread, prj, files, rebuild);
    }

    private static BuildSystemConfiguration getBuildSysConfig(Project prj) {
        return BuildSystemConfiguration.getInstance((PropertyStorage)prj);
    }

    static boolean getReverseCopyRes(Project prj) {
        BuildSystemConfiguration bsc = JCompiler.getBuildSysConfig(prj);
        if (bsc != null) {
            return bsc.getReverseCopyRes();
        }
        return false;
    }

    static String[] getCopyRes(Project prj) {
        BuildSystemConfiguration bsc = JCompiler.getBuildSysConfig(prj);
        if (bsc != null) {
            return bsc.getCopyRes();
        }
        return null;
    }

    static boolean isCopyable(String name, String[] copyResSpec, boolean reverseCopy) {
        if (name != null && copyResSpec != null) {
            int i = 0;
            while (i < copyResSpec.length) {
                if (name.endsWith(copyResSpec[i])) {
                    return reverseCopy ^ true;
                }
                ++i;
            }
        }
        return reverseCopy;
    }

    static boolean isCopyable(Element element, String[] copyResSpec, boolean reverseCopy) {
        if (element != null) {
            URL url;
            String name = element instanceof Node ? ((url = ((Node)element).getURL()) != null ? url.getPath() : element.getShortLabel()) : element.getShortLabel();
            return JCompiler.isCopyable(name, copyResSpec, reverseCopy);
        }
        return false;
    }

    static boolean isCopyable(Element element, Project prj) {
        return JCompiler.isCopyable(element, JCompiler.getCopyRes(prj), JCompiler.getReverseCopyRes(prj));
    }

    public synchronized boolean addCopyListener(CopyListener cl) {
        int i = 0;
        while (i < this.copyListeners.size()) {
            if ((CopyListener)this.copyListeners.get(i) == cl) {
                return false;
            }
            ++i;
        }
        this.copyListeners.add(cl);
        return true;
    }

    public synchronized boolean removeCopyListener(CopyListener cl) {
        int i = 0;
        while (i < this.copyListeners.size()) {
            if ((CopyListener)this.copyListeners.get(i) == cl) {
                this.copyListeners.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized boolean addBuildSystemListener(BuildSystemListener bsl) {
        int i = 0;
        while (i < this.buildListeners.size()) {
            if ((BuildSystemListener)this.buildListeners.get(i) == bsl) {
                return false;
            }
            ++i;
        }
        this.buildListeners.add(bsl);
        return true;
    }

    public synchronized boolean removeBuildSystemListener(BuildSystemListener bsl) {
        int i = 0;
        while (i < this.buildListeners.size()) {
            if ((BuildSystemListener)this.buildListeners.get(i) == bsl) {
                this.buildListeners.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    void invokeListenersBuildBegin(Context context, IdeLog ideLog) throws BuildSystemVetoException {
        listeners = this.getBuildSystemListenersArray();
        if (listeners == null) {
            return;
        }
        i = 0;
        while (i < listeners.length) {
            block5: {
                try {
                    startTime = System.nanoTime();
                    listeners[i].buildWillStart(context);
                    endTime = System.nanoTime();
                    PerformanceLogger.get().log("BuildSystemListener.buildWillStart()", listeners[i].getClass().getName(), endTime - startTime);
                    break block5;
                }
                catch (BuildSystemVetoException ex) {
                    ideLog.error(null, 0, 0, 0, ex.getMessage());
                    j = 0;
                    ** while (j < i)
                }
lbl-1000:
                // 1 sources

                {
                    this.invokeOneListenerBuildFinish(listeners[j], ideLog);
                    ++j;
                    continue;
                }
lbl19:
                // 1 sources

                throw ex;
            }
            ++i;
        }
    }

    void invokeListenersBuildFinish(IdeLog ideLog) {
        BuildSystemListener[] listeners = this.getBuildSystemListenersArray();
        if (listeners == null) {
            return;
        }
        int i = 0;
        while (i < listeners.length) {
            this.invokeOneListenerBuildFinish(listeners[i], ideLog);
            ++i;
        }
    }

    private void invokeOneListenerBuildFinish(BuildSystemListener listener, IdeLog ideLog) {
        try {
            long startTime = System.nanoTime();
            listener.buildFinished(ideLog.nerrors(), ideLog.nwarnings(), 0);
            long endTime = System.nanoTime();
            PerformanceLogger.get().log("BuildSystemListener.buildFinished", listener.getClass().getName(), endTime - startTime);
        }
        catch (BuildSystemVetoException ex) {
            ideLog.error(null, 0, 0, 0, ex.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    void invokeListenersCleanBegin(Context context, IdeLog ideLog) throws BuildSystemVetoException {
        listeners = this.getBuildSystemListenersArray();
        if (listeners == null) {
            return;
        }
        i = 0;
        while (i < listeners.length) {
            block6: {
                try {
                    startTime = System.nanoTime();
                    listeners[i].cleanWillStart(context);
                    endTime = System.nanoTime();
                    PerformanceLogger.get().log("BuildSystemListener.cleanWillStart", listeners[i].getClass().getName(), endTime - startTime);
                    break block6;
                }
                catch (AbstractMethodError e) {
                    break block6;
                }
                catch (BuildSystemVetoException bsvex) {
                    ideLog.error(null, 0, 0, 0, bsvex.getMessage());
                    j = 0;
                    ** while (j < i)
                }
lbl-1000:
                // 1 sources

                {
                    this.invokeOneListenerCleanFinish(listeners[j], context, ideLog);
                    ++j;
                    continue;
                }
lbl21:
                // 1 sources

                throw bsvex;
            }
            ++i;
        }
    }

    void invokeListenersCleanFinish(Context context, IdeLog ideLog) {
        BuildSystemListener[] listeners = this.getBuildSystemListenersArray();
        if (listeners == null) {
            return;
        }
        int i = 0;
        while (i < listeners.length) {
            this.invokeOneListenerCleanFinish(listeners[i], context, ideLog);
            ++i;
        }
    }

    private void invokeOneListenerCleanFinish(BuildSystemListener listener, Context context, IdeLog ideLog) {
        try {
            long startTime = System.nanoTime();
            listener.cleanFinished(context);
            long endTime = System.nanoTime();
            PerformanceLogger.get().log("BuildSystemListener.cleanFinished", listener.getClass().getName(), endTime - startTime);
        }
        catch (AbstractMethodError e) {
        }
        catch (BuildSystemVetoException bsvex) {
            ideLog.error(null, 0, 0, 0, bsvex.getMessage());
        }
    }

    private synchronized BuildSystemListener[] getBuildSystemListenersArray() {
        if (this.buildListeners == null || this.buildListeners.size() == 0) {
            return null;
        }
        BuildSystemListener[] listeners = new BuildSystemListener[this.buildListeners.size()];
        int i = 0;
        Iterator iter = this.buildListeners.iterator();
        while (iter.hasNext()) {
            listeners[i++] = (BuildSystemListener)iter.next();
        }
        return listeners;
    }

    public boolean lock(Context context, boolean wait) {
        if (this.isBusy(context)) {
            if (!wait) {
                return false;
            }
            try {
                UnifiedBuildSystem.getInstance().join(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return UnifiedBuildSystem.getInstance().lock(context);
    }

    public boolean unlock(Context context) {
        return UnifiedBuildSystem.getInstance().unlock();
    }

    public LogPage getOutputLog() {
        if (this.userDefinedOutputLog != null) {
            return this.userDefinedOutputLog;
        }
        if (this.outputLog == null) {
            IdeArgs args = Ide.getIdeArgs();
            this.outputLog = !args.getCreateUI() || args.hasArg("-make") || args.hasArg("-rebuild") ? new OutputStreamLogPage(System.out) : LogManager.getLogManager().getMsgPage();
        }
        return this.outputLog;
    }

    public void logOutMsg(String msg) {
        try {
            JCompiler.invokeAsap(new 7(this, msg));
        }
        catch (Throwable t) {
            Assert.printStackTrace((Throwable)t);
        }
    }

    void logOutStartBuild() {
        JCompiler.invokeAsap(new 8());
    }

    private void _logOutEndBuild(int filesBuilt, int cleanAll) {
        IdeLog ideLog = UnifiedBuildSystem.ideLog;
        if (ideLog == null) {
            return;
        }
        DateFormat timeFormatter = DateFormat.getTimeInstance(2);
        String timeMsg = "[" + timeFormatter.format(new Date()) + "] ";
        if (cleanAll > 0) {
            String msg = timeMsg + (cleanAll == 1 ? cleanCompleted : cleanCancelled);
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(msg + "\n");
            }
            this.setStatusBarText(msg);
        } else if (ideLog.nerrors() + ideLog.nwarnings() > 0) {
            String msgFailure = timeMsg + CompArb.format(37, Integer.toString(ideLog.nerrors()), Integer.toString(ideLog.nwarnings()));
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(msgFailure + "\n");
            }
            this.setStatusBarText(msgFailure);
            ideLog.unregisterAsynchronousLogPage(this.getErrorLog());
        } else {
            String msg = timeMsg + (filesBuilt == 0 ? msgNothingToBuild : msgSuccess);
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(msg + "\n");
            }
            this.setStatusBarText(msg);
            ideLog.unregisterAsynchronousLogPage(this.getErrorLog());
        }
    }

    private void setStatusBarText(String message) {
        Ide.getStatusBar().setText(message);
    }

    void logOutEndBuild(int filesBuilt, int cleanAll) {
        JCompiler.invokeAsap(new 9(this, filesBuilt, cleanAll));
    }

    public static Logger getLogger() {
        return Logger.getLogger(JCompiler.class.getName());
    }

    public LogPage getErrorLog() {
        if (this.userDefinedErrorLog != null) {
            return this.userDefinedErrorLog;
        }
        if (this.errorLog == null) {
            IdeArgs args = Ide.getIdeArgs();
            this.errorLog = !Ide.getIdeArgs().getCreateUI() ? new OutputStreamLogPage(System.err) : (args.hasArg("-make") || args.hasArg("-rebuild") ? new OutputStreamLogPage(System.err) : (System.getProperty("compiler.log") != null && System.getProperty("compiler.log").equals("tablestyle") ? new ProblemsPage() : new CompilerPage()));
        }
        return this.errorLog;
    }

    public void registerTranslator(Translator translator) {
        UnifiedBuildSystem.getInstance().registerTranslator(translator);
    }

    public void unregisterTranslator(Translator translator) {
        UnifiedBuildSystem.getInstance().unregisterTranslator(translator);
    }

    public void registerNavigable(Navigable navigable) {
        if (this.compilerNavigable != null) {
            this.compilerNavigable.addChildNavigable(navigable);
        }
    }

    static void mav$removeProjectFromCache(JCompiler jCompiler, Project project) {
        jCompiler.removeProjectFromCache(project);
    }

    static void mav$projectPropertiesChangedImpl(JCompiler jCompiler, ProjectChangeEvent projectChangeEvent) {
        jCompiler.projectPropertiesChangedImpl(projectChangeEvent);
    }

    static void mav$_logOutEndBuild(JCompiler jCompiler, int n, int n2) {
        jCompiler._logOutEndBuild(n, n2);
    }

    static String ra$msgStart() {
        return msgStart;
    }

    static void mav$setStatusBarText(JCompiler jCompiler, String string) {
        jCompiler.setStatusBarText(string);
    }

    static boolean mav$compile(JCompiler jCompiler, Context context, boolean bl, boolean bl2, boolean bl3, OutputStream outputStream, OutputStream outputStream2) {
        return jCompiler.compile(context, bl, bl2, bl3, outputStream, outputStream2);
    }

    static boolean ra$disableProjectUpdates(JCompiler jCompiler) {
        return jCompiler.disableProjectUpdates;
    }

    static void wa$disableProjectUpdates(JCompiler jCompiler, boolean bl) {
        jCompiler.disableProjectUpdates = bl;
    }

    final class 1
    extends NodeListener {
        public void nodeClosed(NodeEvent ee) {
            JCompiler.mav$removeProjectFromCache(JCompiler.this, (Project)ee.getNode());
        }
    }

    final class 2
    extends ProjectChangeListener {
        public void projectPropertiesChanged(ProjectChangeEvent e) {
            JCompiler.mav$projectPropertiesChangedImpl(JCompiler.this, e);
        }
    }

    final class 3
    implements BuildSystemListener {
        private HashMap _timestampMap;

        public void buildWillStart(Context context) throws BuildSystemVetoException {
            this._timestampMap = new HashMap();
            NodeUtil.storeAllTimestamps((Map)this._timestampMap);
        }

        public void buildFinished(int errorCount, int warningCount, int infoCount) throws BuildSystemVetoException {
            EnvironOptions envOpts = Ide.getEnvironOptions();
            HashMap timestampMap = this._timestampMap;
            this._timestampMap = null;
            if (envOpts.getAutoReloadExtMod()) {
                NodeUtil.reloadBuffers((Map)timestampMap, (boolean)envOpts.getSilentReload());
            }
        }

        public void cleanWillStart(Context context) throws BuildSystemVetoException {
        }

        public void cleanFinished(Context context) throws BuildSystemVetoException {
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            boolean oldValue = JCompiler.ra$disableProjectUpdates(JCompiler.this);
            JCompiler.wa$disableProjectUpdates(JCompiler.this, true);
            try {
                try {
                    SaveAllCommand.saveAll();
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            finally {
                JCompiler.wa$disableProjectUpdates(JCompiler.this, oldValue);
            }
        }
    }

    final class 5
    extends Thread {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ boolean v$rebuild;
        private final /* synthetic */ boolean v$save;
        private final /* synthetic */ PostBuilder v$postBuild;
        final /* synthetic */ JCompiler this$0;

        public void run() {
            boolean result = JCompiler.mav$compile(this.this$0, this.v$context, this.v$rebuild, true, this.v$save, null, null);
            if (this.v$postBuild != null) {
                this.v$postBuild.postBuild(result);
            }
        }

        public 5(JCompiler jCompiler, Context context, boolean bl, boolean bl2, PostBuilder postBuilder) {
            this.v$postBuild = postBuilder;
            this.v$save = bl2;
            this.v$rebuild = bl;
            this.v$context = context;
            this.this$0 = jCompiler;
        }
    }

    final class 6
    implements Translator.Log {
        int errCnt;
        int warningCnt;
        private final /* synthetic */ boolean[] v$areThereErrors;
        private final /* synthetic */ ArrayList v$messages;
        final /* synthetic */ JCompiler this$0;

        private void $init$() {
            this.errCnt = 0;
            this.warningCnt = 0;
        }

        public void error(Storage source, int line, int col, int errNumber, String errMsg) {
            this.v$areThereErrors[0] = true;
            this.v$messages.add(source.getPath() + '(' + line + ',' + col + "):" + errNumber + ':' + errMsg);
            ++this.errCnt;
        }

        public void warning(Storage source, int line, int col, int errNumber, String errMsg) {
            this.v$messages.add(source.getPath() + '(' + line + ',' + col + "):" + errNumber + ':' + errMsg);
            ++this.warningCnt;
        }

        public void clear(Storage source) {
        }

        public int nerrors() {
            return this.errCnt;
        }

        public int nwarnings() {
            return this.warningCnt;
        }

        public 6(JCompiler jCompiler, boolean[] blArray, ArrayList arrayList) {
            this.v$messages = arrayList;
            this.v$areThereErrors = blArray;
            this.this$0 = jCompiler;
            this.$init$();
        }
    }

    final class 7
    implements Runnable {
        private final /* synthetic */ String v$msg;
        final /* synthetic */ JCompiler this$0;

        public void run() {
            this.this$0.getOutputLog().log((Object)this.v$msg);
        }

        public 7(JCompiler jCompiler, String string) {
            this.v$msg = string;
            this.this$0 = jCompiler;
        }
    }

    final class 8
    implements Runnable {
        public void run() {
            if (UnifiedBuildSystem.showCompileProgress) {
                JCompiler.this.logOutMsg(JCompiler.ra$msgStart() + "\n");
            }
            JCompiler.mav$setStatusBarText(JCompiler.this, JCompiler.ra$msgStart());
            LogPage log = JCompiler.this.getErrorLog();
            UnifiedBuildSystem.ideLog.registerAsynchronousLogPage(log);
            if (Ide.getEnvironOptions().getClearCompilerLogBeforeCompile() && (System.getProperty("compiler.log") == null || !System.getProperty("compiler.log").equals("tablestyle"))) {
                log.clearAll();
            }
        }
    }

    final class 9
    implements Runnable {
        private final /* synthetic */ int v$filesBuilt;
        private final /* synthetic */ int v$cleanAll;
        final /* synthetic */ JCompiler this$0;

        public void run() {
            JCompiler.mav$_logOutEndBuild(this.this$0, this.v$filesBuilt, this.v$cleanAll);
        }

        public 9(JCompiler jCompiler, int n, int n2) {
            this.v$cleanAll = n2;
            this.v$filesBuilt = n;
            this.this$0 = jCompiler;
        }
    }
}

