/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.compiler.Compiler;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.util.Log;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.cm.dt.CmJavaUtil;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerContext;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;

final class JCompilerMenuItems
implements Addin,
Controller,
ContextMenuListener {
    private static final Log LOG;
    private JCompiler jcompiler;
    private JMenuItem compileSelected;
    private JMenuItem rebuildSelected;
    private JMenuItem makeWorkingSet;
    private JMenuItem buildWorkingSet;
    private JMenuItem makeProject;
    private JMenuItem buildProject;
    private JMenuItem makeWorkspace;
    private JMenuItem buildWorkspace;
    private JMenuItem cancelBuild;
    private JMenuItem cleanAll;
    private static final String CompileS;
    private static final String RebuildS;
    private static final String SelectedS;
    private static final String CleanS;
    private static final String CompileDB;
    private static JCompilerMenuItems instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    private HashMap popupCachedMenuItems;

    JCompilerMenuItems() {
        instance = this;
    }

    static JCompilerMenuItems getInstance() {
        return instance;
    }

    public void initialize() {
        this.jcompiler = JCompiler.getInstance();
        if (this.jcompiler != null && this.jcompiler == Compiler.getCompiler()) {
            this.createBuildMenu();
            this.initializeMenuItems();
            NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener((ContextMenuListener)this, null);
            ContextMenu menu = EditorManager.getEditorManager().getContextMenu();
            if (menu != null) {
                menu.addContextMenuListener((ContextMenuListener)this);
            }
            if ((menu = LogManager.getLogManager().getContextMenu()) != null) {
                menu.addContextMenuListener((ContextMenuListener)this);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (context == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (this.jcompiler.isBusy(null) && cmdId == JCompiler.CANCEL_BUILD_CMD_ID) {
            this.jcompiler.stopBuild(context);
            return true;
        }
        CompilerContext.setCompileAction(context, action);
        if (cmdId == JCompiler.MAKE_SELECTED_CMD_ID || cmdId == JCompiler.MAKE_FOLDER_CMD_ID || cmdId == JCompiler.MAKE_PROJECT_CMD_ID || cmdId == JCompiler.MAKE_WORKINGSET_CMD_ID || cmdId == JCompiler.MAKE_WORKSPACE_CMD_ID) {
            this.jcompiler.compile(context, false, false, true);
            return true;
        }
        if (cmdId == JCompiler.BUILD_SELECTED_CMD_ID || cmdId == JCompiler.BUILD_WORKINGSET_CMD_ID || cmdId == JCompiler.BUILD_PROJECT_CMD_ID || cmdId == JCompiler.BUILD_WORKSPACE_CMD_ID) {
            this.jcompiler.compile(context, true, false, true);
            return true;
        }
        if (cmdId == JCompiler.CANCEL_BUILD_CMD_ID) {
            return true;
        }
        if (cmdId == JCompiler.CLEANALL_CMD_ID) {
            this.jcompiler.cleanAll(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (context == null || action == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (cmdId == JCompiler.MAKE_SELECTED_CMD_ID) {
            return this.setMenuItem(context, this.compileSelected, action, false, false);
        }
        if (cmdId == JCompiler.BUILD_SELECTED_CMD_ID) {
            return this.setMenuItem(context, this.rebuildSelected, action, true, false);
        }
        if (cmdId == JCompiler.MAKE_WORKINGSET_CMD_ID) {
            return this.setWSMenuItem(action, !this.jcompiler.isBusy(context), this.makeWorkingSet, this.getWorkingSet(Ide.getActiveWorkspace()));
        }
        if (cmdId == JCompiler.BUILD_WORKINGSET_CMD_ID) {
            return this.setWSMenuItem(action, !this.jcompiler.isBusy(context), this.buildWorkingSet, this.getWorkingSet(Ide.getActiveWorkspace()));
        }
        if (cmdId == JCompiler.MAKE_PROJECT_CMD_ID) {
            return this.setWPMenuItem(context, (Element)Ide.getActiveProject(), this.makeProject, action, false);
        }
        if (cmdId == JCompiler.BUILD_PROJECT_CMD_ID) {
            return this.setWPMenuItem(context, (Element)Ide.getActiveProject(), this.buildProject, action, true);
        }
        if (cmdId == JCompiler.MAKE_WORKSPACE_CMD_ID) {
            return this.setWPMenuItem(context, (Element)Ide.getActiveWorkspace(), this.makeWorkspace, action, false);
        }
        if (cmdId == JCompiler.BUILD_WORKSPACE_CMD_ID) {
            return this.setWPMenuItem(context, (Element)Ide.getActiveWorkspace(), this.buildWorkspace, action, true);
        }
        if (cmdId == JCompiler.MAKE_FOLDER_CMD_ID) {
            return this.setMenuItem(context, null, action, false, false);
        }
        if (cmdId == JCompiler.CANCEL_BUILD_CMD_ID) {
            boolean isCancellable = UnifiedBuildSystem.getInstance().isAlive();
            return this.setMenuItem(action, isCancellable, this.cancelBuild);
        }
        if (cmdId == JCompiler.CLEANALL_CMD_ID) {
            return this.setMenuItem(context, this.cleanAll, action, false, true);
        }
        return false;
    }

    static {
        $assertionsDisabled = JCompilerMenuItems.class.desiredAssertionStatus() ^ true;
        LOG = new Log("JCompilerMenuItems");
        CompileS = CompArb.getString(2);
        RebuildS = CompArb.getString(81);
        SelectedS = CompArb.getString(7);
        CleanS = CompArb.getString(53);
        CompileDB = CompArb.getString(11);
    }

    public void menuWillShow(ContextMenu popup) {
        if (!$assertionsDisabled && !LOG.trace("Start of JCompilerMenuItems.menuWillShow")) {
            throw new AssertionError();
        }
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof MessagePage && this.jcompiler.isBusy(context)) {
            IdeAction action = IdeAction.find((int)JCompiler.CANCEL_BUILD_CMD_ID);
            action.setEnabled(true);
            popup.add((Component)this.getMenuItem(popup, action), JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        boolean leaveEarly = false;
        Element[] elements = this.getElementsFromContext(context, false);
        if (elements == null || elements.length == 0) {
            leaveEarly = true;
        } else {
            int x = 0;
            while (x < elements.length) {
                if (elements[x] == null || elements[x] instanceof AntNode || !elements[x].getAttributes().isSet(ElementAttributes.BUILDABLE) && !JCompiler.isCopyable(elements[x], context.getProject())) {
                    leaveEarly = true;
                    break;
                }
                ++x;
            }
        }
        if (leaveEarly) {
            if (!$assertionsDisabled && !LOG.trace("End of JCompilerMenuItems.menuWillShow")) {
                throw new AssertionError();
            }
            return;
        }
        boolean isWorkingSetNavigator = false;
        if (view instanceof NavigatorWindow) {
            NavigatorManager n = ((NavigatorWindow)view).getManager();
            boolean bl = isWorkingSetNavigator = n != null && (n == NavigatorManager.getWorkspaceNavigatorManager() || n == NavigatorManager.getApplicationNavigatorManager());
        }
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            context = codeEditor.getContext();
        }
        Element element = elements.length >= 1 ? elements[0] : null;
        boolean isElementAProject = elements.length == 1 && element instanceof Project;
        IdeAction action = IdeAction.find((int)(isElementAProject ? JCompiler.MAKE_PROJECT_CMD_ID : JCompiler.MAKE_SELECTED_CMD_ID));
        if (action != null) {
            this.update(action, context);
            popup.add((Component)this.getMenuItem(popup, action), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        }
        if (isElementAProject && isWorkingSetNavigator && (action = IdeAction.find((int)JCompiler.MAKE_WORKINGSET_CMD_ID)) != null) {
            this.update(action, context);
            JMenuItem m = this.getMenuItem(popup, action);
            this.setWSMenuItem(action, true, m, this.getWorkingSet(Ide.getActiveWorkspace()));
            popup.add((Component)m, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        }
        if ((action = IdeAction.find((int)(isElementAProject ? JCompiler.BUILD_PROJECT_CMD_ID : JCompiler.BUILD_SELECTED_CMD_ID))) != null && this.getPrefix(element, false, false) != CompileDB) {
            this.update(action, context);
            popup.add((Component)this.getMenuItem(popup, action), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        }
        if (isElementAProject && isWorkingSetNavigator && (action = IdeAction.find((int)JCompiler.BUILD_WORKINGSET_CMD_ID)) != null) {
            this.update(action, context);
            JMenuItem m = this.getMenuItem(popup, action);
            this.setWSMenuItem(action, true, m, this.getWorkingSet(Ide.getActiveWorkspace()));
            popup.add((Component)m, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        }
        if (!$assertionsDisabled && !LOG.trace("End of JCompilerMenuItems.menuWillShow")) {
            throw new AssertionError();
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void createBuildMenu() {
        Menubar menubar = Ide.getMenubar();
        JMenu buildMenu = menubar.createMenu(CompArb.getString(54), CompArb.getInteger(83), JDeveloperMenuConstants.WEIGHT_BUILD_MENU, JDeveloperMenuConstants.SECTION_BUILD_TOOLS);
        menubar.add((Component)buildMenu);
        MenuManager.putJMenu((String)"Build", (JMenu)buildMenu);
    }

    private void initializeMenuItems() {
        Menubar menuMgr = Ide.getMenubar();
        AddinManager addMgr = AddinManager.getAddinManager();
        JMenu buildMenu = MenuManager.getJMenu((String)"Build");
        String cmd = addMgr.getCommand(JCompiler.MAKE_WORKSPACE_CMD_ID, "oracle.jdeveloper.compiler.MakeWorkspaceCommand");
        IdeAction action = IdeAction.get((int)JCompiler.MAKE_WORKSPACE_CMD_ID, (String)cmd, (String)CompArb.getString(58), (String)buildMenu.getText(), (Integer)CompArb.getInteger(43), (ArrayResourceBundle)CompArb.getInstance(), (int)8, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(58));
        action.addController((Controller)this);
        this.makeWorkspace = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_WORKSPACE);
        menuMgr.add((Component)this.makeWorkspace, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_MAKE);
        cmd = addMgr.getCommand(JCompiler.MAKE_PROJECT_CMD_ID, "oracle.jdeveloper.compiler.MakeProjectCommand");
        action = IdeAction.get((int)JCompiler.MAKE_PROJECT_CMD_ID, (String)cmd, (String)CompArb.getString(51), (String)buildMenu.getText(), (Integer)CompArb.getInteger(84), (ArrayResourceBundle)CompArb.getInstance(), (int)47, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(51));
        action.addController((Controller)this);
        this.makeProject = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_PROJECT);
        menuMgr.add((Component)this.makeProject, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_MAKE);
        cmd = addMgr.getCommand(JCompiler.MAKE_WORKINGSET_CMD_ID, "oracle.jdeveloper.compiler.MakeWorkingSetCommand");
        action = IdeAction.get((int)JCompiler.MAKE_WORKINGSET_CMD_ID, (String)cmd, (String)CompArb.getString(5), (String)buildMenu.getText(), (Integer)CompArb.getInteger(49), (ArrayResourceBundle)CompArb.getInstance(), (int)24, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(5));
        action.addController((Controller)this);
        this.makeWorkingSet = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_WORKSET);
        menuMgr.add((Component)this.makeWorkingSet, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_MAKE);
        cmd = addMgr.getCommand(JCompiler.BUILD_WORKINGSET_CMD_ID, "oracle.jdeveloper.compiler.BuildWorkingSetCommand");
        action = IdeAction.get((int)JCompiler.BUILD_WORKINGSET_CMD_ID, (String)cmd, (String)CompArb.getString(89), (String)buildMenu.getText(), (Integer)CompArb.getInteger(67), (ArrayResourceBundle)CompArb.getInstance(), (int)94, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(89));
        action.addController((Controller)this);
        this.buildWorkingSet = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_WORKSET);
        menuMgr.add((Component)this.buildWorkingSet, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_REBUILD);
        cmd = addMgr.getCommand(JCompiler.MAKE_FOLDER_CMD_ID, "oracle.jdeveloper.compiler.MakeFolderCommand");
        action = IdeAction.get((int)JCompiler.MAKE_FOLDER_CMD_ID, (String)cmd, (String)CompArb.getString(79), (String)buildMenu.getText(), (Integer)CompArb.getInteger(84), (ArrayResourceBundle)CompArb.getInstance(), (int)8, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(79));
        action.addController((Controller)this);
        cmd = addMgr.getCommand(JCompiler.BUILD_WORKSPACE_CMD_ID, "oracle.jdeveloper.compiler.BuildWorkspaceCommand");
        action = IdeAction.get((int)JCompiler.BUILD_WORKSPACE_CMD_ID, (String)cmd, (String)CompArb.getString(96), (String)buildMenu.getText(), (Integer)CompArb.getInteger(72), (ArrayResourceBundle)CompArb.getInstance(), (int)66, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(96));
        action.addController((Controller)this);
        this.buildWorkspace = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_WORKSPACE);
        menuMgr.add((Component)this.buildWorkspace, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_REBUILD);
        cmd = addMgr.getCommand(JCompiler.BUILD_PROJECT_CMD_ID, "oracle.jdeveloper.compiler.BuildProjectCommand");
        action = IdeAction.get((int)JCompiler.BUILD_PROJECT_CMD_ID, (String)cmd, (String)CompArb.getString(88), (String)buildMenu.getText(), (Integer)CompArb.getInteger(31), (ArrayResourceBundle)CompArb.getInstance(), (int)70, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(88));
        action.addController((Controller)this);
        this.buildProject = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_PROJECT);
        menuMgr.add((Component)this.buildProject, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_REBUILD);
        cmd = addMgr.getCommand(JCompiler.MAKE_SELECTED_CMD_ID, "oracle.jdeveloper.compiler.MakeSelectedCommand");
        action = IdeAction.get((int)JCompiler.MAKE_SELECTED_CMD_ID, (String)cmd, (String)CompileS, (String)buildMenu.getText(), (Integer)CompArb.getInteger(23), (ArrayResourceBundle)CompArb.getInstance(), (int)12, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(13));
        action.addController((Controller)this);
        this.compileSelected = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_FILE);
        cmd = addMgr.getCommand(JCompiler.BUILD_SELECTED_CMD_ID, "oracle.jdeveloper.compiler.BuildSelectedCommand");
        action = IdeAction.get((int)JCompiler.BUILD_SELECTED_CMD_ID, (String)cmd, (String)RebuildS, (String)buildMenu.getText(), (Integer)CompArb.getInteger(86), (ArrayResourceBundle)CompArb.getInstance(), (int)0, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(71));
        action.addController((Controller)this);
        this.rebuildSelected = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_FILE);
        cmd = addMgr.getCommand(JCompiler.CANCEL_BUILD_CMD_ID, "oracle.jdeveloper.compiler.CancelBuildCommand");
        action = IdeAction.get((int)JCompiler.CANCEL_BUILD_CMD_ID, (String)cmd, (String)CompArb.getString(63), (String)buildMenu.getText(), (Integer)CompArb.getInteger(1), (ArrayResourceBundle)CompArb.getInstance(), (int)41, null, (boolean)false);
        action.putValue("ShortDescription", (Object)CompArb.getString(63));
        action.addController((Controller)this);
        this.cancelBuild = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_CANCEL_BUILD);
        menuMgr.add((Component)this.cancelBuild, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_CONTROL);
        cmd = addMgr.getCommand(JCompiler.CLEANALL_CMD_ID, "oracle.jdeveloper.compiler.CleanAllCommand");
        action = IdeAction.get((int)JCompiler.CLEANALL_CMD_ID, (String)cmd, (String)CleanS, (String)buildMenu.getText(), (Integer)CompArb.getInteger(85), (ArrayResourceBundle)CompArb.getInstance(), (int)32, null, (boolean)false);
        action.putValue("ShortDescription", (Object)CleanS);
        action.addController((Controller)this);
        this.cleanAll = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_CLEANALL);
        menuMgr.add((Component)this.cleanAll, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_CONTROL);
    }

    private JMenuItem getMenuItem(ContextMenu popup, IdeAction action) {
        JMenuItem menuItem;
        if (this.popupCachedMenuItems == null) {
            this.popupCachedMenuItems = new HashMap();
        }
        if ((menuItem = (JMenuItem)this.popupCachedMenuItems.get(action)) == null) {
            menuItem = popup.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
            this.popupCachedMenuItems.put(action, menuItem);
        }
        return menuItem;
    }

    private boolean setMenuItem(IdeAction action, boolean enabled, JMenuItem m) {
        action.setEnabled(enabled);
        m.setEnabled(enabled);
        m.setVisible(true);
        return true;
    }

    private boolean setWPMenuItem(Context context, Element node, JMenuItem menu, IdeAction action, boolean rebuild) {
        String name = "";
        Element[] elements = this.getElementsFromContext(context, true);
        if (elements != null && elements.length > 1 && elements[0] != null && (node == null || elements[0].getClass() == node.getClass())) {
            name = this.getPrefix(elements[0], rebuild, false) + SelectedS;
        } else if (node != null) {
            String label = this.inPopup(context) ? "" : (node instanceof Workspace || node instanceof Workspaces ? CompArb.getString(77) : node.getShortLabel());
            name = this.getPrefix(node, rebuild, false) + label;
        }
        if (name.length() > 0) {
            boolean isBusy = this.jcompiler.isBusy(null);
            menu.setText(name);
            menu.setEnabled(isBusy ^ true);
            action.setEnabled(isBusy ^ true);
            action.putValue("Name", (Object)name);
        } else {
            action.setEnabled(false);
        }
        return true;
    }

    private boolean setWSMenuItem(IdeAction action, boolean enabled, JMenuItem m, WorkingSet workingSet) {
        if (workingSet != null) {
            action.setEnabled(enabled);
            m.setEnabled(enabled);
            m.setVisible(true);
            String prefix = CompArb.getString(action.getCommandId() == JCompiler.MAKE_WORKINGSET_CMD_ID ? 5 : 89);
            m.setText(prefix);
        }
        return true;
    }

    private WorkingSet getWorkingSet(Workspace workspace) {
        if (workspace == null) {
            return null;
        }
        WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
        WorkingSet curWorkingSet = workingSets.getCurrentWorkingSet();
        if (curWorkingSet == null) {
            curWorkingSet = workingSets.getWorkingSet(WorkingSets.ALL_FILES_WORKING_SET_LABEL);
        }
        return curWorkingSet;
    }

    /*
     * Unable to fully structure code
     */
    private boolean setMenuItem(Context context, JMenuItem menuItem, IdeAction action, boolean rebuild, boolean clean) {
        elements = this.getElementsFromContext(context, true);
        element = null;
        allowMultipleSelections = true;
        try {
            if (elements != null && elements.length != 0 && elements[0] != null) ** GOTO lbl28
            action.setEnabled(false);
            var12_9 = true;
            prefix = this.getPrefix(element, rebuild, clean);
            label = element == null ? "" : (element instanceof Workspace != false || element instanceof Workspaces != false ? CompArb.getString(77) : element.getShortLabel());
        }
        catch (Throwable var15_18) {
            prefix = this.getPrefix(element, rebuild, clean);
            label = element == null ? "" : (element instanceof Workspace != false || element instanceof Workspaces != false ? CompArb.getString(77) : element.getShortLabel());
            if (label == null) {
                label = "";
            }
            name = prefix + (elements != null && elements.length > 1 && allowMultipleSelections != false ? JCompilerMenuItems.SelectedS : (this.inPopup(context) != false ? "" : label));
            if (menuItem != null) {
                menuItem.setText(name);
            }
            action.putValue("Name", (Object)name);
            throw var15_18;
        }
        if (label == null) {
            label = "";
        }
        name = prefix + (elements != null && elements.length > 1 && allowMultipleSelections != false ? JCompilerMenuItems.SelectedS : (this.inPopup(context) != false ? "" : label));
        if (menuItem != null) {
            menuItem.setText(name);
        }
        action.putValue("Name", (Object)name);
        return var12_9;
lbl28:
        // 1 sources

        element = elements[0];
        if (!clean) ** GOTO lbl61
        if (!(element instanceof Workspace) && !(element instanceof Workspaces)) ** GOTO lbl43
        action.setEnabled(true);
        var13_16 = true;
        prefix = this.getPrefix(element, rebuild, clean);
        label = element == null ? "" : (element instanceof Workspace != false || element instanceof Workspaces != false ? CompArb.getString(77) : element.getShortLabel());
        if (label == null) {
            label = "";
        }
        name = prefix + (elements != null && elements.length > 1 && allowMultipleSelections != false ? JCompilerMenuItems.SelectedS : (this.inPopup(context) != false ? "" : label));
        if (menuItem != null) {
            menuItem.setText(name);
        }
        action.putValue("Name", (Object)name);
        return var13_16;
lbl43:
        // 1 sources

        if (element instanceof Project) ** GOTO lbl61
        allowMultipleSelections = false;
        element = context.getProject();
        if (element == null) {
            element = Ide.getActiveProject();
        }
        if (element != null) ** GOTO lbl61
        action.setEnabled(false);
        var14_17 = true;
        prefix = this.getPrefix(element, rebuild, clean);
        label = element == null ? "" : (element instanceof Workspace != false || element instanceof Workspaces != false ? CompArb.getString(77) : element.getShortLabel());
        if (label == null) {
            label = "";
        }
        name = prefix + (elements != null && elements.length > 1 && allowMultipleSelections != false ? JCompilerMenuItems.SelectedS : (this.inPopup(context) != false ? "" : label));
        if (menuItem != null) {
            menuItem.setText(name);
        }
        action.putValue("Name", (Object)name);
        return var14_17;
lbl61:
        // 3 sources

        if (menuItem != null) {
            menuItem.setVisible(true);
        }
        if ((element instanceof Locatable || element != null && element.mayHaveChildren()) && !(element instanceof AntNode) && (element.getAttributes().isSet(ElementAttributes.BUILDABLE) || JCompiler.isCopyable(element, context.getProject())) || element instanceof Workspaces) {
            action.setEnabled(this.jcompiler.isBusy(null) ^ true);
        } else {
            action.setEnabled(false);
        }
        prefix = this.getPrefix(element, rebuild, clean);
        label = element == null ? "" : (element instanceof Workspace != false || element instanceof Workspaces != false ? CompArb.getString(77) : element.getShortLabel());
        if (label == null) {
            label = "";
        }
        name = prefix + (elements != null && elements.length > 1 && allowMultipleSelections != false ? JCompilerMenuItems.SelectedS : (this.inPopup(context) != false ? "" : label));
        if (menuItem != null) {
            menuItem.setText(name);
        }
        action.putValue("Name", (Object)name);
        return true;
    }

    private String getPrefix(Element elem, boolean rebuild, boolean clean) {
        if (elem instanceof Locatable && CmJavaUtil.isCMUrl(((Locatable)elem).getURL())) {
            return CompileDB;
        }
        return rebuild ? RebuildS : (clean ? CleanS : CompileS);
    }

    private boolean inPopup(Context context) {
        if (context.getNode() instanceof Workspace) {
            return false;
        }
        EventObject o = context.getEvent();
        return o == null || o instanceof MouseEvent;
    }

    private Element[] getElementsFromContext(Context context, boolean checkNode) {
        Element[] elements = context.getSelection();
        if (!(elements != null && elements.length != 0 && (elements[0] == null || elements[0].getAttributes().isSet(ElementAttributes.BUILDABLE)) || checkNode && context.getNode() == null)) {
            elements = new Element[]{context.getNode()};
        }
        return elements;
    }

    void enableCancelBuild(boolean enable) {
        if (Ide.getIdeArgs().getCreateUI()) {
            JCompiler.invokeAsap(new 1(this, enable));
        }
    }

    static JMenuItem ra$cancelBuild(JCompilerMenuItems jCompilerMenuItems) {
        return jCompilerMenuItems.cancelBuild;
    }

    static boolean mav$setMenuItem(JCompilerMenuItems jCompilerMenuItems, IdeAction ideAction, boolean bl, JMenuItem jMenuItem) {
        return jCompilerMenuItems.setMenuItem(ideAction, bl, jMenuItem);
    }

    static JMenuItem ra$makeProject(JCompilerMenuItems jCompilerMenuItems) {
        return jCompilerMenuItems.makeProject;
    }

    static JMenuItem ra$buildProject(JCompilerMenuItems jCompilerMenuItems) {
        return jCompilerMenuItems.buildProject;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ boolean v$enable;
        final /* synthetic */ JCompilerMenuItems this$0;

        public void run() {
            JCompilerMenuItems.mav$setMenuItem(this.this$0, IdeAction.find((int)JCompiler.CANCEL_BUILD_CMD_ID), this.v$enable, JCompilerMenuItems.ra$cancelBuild(this.this$0));
            JCompilerMenuItems.mav$setMenuItem(this.this$0, IdeAction.find((int)JCompiler.MAKE_PROJECT_CMD_ID), this.v$enable ^ true, JCompilerMenuItems.ra$makeProject(this.this$0));
            JCompilerMenuItems.mav$setMenuItem(this.this$0, IdeAction.find((int)JCompiler.BUILD_PROJECT_CMD_ID), this.v$enable ^ true, JCompilerMenuItems.ra$buildProject(this.this$0));
        }

        public 1(JCompilerMenuItems jCompilerMenuItems, boolean bl) {
            this.v$enable = bl;
            this.this$0 = jCompilerMenuItems;
        }
    }
}

