/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.compiler.CompArb;
import oracle.ojc.interfaces.Storage;

public class JarStorage
implements Storage {
    private final URL _jarURL;
    private final JarIndex _jarIndex;
    private final String _jarEntry;
    private final int _jarEntryIndex;
    private final File _jarFile;
    private String _canonicalPath;
    private HashMap properties;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.properties = null;
    }

    public JarStorage(URL jarURL) {
        LogManager logMgr;
        this.$init$();
        this._jarURL = jarURL;
        URL jarPath = JarUtil.getJarFileURL((URL)jarURL);
        this._jarFile = new File(jarPath.getPath());
        JarIndex jarIndex = null;
        try {
            jarIndex = JarUtil.getJarIndex((URL)this._jarURL);
        }
        catch (IOException e) {
            jarIndex = null;
        }
        this._jarIndex = jarIndex;
        if ((this._jarIndex == null || this._jarIndex.getNumEntries() == 0 && this._jarIndex.getTimestamp() > 0L) && (logMgr = LogManager.getLogManager()) != null) {
            LogPage page = logMgr.getMsgPage();
            1 log = new 1(this, page);
            if (page instanceof MessagePage) {
                log.run();
            } else {
                SwingUtilities.invokeLater(log);
            }
        }
        this._jarEntry = JarUtil.getJarEntry((URL)this._jarURL);
        this._jarEntryIndex = -1;
    }

    private JarStorage(JarStorage orig, String jarEntry, int index) {
        this.$init$();
        this._jarURL = orig._jarURL;
        this._jarIndex = orig._jarIndex;
        this._jarEntry = jarEntry;
        this._jarEntryIndex = index;
        this._jarFile = orig._jarFile;
        if (!ModelUtil.hasLength((String)orig._jarEntry)) {
            this._canonicalPath = orig.getCanonicalPath() + File.separator + jarEntry.replace('/', File.separatorChar);
        } else {
            this._canonicalPath = orig.getCanonicalPath();
            if (!this._canonicalPath.endsWith(File.separator)) {
                this._canonicalPath = this._canonicalPath + File.separator;
            }
            this._canonicalPath = this._canonicalPath + this.getName().replace('/', File.separatorChar);
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        JarStorage jarStorage = (JarStorage)o;
        return ModelUtil.areEqual((Object)this._jarEntry, (Object)jarStorage._jarEntry) && ModelUtil.areEqual((Object)this._jarFile, (Object)jarStorage._jarFile);
    }

    public int hashCode() {
        return this._jarURL != null ? this._jarURL.hashCode() : 0;
    }

    public String toString() {
        return this.getCanonicalPath();
    }

    public long modDate() {
        if (this._jarIndex != null && this._jarEntryIndex >= 0) {
            return this._jarIndex.getTimestamp(this._jarEntryIndex);
        }
        return this._jarFile.lastModified();
    }

    public URL getURL() {
        return URLFactory.newJarURL((URL)this._jarURL, (String)this._jarEntry);
    }

    public String getName() {
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            int lastSlash = this._jarEntry.lastIndexOf("/");
            if (this._jarEntry.endsWith("/") && lastSlash > 0) {
                lastSlash = this._jarEntry.lastIndexOf("/", lastSlash - 1);
            }
            return this._jarEntry.substring(lastSlash + 1);
        }
        return this._jarFile.getName();
    }

    public String getPath() {
        String jarFilePath = this._jarFile.getPath();
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            return jarFilePath + "/" + this._jarEntry;
        }
        return jarFilePath;
    }

    public String getCanonicalPath() {
        if (this._canonicalPath == null) {
            try {
                this._canonicalPath = this._jarFile.getCanonicalPath() + "!";
            }
            catch (IOException e) {
                this._canonicalPath = this._jarFile.getAbsolutePath();
            }
            if (ModelUtil.hasLength((String)this._jarEntry)) {
                this._canonicalPath = this._canonicalPath + File.separator + this._jarEntry.replace('/', File.separatorChar);
            }
        }
        return this._canonicalPath;
    }

    public String getParent() {
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            return this._jarFile.getPath();
        }
        return this._jarFile.getParent();
    }

    public Object getProperty(String property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(property, value);
    }

    public boolean isDirectory() {
        return !ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/");
    }

    public boolean isInJar() {
        return true;
    }

    public void close() {
    }

    static {
        $assertionsDisabled = JarStorage.class.desiredAssertionStatus() ^ true;
    }

    public int size() throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    public ArrayList listStorage() {
        String[] files = this.list();
        if (files != null) {
            ArrayList<Storage> res = new ArrayList<Storage>(files.length);
            int i = 0;
            while (i < files.length) {
                res.add(this.open(files[i]));
                ++i;
            }
            return res;
        }
        return null;
    }

    public String[] list() {
        if (this._jarIndex != null && (this._jarEntry.length() == 0 || this._jarEntry.endsWith("/"))) {
            return this._jarIndex.list(this._jarEntry);
        }
        return new String[0];
    }

    public void open() throws IOException {
    }

    public Storage open(String name) {
        if ((name = name.replace(File.separatorChar, '/')).endsWith("/")) {
            return this.openDir(name);
        }
        name = this._jarEntry + name;
        int index = this._jarIndex != null ? this._jarIndex.entryIndex(name) : -1;
        return index >= 0 ? new JarStorage(this, name, index) : null;
    }

    public Storage openDir(String name) {
        if (!(name = name.replace(File.separatorChar, '/')).endsWith("/")) {
            name = name + "/";
        }
        name = this._jarEntry + name;
        int index = this._jarIndex != null ? this._jarIndex.dirEntryIndex(name) : -1;
        return index >= 0 ? new JarStorage(this, name, index) : null;
    }

    public byte[] read() throws IOException {
        if (!ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/")) {
            throw new UnsupportedOperationException();
        }
        return this._jarIndex.getBytes(this._jarEntry);
    }

    public int read(byte[] buf) throws IOException {
        if (!ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/")) {
            throw new UnsupportedOperationException();
        }
        byte[] bytes = this._jarIndex.getBytes(this._jarEntry);
        int n = bytes.length;
        if (n > buf.length) {
            return n;
        }
        System.arraycopy(bytes, 0, buf, 0, n);
        return n;
    }

    public Storage setContext(Storage newContext) {
        throw new UnsupportedOperationException();
    }

    public void setPackage(String packageName) {
    }

    public void write(byte[] xs, int start, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Storage create(String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Storage createDir(String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    static File ra$_jarFile(JarStorage jarStorage) {
        return jarStorage._jarFile;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ LogPage v$page;
        final /* synthetic */ JarStorage this$0;

        public void run() {
            this.v$page.log((Object)CompArb.format(9, JarStorage.ra$_jarFile(this.this$0).getPath()));
            this.v$page.log((Object)"\n");
        }

        public 1(JarStorage jarStorage, LogPage logPage) {
            this.v$page = logPage;
            this.this$0 = jarStorage;
        }
    }
}

