/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogPage;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.runner.SimpleProcess;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.DependencyProvider;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorageMap;
import oracle.jdeveloper.compiler.IdeStorageWrapper;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.PatchClassFile;
import oracle.jdeveloper.compiler.RedefineMap;
import oracle.jdeveloper.compiler.SourceMap;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.ojc.compiler.Compiler;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Warning;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.IdeEnv;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Log2;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.FileStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ojc
implements Translator,
Addin {
    private Translator.Log _log;
    private static File tmpJavacFile = null;
    private static File tmpOjcFile = null;
    static Context currentContext = null;

    private void $init$() {
        this._log = null;
    }

    public Ojc() {
        this.$init$();
    }

    @Override
    public String getName() {
        return "Ojc";
    }

    @Override
    public ArrayList getInputTypes() {
        ArrayList<String> v = new ArrayList<String>(1);
        v.add(".java");
        return v;
    }

    @Override
    public ArrayList getOutputTypes() {
        ArrayList<String> v = new ArrayList<String>(1);
        v.add(".class");
        return v;
    }

    @Override
    public boolean canBuild(Storage store) {
        return store.getName().endsWith(".java");
    }

    @Override
    public boolean needToBuild(Storage store) {
        return false;
    }

    @Override
    public void setLog(Translator.Log log) {
        this._log = log;
    }

    @Override
    public void setParameter(String name, String value) {
        throw new Error();
    }

    @Override
    public void setProject(Project project) {
    }

    @Override
    public void updateProject(Project project) {
    }

    private static String replaceExt(String name, String newExt) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            lastDot = name.length();
        }
        if (name.indexOf(File.separatorChar, lastDot) < 0) {
            name = name.substring(0, lastDot);
        }
        return name + newExt;
    }

    private static File getCdiFile(Project prj, boolean javac_depinfo) {
        String ext = javac_depinfo ? ".cdi_javac" : ".cdi";
        URL prjURL = prj.getURL();
        URL outURL = JavaProject.getInstance((Project)prj).getOutputDirectory();
        if (outURL != null) {
            String outPathName = new File(outURL.getPath()).getPath();
            String prjPathName = URLFileSystem.getFileName((URL)prjURL);
            return new File(outPathName, Ojc.replaceExt(prjPathName, ext));
        }
        String prjPathName = URLFileSystem.getPlatformPathName((URL)prjURL);
        return new File(Ojc.replaceExt(prjPathName, ext));
    }

    private static File processOutputDirectory(Project prj, ArrayList cmd) {
        File outFile;
        URL outUrl = JavaProject.getInstance((Project)prj).getOutputDirectory();
        File file = outFile = outUrl != null ? new File(outUrl.getPath()) : new File(prj.getURL().getPath()).getParentFile();
        if (cmd != null) {
            cmd.add("-d");
            cmd.add(Ojc.stringize(outFile.getPath()));
        }
        if (!outFile.exists()) {
            outFile.mkdirs();
        }
        return outFile;
    }

    private static String stringize(String str) {
        if (str.indexOf(32) >= 0 || str.indexOf(9) >= 0) {
            return "\"" + str + "\"";
        }
        return str;
    }

    private String buildString(String opt, Storage[] path, ArrayList sources) {
        StringBuffer pathstr = new StringBuffer();
        if (path != null) {
            int i = 0;
            while (i < path.length) {
                if (path[i].getProperty("isFromManifestFile") != Boolean.TRUE) {
                    pathstr.append(opt == null ? Ojc.stringize(path[i].getPath()) : path[i].getPath());
                    pathstr.append(opt == null ? " " : File.pathSeparator);
                }
                ++i;
            }
        }
        if (sources != null) {
            ArrayList srcList = new ArrayList();
            int i = 0;
            while (i < sources.size()) {
                srcList.add(sources.get(i));
                ++i;
            }
            ArrayList cpElements = Helpers.listOfUniqueClassPathElement(srcList);
            if (cpElements != null) {
                int i2 = 0;
                while (i2 < cpElements.size()) {
                    URL url = (URL)cpElements.get(i2);
                    String p = new File(url.getPath()).getPath();
                    pathstr.append(opt == null ? Ojc.stringize(p) : p);
                    pathstr.append(opt == null ? " " : File.pathSeparator);
                    ++i2;
                }
            }
        }
        if (pathstr != null && pathstr.length() > 0) {
            if (opt != null) {
                pathstr.setLength(pathstr.length() - 1);
                return opt + " " + Ojc.stringize(pathstr.toString()) + " ";
            }
            pathstr.setCharAt(pathstr.length() - 1, ' ');
            return pathstr.toString();
        }
        return "";
    }

    private void addSMAPs(ArrayList sources, String outPath) {
        HashMap<String, File[]> classDirectoryMap = new HashMap<String, File[]>();
        int i = 0;
        while (i < sources.size()) {
            Storage stor = (Storage)sources.get(i);
            SourceMap sourceMap = (SourceMap)stor.getProperty("sourceMap");
            if (sourceMap != null) {
                try {
                    String qualifiedClassName = sourceMap.getQualifiedClassName().replace('.', File.separatorChar) + ".class";
                    File qualifiedClassFile = new File(outPath + File.separatorChar + qualifiedClassName);
                    if (qualifiedClassFile.exists()) {
                        this.patchAndMoveClassFiles(qualifiedClassFile, qualifiedClassName, sourceMap, stor, outPath, classDirectoryMap);
                    }
                }
                catch (IOException e) {
                    Assert.printStackTrace((Throwable)e);
                }
                catch (ClassFormatError e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            ++i;
        }
    }

    private void patchAndMoveClassFiles(File qualifiedClassFile, String qualifiedClassName, SourceMap sourceMap, Storage stor, String outPath, HashMap<String, File[]> classDirectoryMap) throws IOException, ClassFormatError {
        String destOutPath = (String)stor.getProperty("outputDirectory");
        boolean moveClassFiles = destOutPath != null && !destOutPath.equals(outPath);
        ArrayList<File> classFileList = new ArrayList<File>();
        classFileList.add(qualifiedClassFile);
        int separatorIndex = qualifiedClassName.lastIndexOf(File.separatorChar);
        String qualifiedPackageName = separatorIndex > 0 ? qualifiedClassName.substring(0, separatorIndex + 1) : "";
        File classDirectory = qualifiedClassFile.getParentFile();
        String classNamePrefix = qualifiedClassFile.getName();
        int dotIndex = classNamePrefix.lastIndexOf(46);
        classNamePrefix = dotIndex > 0 ? classNamePrefix.substring(0, dotIndex) + "$" : null;
        if (classDirectory != null && classNamePrefix != null) {
            File[] children = classDirectoryMap.get(classDirectory.getPath());
            if (children == null) {
                children = classDirectory.listFiles();
                classDirectoryMap.put(classDirectory.getPath(), children);
            }
            int x = 0;
            while (x < children.length) {
                String childName = children[x].getName();
                if (childName.endsWith(".class") && childName.startsWith(classNamePrefix)) {
                    classFileList.add(children[x]);
                }
                ++x;
            }
        }
        int x = 0;
        while (x < classFileList.size()) {
            File classFile = (File)classFileList.get(x);
            PatchClassFile.addSMAP(classFile, sourceMap.getSMAP());
            if (moveClassFiles) {
                String className = classFile.getName();
                File dest = new File(destOutPath + File.separatorChar + qualifiedPackageName + className);
                if (dest.exists()) {
                    dest.delete();
                }
                classFile.renameTo(dest);
            }
            ++x;
        }
    }

    private void logMessage(Translator.Log log, Storage source, int pos, int errCode, String errMsg, boolean error) {
        SourceMap sourceMap;
        int line = Scanner.positionToLine((int)pos);
        int col = Scanner.positionToColumn((int)pos);
        if (source != null && (sourceMap = (SourceMap)source.getProperty("sourceMap")) != null) {
            int[] data = new int[]{line, col};
            Storage[] stor = new Storage[]{null};
            boolean translated = sourceMap.translateLocation(data, stor);
            line = data[0];
            col = data[1];
            source = stor[0];
            if (source != null && J2eeSettings.isCompilableJsp(source.getName()) && log instanceof IdeLog) {
                String path;
                URL htmlRootDirURL;
                URL newPathURL;
                String newPath;
                File f;
                if (!translated && !error) {
                    return;
                }
                Project project = ((IdeLog)log).getProject();
                if (project != null && (f = new File(newPath = URLFileSystem.getPlatformPathName((URL)(newPathURL = URLFactory.newURL((URL)(htmlRootDirURL = J2eeSettings.getInstance(project).getHtmlRootDirectory()), (String)(path = source.getPath())))))).exists()) {
                    source = Helpers.createFileStorage(f);
                }
            }
        }
        if (error) {
            log.error(source, line, col, errCode, errMsg);
        } else {
            log.warning(source, line, col, errCode, errMsg);
        }
    }

    private String buildOjcCmdLine(Project jprj, Options opt, ArrayList toBuild, boolean rebuild) {
        StringBuffer ojcCmd = new StringBuffer();
        String str = new File(JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK().getJavaExecutable().getPath()).getPath();
        if (str == null) {
            str = "<path to java executable>";
        }
        ojcCmd.append(str);
        ojcCmd.append(" -jar ");
        File file = new File(Ide.getLibDirectory(), "ojc.jar");
        if (file.exists()) {
            ojcCmd.append(file.getPath());
        } else {
            file = new File(Ide.getBinDirectory() + "/../lib/ojc.jar");
            if (file.exists()) {
                ojcCmd.append(file.getPath());
            } else {
                ojcCmd.append("<ojc.jar location>");
            }
        }
        ojcCmd.append(" ");
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)jprj);
        ojcCmd.append(optionManager.getCompilerOptionsAsString("Ojc"));
        switch (opt.sourceJDKVersion) {
            case 110: {
                ojcCmd.append("-source 1.1 ");
                break;
            }
            case 120: {
                ojcCmd.append("-source 1.2 ");
                break;
            }
            case 130: {
                ojcCmd.append("-source 1.3 ");
                break;
            }
            case 140: {
                ojcCmd.append("-source 1.4 ");
                break;
            }
            case 150: {
                ojcCmd.append("-source 1.5 ");
                break;
            }
            case 160: {
                ojcCmd.append("-source 1.6 ");
                break;
            }
            case 170: {
                ojcCmd.append("-source 1.7 ");
                break;
            }
        }
        switch (opt.targetJDKVersion) {
            case 110: {
                ojcCmd.append("-target 1.1 ");
                break;
            }
            case 120: {
                ojcCmd.append("-target 1.2 ");
                break;
            }
            case 130: {
                ojcCmd.append("-target 1.3 ");
                break;
            }
            case 140: {
                ojcCmd.append("-target 1.4 ");
                break;
            }
            case 150: {
                ojcCmd.append("-target 1.5 ");
                break;
            }
            case 160: {
                ojcCmd.append("-target 1.6 ");
                break;
            }
            case 170: {
                ojcCmd.append("-target 1.7 ");
                break;
            }
        }
        ojcCmd.append(opt.noquiet ? "-noquiet " : "");
        ojcCmd.append("-encoding ");
        ojcCmd.append(opt.encoding == null ? "null" : opt.encoding);
        ojcCmd.append(" ");
        if (opt.destinationDir != null) {
            ojcCmd.append("-d ");
            ojcCmd.append(Ojc.stringize(opt.destinationDir));
            ojcCmd.append(" ");
        }
        if (opt.makeFile != null) {
            ojcCmd.append("-namereferences ");
            ojcCmd.append("-make ");
            ojcCmd.append(Ojc.stringize(opt.makeFile.getPath()));
            ojcCmd.append(" ");
        }
        if (rebuild && ojcCmd.indexOf("-rebuild") < 0) {
            ojcCmd.append("-rebuild ");
        }
        ojcCmd.append(this.buildString("-classpath ", opt.classpathStorage, toBuild));
        ojcCmd.append(this.buildString("-sourcepath ", opt.sourcepathStorage, null));
        Storage[] tmp = new Storage[toBuild.size()];
        toBuild.toArray(tmp);
        ojcCmd.append(this.buildString(null, tmp, null));
        return ojcCmd.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runJavacProcess(Project jprj, CompilerOptionManager optionManager, boolean rebuild, ArrayList sources, ArrayList results, Translator.Log log) {
        String target;
        String source;
        String[] optionCommands;
        RedefineMap rm = new RedefineMap();
        HashMap<String, Storage> sourceMapFiles = new HashMap<String, Storage>();
        ArrayList<String> cmd = new ArrayList<String>(15 + sources.size());
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        try {
            String javacString = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK().getJavaExecutable().getPath();
            if (javacString.endsWith("jre/bin/java.exe")) {
                javacString = javacString.substring(0, javacString.length() - 16) + (File.separatorChar == '/' ? "bin/javac" : "bin/javac.exe");
            } else if (javacString.endsWith("java.exe")) {
                javacString = javacString.substring(0, javacString.length() - 4) + (File.separatorChar == '/' ? "c" : "c.exe");
            } else if (javacString.endsWith("jre/bin/java")) {
                javacString = javacString.substring(0, javacString.length() - 12) + (File.separatorChar == '/' ? "bin/javac" : "bin/javac.exe");
            } else if (javacString.endsWith("java")) {
                javacString = javacString + (File.separatorChar == '/' ? "c" : "c.exe");
            } else {
                throw new Throwable();
            }
            File javacFile = new File(javacString);
            if (!javacFile.exists()) {
                throw new Throwable();
            }
            javacString = javacFile.getPath();
            cmd.add(Ojc.stringize(javacString));
        }
        catch (Throwable t) {
            System.out.println("error: unable to determine javac path");
            int n = 1;
            return n;
        }
        StringTokenizer vmArgs = new StringTokenizer(buildSysConfig.getOutOfProcessJavaOptions());
        while (vmArgs.hasMoreTokens()) {
            cmd.add("-J" + vmArgs.nextToken());
        }
        boolean reallyVerboseOutput = false;
        String[] stringArray = optionCommands = optionManager.getCompilerOptionsAsArray("Javac");
        int n = 0;
        while (n < stringArray.length) {
            String optionCommand = stringArray[n];
            if (optionCommand.equals("-verbose")) {
                reallyVerboseOutput = true;
            }
            cmd.add(optionCommand);
            ++n;
        }
        if (buildSysConfig.isJDK14OrHigher() && !(source = buildSysConfig.getSource()).equals("Default")) {
            cmd.add("-source");
            cmd.add(source);
        }
        if (!(target = buildSysConfig.getTarget()).equals("Default")) {
            cmd.add("-target");
            cmd.add(target);
        }
        if (UnifiedBuildSystem.showCompileProgress && !reallyVerboseOutput) {
            cmd.add("-verbose");
        }
        cmd.add("-encoding");
        cmd.add(buildSysConfig.getCurrentEncoding());
        cmd.add("-classpath");
        cmd.add(Ojc.stringize(Helpers.urlPathAndDependantPathToString(PathsConfiguration.getInstance((Project)jprj).getClassPath(), sources, File.pathSeparator)));
        cmd.add("-sourcepath");
        cmd.add(Ojc.stringize(Helpers.urlPathToString(PathsConfiguration.getInstance((Project)jprj).getSourcePath(), File.pathSeparator)));
        String outPath = Ojc.processOutputDirectory(jprj, cmd).getPath();
        try {
            if (tmpJavacFile == null) {
                tmpJavacFile = File.createTempFile("javac", null, null);
                tmpJavacFile.deleteOnExit();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmpJavacFile), 16384);
            boolean isBuggedJavac = PlatformUtils.isWindows() && buildSysConfig.isJDK15();
            int i = 0;
            while (i < sources.size()) {
                Storage stor = (Storage)sources.get(i);
                String storPath = stor.getPath();
                if (isBuggedJavac && stor.getName().equals("package-info.java")) {
                    bw.write(Ojc.stringize(storPath).replace('/', '\\'));
                } else {
                    bw.write(Ojc.stringize(storPath).replace('\\', '/'));
                }
                bw.write("\n");
                if (stor.getProperty("sourceMap") != null) {
                    sourceMapFiles.put(storPath.replace('\\', '/'), stor);
                }
                ++i;
            }
            bw.close();
            cmd.add(Ojc.stringize("@" + tmpJavacFile.getPath()));
        }
        catch (Throwable t) {
            System.out.println("error: unable to run javac as an external process: " + t);
            int n2 = 1;
            return n2;
        }
        SimpleProcess javacProcess = new SimpleProcess(cmd.toArray(new String[cmd.size()]));
        javacProcess.setAddToProcessesFolder(false);
        javacProcess.setAddToTerminateMenu(false);
        1JavacLogInfo javacLogInfo = new 1JavacLogInfo(this, outPath, javacProcess, reallyVerboseOutput, sourceMapFiles, log, rm);
        javacProcess.setLogPage((LogPage)javacLogInfo);
        int resCode = javacProcess.execAndWait();
        SimpleProcess jProcess = javacProcess;
        SimpleProcess simpleProcess = javacProcess;
        synchronized (simpleProcess) {
            jProcess = null;
        }
        if (resCode < 0) {
            log.error(null, 0, 0, 0, CompArb.getString(82));
        }
        rm.redefineClassMap(jprj);
        this.addSMAPs(sources, outPath);
        return resCode == 0 ? resCode : (log.nerrors() > 0 ? log.nerrors() : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runOjcOutOfProcess(Project jprj, CompilerOptionManager optionManager, boolean rebuild, ArrayList sources, ArrayList results, Translator.Log log) {
        Boolean val;
        String target;
        String[] compilerOptionArray;
        RedefineMap rm = new RedefineMap();
        HashMap<String, Storage> sourceMapFiles = new HashMap<String, Storage>();
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        ArrayList<String> cmd = new ArrayList<String>(15 + sources.size());
        try {
            String javaString = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK().getJavaExecutable().getPath();
            javaString = new File(javaString).getPath();
            cmd.add(Ojc.stringize(javaString.replace('/', File.separatorChar)));
            StringTokenizer vmArgs = new StringTokenizer(buildSysConfig.getOutOfProcessJavaOptions());
            while (vmArgs.hasMoreTokens()) {
                cmd.add(vmArgs.nextToken());
            }
            cmd.add("-classpath");
            cmd.add(Ide.getLibDirectory() + "ojc.jar");
            cmd.add("oracle.ojc.compiler.OutOfProcessMain");
        }
        catch (Throwable t) {
            System.out.println("Error: unable to run ojc compiler out of process");
            int n = 1;
            return n;
        }
        boolean rebuildOption = false;
        String[] stringArray = compilerOptionArray = optionManager.getCompilerOptionsAsArray("Ojc");
        int n = 0;
        while (n < stringArray.length) {
            String compilerOption = stringArray[n];
            if (compilerOption.equals("-rebuild")) {
                rebuildOption = true;
            }
            cmd.add(compilerOption);
            ++n;
        }
        String source = buildSysConfig.getSource();
        if (!source.equals("Default")) {
            cmd.add("-source");
            cmd.add(source);
        }
        if (!(target = buildSysConfig.getTarget()).equals("Default")) {
            cmd.add("-target");
            cmd.add(target);
        }
        cmd.add("-encoding");
        cmd.add(buildSysConfig.getCurrentEncoding());
        cmd.add("-classpath");
        cmd.add(Ojc.stringize(Helpers.urlPathAndDependantPathToString(PathsConfiguration.getInstance((Project)jprj).getClassPath(), sources, File.pathSeparator)));
        cmd.add("-sourcepath");
        cmd.add(Ojc.stringize(Helpers.urlPathToString(PathsConfiguration.getInstance((Project)jprj).getSourcePath(), File.pathSeparator)));
        String outPath = Ojc.processOutputDirectory(jprj, cmd).getPath();
        File mdfFile = Ojc.getCdiFile(jprj, false);
        cmd.add("-namereferences");
        cmd.add("-make");
        cmd.add(mdfFile.getPath());
        if (rebuild && !rebuildOption) {
            cmd.add("-rebuild");
        }
        if ((rebuild || rebuildOption) && (val = (Boolean)jprj.getTransientProperties().get("rebuild")) != null && val.booleanValue() && mdfFile.exists()) {
            mdfFile.delete();
        }
        if (UnifiedBuildSystem.showCompileProgress) {
            cmd.add("-noquiet");
        }
        try {
            if (tmpOjcFile == null) {
                tmpOjcFile = File.createTempFile("ojc", null, null);
                tmpOjcFile.deleteOnExit();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmpOjcFile), 16384);
            int i = 0;
            while (i < sources.size()) {
                Storage stor = (Storage)sources.get(i);
                String storPath = stor.getPath().replace('\\', '/');
                bw.write(Ojc.stringize(storPath));
                bw.write("\n");
                if (stor.getProperty("sourceMap") != null) {
                    sourceMapFiles.put(storPath, stor);
                }
                ++i;
            }
            bw.close();
            cmd.add(Ojc.stringize("@" + tmpOjcFile.getPath()));
        }
        catch (Throwable t) {
            System.out.println("error: unable to run ojc as an external process: " + t);
            int n2 = 1;
            return n2;
        }
        SimpleProcess ojcProcess = new SimpleProcess(cmd.toArray(new String[cmd.size()]));
        ojcProcess.setAddToProcessesFolder(false);
        ojcProcess.setAddToTerminateMenu(false);
        ojcProcess.setLogPage((LogPage)new 1OjcLogInfo(this, outPath, ojcProcess, sourceMapFiles, log, rm));
        int resCode = ojcProcess.execAndWait();
        SimpleProcess jProcess = ojcProcess;
        SimpleProcess simpleProcess = ojcProcess;
        synchronized (simpleProcess) {
            jProcess = null;
        }
        if (resCode < 0) {
            log.error(null, 0, 0, 0, CompArb.getString(82));
        }
        rm.redefineClassMap(jprj);
        this.addSMAPs(sources, outPath);
        return resCode == 0 ? resCode : (log.nerrors() > 0 ? log.nerrors() : 1);
    }

    private ArrayList checkDependencies(DependencyProvider dp, File depFile, Project jprj, ArrayList sources, boolean rebuild) {
        if (depFile.exists()) {
            try {
                FileInputStream is = new FileInputStream(depFile);
                dp.load(is, false);
            }
            catch (IOException e) {
                dp.reinit();
            }
        }
        ArrayList urlList = new ArrayList();
        this.getJavaSourceFiles(jprj, urlList);
        HashMap<URL, Storage> sourceMap = new HashMap<URL, Storage>(sources.size());
        int i = 0;
        while (i < sources.size()) {
            Storage s = (Storage)sources.get(i);
            String p = s.getPath();
            URL url = URLFactory.newFileURL((String)p);
            sourceMap.put(url, s);
            if (p.endsWith(".java") && s.getProperty("preprocessor_generated_file") == Boolean.TRUE && !urlList.contains(url)) {
                urlList.add(url);
            }
            ++i;
        }
        try {
            urlList = dp.updateData(urlList, rebuild, true, sourceMap);
        }
        catch (IOException e) {
            new Exception("dependency provider error").printStackTrace();
        }
        sources.clear();
        ArrayList c = rebuild ? urlList : dp.getDependants(urlList, true);
        for (Object ourl : c) {
            URL url = (URL)ourl;
            Storage stor = (Storage)sourceMap.get(url);
            if (stor != null) {
                sources.add(stor);
                continue;
            }
            sources.add(new FileStorage(new File(url.getPath())));
        }
        return sources;
    }

    private void getJavaSourceFiles(Project prj, ArrayList result) {
        URL[] urls;
        QueryCriteria criteria = new QueryCriteria();
        criteria.put((Object)"file.extension", (Object)".java");
        URL[] uRLArray = urls = Helpers.getUrlsThroughIndexer(prj, criteria);
        int n = 0;
        while (n < uRLArray.length) {
            URL url = uRLArray[n];
            result.add(url);
            ++n;
        }
    }

    @Override
    public int translate(Project prj, boolean rebuild, ArrayList sources, ArrayList results) {
        int batchSize;
        Boolean val;
        UnifiedBuildSystem.getInstance().beginMarking(this);
        Translator.Log log = this._log;
        Project jprj = prj;
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)jprj);
        RedefineMap rm = new RedefineMap();
        if (optionManager.getCurrentCompiler().equalsIgnoreCase("javac")) {
            File depFile = Ojc.getCdiFile(prj, true);
            DependencyProvider dp = new DependencyProvider();
            Assert.println((String)("**** rebuild value is " + rebuild));
            sources = this.checkDependencies(dp, depFile, jprj, sources, rebuild);
            if (sources.size() <= 0) {
                JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(69) + "\n"));
                return 0;
            }
            int errCnt = log.nerrors();
            if (this.runJavacProcess(jprj, optionManager, rebuild, sources, results, log) == 0) {
                if (errCnt == log.nerrors()) {
                    try {
                        File dir = depFile.getParentFile();
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        dp.save(new FileOutputStream(depFile), false);
                    }
                    catch (IOException e) {
                        new Exception("Dependency provider error, " + depFile.getPath() + " may be readonly").printStackTrace();
                    }
                }
                return 0;
            }
            return 1;
        }
        BuildSystemConfiguration buildSystemConfiguration = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        if (buildSystemConfiguration.getOutOfProcess()) {
            return this.runOjcOutOfProcess(jprj, optionManager, rebuild, sources, results, log);
        }
        Options options = new Options(null);
        options.ideEnv = new 1(this, log, rm);
        2 ojcLog = new 2(this, options, log);
        options.setLog((Log)ojcLog);
        Message.initializeMessages((Log)options.getLog());
        options.noquiet = UnifiedBuildSystem.showCompileProgress;
        if (Thread.currentThread().isInterrupted()) {
            return 0;
        }
        Warning.disableAllWarnings();
        String[] optionArgs = optionManager.getCompilerOptionsAsArray("Ojc");
        int optionArgCount = 0;
        while (optionArgCount < optionArgs.length) {
            int result = options.parseOption(optionArgs, optionArgCount);
            if (result == 0) {
                return 1;
            }
            optionArgCount += result;
        }
        String target = buildSystemConfiguration.getTarget();
        options.targetJDKVersion = target.equals("1.1") ? 110 : (target.equals("1.2") ? 120 : (target.equals("1.3") ? 130 : (target.equals("1.4") ? 140 : (target.equals("1.5") ? 150 : (target.equals("1.6") ? 160 : (target.equals("1.7") ? 170 : 150))))));
        String source = buildSystemConfiguration.getSource();
        options.sourceJDKVersion = source.equals("1.1") ? 110 : (source.equals("1.2") ? 120 : (source.equals("1.3") ? 130 : (source.equals("1.4") ? 140 : (source.equals("1.5") ? 150 : (source.equals("1.6") ? 160 : (source.equals("1.7") ? 170 : 150))))));
        if (currentContext != null && currentContext.getProperty("CompilerGenerateClassesDespiteErrors") == Boolean.TRUE) {
            options.generateClassesDespiteErrors = true;
        }
        options.encoding = buildSystemConfiguration.getCurrentEncoding();
        options.classpathStorage = Helpers.urlPathAndDependantPathToStorageArray(PathsConfiguration.getInstance((Project)jprj).getClassPath(), sources);
        URLPath urlSrcPath = PathsConfiguration.getInstance((Project)jprj).getSourcePath();
        Storage[] srcPath = Helpers.urlPathToStorageArray(urlSrcPath);
        IdeStorageMap storageMap = IdeStorageMap.create(urlSrcPath);
        int i = 0;
        while (i < srcPath.length) {
            if (srcPath[i] instanceof FileStorage) {
                srcPath[i] = new IdeStorageWrapper(srcPath[i], storageMap);
            }
            ++i;
        }
        options.sourcepathStorage = srcPath;
        options.bootClasspathStr = "";
        File outputDirectory = Ojc.processOutputDirectory(jprj, null);
        options.destinationDir = outputDirectory.getPath();
        File mdf = Ojc.getCdiFile(prj, false);
        options.rebuild |= rebuild;
        if (options.rebuild && (val = (Boolean)prj.getTransientProperties().get("rebuild")) != null && val.booleanValue() && mdf.exists()) {
            mdf.delete();
        }
        options.makeFile = new FileStorage(mdf);
        options.addNameReferences = true;
        int fileCount = sources.size();
        try {
            String fileCountStr = Integer.toString(fileCount);
            String splitProperty = Ide.getProperty((String)"OJC.BuildFragmentSize", (String)fileCountStr);
            batchSize = Integer.parseInt(splitProperty);
            if (batchSize <= 0 || batchSize > fileCount) {
                batchSize = fileCount;
            }
        }
        catch (Throwable t) {
            batchSize = fileCount;
        }
        int fileIndex = 0;
        int retry = 0;
        if (batchSize != fileCount) {
            Assert.println((String)("OJC: Building " + fileCount + " by chunks of " + batchSize + " files"));
        }
        while (fileCount > 0) {
            int res;
            int fileToBuild;
            block29: {
                fileToBuild = fileCount < batchSize ? fileCount : batchSize;
                ArrayList<Storage> toBuild = new ArrayList<Storage>(fileToBuild);
                int i2 = 0;
                while (i2 < fileToBuild) {
                    toBuild.add((Storage)sources.get(fileIndex + i2));
                    ++i2;
                }
                fileIndex += fileToBuild;
                fileCount -= fileToBuild;
                if (options.noquiet) {
                    String cmdLine = this.buildOjcCmdLine(jprj, options, toBuild, rebuild);
                    oracle.ide.compiler.Compiler.getCompiler().logOutMsg(cmdLine + "\n");
                }
                try {
                    try {
                        res = Compiler.main_throws_exceptions(toBuild, (Options)options);
                    }
                    catch (NoSuchMethodError e) {
                        res = Compiler.main(toBuild, (Options)options);
                    }
                }
                catch (Exception e) {
                    res = 2;
                    Throwable t = e.getCause();
                    if (t == null) break block29;
                    FeedbackManager.reportException((String)e.getMessage(), (Throwable)t);
                }
            }
            if (res == 4) {
                if (retry > 3 || batchSize < 2) {
                    log.error(null, 0, 0, 0, CompArb.getString(35));
                    continue;
                }
                fileIndex -= fileToBuild;
                fileCount += fileToBuild;
                prj.setProperty("OJC.BuildFragmentSize", Integer.toString(batchSize /= 2));
                ++retry;
                continue;
            }
            if (res < 2) continue;
            log.error(null, 0, 0, 0, res == 3 ? CompArb.getString(82) : CompArb.getString(62));
        }
        if (storageMap != null) {
            storageMap.destroy();
        }
        rm.redefineClassMap(prj);
        this.addSMAPs(sources, outputDirectory.getPath());
        return log.nerrors();
    }

    public void initialize() {
        JCompiler.getInstance().registerTranslator(this);
    }

    static void mav$logMessage(Ojc ojc, Translator.Log log, Storage storage, int n, int n2, String string, boolean bl) {
        ojc.logMessage(log, storage, n, n2, string, bl);
    }

    static Translator.Log ra$_log(Ojc ojc) {
        return ojc._log;
    }

    class 1JavacLogInfo
    extends AbstractLogPage {
        final StringBuffer sb;
        final String outPath;
        final SimpleProcess javacProcess;
        int logLine;
        boolean reallyVerboseOutput;
        boolean startedParsing;
        boolean errorsAtStartup;
        private final Pattern javacErrorPattern;
        private final Pattern javacWarningPattern;
        private final Pattern javacOutFilePattern;
        private final Pattern javacParsingFilePattern;
        private final /* synthetic */ HashMap v$sourceMapFiles;
        private final /* synthetic */ Translator.Log v$log;
        private final /* synthetic */ RedefineMap v$rm;
        final /* synthetic */ Ojc this$0;

        1JavacLogInfo(Ojc ojc, String outp, SimpleProcess prc, boolean reallyVerboseOutput, HashMap hashMap, Translator.Log log, RedefineMap redefineMap) {
            this.v$rm = redefineMap;
            this.v$log = log;
            this.v$sourceMapFiles = hashMap;
            this.this$0 = ojc;
            super(new ViewId("BuildSystemJavacBufferPage", "BuildSystemJavacBufferPage"), null, false);
            this.$init$();
            this.sb = new StringBuffer(1024);
            this.logLine = 0;
            this.outPath = outp;
            this.javacProcess = prc;
            this.reallyVerboseOutput = reallyVerboseOutput;
            this.startedParsing = false;
            this.errorsAtStartup = false;
        }

        private void $init$() {
            this.javacErrorPattern = Pattern.compile("^(.*):([0-9A-Za-z]+):(.*)$");
            this.javacWarningPattern = Pattern.compile("^([^\\[]+): \\[([\\p{javaLowerCase}\\p{javaUpperCase}]+)\\] (.+):(.+)");
            this.javacOutFilePattern = Pattern.compile("^\\[wrote (.*\\.class)\\]$");
            this.javacParsingFilePattern = Pattern.compile("^\\[parsing started (.*\\.java)\\]$");
        }

        private Storage getSourceFile(String sourceFile) {
            Storage source = (Storage)this.v$sourceMapFiles.get(sourceFile.replace('\\', '/'));
            if (source == null) {
                source = new FileStorage(new File(sourceFile));
            }
            return source;
        }

        public void log(Object msg) {
            String line;
            this.sb.append(msg.toString());
            while ((line = this.getLine(this.sb)) != null) {
                Matcher matcher;
                String newLine;
                this.checkForTermination();
                if (++this.logLine == 1) {
                    if (!Ide.getEnvironOptions().getSaveBeforeCompile()) {
                        this.v$log.error(null, 0, 0, 0, CompArb.getString(90));
                    }
                    if (!UnifiedBuildSystem.showCompileProgress) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(14) + "\n"));
                    JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                    continue;
                }
                if (line.endsWith(" cannot find symbol") && (newLine = this.getLine(this.sb)) != null && newLine.startsWith("symbol  : ")) {
                    line = line.substring(0, line.lastIndexOf("symbol")) + newLine.substring(10);
                }
                if ((matcher = this.javacErrorPattern.matcher(line)).matches()) {
                    int lineno;
                    try {
                        lineno = Integer.parseInt(matcher.group(2));
                    }
                    catch (NumberFormatException e) {
                        lineno = 0;
                    }
                    String errmsg = matcher.group(3);
                    boolean isError = errmsg.startsWith(" warning:") ^ true;
                    Ojc.mav$logMessage(this.this$0, this.v$log, this.getSourceFile(matcher.group(1)), Scanner.lineColumnToPosition((int)lineno, (int)0), 0, isError ? errmsg : errmsg.substring(9), isError);
                    continue;
                }
                matcher = this.javacOutFilePattern.matcher(line);
                if (matcher.matches()) {
                    String classFile = matcher.group(1);
                    this.v$rm.redefineClass(classFile, this.outPath, this.v$log);
                    if (!UnifiedBuildSystem.showCompileProgress) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)("  writing " + classFile + "\n"));
                    continue;
                }
                matcher = this.javacParsingFilePattern.matcher(line);
                if (matcher.matches()) {
                    this.startedParsing = true;
                    String fname = matcher.group(1);
                    Storage source = this.getSourceFile(fname);
                    UnifiedBuildSystem.getInstance().markTranslated((Object)this, source);
                    this.v$log.clear(source);
                    if (!UnifiedBuildSystem.showCompileProgress) continue;
                    if (fname != null) {
                        fname = fname.replace('/', File.separatorChar);
                    }
                    JCompiler.getInstance().getOutputLog().log((Object)("  compiling " + fname + "\n"));
                    continue;
                }
                matcher = this.javacWarningPattern.matcher(line);
                if (matcher.matches()) {
                    this.v$log.warning(null, 0, 0, 0, line);
                    continue;
                }
                if (line.startsWith("javac:")) {
                    this.v$log.error(null, 0, 0, 0, line);
                    JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                    continue;
                }
                if (line.startsWith("javac ")) {
                    JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                    continue;
                }
                if (line.startsWith("[")) {
                    if (!this.reallyVerboseOutput) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                    continue;
                }
                if (!this.startedParsing && line.startsWith("Could ") || line.startsWith("Error") || line.startsWith("Unrecognized") || line.startsWith("Invalid")) {
                    if (!this.errorsAtStartup) {
                        this.v$log.error(null, 0, 0, 0, line);
                    }
                    this.errorsAtStartup = true;
                    JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                    continue;
                }
                if (this.startedParsing) continue;
                JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
            }
            this.checkForTermination();
        }

        private String getLine(StringBuffer sb) {
            int i = sb.indexOf("\n");
            if (i >= 0) {
                int j = i;
                char c = sb.charAt(j);
                while (j >= 0 && (c == '\r' || c == '\n')) {
                    if (--j < 0) continue;
                    c = sb.charAt(j);
                }
                String result = sb.substring(0, j + 1);
                sb.delete(0, i + 1);
                return result;
            }
            return null;
        }

        private void checkForTermination() {
            if (Thread.currentThread().isInterrupted()) {
                new 1().start();
            }
        }

        public Component getGUI() {
            return null;
        }

        protected void requestShow() {
        }

        public void show() {
        }

        public boolean isVisible() {
            return true;
        }

        final class 1
        extends Thread {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SimpleProcess simpleProcess = 1JavacLogInfo.this.javacProcess;
                synchronized (simpleProcess) {
                    if (1JavacLogInfo.this.javacProcess != null) {
                        1JavacLogInfo.this.javacProcess.getRunProcess().terminate();
                    }
                }
            }
        }
    }

    class 1OjcLogInfo
    extends AbstractLogPage {
        final SimpleProcess ojcProcess;
        final String outPath;
        final StringBuffer sb;
        int logLine;
        boolean ojcStarted;
        boolean errorsAtStartup;
        private final /* synthetic */ HashMap v$sourceMapFiles;
        private final /* synthetic */ Translator.Log v$log;
        private final /* synthetic */ RedefineMap v$rm;
        final /* synthetic */ Ojc this$0;

        1OjcLogInfo(Ojc ojc, String outp, SimpleProcess prc, HashMap hashMap, Translator.Log log, RedefineMap redefineMap) {
            this.v$rm = redefineMap;
            this.v$log = log;
            this.v$sourceMapFiles = hashMap;
            this.this$0 = ojc;
            super(new ViewId("BuildSystemOjcBufferPage", "BuildSystemOjcBufferPage"), null, false);
            this.sb = new StringBuffer(1024);
            this.logLine = 0;
            this.outPath = outp;
            this.ojcProcess = prc;
            this.ojcStarted = false;
            this.errorsAtStartup = false;
        }

        private Storage getSourceFile(String sourceFile) {
            Storage source = (Storage)this.v$sourceMapFiles.get(sourceFile.replace('\\', '/'));
            if (source == null) {
                source = new FileStorage(new File(sourceFile));
            }
            return source;
        }

        public void log(Object msg) {
            String line;
            this.sb.append(msg.toString());
            while ((line = this.getLine(this.sb)) != null) {
                this.checkForTermination();
                if (++this.logLine == 1) {
                    if (!Ide.getEnvironOptions().getSaveBeforeCompile()) {
                        this.v$log.warning(null, 0, 0, 0, CompArb.getString(33));
                    }
                    if (!UnifiedBuildSystem.showCompileProgress) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(14) + "\n"));
                    JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                    continue;
                }
                this.logLine(line);
            }
            this.checkForTermination();
        }

        private void logLine(String line) {
            Storage source = null;
            if (line.startsWith("OutOfProcessAuthorizeParse:")) {
                int len = "OutOfProcessAuthorizeParse:".length();
                source = this.getSourceFile(line.substring(len));
                this.v$log.clear(source);
                UnifiedBuildSystem.getInstance().markTranslated(this.this$0, source);
                return;
            }
            if (line.startsWith("OutOfProcessAuthorizeWrite:")) {
                int len = "OutOfProcessAuthorizeWrite:".length();
                this.v$rm.redefineClass(line.substring(len), this.outPath, this.v$log);
                return;
            }
            if (line.equals("OutOfProcessOjcStarted")) {
                this.ojcStarted = true;
                return;
            }
            if (line.startsWith("OutOfProcessWord:")) {
                int len = "OutOfProcessWord:".length();
                if (UnifiedBuildSystem.showCompileProgress) {
                    JCompiler.getInstance().getOutputLog().log((Object)line.substring(len));
                }
                return;
            }
            if (line.startsWith("OutOfProcessLine:")) {
                int len = "OutOfProcessLine:".length();
                if (UnifiedBuildSystem.showCompileProgress) {
                    line = line.substring(len);
                    String translatedCompilingString = "[" + CompArb.getString(46) + " ";
                    String originalCompilingString = "[compiling ";
                    if ((line.startsWith(translatedCompilingString) || line.startsWith(originalCompilingString)) && line.endsWith("]")) {
                        line = "  " + line.substring(1, line.length() - 1);
                    }
                    JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                }
                return;
            }
            if (line.startsWith("[")) {
                JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                return;
            }
            String prefixToken = null;
            int lineNumber = 0;
            int column = 0;
            int diagnosticNumber = 0;
            int state = 0;
            StringTokenizer tokenizer = new StringTokenizer(line, ",", true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                switch (state) {
                    case 0: {
                        if (token.equals("OutOfProcessError") || token.equals("OutOfProcessWarning")) {
                            prefixToken = token;
                            ++state;
                            break;
                        }
                        if (!this.ojcStarted && !this.errorsAtStartup) {
                            this.v$log.error(null, 0, 0, 0, line);
                            this.errorsAtStartup = true;
                        }
                        JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                        return;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: {
                        if (token.equals(",")) {
                            ++state;
                            break;
                        }
                        Assert.check((boolean)false, (String)"Invalid token in compiler message");
                        JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                        return;
                    }
                    case 2: {
                        if (token.trim().length() > 0) {
                            source = this.getSourceFile(token);
                        }
                        ++state;
                        break;
                    }
                    case 4: {
                        lineNumber = this.getInt(token, line);
                        if (lineNumber < 0) {
                            return;
                        }
                        ++state;
                        break;
                    }
                    case 6: {
                        column = this.getInt(token, line);
                        if (column < 0) {
                            return;
                        }
                        ++column;
                        ++state;
                        break;
                    }
                    case 8: {
                        diagnosticNumber = this.getInt(token, line);
                        if (diagnosticNumber < 0) {
                            return;
                        }
                        ++state;
                        break;
                    }
                    case 10: {
                        StringBuilder buf = new StringBuilder(token);
                        while (tokenizer.hasMoreTokens()) {
                            buf.append(tokenizer.nextToken());
                        }
                        Ojc.mav$logMessage(this.this$0, this.v$log, source, Scanner.lineColumnToPosition((int)lineNumber, (int)column), diagnosticNumber, buf.toString(), prefixToken.equals("OutOfProcessError"));
                        return;
                    }
                }
            }
            JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
        }

        private int getInt(String token, String line) {
            try {
                if (token.trim().length() > 0) {
                    int n = Integer.parseInt(token);
                    return n;
                }
                int n = 0;
                return n;
            }
            catch (NumberFormatException e) {
                Assert.check((boolean)false, (String)"Invalid token in compiler message");
                JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                int n = -1;
                return n;
            }
        }

        private String getLine(StringBuffer sb) {
            int i = sb.indexOf("\n");
            if (i >= 0) {
                int j = i;
                char c = sb.charAt(j);
                while (j >= 0 && (c == '\r' || c == '\n')) {
                    if (--j < 0) continue;
                    c = sb.charAt(j);
                }
                String result = sb.substring(0, j + 1);
                sb.delete(0, i + 1);
                return result;
            }
            return null;
        }

        private void checkForTermination() {
            if (Thread.currentThread().isInterrupted()) {
                new 1().start();
            }
        }

        public Component getGUI() {
            return null;
        }

        protected void requestShow() {
        }

        public void show() {
        }

        public boolean isVisible() {
            return true;
        }

        final class 1
        extends Thread {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SimpleProcess simpleProcess = 1OjcLogInfo.this.ojcProcess;
                synchronized (simpleProcess) {
                    if (1OjcLogInfo.this.ojcProcess != null) {
                        1OjcLogInfo.this.ojcProcess.getRunProcess().terminate();
                    }
                }
            }
        }
    }

    final class 1
    implements IdeEnv {
        private final /* synthetic */ Translator.Log v$log;
        private final /* synthetic */ RedefineMap v$rm;
        final /* synthetic */ Ojc this$0;

        public boolean authorizeParsing(Storage source, String reason) {
            this.v$log.clear(source);
            if (Thread.currentThread().isInterrupted()) {
                Assert.println((String)"authorizeParsing: Thread interrupted");
                return false;
            }
            UnifiedBuildSystem.getInstance().markTranslated(this, source);
            return true;
        }

        public boolean authorizeChecking(Storage source, String reason) {
            if (Thread.currentThread().isInterrupted()) {
                Assert.println((String)"authorizeChecking: Thread interrupted");
                return false;
            }
            return true;
        }

        public boolean authorizeWriting(Storage source, String qualifiedClassName, byte[] buffer, int offset, int len) {
            if (Thread.currentThread().isInterrupted()) {
                Assert.println((String)"authorizeWriting: Thread interrupted");
                return false;
            }
            this.v$rm.redefineClass(source, qualifiedClassName, buffer, len, Ojc.ra$_log(this.this$0));
            return true;
        }

        public 1(Ojc ojc, Translator.Log log, RedefineMap redefineMap) {
            this.v$rm = redefineMap;
            this.v$log = log;
            this.this$0 = ojc;
        }
    }

    final class 2
    implements Log2 {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final /* synthetic */ Options v$options;
        private final /* synthetic */ Translator.Log v$log;
        final /* synthetic */ Ojc this$0;

        static {
            $assertionsDisabled = 2.class.desiredAssertionStatus() ^ true;
        }

        public void redirect(String filename) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void print(String word) {
            if (this.v$options.noquiet) {
                oracle.ide.compiler.Compiler.getCompiler().logOutMsg(word);
            }
        }

        public void println(String line) {
            if (this.v$options.noquiet) {
                String translatedCompilingString = "[" + CompArb.getString(46) + " ";
                String originalCompilingString = "[compiling ";
                if (UnifiedBuildSystem.showCompileProgress && (line.startsWith(translatedCompilingString) || line.startsWith(originalCompilingString)) && line.endsWith("]")) {
                    line = "  " + line.substring(1, line.length() - 1);
                }
                oracle.ide.compiler.Compiler.getCompiler().logOutMsg(line + "\n");
            }
        }

        public void printError(Storage source, int pos, ErrorInfo info) {
            Ojc.mav$logMessage(this.this$0, this.v$log, source, pos + 1, info.getNumber(), info.getMessage(), true);
        }

        public void printError(String errorMessage) {
            this.v$log.error(null, 0, 0, 0, errorMessage);
        }

        public void printWarning(Storage source, int pos, ErrorInfo info) {
            Ojc.mav$logMessage(this.this$0, this.v$log, source, pos + 1, info.getNumber(), info.getMessage(), false);
        }

        public void printWarning(String warningMessage) {
            this.v$log.warning(null, 0, 0, 0, warningMessage);
        }

        public int nerrors() {
            return this.v$log.nerrors();
        }

        public int nwarnings() {
            return this.v$log.nwarnings();
        }

        public 2(Ojc ojc, Options options, Translator.Log log) {
            this.v$log = log;
            this.v$options = options;
            this.this$0 = ojc;
        }
    }
}

