/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.controls.GridBagConstraints2;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Encodings;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdevimpl.compiler.CompilerOptionManager;

public class OjcConfigurationPanel
extends ProjectSettingsTraversablePanel
implements ActionListener {
    JLabel copyResLabel;
    JTextField copyResTextField;
    JCheckBox reverseCopyResCheckBox;
    JLabel encodingLabel;
    JComboBox encodingComboBox;
    JLabel targetLabel;
    JComboBox targetComboBox;
    JLabel sourceLabel;
    JComboBox sourceComboBox;
    JLabel jdkCompatibilityLabel;
    GridBagLayout gridBagLayout1;
    private boolean addedActionListeners;
    private JCheckBox enableDebugInfoCheckBox;
    private JComboBox compilerChooser;
    private JLabel compilerChooserLabel;
    private JCheckBox outOfProcessCheckBox;
    private boolean outOfProcessState;
    private JLabel javaOptionsLabel;
    private JTextField javaOptionsTextField;
    private CompilerOptionManager compilerOptionManager;
    private Hashtable<String, Boolean> debugOptionTable;
    private static final String[] PROPERTY_KEYS = new String[]{"source", "target", "internalEncoding", "copyRes", "reverseCopyRes", "compiler.name", "outOfProcess", "outOfProcessJavaOptions"};

    private void $init$() {
        this.copyResLabel = new JLabel();
        this.copyResTextField = new JTextField();
        this.reverseCopyResCheckBox = new JCheckBox();
        this.encodingLabel = new JLabel();
        this.encodingComboBox = new JComboBox<String>(new String[0]);
        this.targetLabel = new JLabel();
        this.targetComboBox = new JComboBox<String>(new String[0]);
        this.sourceLabel = new JLabel();
        this.sourceComboBox = new JComboBox<String>(new String[0]);
        this.jdkCompatibilityLabel = new JLabel();
        this.gridBagLayout1 = new GridBagLayout();
        this.addedActionListeners = false;
        this.enableDebugInfoCheckBox = new JCheckBox();
        this.compilerChooser = new JComboBox<String>(new String[0]);
        this.compilerChooserLabel = new JLabel();
        this.outOfProcessCheckBox = new JCheckBox();
        this.outOfProcessState = false;
        this.javaOptionsLabel = new JLabel();
        this.javaOptionsTextField = new JTextField();
        this.debugOptionTable = new Hashtable();
    }

    public OjcConfigurationPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDataKey() {
        return OjcConfiguration.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        if (tc != null && OjcConfigurationPanel.isDefaultProject((Namespace)tc)) {
            this.setHelpID("f1_com_proset_compilerdpp_html");
        } else {
            this.setHelpID("f1_com_proset_compiler_html");
        }
        BuildSystemConfiguration buildSystemConfiguration = OjcConfigurationPanel.getBuildSystemConfiguration(tc);
        this.compilerOptionManager = OjcConfigurationPanel.getCompilerOptionManager(tc);
        this.loadFrom(buildSystemConfiguration, this.compilerOptionManager);
        if (!this.addedActionListeners) {
            this.addedActionListeners = true;
            this.targetComboBox.addActionListener(this);
            this.sourceComboBox.addActionListener(this);
            this.compilerChooser.addActionListener(this);
            this.enableDebugInfoCheckBox.addActionListener(this);
            this.outOfProcessCheckBox.addActionListener(this);
        }
    }

    public void onExit(TraversableContext tc) {
        BuildSystemConfiguration buildSystemConfiguration = OjcConfigurationPanel.getBuildSystemConfiguration(tc);
        this.compilerOptionManager = OjcConfigurationPanel.getCompilerOptionManager(tc);
        this.commitTo(buildSystemConfiguration, this.compilerOptionManager);
        if (this.addedActionListeners) {
            this.addedActionListeners = false;
            this.targetComboBox.removeActionListener(this);
            this.sourceComboBox.removeActionListener(this);
            this.compilerChooser.removeActionListener(this);
            this.enableDebugInfoCheckBox.removeActionListener(this);
            this.outOfProcessCheckBox.removeActionListener(this);
        }
    }

    private static BuildSystemConfiguration getBuildSystemConfiguration(TraversableContext tc) {
        PropertyStorage propertyData = OjcConfigurationPanel.getPropertyData((Namespace)tc);
        return BuildSystemConfiguration.getInstance((PropertyStorage)propertyData);
    }

    private static CompilerOptionManager getCompilerOptionManager(TraversableContext tc) {
        PropertyStorage propertyData = OjcConfigurationPanel.getPropertyData((Namespace)tc);
        return CompilerOptionManager.getInstance((PropertyStorage)propertyData);
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.targetComboBox || obj == this.sourceComboBox) {
            String s;
            String t = (String)this.targetComboBox.getSelectedItem();
            if (t != null && (s = (String)this.sourceComboBox.getSelectedItem()) != null) {
                String newT = null;
                String newS = null;
                if (obj == this.targetComboBox) {
                    if (t.equals("Default")) {
                        if (!s.equals("Default")) {
                            newS = "Default";
                        }
                    } else if (s.equals("Default")) {
                        newS = this.checkNewSourceTarget(this.sourceComboBox, t);
                    } else if (s.compareTo(t) > 0 && s.compareTo("1.4") >= 0) {
                        newS = this.checkNewSourceTarget(this.sourceComboBox, t);
                    }
                }
                if (obj == this.sourceComboBox) {
                    if (s.equals("Default")) {
                        if (!t.equals("Default")) {
                            newT = "Default";
                        }
                    } else if (t.equals("Default")) {
                        newT = this.checkNewSourceTarget(this.targetComboBox, s);
                    } else if (s.compareTo(t) > 0 && s.compareTo("1.4") >= 0) {
                        newT = this.checkNewSourceTarget(this.targetComboBox, s);
                    }
                }
                if (newT != null) {
                    this.targetComboBox.setSelectedItem(newT);
                } else if (newS != null) {
                    this.sourceComboBox.setSelectedItem(newS);
                }
            }
        } else if (obj == this.compilerChooser) {
            if (this.compilerChooser.getSelectedItem() != null) {
                String currentCompiler = this.compilerChooser.getSelectedItem().toString();
                boolean isDebug = this.debugOptionTable.get(currentCompiler);
                this.enableDebugInfoCheckBox.setSelected(isDebug);
                if (currentCompiler.equalsIgnoreCase("javac")) {
                    this.outOfProcessCheckBox.setSelected(true);
                    this.outOfProcessCheckBox.setEnabled(false);
                    this.javaOptionsLabel.setEnabled(true);
                    this.javaOptionsTextField.setEnabled(true);
                } else {
                    this.outOfProcessCheckBox.setSelected(this.outOfProcessState);
                    this.outOfProcessCheckBox.setEnabled(true);
                    this.javaOptionsLabel.setEnabled(this.outOfProcessState);
                    this.javaOptionsTextField.setEnabled(this.outOfProcessState);
                }
            }
        } else if (obj == this.enableDebugInfoCheckBox) {
            String currentCompiler = this.compilerChooser.getSelectedItem().toString();
            boolean isDebug = this.enableDebugInfoCheckBox.isSelected();
            this.debugOptionTable.put(currentCompiler, isDebug);
        } else if (obj == this.outOfProcessCheckBox) {
            this.outOfProcessState = this.outOfProcessCheckBox.isSelected();
            this.javaOptionsLabel.setEnabled(this.outOfProcessState);
            this.javaOptionsTextField.setEnabled(this.outOfProcessState);
        }
    }

    private String checkNewSourceTarget(JComboBox comboBox, String newSourceTarget) {
        Object bestMatch = null;
        int size = comboBox.getItemCount();
        TreeSet<String> treeSet = new TreeSet<String>();
        int x = 0;
        while (x < size) {
            String item = comboBox.getItemAt(x).toString();
            if (item.equals(newSourceTarget)) {
                return item;
            }
            if (!item.equals("Default") && !item.equals("Default")) {
                treeSet.add(item);
            }
            ++x;
        }
        String lastItem = null;
        for (String item : treeSet) {
            if (item.compareTo(newSourceTarget) > 0) {
                return lastItem != null ? lastItem : item;
            }
            lastItem = item;
        }
        return lastItem != null ? lastItem : newSourceTarget;
    }

    private String toStringList(String[] strArray) {
        if (strArray != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < strArray.length) {
                buffer.append(strArray[i]).append(";");
                ++i;
            }
            if (strArray.length > 0) {
                int lastCharIndex = buffer.length() - 1;
                buffer.deleteCharAt(lastCharIndex);
            }
            return buffer.toString();
        }
        return "";
    }

    private void populateComboBox(JComboBox box, String[] list, String element) {
        box.removeAllItems();
        int i = 0;
        while (i < list.length) {
            box.addItem(list[i]);
            ++i;
        }
        box.setSelectedItem(element);
    }

    private void loadFrom(BuildSystemConfiguration c, CompilerOptionManager compilerOptionManager) {
        this.outOfProcessCheckBox.setSelected(c.getOutOfProcess());
        this.outOfProcessState = c.getOutOfProcess();
        this.javaOptionsTextField.setText(c.getOutOfProcessJavaOptions());
        this.actionPerformed(new ActionEvent(this.outOfProcessCheckBox, 1001, null));
        List compilerList = compilerOptionManager.getCompilers();
        String currentCompiler = compilerOptionManager.getCurrentCompiler();
        boolean foundCurrentCompiler = false;
        this.compilerChooser.removeAllItems();
        this.debugOptionTable.clear();
        for (String compilerName : compilerList) {
            boolean isDebug = compilerOptionManager.isDebugInformation(compilerName);
            this.debugOptionTable.put(compilerName, isDebug);
            this.compilerChooser.addItem(compilerName);
            if (!compilerName.equals(currentCompiler)) continue;
            this.compilerChooser.setSelectedItem(compilerName);
            foundCurrentCompiler = true;
        }
        if (!foundCurrentCompiler) {
            this.compilerChooser.setSelectedIndex(0);
        }
        this.actionPerformed(new ActionEvent(this.compilerChooser, 1001, null));
        this.populateComboBox(this.targetComboBox, c.getTargets(), c.getTargetString());
        this.populateComboBox(this.sourceComboBox, c.getSources(), c.getSourceString());
        this.copyResTextField.setText(this.toStringList(c.getCopyRes()));
        this.reverseCopyResCheckBox.setSelected(c.getReverseCopyRes());
        String enc = c.getCurrentEncoding();
        Encodings.initComboBox((JComboBox)this.encodingComboBox, (boolean)true, (String)enc);
    }

    private String[] toStringArray(String strList) {
        StringTokenizer tokenizer = new StringTokenizer(strList, ";");
        String[] strArray = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            strArray[i++] = tokenizer.nextToken();
        }
        return strArray;
    }

    private void commitTo(BuildSystemConfiguration c, CompilerOptionManager compilerOptionManager) {
        c.setTarget((String)this.targetComboBox.getSelectedItem());
        c.setSource((String)this.sourceComboBox.getSelectedItem());
        c.setCopyRes(this.toStringArray(this.copyResTextField.getText()));
        c.setReverseCopyRes(this.reverseCopyResCheckBox.isSelected());
        c.setOutOfProcess(this.outOfProcessState);
        c.setOutOfProcessJavaOptions(this.javaOptionsTextField.getText());
        if (Boolean.TRUE.equals(this.encodingComboBox.getClientProperty("encodings-loaded"))) {
            String encoding = (String)this.encodingComboBox.getSelectedItem();
            c.setCurrentEncoding("Default".equals(encoding) ? null : encoding);
        }
        String newCompiler = this.compilerChooser.getSelectedItem().toString();
        if (!compilerOptionManager.getCurrentCompiler().equals(newCompiler)) {
            compilerOptionManager.setCurrentCompiler(newCompiler);
        }
        Enumeration<String> compilers = this.debugOptionTable.keys();
        while (compilers.hasMoreElements()) {
            String compilerName = compilers.nextElement();
            boolean isDebug = this.debugOptionTable.get(compilerName);
            compilerOptionManager.setDebugInformation(compilerName, isDebug);
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.copyResLabel, (Component)this.copyResTextField, (String)CompArb.getString(64));
        ResourceUtils.resButton((AbstractButton)this.reverseCopyResCheckBox, (String)CompArb.getString(10));
        ResourceUtils.resLabel((JLabel)this.encodingLabel, (Component)this.encodingComboBox, (String)CompArb.getString(95));
        ResourceUtils.resLabel((JLabel)this.targetLabel, (Component)this.targetComboBox, (String)CompArb.getString(21));
        ResourceUtils.resLabel((JLabel)this.sourceLabel, (Component)this.sourceComboBox, (String)CompArb.getString(20));
        ResourceUtils.resLabel((JLabel)this.compilerChooserLabel, (Component)this.compilerChooser, (String)CompArb.getString(55));
        ResourceUtils.resButton((AbstractButton)this.enableDebugInfoCheckBox, (String)CompArb.getString(78));
        ResourceUtils.resButton((AbstractButton)this.outOfProcessCheckBox, (String)CompArb.getString(38));
        ResourceUtils.resLabel((JLabel)this.javaOptionsLabel, (Component)this.javaOptionsTextField, (String)CompArb.getString(76));
        this.jdkCompatibilityLabel.setText(CompArb.getString(22));
        int y = 0;
        this.setLayout(this.gridBagLayout1);
        JPanel compilerPanel = new JPanel();
        compilerPanel.setLayout(new GridBagLayout());
        compilerPanel.add((Component)this.compilerChooserLabel, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        compilerPanel.add((Component)this.compilerChooser, new GridBagConstraints2(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        compilerPanel.add((Component)this.enableDebugInfoCheckBox, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 24, 5, 0), 0, 0));
        compilerPanel.add((Component)this.outOfProcessCheckBox, new GridBagConstraints2(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 24, 5, 0), 0, 0));
        this.add(compilerPanel, new GridBagConstraints2(0, y, 6, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.javaOptionsLabel, new GridBagConstraints2(0, ++y, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.javaOptionsTextField, new GridBagConstraints2(0, ++y, 6, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 7, 0), 0, 0));
        ++y;
        JPanel scPanel = new JPanel();
        scPanel.setLayout(new GridBagLayout());
        scPanel.add((Component)this.jdkCompatibilityLabel, new GridBagConstraints2(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        scPanel.add((Component)this.sourceLabel, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 7, 0), 0, 0));
        scPanel.add((Component)this.sourceComboBox, new GridBagConstraints2(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 7, 0), 10, 0));
        scPanel.add((Component)this.targetLabel, new GridBagConstraints2(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 16, 7, 0), 0, 0));
        scPanel.add((Component)this.targetComboBox, new GridBagConstraints2(3, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 7, 0), 10, 0));
        this.add(scPanel, new GridBagConstraints2(0, y, 6, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.encodingLabel, new GridBagConstraints2(0, ++y, 3, 1, 0.0, 0.0, 17, 2, new Insets(8, 0, 0, 0), 0, 0));
        this.add(this.encodingComboBox, new GridBagConstraints2(0, ++y, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 7, 0), 0, 0));
        this.add(this.copyResLabel, new GridBagConstraints2(0, ++y, 3, 1, 0.0, 0.0, 17, 2, new Insets(8, 0, 0, 0), 0, 0));
        this.add(this.reverseCopyResCheckBox, new GridBagConstraints2(3, y, 3, 1, 0.0, 0.0, 13, 2, new Insets(8, 8, 0, 0), 0, 0));
        this.add(this.copyResTextField, new GridBagConstraints2(0, ++y, 6, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel moreLabel = new JLabel(CompArb.getString(42));
        this.add(moreLabel, new GridBagConstraints2(0, ++y, 6, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }
}

