/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class PatchClassFile {
    public static void addSMAP(File classFile, String smap) throws IOException, ClassFormatError {
        if (!classFile.getName().endsWith(".class")) {
            throw new ClassFormatError();
        }
        FileInputStream is = new FileInputStream(classFile);
        int len = is.available();
        byte[] buffer = new byte[len];
        is.read(buffer);
        is.close();
        try {
            buffer = PatchClassFile.patchClass(buffer, smap);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ClassFormatError();
        }
        FileOutputStream os = new FileOutputStream(classFile);
        os.write(buffer);
        os.close();
    }

    private static byte[] patchClass(byte[] in, String smap) {
        int len = in.length;
        byte[] out = new byte[len + smap.length() + 1 + 2 + 20 + 2 + 4];
        int inIdx = 0;
        int outIdx = 0;
        System.arraycopy(in, inIdx, out, outIdx, 8);
        int cnt = PatchClassFile.getChar(in, inIdx += 8);
        int outCstPoolCntIdx = outIdx += 8;
        out[outIdx++] = in[inIdx++];
        out[outIdx++] = in[inIdx++];
        int sourceDebugExtensionId = 0;
        int i = 1;
        while (i < cnt) {
            out[outIdx++] = in[inIdx];
            switch (in[inIdx++]) {
                case 1: 
                case 2: {
                    char utf8Len = PatchClassFile.getChar(in, inIdx);
                    System.arraycopy(in, inIdx, out, outIdx, 2 + utf8Len);
                    inIdx += 2;
                    if (utf8Len == '\u0014' && sourceDebugExtensionId == 0) {
                        boolean attrFound = true;
                        int j = 0;
                        while (j < 20) {
                            if (in[inIdx + j] != "SourceDebugExtension".charAt(j)) {
                                attrFound = false;
                                break;
                            }
                            ++j;
                        }
                        if (attrFound) {
                            sourceDebugExtensionId = i;
                        }
                    }
                    inIdx += utf8Len;
                    outIdx += utf8Len + 2;
                    break;
                }
                case 5: 
                case 6: {
                    ++i;
                    int j = 0;
                    while (j < 4) {
                        out[outIdx++] = in[inIdx++];
                        ++j;
                    }
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    out[outIdx++] = in[inIdx++];
                    out[outIdx++] = in[inIdx++];
                }
                case 7: 
                case 8: {
                    out[outIdx++] = in[inIdx++];
                    out[outIdx++] = in[inIdx++];
                    break;
                }
                default: {
                    throw new ClassFormatError();
                }
            }
            ++i;
        }
        if (sourceDebugExtensionId == 0) {
            out[outIdx++] = 1;
            outIdx = PatchClassFile.writeChar(20, out, outIdx);
            int i2 = 0;
            while (i2 < 20) {
                out[outIdx++] = (byte)"SourceDebugExtension".charAt(i2);
                ++i2;
            }
            sourceDebugExtensionId = cnt++;
            PatchClassFile.writeChar(cnt, out, outCstPoolCntIdx);
        }
        System.arraycopy(in, inIdx, out, outIdx, 6);
        outIdx += 6;
        int savedInIdx = inIdx += 6;
        cnt = PatchClassFile.getChar(in, inIdx);
        inIdx += 2 + cnt * 2;
        int i3 = 0;
        while (i3 < 2) {
            cnt = PatchClassFile.getChar(in, inIdx);
            inIdx += 2;
            int j = 0;
            while (j < cnt) {
                int attrCnt = PatchClassFile.getChar(in, inIdx += 6);
                inIdx += 2;
                int k = 0;
                while (k < attrCnt) {
                    int attrLen = PatchClassFile.getInt(in, inIdx += 2);
                    inIdx += 4 + attrLen;
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        System.arraycopy(in, savedInIdx, out, outIdx, inIdx - savedInIdx);
        int outAttrCntIdx = outIdx += inIdx - savedInIdx;
        cnt = PatchClassFile.getChar(in, inIdx);
        out[outIdx++] = in[inIdx++];
        out[outIdx++] = in[inIdx++];
        boolean attrFound = false;
        int i4 = 0;
        while (i4 < cnt) {
            char id = PatchClassFile.getChar(in, inIdx);
            if (id == sourceDebugExtensionId) {
                int attrLen = PatchClassFile.getInt(in, inIdx += 2);
                inIdx += 4 + attrLen;
            } else {
                int attrLen = PatchClassFile.getInt(in, inIdx + 2);
                System.arraycopy(in, inIdx, out, outIdx, 6 + attrLen);
                inIdx += 6 + attrLen;
                outIdx += 6 + attrLen;
            }
            ++i4;
        }
        PatchClassFile.writeChar(cnt + 1, out, outAttrCntIdx);
        outIdx = PatchClassFile.writeChar(sourceDebugExtensionId, out, outIdx);
        outIdx = PatchClassFile.writeInt(smap.length(), out, outIdx);
        int i5 = 0;
        while (i5 < smap.length()) {
            out[outIdx++] = (byte)smap.charAt(i5);
            ++i5;
        }
        if (outIdx < out.length) {
            byte[] newOut = new byte[outIdx];
            System.arraycopy(out, 0, newOut, 0, outIdx);
            out = newOut;
        }
        return out;
    }

    private static char getChar(byte[] buf, int bp) {
        return (char)(((buf[bp] & 0xFF) << 8) + (buf[bp + 1] & 0xFF));
    }

    private static int getInt(byte[] buf, int bp) {
        return ((buf[bp] & 0xFF) << 24) + ((buf[bp + 1] & 0xFF) << 16) + ((buf[bp + 2] & 0xFF) << 8) + (buf[bp + 3] & 0xFF);
    }

    private static int writeChar(int x, byte[] out, int idx) {
        out[idx++] = (byte)(x >> 8 & 0xFF);
        out[idx++] = (byte)(x & 0xFF);
        return idx;
    }

    private static int writeInt(int x, byte[] out, int idx) {
        out[idx++] = (byte)(x >> 24 & 0xFF);
        out[idx++] = (byte)(x >> 16 & 0xFF);
        out[idx++] = (byte)(x >> 8 & 0xFF);
        out[idx++] = (byte)(x & 0xFF);
        return idx;
    }

    private PatchClassFile() {
    }
}

