/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.TableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Assert;
import oracle.ide.util.BitField;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.controls.nicetable.DefaultNiceTableModel;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchField;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.JCompiler;

public class ProblemsPage
extends AbstractLogPage
implements ActiveViewListener,
Observer {
    private static int _shift;
    public static int HIDE_NO_MENUS;
    public static int HIDE_COPY_MENU;
    public static int HIDE_SAVE_AS_MENU;
    public static int HIDE_GOTO_SOURCE_MENU;
    public static int HIDE_FIX_SOURCE_MENU;
    public static int HIDE_ALL_MENUS;
    protected static final int GOTO_SOURCE_CMD_ID;
    protected static final int FIX_SOURCE_CMD_ID;
    private static URL _lastSaveToFileURL;
    protected KeyAdapter keyAdapter;
    private Controller _controller;
    private JMenuItem _copyMenu;
    private JMenuItem _saveAsMenu;
    private JMenuItem _gotoSourceMenu;
    private JMenuItem _fixSourceMenu;
    private boolean _popupMenuItemsInitialized;
    private static int TYPE_COL;
    private static int DESC_COL;
    private static int FILE_COL;
    private static int LINE_COL;
    private static int PROJ_COL;
    private static int DESC_FILTER_OPT;
    private static int FILE_FILTER_OPT;
    private static int DORF_FILTER_OPT;
    private Vector colNames;
    private Vector tableContent;
    private static final String TYPE_COL_NAME = " ";
    private static final String DESC_COL_NAME = "Description";
    private static final String FILE_COL_NAME = "File";
    private static final String LINE_COL_NAME = "Line";
    private static final String PROJ_COL_NAME = "Project";
    private DefaultNiceTableModel model;
    private NiceTable table;
    private boolean _isTableVisible;
    private JPanel logPage;
    private JPanel header;
    private JLabel compileInfo;
    private Toolbar toolbar;
    private JScrollPane scrollPane;
    private int nErrors;
    private int nWarnings;
    private String currPattern;
    private int currFilterOpt;
    private Vector hiddenRowData;
    int ENTER_FILTER_CMD_ID;
    int APPLY_FILTER_CMD_ID;
    int WARN_FILTER_CMD_ID;
    private IdeAction filterEnterKey;
    private IdeAction warnFilter;
    private SearchField _searchField;
    private SearchCategory _descCat;
    private SearchCategory _fileCat;
    private SearchCategory _dORfCat;
    private HashMap urlMsgWrapperTable;
    private HashMap urlOffsetMarkTable;
    private HashMap msgMsgWrapperMap;
    private static final int MAX_ASYNC_MESSAGES = 100;
    private static final int ASYNC_THREAD_SLEEP = 1000;
    private ArrayList asyncMessages;
    private Thread updateThread;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.keyAdapter = new DefaultKeyAdapter(null);
        this.table = new 1();
        this._isTableVisible = false;
        this.logPage = new JPanel(new BorderLayout());
        this.header = new JPanel(new BorderLayout());
        this.compileInfo = new JLabel("");
        this.toolbar = new Toolbar();
        this.scrollPane = new JScrollPane((Component)this.table);
        this.nErrors = 0;
        this.nWarnings = 0;
        this.currPattern = "";
        this.currFilterOpt = -1;
        this.hiddenRowData = new Vector();
        this.ENTER_FILTER_CMD_ID = Ide.createCmdID((String)"enterAction");
        this.APPLY_FILTER_CMD_ID = Ide.createCmdID((String)"filterAction");
        this.WARN_FILTER_CMD_ID = Ide.createCmdID((String)"warnFilter");
        this.filterEnterKey = IdeAction.get((int)this.ENTER_FILTER_CMD_ID, null, (String)"Enter filter", (String)"Compiler", (Integer)new Integer(10), null, null, (boolean)true);
        this.warnFilter = IdeAction.get((int)this.WARN_FILTER_CMD_ID, null, (String)"Show/Hide warnings", (String)"Compiler", null, (Icon)OracleIcons.getIcon((String)"warning.png"), null, (boolean)true);
        this._searchField = new SearchField();
        this._descCat = new SearchCategory(DESC_COL_NAME);
        this._fileCat = new SearchCategory(FILE_COL_NAME);
        this._dORfCat = new SearchCategory("Description or File");
        this.urlMsgWrapperTable = new HashMap();
        this.urlOffsetMarkTable = new HashMap();
        this.msgMsgWrapperMap = new HashMap();
        this.asyncMessages = new ArrayList(100);
        this.updateThread = null;
    }

    public ProblemsPage() {
        this("CompilerPageId", CompArb.getString(73), null);
    }

    public ProblemsPage(String pageId, String pageName, Icon icon) {
        this(pageId, pageName, icon, HIDE_FIX_SOURCE_MENU);
    }

    public ProblemsPage(String pageId, String pageName, Icon icon, int menuOptions) {
        this(new ViewId(pageId, pageName), icon, false, menuOptions);
    }

    public ProblemsPage(ViewId id, Icon icon, boolean addPage, int menuOptions) {
        super(id, icon, false);
        this.$init$();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setViewportView((Component)this.table);
        ToggleToolButton hideOrShowWarnings = new ToggleToolButton((ToggleAction)this.warnFilter);
        this.table.addKeyListener((KeyListener)this.keyAdapter);
        this.table.addMouseListener((MouseListener)new TableContentAdapter(null));
        this.toolbar.add((Component)hideOrShowWarnings);
        this._searchField.setStyle(SearchField.Style.FILTER);
        this._searchField.addCategory(this._descCat);
        this._searchField.addCategory(this._fileCat);
        this._searchField.addCategory(this._dORfCat);
        Dimension preferredSize = this._searchField.getPreferredSize();
        this._searchField.setMaximumSize(new Dimension(200, preferredSize.height));
        JButton _button = ProblemsPage.getButton((Container)this._searchField);
        _button.setToolTipText("<html>Pattern rules:<br><table><tr><td>*</td><td>matches 0 or more</td></tr><tr><td>x y</td><td>agregates x and y</td></tr><tr><td>exp</td><td>regular expressions</td></tr></table></html>");
        JTextField _textField = ProblemsPage.getTextField((Container)this._searchField);
        _textField.setAction((Action)this.filterEnterKey);
        _textField.setColumns(20);
        this.toolbar.add((Component)this._searchField);
        this.toolbar.setBorder(BorderFactory.createEmptyBorder());
        this.header.add((Component)this.compileInfo, "West");
        this.header.add((Component)this.toolbar, "East");
        this.logPage.add((Component)this.header, "North");
        this.logPage.add((Component)this.scrollPane, "Center");
        this.initPopupMenuItems(menuOptions);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.table);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        if (addPage) {
            LogManager.getLogManager().addPage((LogPage)this);
        }
    }

    public ProblemsPage(ViewId id, Icon icon, boolean addPage) {
        this(id, icon, false, HIDE_FIX_SOURCE_MENU);
    }

    private void initPopupMenuItems(int options) {
        if (!this._popupMenuItemsInitialized) {
            this._popupMenuItemsInitialized = true;
            ContextMenu cm = LogManager.getLogManager().getContextMenu();
            IdeAction action = null;
            if (!BitField.isSet((int)options, (int)HIDE_COPY_MENU)) {
                action = IdeAction.find((int)18);
                this._copyMenu = cm.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_EDIT_COPY);
            }
            if (!BitField.isSet((int)options, (int)HIDE_SAVE_AS_MENU)) {
                action = IdeAction.find((int)12);
                this._saveAsMenu = cm.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
            }
            if (!BitField.isSet((int)options, (int)HIDE_GOTO_SOURCE_MENU)) {
                action = IdeAction.get((int)GOTO_SOURCE_CMD_ID, null, (String)LogArb.getString((int)8), (String)null, (Integer)LogArb.getInteger((int)25), (Icon)LogArb.getIcon((int)30), null, (boolean)true);
                this._gotoSourceMenu = cm.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
                action.addController(this.getController());
            }
            if (!BitField.isSet((int)options, (int)HIDE_FIX_SOURCE_MENU)) {
                action = IdeAction.get((int)FIX_SOURCE_CMD_ID, null, (String)LogArb.getString((int)10), (String)null, (Integer)LogArb.getInteger((int)0), (Icon)LogArb.getIcon((int)29), null, (boolean)true);
                this._fixSourceMenu = cm.createMenuItem((ToggleAction)action);
                action.addController(this.getController());
            }
            if (action != null) {
                cm.addContextMenuListener((ContextMenuListener)new PrivateContextMenuListener(null));
            }
        }
    }

    private void hideOrShowWarnings() {
        if (this.warnFilter.getState()) {
            int i = 0;
            while (i < this.model.getRowCount()) {
                IdeLog.Message msg = (IdeLog.Message)this.model.getValueAt(i, 0);
                if (msg.isWarning()) {
                    this.hiddenRowData.add(((Vector)this.model.getDataVector().get(i)).clone());
                    this.model.removeRow(i);
                    continue;
                }
                ++i;
            }
        } else if (this.currFilterOpt == DORF_FILTER_OPT) {
            this.restoreMessages(new int[]{DESC_COL, FILE_COL});
        } else {
            this.restoreMessages();
        }
        this.table.reSort();
    }

    public void update(Object subject, UpdateMessage change) {
        int msgID = change.getMessageID();
        if (msgID == UpdateMessage.OBJECT_RELOADED) {
            if (subject instanceof TextNode) {
                Vector messages;
                URL url = ((TextNode)subject).getURL();
                OffsetMark[] om = (OffsetMark[])this.urlOffsetMarkTable.get(url);
                if (om != null) {
                    this.clearUrlOffsetMarkNode((Node)subject, om);
                }
                if ((messages = (Vector)this.urlMsgWrapperTable.get(url)) != null) {
                    this.setOffsetMarkTable(url, messages);
                }
            }
            return;
        }
        if (msgID == UpdateMessage.OBJECT_CLOSED) {
            if (subject instanceof Project) {
                ((Project)subject).detach((Observer)this);
                JCompiler.invokeAsap(new 2(this, subject));
                return;
            }
            if (subject instanceof TextNode) {
                Vector messages;
                URL url = ((TextNode)subject).getURL();
                OffsetMark[] om = (OffsetMark[])this.urlOffsetMarkTable.remove(url);
                if (om != null) {
                    this.clearUrlOffsetMarkNode((Node)subject, om);
                }
                if ((messages = (Vector)this.urlMsgWrapperTable.get(url)) != null) {
                    int i = 0;
                    while (i < messages.size()) {
                        MsgWrapper msgWrapper = (MsgWrapper)messages.get(i);
                        msgWrapper.offsetMark = null;
                        ++i;
                    }
                }
                return;
            }
        }
    }

    private static JTextField getTextField(Container parent) {
        if (parent instanceof JTextField) {
            JTextField jTextField = (JTextField)parent;
            return jTextField;
        }
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length) {
            Container container;
            JTextField textField;
            Component child = children[i];
            if (child instanceof Container && (textField = ProblemsPage.getTextField(container = (Container)child)) != null) {
                return textField;
            }
            ++i;
        }
        return null;
    }

    private static JButton getButton(Container parent) {
        if (parent instanceof JButton) {
            JButton jButton = (JButton)parent;
            return jButton;
        }
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length) {
            Component child = children[i];
            if (child instanceof Container) {
                return ProblemsPage.getButton((Container)child);
            }
            ++i;
        }
        return null;
    }

    private boolean localPatternMatcher(String currPattern, String string) {
        StringBuffer sbuffer = new StringBuffer(".*");
        int n = currPattern.length();
        int i = 0;
        while (i < n) {
            if (currPattern.charAt(i) == ' ' || currPattern.charAt(i) == '*') {
                sbuffer.append(".*");
            } else {
                sbuffer.append(currPattern.charAt(i));
            }
            ++i;
        }
        sbuffer.append(".*");
        return Pattern.matches(sbuffer.toString(), string);
    }

    private void filterMessages(int col) {
        this.restoreMessages();
        int row = 0;
        while (row < this.model.getRowCount()) {
            String string = (String)this.model.getValueAt(row, col);
            if (!this.localPatternMatcher(this.currPattern, string) && !Pattern.matches(this.currPattern, string)) {
                this.hiddenRowData.add(((Vector)this.model.getDataVector().get(row)).clone());
                this.model.removeRow(row);
                continue;
            }
            ++row;
        }
        this.table.reSort();
    }

    private void filterMessages(int[] cols) {
        if (cols.length == 0) {
            return;
        }
        this.restoreMessages(cols);
        int row = 0;
        while (row < this.model.getRowCount()) {
            int i = 0;
            while (i < cols.length) {
                String string = (String)this.model.getValueAt(row, cols[i]);
                if (this.localPatternMatcher(this.currPattern, string) || Pattern.matches(this.currPattern, string)) break;
                ++i;
            }
            if (i == cols.length) {
                this.hiddenRowData.add(((Vector)this.model.getDataVector().get(row)).clone());
                this.model.removeRow(row);
                continue;
            }
            ++row;
        }
        this.table.reSort();
    }

    static {
        $assertionsDisabled = ProblemsPage.class.desiredAssertionStatus() ^ true;
        _shift = 0;
        HIDE_NO_MENUS = 0;
        HIDE_COPY_MENU = 1 << _shift++;
        HIDE_SAVE_AS_MENU = 1 << _shift++;
        HIDE_GOTO_SOURCE_MENU = 1 << _shift++;
        HIDE_FIX_SOURCE_MENU = 1 << _shift++;
        HIDE_ALL_MENUS = HIDE_COPY_MENU | HIDE_SAVE_AS_MENU | HIDE_GOTO_SOURCE_MENU | HIDE_FIX_SOURCE_MENU;
        GOTO_SOURCE_CMD_ID = Ide.findOrCreateCmdID((String)"GOTO_SOURCE_CMD_ID");
        FIX_SOURCE_CMD_ID = Ide.findOrCreateCmdID((String)"FIX_SOURCE_CMD_ID");
        _lastSaveToFileURL = null;
        TYPE_COL = 0;
        DESC_COL = 1;
        FILE_COL = 2;
        LINE_COL = 3;
        PROJ_COL = 4;
        DESC_FILTER_OPT = 0;
        FILE_FILTER_OPT = 1;
        DORF_FILTER_OPT = 2;
    }

    private void restoreMessages() {
        if (this.currPattern.equals("")) {
            if (!this.warnFilter.getState()) {
                int i = 0;
                while (i < this.hiddenRowData.size()) {
                    this.model.addRow((Vector)((Vector)this.hiddenRowData.get(i)).clone());
                    ++i;
                }
                this.hiddenRowData.clear();
            } else {
                int i = 0;
                while (i < this.hiddenRowData.size()) {
                    Vector rowData = (Vector)this.hiddenRowData.get(i);
                    if (((IdeLog.Message)rowData.get(0)).isError()) {
                        this.model.addRow((Vector)rowData.clone());
                        this.hiddenRowData.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < this.hiddenRowData.size()) {
                Vector rowData = (Vector)this.hiddenRowData.get(i);
                String string = null;
                if (this.currFilterOpt == DESC_FILTER_OPT) {
                    string = (String)rowData.get(DESC_COL);
                } else if (this.currFilterOpt == FILE_FILTER_OPT) {
                    string = (String)rowData.get(FILE_COL);
                }
                if (!$assertionsDisabled && string == null) {
                    throw new AssertionError();
                }
                if (this.localPatternMatcher(this.currPattern, string) || Pattern.matches(this.currPattern, string)) {
                    if (this.warnFilter.getState() && !((IdeLog.Message)rowData.get(0)).isError()) continue;
                    this.model.addRow((Vector)rowData.clone());
                    this.hiddenRowData.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    private void restoreMessages(int[] cols) {
        if (this.currPattern.equals("")) {
            if (!this.warnFilter.getState()) {
                int i = 0;
                while (i < this.hiddenRowData.size()) {
                    this.model.addRow((Vector)((Vector)this.hiddenRowData.get(i)).clone());
                    ++i;
                }
                this.hiddenRowData.clear();
            } else {
                int i = 0;
                while (i < this.hiddenRowData.size()) {
                    Vector rowData = (Vector)this.hiddenRowData.get(i);
                    if (((IdeLog.Message)rowData.get(0)).isError()) {
                        this.model.addRow((Vector)rowData.clone());
                        this.hiddenRowData.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < this.hiddenRowData.size()) {
                Vector rowData = (Vector)this.hiddenRowData.get(i);
                int j = 0;
                while (j < cols.length) {
                    if (this.localPatternMatcher(this.currPattern, (String)rowData.get(cols[j])) || Pattern.matches(this.currPattern, (String)rowData.get(cols[j]))) break;
                    ++j;
                }
                if (j < cols.length) {
                    if (this.warnFilter.getState() && !((IdeLog.Message)rowData.get(0)).isError()) continue;
                    this.model.addRow((Vector)rowData.clone());
                    this.hiddenRowData.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    public String getTitleName() {
        String s = super.getTitleName();
        AccessibleUtils.updateAccessibleName((Accessible)this.table, (String)s, (boolean)true);
        return s;
    }

    public Component getGUI() {
        return this.logPage;
    }

    private final void copy(Object msg) {
        StringSelection text = new StringSelection(((IdeLog.Message)msg).getMessage());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(text, null);
    }

    protected void saveToFile(Context context) {
        URL url;
        if (this.model == null || this.table.getRowCount() <= 0) {
            return;
        }
        String title = LogArb.getString((int)34);
        URLChooser chooser = DialogUtil.newURLChooser((Context)context);
        chooser.setHelpID("f1_idedsaveasrename_html");
        if (_lastSaveToFileURL != null) {
            chooser.setSelectedURL(_lastSaveToFileURL);
        }
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), title) == 0 && (url = chooser.getSelectedURL()) != null) {
            _lastSaveToFileURL = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                String encoding = Ide.getEnvironOptions().getEncoding();
                OutputStream os = URLFileSystem.openOutputStream((URL)url);
                PrintStream ps = encoding == null ? new PrintStream(os) : new PrintStream(os, false, encoding);
                int row = 0;
                while (row < this.model.getRowCount()) {
                    IdeLog.Message msg = (IdeLog.Message)this.model.getValueAt(row, TYPE_COL);
                    ps.println(msg.toString());
                    ++row;
                }
                ps.flush();
                ps.close();
            }
            catch (Exception e) {
                String fileName = URLFileSystem.getPlatformPathName((URL)url);
                String msg = LogArb.format((int)2, (Object)fileName);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), msg, IdeArb.getString((int)170), 0);
            }
            wc.hide();
        }
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new DefaultLogPageController(null);
        }
        return this._controller;
    }

    public ContextMenu getContextMenu() {
        ContextMenu cm = LogManager.getLogManager().getContextMenu();
        return cm;
    }

    public void clearAll() {
        if (this.model == null) {
            return;
        }
        this.nWarnings = 0;
        this.nErrors = 0;
        this.compileInfo.setText("");
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        this.hiddenRowData.clear();
        this.table.repaint();
    }

    public void addMouseListener(MouseListener listener) {
        if (listener != null) {
            this.table.addMouseListener(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        if (listener != null) {
            this.table.removeMouseListener(listener);
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (listener != null) {
            this.table.addKeyListener(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        if (listener != null) {
            this.table.removeKeyListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logMsg(Object msg) {
        if (msg instanceof IdeLog.Message) {
            ArrayList arrayList = this.asyncMessages;
            synchronized (arrayList) {
                this.asyncMessages.add(msg);
                if (this.asyncMessages.size() == 100) {
                    this.processAsyncMsgQueue(100);
                }
            }
        }
    }

    public void startAsynchronousLogging() {
        this.updateThread = new 3("Log Page Updater");
        this.updateThread.setPriority(this.updateThread.getPriority() - 1);
        this.updateThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAsynchronousLogging() {
        this.updateThread = null;
        ArrayList arrayList = this.asyncMessages;
        synchronized (arrayList) {
            this.asyncMessages.clear();
        }
    }

    public void finishAsynchronousLogging() {
        this.updateThread = null;
        this.processAsyncMsgQueue(-1);
        this.requestShow();
    }

    private void processAsyncMsgQueue(int max) {
        4 runner = new 4(this, max);
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    private void addMsg(IdeLog.Message msg) {
        if (this.getCurrentView() != this.table) {
            this.setCurrentView((Component)this.table);
        }
        if (msg.isStarting()) {
            this.colNames = new Vector();
            this.colNames.add(TYPE_COL_NAME);
            this.colNames.add(DESC_COL_NAME);
            this.colNames.add(FILE_COL_NAME);
            this.colNames.add(LINE_COL_NAME);
            this.colNames.add(PROJ_COL_NAME);
            this.tableContent = new Vector();
            return;
        }
        if (msg.isCompleted()) {
            String errString = this.nErrors + (this.nErrors == 1 ? " error" : " errors");
            String warnString = this.nWarnings + (this.nWarnings == 1 ? " warning" : " warnings");
            this.compileInfo.setText(TYPE_COL_NAME + errString + ", " + warnString);
            this.table.repaint();
            return;
        }
        if (msg.isRemove()) {
            this.removeMessages(msg);
            return;
        }
        if (!LogManager.getLogManager().isLogVisible()) {
            LogManager.getLogManager().showLog();
        }
        if (!this.isVisible()) {
            this.requestShow();
        }
        if (Ide.getMainWindow().getLastActiveView() == LogManager.getLogManager().getLogWindow()) {
            IdeUtil.tryToRestoreFocus((Component)this.table);
        } else {
            this.requestShow();
        }
        if (msg.isNoDetails()) {
            return;
        }
        Vector<Object> rowData = new Vector<Object>(5);
        rowData.add(msg);
        rowData.add(this.justContent(msg));
        if (msg.fname == null) {
            rowData.add("");
            rowData.add(new Integer(Integer.MAX_VALUE));
            rowData.add("");
        } else {
            rowData.add(msg.fname.getName());
            rowData.add(new Integer(msg.line));
            rowData.add(msg.getProject().toString());
        }
        if (msg.isError()) {
            ++this.nErrors;
        } else {
            ++this.nWarnings;
        }
        if (this.canAddToModel(msg)) {
            if (!this._isTableVisible) {
                this.tableContent.add(rowData);
                this.model = new 5(this.tableContent, this.colNames);
                this.table.setModel((TableModel)this.model);
                this.table.setSortColumn(FILE_COL, true);
                this.setCurrentView((Component)this.table);
                this.table.getColumnModel().getColumn(TYPE_COL).setMaxWidth(20);
                this.table.getColumnModel().getColumn(DESC_COL).setPreferredWidth(525);
                this.table.getColumnModel().getColumn(FILE_COL).setPreferredWidth(100);
                this.table.getColumnModel().getColumn(LINE_COL).setPreferredWidth(50);
                this.table.getColumnModel().getColumn(PROJ_COL).setPreferredWidth(75);
                this.table.setShowGrid(true);
                this.table.repaint();
                this._isTableVisible = true;
            } else {
                this.model.addRow(rowData);
                this.table.reSort();
                this.model.fireTableDataChanged();
                this.table.repaint();
                String errString = this.nErrors + (this.nErrors == 1 ? " error" : " errors");
                String warnString = this.nWarnings + (this.nWarnings == 1 ? " warning" : " warnings");
                this.compileInfo.setText(TYPE_COL_NAME + errString + ", " + warnString);
            }
        } else {
            this.hiddenRowData.add(rowData);
        }
        if (msg.fname != null) {
            URL url = URLFactory.newURL((String)msg.fname.getPath());
            MsgWrapper msgWrapper = new MsgWrapper(this.fixMessages(msg), msg);
            this.msgMsgWrapperMap.put(msg, msgWrapper);
            Vector messages = (Vector)this.urlMsgWrapperTable.get(url);
            if (messages == null) {
                Vector<MsgWrapper> value = new Vector<MsgWrapper>();
                value.add(msgWrapper);
                this.urlMsgWrapperTable.put(url, value);
            } else {
                messages.add(msgWrapper);
            }
        }
    }

    private boolean canAddToModel(IdeLog.Message msg) {
        if (this.warnFilter.getState() && msg.isWarning()) {
            return false;
        }
        if (this.currFilterOpt == -1 || this.currPattern.equals("")) {
            return true;
        }
        if (this.currFilterOpt == DESC_FILTER_OPT) {
            return this.localPatternMatcher(this.currPattern, msg.getMessage()) || Pattern.matches(this.currPattern, msg.getMessage());
        }
        if (this.currFilterOpt == FILE_FILTER_OPT) {
            return this.localPatternMatcher(this.currPattern, msg.fname.getName()) || Pattern.matches(this.currPattern, msg.fname.getName());
        }
        if (this.currFilterOpt == DORF_FILTER_OPT) {
            return this.localPatternMatcher(this.currPattern, msg.getMessage()) || Pattern.matches(this.currPattern, msg.getMessage()) || this.localPatternMatcher(this.currPattern, msg.fname.getName()) || Pattern.matches(this.currPattern, msg.fname.getName());
        }
        return true;
    }

    private void removeMessages(IdeLog.Message msg) {
        if (msg.project == null) {
            return;
        }
        if (msg.fname == null) {
            String projPath = msg.project.toString();
            int i = 0;
            while (this.model != null && i < this.model.getRowCount()) {
                IdeLog.Message i_msg = (IdeLog.Message)this.model.getValueAt(i, TYPE_COL);
                if (i_msg.fname == null || i_msg.project == null || projPath.equals(i_msg.project.toString())) {
                    this.model.removeRow(i);
                    if (i_msg.isError()) {
                        --this.nErrors;
                    } else if (i_msg.isWarning()) {
                        --this.nWarnings;
                    }
                    this.table.repaint();
                    String errString = this.nErrors + (this.nErrors == 1 ? " error" : " errors");
                    String warnString = this.nWarnings + (this.nWarnings == 1 ? " warning" : " warnings");
                    this.compileInfo.setText(TYPE_COL_NAME + errString + ", " + warnString);
                    continue;
                }
                ++i;
            }
        } else {
            String filePath = msg.fname.toString();
            int i = 0;
            while (this.model != null && i < this.model.getRowCount()) {
                IdeLog.Message i_msg = (IdeLog.Message)this.model.getValueAt(i, TYPE_COL);
                if (i_msg.fname == null || i_msg.project == null || filePath.equals(i_msg.fname.toString())) {
                    this.model.removeRow(i);
                    if (i_msg.isError()) {
                        --this.nErrors;
                    } else if (i_msg.isWarning()) {
                        --this.nWarnings;
                    }
                    this.table.repaint();
                    String errString = this.nErrors + (this.nErrors == 1 ? " error" : " errors");
                    String warnString = this.nWarnings + (this.nWarnings == 1 ? " warning" : " warnings");
                    this.compileInfo.setText(TYPE_COL_NAME + errString + ", " + warnString);
                    continue;
                }
                ++i;
            }
        }
    }

    private Editor getEditorFromMessageNode(IdeLog.Message msg) {
        File file;
        Editor result = null;
        Project lastActiveProject = Ide.getActiveProject();
        Project nodeProject = msg.getProject();
        if (nodeProject != null) {
            Ide.setActiveProject((Project)nodeProject);
        }
        Workspace lastActiveWsp = Ide.getActiveWorkspace();
        Workspace nodeWsp = msg.getWorkspace();
        if (nodeWsp != null) {
            Ide.setActiveWorkspace((Workspace)nodeWsp);
        }
        if ((file = new File(msg.fname.getPath())).exists()) {
            result = this.openPreferredEditor(URLFactory.newFileURL((File)file), msg.workspace, msg.project);
        }
        Ide.setActiveProject((Project)lastActiveProject);
        Ide.setActiveWorkspace((Workspace)lastActiveWsp);
        return result;
    }

    private Editor openPreferredEditor(Context context) {
        EditorManager editorManager = EditorManager.getEditorManager();
        try {
            Editor editor = editorManager.openEditorInFrame(CodeEditor.class, context);
            if (editor != null) {
                Editor editor2 = editor;
                return editor2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return editorManager.openDefaultEditorInFrame(context);
    }

    private Editor openPreferredEditor(URL url, Workspace wsp, Project prj) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            Context context = Context.newIdeContext((Node)node);
            context.setWorkspace(wsp);
            context.setProject(prj);
            Editor editor = this.openPreferredEditor(context);
            return editor;
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
            Assert.println((String)("oracle.jdeveloper.compiler.CompilePage.openURLInCodeEditor() - " + e.toString()));
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void activateObject(Object obj, int modelRowIndex) {
        msg = (IdeLog.Message)obj;
        if (msg.fname == null) {
            return;
        }
        this.copyPartialImportWarningToClipboard(msg);
        point = null;
        editor = this.getEditorFromMessageNode(msg);
        if (editor instanceof CodeEditor) {
            ceditor = (CodeEditor)editor;
            line = msg.line;
            col = msg.col;
            msgWrapper = (MsgWrapper)this.msgMsgWrapperMap.get(msg);
            if (msgWrapper.offsetMark == null) {
                this.activeViewChanged(null);
            }
            if (msgWrapper.offsetMark != null && msgWrapper.getURL() != null) {
                tnode = (TextNode)NodeFactory.find((URL)msgWrapper.getURL());
                try {
                    try {
                        tbuf = tnode.acquireTextBuffer();
                        lmap = tbuf.getLineMap();
                        line = lmap.getLineFromOffset(msgWrapper.offsetMark.getOffset()) + 1;
                        if (col <= 0) ** GOTO lbl36
                        --col;
                    }
                    catch (Throwable t) {}
                }
                finally {
                    tnode.releaseTextBuffer();
                }
            } else if (line == 0 && col > 0) {
                line = ceditor.getLineFromOffset(col) + 1;
                lineStartOffset = ceditor.getLineStartOffset(line - 1);
                col = lineStartOffset < col ? col - lineStartOffset : 1;
            } else if (col > 0) {
                --col;
            }
lbl36:
            // 7 sources

            ceditor.gotoLine(line, col, IdeLog.isPartiallyUsedImportWarning(msg) != false || IdeLog.isUnusedImportWarning(msg) != false);
            this.model.setValueAt((Object)new Integer(line), modelRowIndex, ProblemsPage.LINE_COL);
            Ide.getStatusBar().setText(msg.msg);
            point = new CodeNavigationPoint();
        } else if (editor != null) {
            point = new DefaultNavigationPoint();
        }
        if (point != null && (mgr = NavigationManager.getNavigationManager()) != null) {
            point.setContext(editor.getContext());
            try {
                mgr.navigateTo((NavigationPoint)point);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void copyPartialImportWarningToClipboard(IdeLog.Message m) {
        if (m != null && IdeLog.isPartiallyUsedImportWarning(m)) {
            String msg = m.msg;
            StringBuffer sb = new StringBuffer(256);
            int i = msg.indexOf("\n");
            if (i == -1) {
                return;
            }
            i = msg.indexOf("import ", i);
            while (i > -1) {
                int j = msg.indexOf("\n", i);
                if (j == -1) {
                    sb.append(msg.substring(i));
                    sb.append("\n");
                    j = msg.length() - 1;
                } else {
                    sb.append(msg.substring(i, j + 1));
                }
                i = msg.indexOf("import ", j);
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(sb.toString()), null);
        }
    }

    protected String fixMessages(IdeLog.Message m) {
        int i;
        String msg = m.msg;
        if (IdeLog.isPartiallyUsedImportWarning(m) && (i = msg.indexOf("\n")) > -1) {
            msg = msg.substring(0, i) + " (dbl-click will copy replacement to clipboard)" + msg.substring(i);
        }
        msg = msg.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        return msg;
    }

    private String justContent(IdeLog.Message msg) {
        int start = msg.getMessage().indexOf(58) + 2;
        return msg.getMessage().substring(start);
    }

    protected final Component getCurrentView() {
        JViewport viewport = this.scrollPane.getViewport();
        return viewport != null ? viewport.getView() : null;
    }

    protected final void setCurrentView(Component view) {
        this.scrollPane.setViewportView(view);
    }

    protected void fixObject(Object obj) {
    }

    public void activeViewChanged(ActiveViewEvent e) {
        View editor;
        View view = editor = e != null ? e.getNewView() : Ide.getMainWindow().getLastActiveView();
        if (editor == null || !(editor instanceof CodeEditor)) {
            return;
        }
        Context ctxt = ((CodeEditor)editor).getContext();
        if (ctxt == null || ctxt.getNode() == null || ctxt.getNode().getURL() == null) {
            return;
        }
        URL url = ctxt.getNode().getURL();
        Vector messages = (Vector)this.urlMsgWrapperTable.get(url);
        if (messages != null && this.urlOffsetMarkTable.get(url) == null) {
            this.setOffsetMarkTable(url, messages);
        }
    }

    protected void setOffsetMarkTable(URL url, Vector messages) {
        Node node = NodeFactory.find((URL)url);
        if (node instanceof TextNode) {
            TextNode tnode = (TextNode)node;
            try {
                try {
                    TextBuffer tbuf = tnode.acquireTextBuffer();
                    LineMap lmap = tbuf.getLineMap();
                    OffsetMark[] offsetMarks = new OffsetMark[messages.size()];
                    int i = 0;
                    while (i < messages.size()) {
                        MsgWrapper msgWrapper = (MsgWrapper)messages.get(i);
                        IdeLog.Message msg = msgWrapper.getMessage();
                        int offset = msg.line == 0 && msg.col > 0 ? msg.col : lmap.getLineStartOffset(msg.line - 1);
                        msgWrapper.setURL(url);
                        offsetMarks[i] = msgWrapper.offsetMark = tbuf.addOffsetMark(offset);
                        ++i;
                    }
                    tnode.attach((Observer)this);
                    this.urlOffsetMarkTable.put(url, offsetMarks);
                }
                catch (Throwable t) {}
            }
            finally {
                tnode.releaseTextBuffer();
            }
        }
    }

    protected void clearUrlOffsetMarkNode(Node node, OffsetMark[] offsetMarks) {
        if (node instanceof TextNode) {
            TextBuffer tbuf;
            TextNode tnode = (TextNode)node;
            if (tnode != null && tnode.isOpen() && (tbuf = tnode.acquireTextBuffer()) != null) {
                int j = 0;
                while (j < offsetMarks.length) {
                    tbuf.removeOffsetMark(offsetMarks[j]);
                    ++j;
                }
            }
            tnode.detach((Observer)this);
        }
    }

    static NiceTable ra$table(ProblemsPage problemsPage) {
        return problemsPage.table;
    }

    static DefaultNiceTableModel ra$model(ProblemsPage problemsPage) {
        return problemsPage.model;
    }

    static int ra$TYPE_COL() {
        return TYPE_COL;
    }

    static void mav$activateObject(ProblemsPage problemsPage, Object object, int n) {
        problemsPage.activateObject(object, n);
    }

    static void mav$copy(ProblemsPage problemsPage, Object object) {
        problemsPage.copy(object);
    }

    static void mav$hideOrShowWarnings(ProblemsPage problemsPage) {
        problemsPage.hideOrShowWarnings();
    }

    static SearchField ra$_searchField(ProblemsPage problemsPage) {
        return problemsPage._searchField;
    }

    static void wa$currPattern(ProblemsPage problemsPage, String string) {
        problemsPage.currPattern = string;
    }

    static String ra$currPattern(ProblemsPage problemsPage) {
        return problemsPage.currPattern;
    }

    static SearchCategory ra$_dORfCat(ProblemsPage problemsPage) {
        return problemsPage._dORfCat;
    }

    static int ra$DESC_COL() {
        return DESC_COL;
    }

    static int ra$FILE_COL() {
        return FILE_COL;
    }

    static void mav$restoreMessages(ProblemsPage problemsPage, int[] nArray) {
        problemsPage.restoreMessages(nArray);
    }

    static void mav$restoreMessages(ProblemsPage problemsPage) {
        problemsPage.restoreMessages();
    }

    static SearchCategory ra$_descCat(ProblemsPage problemsPage) {
        return problemsPage._descCat;
    }

    static int ra$DESC_FILTER_OPT() {
        return DESC_FILTER_OPT;
    }

    static void wa$currFilterOpt(ProblemsPage problemsPage, int n) {
        problemsPage.currFilterOpt = n;
    }

    static void mav$filterMessages(ProblemsPage problemsPage, int n) {
        problemsPage.filterMessages(n);
    }

    static SearchCategory ra$_fileCat(ProblemsPage problemsPage) {
        return problemsPage._fileCat;
    }

    static int ra$FILE_FILTER_OPT() {
        return FILE_FILTER_OPT;
    }

    static int ra$DORF_FILTER_OPT() {
        return DORF_FILTER_OPT;
    }

    static void mav$filterMessages(ProblemsPage problemsPage, int[] nArray) {
        problemsPage.filterMessages(nArray);
    }

    static JMenuItem ra$_gotoSourceMenu(ProblemsPage problemsPage) {
        return problemsPage._gotoSourceMenu;
    }

    static JMenuItem ra$_fixSourceMenu(ProblemsPage problemsPage) {
        return problemsPage._fixSourceMenu;
    }

    static JMenuItem ra$_copyMenu(ProblemsPage problemsPage) {
        return problemsPage._copyMenu;
    }

    static JMenuItem ra$_saveAsMenu(ProblemsPage problemsPage) {
        return problemsPage._saveAsMenu;
    }

    static int ra$PROJ_COL() {
        return PROJ_COL;
    }

    static int ra$LINE_COL() {
        return LINE_COL;
    }

    static ArrayList ra$asyncMessages(ProblemsPage problemsPage) {
        return problemsPage.asyncMessages;
    }

    static void mav$addMsg(ProblemsPage problemsPage, IdeLog.Message message) {
        problemsPage.addMsg(message);
    }

    static void mav$processAsyncMsgQueue(ProblemsPage problemsPage, int n) {
        problemsPage.processAsyncMsgQueue(n);
    }

    static Thread ra$updateThread(ProblemsPage problemsPage) {
        return problemsPage.updateThread;
    }

    final class 1
    extends NiceTable {
        private int ROW_HEIGHT;

        private void $init$() {
            this.ROW_HEIGHT = this.getRowHeight();
        }

        public Class getColumnClass(int c) {
            if (c == ProblemsPage.ra$TYPE_COL()) {
                return Icon.class;
            }
            return Object.class;
        }

        public Object getValueAt(int r, int c) {
            int modelRowIndex = this.convertRowToModelIndex(r);
            int modelColIndex = this.convertColumnIndexToModel(c);
            if (modelRowIndex < ProblemsPage.ra$model(ProblemsPage.this).getRowCount()) {
                Integer i;
                if (modelColIndex == ProblemsPage.ra$TYPE_COL()) {
                    IdeLog.Message msg = (IdeLog.Message)ProblemsPage.ra$model(ProblemsPage.this).getValueAt(modelRowIndex, modelColIndex);
                    if (msg.isError()) {
                        return OracleIcons.getIcon((String)"error.png");
                    }
                    if (msg.isWarning()) {
                        return OracleIcons.getIcon((String)"warning.png");
                    }
                } else if (modelColIndex == ProblemsPage.ra$LINE_COL() && (i = (Integer)ProblemsPage.ra$model(ProblemsPage.this).getValueAt(modelRowIndex, modelColIndex)) == Integer.MAX_VALUE) {
                    return "";
                }
            }
            return ProblemsPage.ra$model(ProblemsPage.this).getValueAt(modelRowIndex, modelColIndex);
        }

        public void paint(Graphics g) {
            super.paint(g);
            this.paintEmptyRows(g);
        }

        private void paintEmptyRows(Graphics g) {
            if (ProblemsPage.ra$model(ProblemsPage.this) == null || ProblemsPage.ra$model(ProblemsPage.this).getRowCount() == 0) {
                return;
            }
            int nRows = this.getRowCount();
            Rectangle clip = g.getClipBounds();
            if (ProblemsPage.ra$model(ProblemsPage.this) != null && nRows * this.ROW_HEIGHT < clip.height) {
                g.setColor(ProblemsPage.ra$table(ProblemsPage.this).getGridColor());
                int nExtraRows = clip.height / this.ROW_HEIGHT;
                int i = nRows + 1;
                while (i <= nExtraRows) {
                    int y = i * this.ROW_HEIGHT;
                    g.drawLine(clip.x, y, clip.width, y);
                    ++i;
                }
                int v0 = clip.x;
                int v1 = v0 + this.getColumnModel().getColumn(ProblemsPage.ra$TYPE_COL()).getWidth() - 1;
                int startY = nRows * this.ROW_HEIGHT;
                g.drawLine(v1, startY, v1, clip.height);
                int v2 = v1 + this.getColumnModel().getColumn(ProblemsPage.ra$DESC_COL()).getWidth();
                g.drawLine(v2, startY, v2, clip.height);
                int v3 = v2 + this.getColumnModel().getColumn(ProblemsPage.ra$FILE_COL()).getWidth();
                g.drawLine(v3, startY, v3, clip.height);
                int v4 = v3 + this.getColumnModel().getColumn(ProblemsPage.ra$LINE_COL()).getWidth();
                g.drawLine(v4, startY, v4, clip.height);
                int v5 = v4 + this.getColumnModel().getColumn(ProblemsPage.ra$PROJ_COL()).getWidth();
                g.drawLine(v5, startY, v5, clip.height);
                int viewSortColumn = this.convertColumnIndexToView(this.getSortColumn());
                g.setColor(ProblemsPage.ra$table(ProblemsPage.this).getSortColumnBackgroundColor());
                if (viewSortColumn == 0) {
                    g.fillRect(v0, startY, v1 - v0, clip.height);
                } else if (viewSortColumn == 1) {
                    g.fillRect(v1 + 1, startY, v2 - v1, clip.height);
                } else if (viewSortColumn == 2) {
                    g.fillRect(v2 + 1, startY, v3 - v2, clip.height);
                } else if (viewSortColumn == 3) {
                    g.fillRect(v3 + 1, startY, v4 - v3, clip.height);
                } else if (viewSortColumn == 4) {
                    g.fillRect(v4 + 1, startY, clip.y - v4, clip.height);
                }
            }
        }

        public boolean getScrollableTracksViewportHeight() {
            if (this.getParent() instanceof JViewport) {
                return (double)((JViewport)this.getParent()).getHeight() > this.getPreferredSize().getHeight();
            }
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            if (this.getParent() instanceof JViewport) {
                return (double)((JViewport)this.getParent()).getWidth() > this.getPreferredSize().getWidth();
            }
            return false;
        }

        public String getToolTipText(MouseEvent e) {
            Point p = new Point(e.getX(), e.getY());
            int row = this.rowAtPoint(p);
            int col = this.columnAtPoint(p);
            if (row >= 0 && row < ProblemsPage.ra$model(ProblemsPage.this).getRowCount() && col >= 0 && col < 5) {
                int modelRowIndex = ProblemsPage.ra$table(ProblemsPage.this).convertRowToModelIndex(row);
                int modelColIndex = ProblemsPage.ra$table(ProblemsPage.this).convertColumnIndexToModel(col);
                if (modelRowIndex >= 0 && modelRowIndex < this.getRowCount()) {
                    IdeLog.Message msg = (IdeLog.Message)ProblemsPage.ra$model(ProblemsPage.this).getValueAt(modelRowIndex, ProblemsPage.ra$TYPE_COL());
                    if (modelColIndex == ProblemsPage.ra$DESC_COL()) {
                        return msg.getMessage();
                    }
                    if (modelColIndex == ProblemsPage.ra$FILE_COL() && msg.fname != null) {
                        return msg.fname.getPath();
                    }
                    if (modelColIndex == ProblemsPage.ra$PROJ_COL() && msg.project != null) {
                        return msg.project.getLongLabel();
                    }
                }
            }
            return null;
        }

        public 1() {
            this.$init$();
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ Object v$subject;
        final /* synthetic */ ProblemsPage this$0;

        public void run() {
            IdeLog.Message msg = new IdeLog.Message(null, (Project)this.v$subject, null, null, 0, 0, 0, 3);
            ProblemsPage.mav$addMsg(this.this$0, msg);
            msg = new IdeLog.Message(null, null, null, null, 0, 0, 0, 4);
            ProblemsPage.mav$addMsg(this.this$0, msg);
        }

        public 2(ProblemsPage problemsPage, Object object) {
            this.v$subject = object;
            this.this$0 = problemsPage;
        }
    }

    private class DefaultLogPageController
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            if (action != null) {
                int cmdId = action.getCommandId();
                if (cmdId == 30 || cmdId == 31) {
                    int row = ProblemsPage.ra$table(ProblemsPage.this).getSelectedRow();
                    if (row >= 0) {
                        int modelRowIndex = ProblemsPage.ra$table(ProblemsPage.this).convertRowToModelIndex(row);
                        Object obj = ProblemsPage.ra$model(ProblemsPage.this).getValueAt(modelRowIndex, ProblemsPage.ra$TYPE_COL());
                        ProblemsPage.mav$activateObject(ProblemsPage.this, obj, modelRowIndex);
                    }
                    return true;
                }
                if (cmdId == 18 || cmdId == GOTO_SOURCE_CMD_ID || cmdId == FIX_SOURCE_CMD_ID) {
                    int row = ProblemsPage.ra$table(ProblemsPage.this).getSelectedRow();
                    if (row >= 0) {
                        int modelRowIndex = ProblemsPage.ra$table(ProblemsPage.this).convertRowToModelIndex(row);
                        Object p = ProblemsPage.ra$model(ProblemsPage.this).getValueAt(modelRowIndex, ProblemsPage.ra$TYPE_COL());
                        if (p != null) {
                            if (cmdId == GOTO_SOURCE_CMD_ID) {
                                ProblemsPage.mav$activateObject(ProblemsPage.this, p, modelRowIndex);
                            } else if (cmdId == FIX_SOURCE_CMD_ID) {
                                ProblemsPage.this.fixObject(p);
                            } else {
                                ProblemsPage.mav$copy(ProblemsPage.this, p);
                            }
                        }
                    }
                    return true;
                }
                if (cmdId == 12) {
                    ProblemsPage.this.saveToFile(context);
                    return true;
                }
                if (cmdId == ProblemsPage.this.WARN_FILTER_CMD_ID) {
                    ProblemsPage.mav$hideOrShowWarnings(ProblemsPage.this);
                    return true;
                }
                if (cmdId == ProblemsPage.this.ENTER_FILTER_CMD_ID) {
                    SearchCategory selectedCat = ProblemsPage.ra$_searchField(ProblemsPage.this).getSelectedCategory();
                    ProblemsPage.wa$currPattern(ProblemsPage.this, ProblemsPage.ra$_searchField(ProblemsPage.this).getText().trim());
                    if (ProblemsPage.ra$currPattern(ProblemsPage.this).equals("")) {
                        if (selectedCat.equals((Object)ProblemsPage.ra$_dORfCat(ProblemsPage.this))) {
                            ProblemsPage.mav$restoreMessages(ProblemsPage.this, new int[]{ProblemsPage.ra$DESC_COL(), ProblemsPage.ra$FILE_COL()});
                        } else {
                            ProblemsPage.mav$restoreMessages(ProblemsPage.this);
                        }
                        ProblemsPage.ra$table(ProblemsPage.this).reSort();
                    } else if (selectedCat.equals((Object)ProblemsPage.ra$_descCat(ProblemsPage.this))) {
                        ProblemsPage.wa$currFilterOpt(ProblemsPage.this, ProblemsPage.ra$DESC_FILTER_OPT());
                        ProblemsPage.mav$filterMessages(ProblemsPage.this, ProblemsPage.ra$DESC_COL());
                    } else if (selectedCat.equals((Object)ProblemsPage.ra$_fileCat(ProblemsPage.this))) {
                        ProblemsPage.wa$currFilterOpt(ProblemsPage.this, ProblemsPage.ra$FILE_FILTER_OPT());
                        ProblemsPage.mav$filterMessages(ProblemsPage.this, ProblemsPage.ra$FILE_COL());
                    } else if (selectedCat.equals((Object)ProblemsPage.ra$_dORfCat(ProblemsPage.this))) {
                        ProblemsPage.wa$currFilterOpt(ProblemsPage.this, ProblemsPage.ra$DORF_FILTER_OPT());
                        ProblemsPage.mav$filterMessages(ProblemsPage.this, new int[]{ProblemsPage.ra$DESC_COL(), ProblemsPage.ra$FILE_COL()});
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            if (action == null) {
                return true;
            }
            int cmdId = action.getCommandId();
            if (cmdId == 30 || cmdId == 31 || cmdId == 12) {
                action.setEnabled(ProblemsPage.ra$table(ProblemsPage.this) != null && ProblemsPage.ra$table(ProblemsPage.this).getRowCount() > 0);
                return true;
            }
            if (cmdId == 18) {
                action.setEnabled(ProblemsPage.ra$table(ProblemsPage.this).getSelectedRow() >= 0);
                return true;
            }
            if (cmdId == FIX_SOURCE_CMD_ID) {
                boolean enabled = false;
                action.setEnabled(enabled);
                return true;
            }
            if (cmdId == GOTO_SOURCE_CMD_ID) {
                action.setEnabled(ProblemsPage.ra$table(ProblemsPage.this).getSelectedRow() >= 0);
                return true;
            }
            return false;
        }

        private DefaultLogPageController() {
        }

        DefaultLogPageController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 3
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (ProblemsPage.ra$updateThread(ProblemsPage.this) == this) {
                try {
                    Thread.sleep(1000L);
                    ArrayList arrayList = ProblemsPage.ra$asyncMessages(ProblemsPage.this);
                    synchronized (arrayList) {
                        if (ProblemsPage.ra$asyncMessages(ProblemsPage.this).size() > 0) {
                            ProblemsPage.mav$processAsyncMsgQueue(ProblemsPage.this, 100);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public 3(String string) {
            super(string);
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ int v$max;
        final /* synthetic */ ProblemsPage this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList arrayList = ProblemsPage.ra$asyncMessages(this.this$0);
            synchronized (arrayList) {
                int size = ProblemsPage.ra$asyncMessages(this.this$0).size();
                int num = this.v$max > 0 && size > this.v$max ? this.v$max : size;
                int i = 0;
                while (i < num) {
                    ProblemsPage.mav$addMsg(this.this$0, (IdeLog.Message)ProblemsPage.ra$asyncMessages(this.this$0).remove(0));
                    ++i;
                }
            }
        }

        public 4(ProblemsPage problemsPage, int n) {
            this.v$max = n;
            this.this$0 = problemsPage;
        }
    }

    final class 5
    extends DefaultNiceTableModel {
        Comparator<IdeLog.Message> msgComparator;
        Comparator<Integer> intComparator;

        private void $init$() {
            this.msgComparator = new 1();
            this.intComparator = new 2();
        }

        public Comparator getColumnSortComparator(int col) {
            if (col == ProblemsPage.ra$TYPE_COL()) {
                return this.msgComparator;
            }
            if (col == ProblemsPage.ra$LINE_COL()) {
                return this.intComparator;
            }
            return String.CASE_INSENSITIVE_ORDER;
        }

        public 5(Vector vector, Vector vector2) {
            super(vector, vector2);
            this.$init$();
        }

        final class 1
        implements Comparator {
            public int compare(IdeLog.Message m1, IdeLog.Message m2) {
                if (m1.isError() && m2.isWarning()) {
                    return -1;
                }
                if (m1.isWarning() && m2.isError()) {
                    return 1;
                }
                return 0;
            }
        }

        final class 2
        implements Comparator {
            public int compare(Integer i1, Integer i2) {
                return i1 - i2;
            }
        }
    }

    private final class TableContentAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point point = new Point(e.getX(), e.getY());
                int row = ProblemsPage.ra$table(ProblemsPage.this).rowAtPoint(point);
                if (row >= 0) {
                    int modelRowIndex = ProblemsPage.ra$table(ProblemsPage.this).convertRowToModelIndex(row);
                    ProblemsPage.mav$activateObject(ProblemsPage.this, ProblemsPage.ra$model(ProblemsPage.this).getValueAt(modelRowIndex, ProblemsPage.ra$TYPE_COL()), modelRowIndex);
                }
            }
        }

        private TableContentAdapter() {
        }

        TableContentAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class DefaultKeyAdapter
    extends KeyAdapter {
        public void keyTyped(KeyEvent e) {
            if (e == null || e.isConsumed() || e.getKeyChar() != '\n') {
                return;
            }
            int row = ProblemsPage.ra$table(ProblemsPage.this).getSelectedRow();
            if (row >= 0) {
                int modelRowIndex = ProblemsPage.ra$table(ProblemsPage.this).convertRowToModelIndex(row);
                ProblemsPage.mav$activateObject(ProblemsPage.this, ProblemsPage.ra$model(ProblemsPage.this).getValueAt(modelRowIndex, ProblemsPage.ra$TYPE_COL()), modelRowIndex);
            }
        }

        private DefaultKeyAdapter() {
        }

        DefaultKeyAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    protected static final class MsgWrapper {
        private Object nodeData;
        private IdeLog.Message msg;
        private URL url;
        private Icon icon;
        int viewId;
        OffsetMark offsetMark;

        MsgWrapper(Object nodeData, IdeLog.Message msg) {
            this.nodeData = nodeData;
            this.msg = msg;
            this.url = null;
            this.offsetMark = null;
        }

        public Object getNodeData() {
            return this.nodeData;
        }

        public IdeLog.Message getMessage() {
            return this.msg;
        }

        public Project getProject() {
            return this.msg != null ? this.msg.project : null;
        }

        public Workspace getWorkspace() {
            return this.msg != null ? this.msg.workspace : null;
        }

        public boolean invokeFixEvent() {
            if (this.msg != null && this.msg.fixEvent != null) {
                this.msg.fixEvent.fix(this.msg);
                return true;
            }
            return false;
        }

        public boolean canInvokeFixEvent() {
            if (this.msg != null && this.msg.fixEvent != null) {
                return this.msg.fixEvent.canFix(this.msg);
            }
            return false;
        }

        public boolean invokeActivateEvent() {
            if (this.msg != null && this.msg.activateEvent != null) {
                this.msg.activateEvent.activate(this.msg);
                return true;
            }
            return false;
        }

        public String toString() {
            return this.nodeData.toString();
        }

        public URL getURL() {
            return this.url;
        }

        public void setURL(URL value) {
            this.url = value;
            Node node = NodeFactory.find((URL)this.url);
            boolean uncache = false;
            if (node == null) {
                try {
                    node = NodeFactory.findOrCreate((URL)value);
                    uncache = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (node != null) {
                this.icon = node.getIcon();
            }
            if (uncache) {
                NodeFactory.uncache((URL)this.url);
            }
        }

        public Icon getIcon() {
            return this.icon;
        }
    }

    private class PrivateContextMenuListener
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu popup) {
            if (popup == null) {
                return;
            }
            Context ctxt = popup.getContext();
            if (ctxt == null || ctxt.getView() != ProblemsPage.this) {
                return;
            }
            if (ProblemsPage.ra$_gotoSourceMenu(ProblemsPage.this) != null) {
                popup.add((Component)ProblemsPage.ra$_gotoSourceMenu(ProblemsPage.this), MenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            }
            if (ProblemsPage.ra$_fixSourceMenu(ProblemsPage.this) != null) {
                popup.add((Component)ProblemsPage.ra$_fixSourceMenu(ProblemsPage.this), MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
            if (ProblemsPage.ra$_copyMenu(ProblemsPage.this) != null) {
                popup.add((Component)ProblemsPage.ra$_copyMenu(ProblemsPage.this), MenuConstants.SECTION_EDIT_CTXT_MENU);
            }
            if (ProblemsPage.ra$_saveAsMenu(ProblemsPage.this) != null) {
                popup.add((Component)ProblemsPage.ra$_saveAsMenu(ProblemsPage.this), MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        private PrivateContextMenuListener() {
        }

        PrivateContextMenuListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

