/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.ide.runner.Debugger;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.ojc.interfaces.Storage;

class RedefineMap {
    final HashMap redefineMap;

    private void $init$() {
        this.redefineMap = new HashMap();
    }

    private byte[] fileToBuffer(String file, Translator.Log log) {
        try {
            File f = new File(file);
            FileInputStream fis = new FileInputStream(f);
            int len = fis.available();
            if (len <= 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] classBuffer = new byte[len];
            fis.read(classBuffer);
            fis.close();
            byte[] byArray = classBuffer;
            return byArray;
        }
        catch (IOException e) {
            log.error(null, 0, 0, 0, "can't redefine " + file);
            return null;
        }
    }

    void redefineClass(Storage storage, String qualifiedClassName, byte[] buffer, int len, Translator.Log log) {
        String path = storage.getPath();
        UnifiedBuildSystem.getInstance().markCompiled(path);
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null && debugger.isDebugging()) {
            byte[] classBuffer;
            if (buffer == null) {
                classBuffer = this.fileToBuffer(path, log);
            } else {
                classBuffer = new byte[len];
                System.arraycopy(buffer, 0, classBuffer, 0, len);
            }
            if (classBuffer != null) {
                this.redefineMap.put(qualifiedClassName, classBuffer);
            }
        }
    }

    void redefineClass(String className, String outDir, Translator.Log log) {
        UnifiedBuildSystem.getInstance().markCompiled(className);
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null && debugger.isDebugging()) {
            byte[] classBuffer = this.fileToBuffer(className, log);
            String c = className;
            if (c.startsWith(outDir)) {
                c = c.substring(outDir.length());
            }
            if (c.length() > 0 && c.charAt(0) == File.separatorChar) {
                c = c.substring(1);
            }
            if (c.endsWith(".class")) {
                c = c.substring(0, c.length() - 6);
            }
            c = c.replace(File.separatorChar, '.');
            if (classBuffer != null) {
                this.redefineMap.put(c, classBuffer);
            }
        }
    }

    void redefineClassMap(Project prj) {
        if (this.redefineMap != null && this.redefineMap.size() > 0) {
            Debugger.getDebugger().redefineClasses(prj, (Map)this.redefineMap);
            this.redefineMap.clear();
        }
    }

    RedefineMap() {
        this.$init$();
    }
}

