/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import oracle.ide.net.URLFactory;
import oracle.ojc.interfaces.Storage;

class SourceFinder {
    private static final int MAGIC_HEADER = 305419897;
    private static byte[] buffer;
    private static int bufidx;

    private static int readInt() {
        int v = (buffer[bufidx] & 0xFF) << 24;
        v += (buffer[bufidx + 1] & 0xFF) << 16;
        v += (buffer[bufidx + 2] & 0xFF) << 8;
        v += buffer[bufidx + 3] & 0xFF;
        bufidx += 4;
        return v;
    }

    private static long readLong() {
        long v = ((long)buffer[bufidx] & 0xFFL) << 56;
        v += ((long)buffer[bufidx + 1] & 0xFFL) << 48;
        v += ((long)buffer[bufidx + 2] & 0xFFL) << 40;
        v += ((long)buffer[bufidx + 3] & 0xFFL) << 32;
        v += ((long)buffer[bufidx + 4] & 0xFFL) << 24;
        v += ((long)buffer[bufidx + 5] & 0xFFL) << 16;
        v += ((long)buffer[bufidx + 6] & 0xFFL) << 8;
        v += (long)buffer[bufidx + 7] & 0xFFL;
        bufidx += 8;
        return v;
    }

    private static String readName() throws IOException {
        int utfl = SourceFinder.readInt();
        ByteArrayInputStream is = new ByteArrayInputStream(buffer, bufidx - 2, utfl + 2);
        bufidx += utfl;
        return new DataInputStream(is).readUTF();
    }

    private static void skipName() {
        int utfl = SourceFinder.readInt();
        bufidx += utfl;
    }

    static String findInCdi(Storage o, String searched) throws IOException {
        buffer = o.read();
        o.close();
        bufidx = 0;
        int classIndex = -1;
        if (SourceFinder.readInt() != 305419897) {
            throw new IOException();
        }
        Hashtable<Integer, String> allObjects = new Hashtable<Integer, String>(30);
        int classCnt = SourceFinder.readInt();
        int i = 0;
        while (i < classCnt) {
            int pos = bufidx;
            if (classIndex == -1) {
                if (searched.equals(SourceFinder.readName())) {
                    classIndex = pos;
                }
            } else {
                SourceFinder.skipName();
            }
            ++i;
        }
        if (classIndex == -1) {
            return null;
        }
        int sourceCnt = SourceFinder.readInt();
        int i2 = 0;
        while (i2 < sourceCnt) {
            int pos = bufidx;
            String sfi = SourceFinder.readName();
            allObjects.put(new Integer(pos), sfi);
            ++i2;
        }
        while (classCnt-- > 0) {
            SourceFinder.readInt();
            SourceFinder.readLong();
            int depClassesCnt = SourceFinder.readInt();
            while (depClassesCnt-- > 0) {
                SourceFinder.readInt();
            }
        }
        while (sourceCnt-- > 0) {
            Integer pos = new Integer(SourceFinder.readInt());
            int depClassesCnt = SourceFinder.readInt();
            while (depClassesCnt-- > 0) {
                if (classIndex != SourceFinder.readInt()) continue;
                return (String)allObjects.get(pos);
            }
        }
        return null;
    }

    static URL getFromCDI(Storage o, String cname) {
        URL res = null;
        try {
            try {
                res = URLFactory.newFileURL((String)SourceFinder.findInCdi(o, cname));
            }
            catch (Exception exception) {}
        }
        finally {
            buffer = null;
        }
        return res;
    }

    SourceFinder() {
    }
}

