/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorUtil;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Attributes;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Log;
import oracle.jdeveloper.cm.dt.CmJavaUtil;
import oracle.jdeveloper.compiler.BuildGraph;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerContext;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.JCompilerMenuItems;
import oracle.jdeveloper.compiler.Ojc;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.common.Interdependency;
import oracle.jdeveloper.deploy.common.ProfileDependable;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.deploy.BuildSystemFacade;
import oracle.ojc.interfaces.Storage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedBuildSystem {
    public static IdeLog ideLog;
    public static boolean showCompileProgress;
    private static final String PREPROCESSOR_GENERATED_PROPERTY = "preprocessor_generated_file";
    private static final int CLEANED = 1;
    private static final int NOT_CLEANED = 2;
    private static final int CANCELLED = 3;
    HashMap registeredTranslators;
    ArrayList registeredTranslatorsList;
    BuildGraph buildGraph;
    CompileThread compileThread;
    boolean locked;
    boolean buildingOnUIThread;
    private static UnifiedBuildSystem instance;
    private final Map<Workspace, Map<Project, Set<Storage>>> translatedWorkspaces;
    private final Map<Workspace, Map<Project, Set<Storage>>> suppressedWorkspaces;
    private Set<Storage> translatedSources;
    private Set<Storage> suppressedSources;
    private int depth;
    private boolean[] marking;
    private Set<Storage>[] translateableSources;
    private static final Log LOG;
    private long translatorStartingTime;
    static final /* synthetic */ boolean $assertionsDisabled;
    private final Map<Workspace, Map<Project, List<String>>> compiledWorkspaces;
    private List<String> compiledClasses;
    private File fileOfFailedDelete;

    private void $init$() {
        this.registeredTranslators = new HashMap(19);
        this.registeredTranslatorsList = new ArrayList(19);
        this.buildGraph = new BuildGraph();
        this.compileThread = null;
        this.locked = false;
        this.buildingOnUIThread = false;
        this.translatedWorkspaces = new HashMap<Workspace, Map<Project, Set<Storage>>>();
        this.suppressedWorkspaces = new HashMap<Workspace, Map<Project, Set<Storage>>>();
        this.marking = new boolean[4];
        this.translateableSources = new Set[4];
        this.compiledWorkspaces = new HashMap<Workspace, Map<Project, List<String>>>();
    }

    private synchronized void initThread(Context context, boolean rebuild, boolean cleanAll, boolean autoClean, boolean stopOnFailedDelete) {
        this.fileOfFailedDelete = null;
        this.compileThread = new CompileThread(rebuild, context, this.buildGraph, cleanAll, autoClean, stopOnFailedDelete, null);
        if (this.compileThread.getPriority() > 1) {
            this.compileThread.setPriority(this.compileThread.getPriority() - 1);
        }
        this.compileThread.start();
    }

    public synchronized boolean init(Context context, boolean rebuild) {
        if (!this.isAlive()) {
            this.initThread(context, rebuild, false, false, false);
            return true;
        }
        return false;
    }

    public synchronized boolean buildOnUIThread(Context context, boolean rebuild) {
        if (!this.isAlive()) {
            try {
                this.compileThread = new CompileThread(rebuild, context, this.buildGraph, false, false, false, null);
                this.buildingOnUIThread = true;
                this.compileThread.run();
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.compileThread = null;
                this.buildingOnUIThread = false;
            }
        }
        return false;
    }

    public synchronized void initCleanAll(Context context) {
        if (!this.isAlive()) {
            this.initThread(context, false, true, false, false);
        }
    }

    synchronized boolean initCleanAll(Context context, boolean autoClean, boolean stopOnFailedDelete) {
        if (this.isAlive()) {
            return false;
        }
        this.initThread(context, false, true, autoClean, stopOnFailedDelete);
        return true;
    }

    public synchronized boolean isAlive() {
        return this.compileThread != null && this.compileThread.isAlive();
    }

    public void join(long millis) throws InterruptedException {
        if (this.compileThread != null) {
            this.compileThread.join(0L);
        }
    }

    public synchronized void stopBuildSystem() {
        if (this.compileThread != null) {
            this.compileThread.interrupt();
        }
    }

    public synchronized boolean isLocked(Context context) {
        return this.locked;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean lock(Context context) {
        if (this.isAlive()) return false;
        this.locked = true;
        if (!true) return false;
        return true;
    }

    public synchronized boolean unlock() {
        if (this.locked) {
            this.locked = false;
            return false ^ true;
        }
        return false;
    }

    public synchronized int compileInThread(Thread thread, Project prj, ArrayList files, boolean rebuild) throws IllegalArgumentException {
        if (!(thread instanceof CompileThread || this.buildingOnUIThread && SwingUtilities.isEventDispatchThread())) {
            throw new IllegalArgumentException("thread");
        }
        int fileCnt = files.size();
        if (files == null) {
            throw new IllegalArgumentException("files");
        }
        int i = 0;
        while (i < fileCnt) {
            if (!(files.get(i) instanceof Storage)) {
                throw new IllegalArgumentException("files[" + i + "]");
            }
            ++i;
        }
        return this.compileThread.buildFilesInThread(prj, files, rebuild);
    }

    public synchronized int getLastErrorCount() {
        return ideLog != null ? ideLog.nerrors() : 0;
    }

    private boolean isTranslatorCompatible(ArrayList al, Translator translator, String ext) {
        int cnt = BuildGraph.isPreprocessor(translator) ? 0 : 1;
        int i = 0;
        while (i < al.size()) {
            if (!BuildGraph.isPreprocessor((Translator)al.get(i))) {
                ++cnt;
            }
            ++i;
        }
        return cnt <= 1;
    }

    public void registerTranslator(Translator translator) {
        ArrayList extensions = translator.getInputTypes();
        int i = 0;
        while (i < extensions.size()) {
            String ext = (String)extensions.get(i);
            ArrayList<Translator> al = (ArrayList<Translator>)this.registeredTranslators.get(ext);
            if (al == null) {
                al = new ArrayList<Translator>(1);
                al.add(translator);
                this.registeredTranslators.put(ext, al);
            } else if (!al.contains(translator)) {
                if (this.isTranslatorCompatible(al, translator, ext)) {
                    al.add(translator);
                    this.registeredTranslators.put(ext, al);
                } else {
                    System.out.println("Addin: Translator " + translator.getName() + " is trying to register a input type (" + ext + ")" + " which conflicts with translator " + translator.getName() + " who already using this input type");
                }
            }
            ++i;
        }
        if (!this.buildGraph.rebuild(this.registeredTranslators)) {
            System.out.println("Addin error: unable to register translator " + translator.getName());
            this.unregisterTranslator(translator);
        } else if (!this.registeredTranslatorsList.contains(translator)) {
            this.registeredTranslatorsList.add(translator);
        }
    }

    public void unregisterTranslator(Translator translator) {
        ArrayList extensions = translator.getInputTypes();
        int i = 0;
        while (i < extensions.size()) {
            String ext = (String)extensions.get(i);
            ArrayList al = (ArrayList)this.registeredTranslators.get(ext);
            if (al != null) {
                al.remove(translator);
            }
            if (al == null || al.size() == 0) {
                this.registeredTranslators.remove(ext);
            }
            ++i;
        }
        this.registeredTranslatorsList.remove(translator);
    }

    Translator getJavaTranslator() {
        for (Translator t : this.registeredTranslatorsList) {
            if ("Ojc".equals(t.getName())) {
                return t;
            }
            if (!t.getInputTypes().contains(".java") || !t.getOutputTypes().contains(".class")) continue;
            return t;
        }
        return null;
    }

    public static UnifiedBuildSystem getInstance() {
        if (instance == null) {
            instance = new UnifiedBuildSystem();
        }
        return instance;
    }

    static {
        $assertionsDisabled = UnifiedBuildSystem.class.desiredAssertionStatus() ^ true;
        ideLog = new IdeLog();
        showCompileProgress = false;
        LOG = new Log("translator");
    }

    private void beginTranslator(Translator translator) {
        if (!$assertionsDisabled && !LOG.trace("begin translator {0}", (Object)translator)) {
            throw new AssertionError();
        }
        this.translatorStartingTime = System.currentTimeMillis();
        if (this.depth == 0) {
            Workspace workspace = ideLog.getWorkspace();
            Project project = ideLog.getProject();
            Map<Project, Set<Storage>> translatedProjects = this.translatedWorkspaces.get(workspace);
            Map<Project, Set<Storage>> suppressedProjects = this.suppressedWorkspaces.get(workspace);
            Map<Project, List<String>> compiledProjects = this.compiledWorkspaces.get(workspace);
            if (translatedProjects == null) {
                translatedProjects = new HashMap<Project, Set<Storage>>();
                this.translatedWorkspaces.put(workspace, translatedProjects);
                suppressedProjects = new HashMap<Project, Set<Storage>>();
                this.suppressedWorkspaces.put(workspace, suppressedProjects);
                compiledProjects = new HashMap<Project, List<String>>();
                this.compiledWorkspaces.put(workspace, compiledProjects);
            }
            this.translatedSources = translatedProjects.get(project);
            this.suppressedSources = suppressedProjects.get(project);
            this.compiledClasses = compiledProjects.get(project);
            if (this.translatedSources == null) {
                this.translatedSources = new HashSet<Storage>();
                translatedProjects.put(project, this.translatedSources);
                this.suppressedSources = new HashSet<Storage>();
                suppressedProjects.put(project, this.suppressedSources);
                this.compiledClasses = new ArrayList<String>();
                compiledProjects.put(project, this.compiledClasses);
            }
        }
        ++this.depth;
        if (this.depth > this.marking.length) {
            this.marking = new boolean[this.depth * 2];
            System.arraycopy(this.marking, 0, this.marking, 0, this.depth);
            this.translateableSources = new Set[this.depth * 2];
            System.arraycopy(this.translateableSources, 0, this.translateableSources, 0, this.depth);
        }
        this.marking[this.depth - 1] = false;
        this.translateableSources[this.depth - 1] = new HashSet<Storage>();
    }

    private void markTranslateable(Storage source) {
        if (this.suppressedSources.contains(source)) {
            return;
        }
        if (Boolean.TRUE.equals(source.getProperty(PREPROCESSOR_GENERATED_PROPERTY))) {
            return;
        }
        this.translateableSources[this.depth - 1].add(source);
    }

    public void beginMarking(Translator translator) {
        if (!$assertionsDisabled && !LOG.trace("begin marking {0}", (Object)translator)) {
            throw new AssertionError();
        }
        this.marking[this.depth - 1] = true;
    }

    public void markTranslated(Object translator, Storage source) {
        boolean suppressed;
        boolean bl = suppressed = this.suppressedSources.contains(source) || Boolean.TRUE.equals(source.getProperty(PREPROCESSOR_GENERATED_PROPERTY));
        if (!$assertionsDisabled && !LOG.trace("mark {1} translated, suppressed {0}, {2}", (Object)suppressed, (Object)source, translator)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.marking[this.depth - 1]) {
            throw new AssertionError((Object)("!marking, translator " + translator + ", depth " + this.depth));
        }
        if (!suppressed) {
            this.translatedSources.add(source);
        }
        this.translateableSources[this.depth - 1].remove(source);
    }

    private void endTranslator(Translator translator) {
        if (!$assertionsDisabled && this.depth <= 0) {
            throw new AssertionError();
        }
        if (this.marking[this.depth - 1]) {
            Set<Storage> untranslated = this.translateableSources[this.depth - 1];
            if (!$assertionsDisabled && !LOG.trace("end translator, suppressed {0}, {1}", untranslated, (Object)translator)) {
                throw new AssertionError();
            }
            this.suppressedSources.addAll(untranslated);
            this.translatedSources.removeAll(untranslated);
        } else {
            Set<Storage> translated = this.translateableSources[this.depth - 1];
            if (!$assertionsDisabled && !LOG.trace("end translator, translated {0}", translated)) {
                throw new AssertionError();
            }
            this.translatedSources.addAll(translated);
        }
        this.translateableSources[this.depth - 1] = null;
        this.marking[this.depth - 1] = false;
        --this.depth;
        if (this.depth == 0) {
            this.translatedSources = null;
            this.suppressedSources = null;
            this.compiledClasses = null;
        }
        if (!$assertionsDisabled && !LOG.trace("Translation time in msec: " + (System.currentTimeMillis() - this.translatorStartingTime))) {
            throw new AssertionError();
        }
    }

    public Map<Workspace, Map<Project, Set<Storage>>> getTranslatedSources() {
        return this.translatedWorkspaces;
    }

    public void markCompiled(String path) {
        this.compiledClasses.add(path);
    }

    public Map<Workspace, Map<Project, List<String>>> getCompiledClasses() {
        return this.compiledWorkspaces;
    }

    File getFileOfFailedDelete() {
        return this.fileOfFailedDelete;
    }

    public UnifiedBuildSystem() {
        this.$init$();
    }

    static Map ra$translatedWorkspaces(UnifiedBuildSystem unifiedBuildSystem) {
        return unifiedBuildSystem.translatedWorkspaces;
    }

    static Map ra$suppressedWorkspaces(UnifiedBuildSystem unifiedBuildSystem) {
        return unifiedBuildSystem.suppressedWorkspaces;
    }

    static File ra$fileOfFailedDelete(UnifiedBuildSystem unifiedBuildSystem) {
        return unifiedBuildSystem.fileOfFailedDelete;
    }

    static Log ra$LOG() {
        return LOG;
    }

    static void wa$translatedSources(UnifiedBuildSystem unifiedBuildSystem, Set set) {
        unifiedBuildSystem.translatedSources = set;
    }

    static void wa$suppressedSources(UnifiedBuildSystem unifiedBuildSystem, Set set) {
        unifiedBuildSystem.suppressedSources = set;
    }

    static void mav$beginTranslator(UnifiedBuildSystem unifiedBuildSystem, Translator translator) {
        unifiedBuildSystem.beginTranslator(translator);
    }

    static void mav$endTranslator(UnifiedBuildSystem unifiedBuildSystem, Translator translator) {
        unifiedBuildSystem.endTranslator(translator);
    }

    static void mav$markTranslateable(UnifiedBuildSystem unifiedBuildSystem, Storage storage) {
        unifiedBuildSystem.markTranslateable(storage);
    }

    static void wa$fileOfFailedDelete(UnifiedBuildSystem unifiedBuildSystem, File file) {
        unifiedBuildSystem.fileOfFailedDelete = file;
    }

    private class CompileThread
    extends Thread {
        boolean rebuild;
        boolean cleanAll;
        BuildGraph buildGraph;
        Context context;
        long startTime;
        String[] copyResSpec;
        boolean reverseCopy;
        HashMap deploymentProfileBuilt;
        HashSet projectsBuilt;
        int filesBuilt;
        boolean warnOnSourceNotInProject;
        boolean saveBeforeCompile;
        private boolean cleanProjectBeforeRebuild;
        private PrintWriter bsfPrintWriter;
        private boolean autoClean;
        private boolean stopOnFailedDelete;
        public static final String THREAD_NAME = "CompileThread";
        static final /* synthetic */ boolean $assertionsDisabled;

        private CompileThread(boolean rebuild, Context context, BuildGraph buildGraph, boolean cleanAll, boolean autoClean, boolean stopOnFailedDelete) {
            super(THREAD_NAME);
            this.rebuild = rebuild;
            this.cleanAll = cleanAll;
            this.autoClean = autoClean;
            this.stopOnFailedDelete = stopOnFailedDelete;
            this.context = context;
            this.buildGraph = buildGraph;
            this.deploymentProfileBuilt = new HashMap();
            this.copyResSpec = null;
            this.reverseCopy = false;
            this.filesBuilt = 0;
            this.warnOnSourceNotInProject = false;
            EnvironOptions opt = Ide.getEnvironOptions();
            showCompileProgress = opt.getShowCompileProgress();
            this.saveBeforeCompile = opt.getSaveBeforeCompile();
            this.cleanProjectBeforeRebuild = opt.getCleanProjectBeforeRebuild();
            this.projectsBuilt = new HashSet();
            this.startTime = System.currentTimeMillis();
        }

        private Storage getStorageForNode(URL url) {
            Storage stor;
            Node node;
            if (url == null) {
                return null;
            }
            if (url.getRef() != null) {
                return null;
            }
            Node node2 = node = this.saveBeforeCompile ? null : NodeFactory.find((URL)url);
            if (node != null && node.isDirty() || !"file".equals(url.getProtocol())) {
                if (node == null) {
                    try {
                        node = NodeFactory.findOrCreate((URL)url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                stor = new IdeStorage(node);
            } else {
                stor = Helpers.createFileStorage(url.getPath());
            }
            if (node != null) {
                stor.setProperty("nodeClassObject", (Object)node.getClass());
            }
            return stor;
        }

        private void processElement(URL url, ArrayList result, HashMap dupCache) {
            String path;
            Storage store = this.getStorageForNode(url);
            if (store != null && dupCache.get(path = store.getPath()) == null) {
                result.add(store);
                dupCache.put(path, store);
            }
        }

        private void getProjectFileList(Project prj, String relPath, IntersectedFilters filters, ArrayList result, HashMap dupCache) {
            Iterator iter = ProjectContent.getInstance((PropertyStorage)prj).getAllContents().urlIterator(relPath, filters);
            int i = 0;
            while (iter.hasNext()) {
                if ((++i & 0x1FF) == 511 && Thread.currentThread().isInterrupted()) {
                    throw new RuntimeException(CompArb.getString(82));
                }
                this.processElement((URL)iter.next(), result, dupCache);
            }
        }

        private void getProjectFileList(Project prj, ArrayList result, HashMap dupCache) {
            URL[] urls;
            QueryCriteria criteria = new QueryCriteria();
            criteria.put((Object)"file.all", (Object)"");
            URL[] uRLArray = urls = Helpers.getUrlsThroughIndexer(prj, criteria);
            int n = 0;
            while (n < uRLArray.length) {
                URL url = uRLArray[n];
                this.processElement(url, result, dupCache);
                ++n;
            }
        }

        private void getFolderFileList(Folder folder, ArrayList result, HashMap dupCache) {
            Iterator iter = folder.getChildren();
            int i = 0;
            while (iter.hasNext()) {
                Element elem = (Element)iter.next();
                if ((++i & 0x1FF) == 511 && Thread.currentThread().isInterrupted()) {
                    throw new RuntimeException(CompArb.getString(82));
                }
                if (elem instanceof Locatable) {
                    this.processElement(((Locatable)elem).getURL(), result, dupCache);
                }
                if (!(elem instanceof Folder)) continue;
                this.getFolderFileList((Folder)elem, result, dupCache);
            }
        }

        private boolean makeSureResultsAreStorageInstances(ArrayList al) {
            if (al == null) {
                return true;
            }
            int i = 0;
            while (i < al.size()) {
                if (!(al.get(i) instanceof Storage)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void recursivelyDeleteDir(File dir) {
            File[] list = dir.listFiles();
            int i = 0;
            while (i < list.length) {
                File f = list[i];
                if (f.isDirectory()) {
                    this.recursivelyDeleteDir(f);
                }
                URL url = null;
                try {
                    url = f.toURL();
                    if (!GlobalIgnoreList.isGloballyIgnored((URL)url) || url.getFile().endsWith(".cdi")) {
                        boolean res = f.delete();
                        Assert.println((String)((res ? "Successfully deleted " : "Can't delete ") + f.getPath()));
                        if (this.stopOnFailedDelete && !res) {
                            UnifiedBuildSystem.wa$fileOfFailedDelete(UnifiedBuildSystem.this, f);
                            throw new FailedDeleteError(null);
                        }
                    }
                }
                catch (MalformedURLException e) {
                    Assert.println((String)("Cannot get URL for " + f.getAbsolutePath()));
                }
                ++i;
            }
        }

        private int cleanProject(Project prj, boolean projectAutoClean, boolean addCancelOption) {
            String projectPath;
            String title = CompArb.format(87, prj.getShortLabel());
            URL outDirUrl = JavaProject.getInstance((Project)prj).getOutputDirectory();
            if (outDirUrl == null) {
                String message = CompArb.getString(60);
                if (!projectAutoClean) {
                    MessageDialog.error(null, (Object)message, (String)title, (String)"");
                } else {
                    JCompiler.getInstance().logOutMsg(message + "\n");
                }
                return 2;
            }
            File outDirFile = new File(outDirUrl.getPath());
            if (!outDirFile.exists()) {
                return 1;
            }
            if (!outDirFile.isDirectory()) {
                String message = CompArb.getString(3);
                if (!projectAutoClean) {
                    MessageDialog.error(null, (Object)message, (String)title, (String)"");
                } else {
                    JCompiler.getInstance().logOutMsg(message + "\n");
                }
                return 2;
            }
            String outDirPath = outDirFile.getPath().replace('\\', '/');
            if (outDirPath.equals(projectPath = prj.getBaseDirectory().replace('\\', '/'))) {
                return 2;
            }
            File deployDirFile = new File(outDirFile.getParent() + "/deploy");
            if (!projectAutoClean) {
                String dirs = outDirFile.getPath() + " " + deployDirFile.getPath();
                if (addCancelOption) {
                    int result = MessageDialog.optionalConfirmOrCancel((String)"cleanProject-normal", (Component)Ide.getMainWindow(), (String)CompArb.format(30, dirs), (String)title, (String)"");
                    if (result != 1) {
                        return result == -1 ? 3 : 2;
                    }
                } else if (!MessageDialog.optionalConfirm((String)"cleanProject-normal", (Component)Ide.getMainWindow(), (String)CompArb.format(30, dirs), (String)title, (String)"")) {
                    return 2;
                }
            }
            if (outDirFile.getParentFile() == null) {
                if (projectAutoClean) {
                    return 2;
                }
                if (addCancelOption) {
                    int result = MessageDialog.optionalConfirmOrCancel((String)"cleanProject-outputToRootDir", (Component)Ide.getMainWindow(), (String)CompArb.getString(56), (String)title, (String)"");
                    if (result != 1) {
                        return result == -1 ? 3 : 2;
                    }
                } else if (!MessageDialog.optionalConfirm((String)"cleanProject-outputToRootDir", (Component)Ide.getMainWindow(), (String)CompArb.getString(56), (String)title, (String)"")) {
                    return 2;
                }
            }
            this.recursivelyDeleteDir(outDirFile);
            if (deployDirFile.isDirectory()) {
                this.recursivelyDeleteDir(deployDirFile);
            }
            return 1;
        }

        private boolean cleanWorkspace(Workspace workSpace) {
            if (workSpace == null || workSpace.getBaseDirectory() == null) {
                return false;
            }
            if (!this.autoClean) {
                String title = CompArb.format(87, workSpace.getShortLabel());
                if (!MessageDialog.optionalConfirm((String)"cleanApplication", (Component)Ide.getMainWindow(), (String)CompArb.format(80, workSpace.getLongLabel()), (String)title, (String)"")) {
                    return false;
                }
            }
            Iterator childIter = workSpace.getChildren();
            while (childIter.hasNext()) {
                this.cleanProject((Project)childIter.next(), true, false);
            }
            File deployDir = new File(workSpace.getBaseDirectory() + "/deploy");
            if (deployDir.isDirectory()) {
                this.recursivelyDeleteDir(deployDir);
            }
            return true;
        }

        static {
            $assertionsDisabled = CompileThread.class.desiredAssertionStatus() ^ true;
        }

        private void buildGraph(ArrayList files, Project prj, boolean rebuild) {
            if (files == null || files.size() <= 0 || prj == null) {
                return;
            }
            ArrayList translators = this.buildGraph.getOrderedTranslatorList();
            int i = 0;
            while (i < UnifiedBuildSystem.this.registeredTranslatorsList.size()) {
                Translator t = (Translator)UnifiedBuildSystem.this.registeredTranslatorsList.get(i);
                if (translators.indexOf(t) == -1) {
                    translators.add(t);
                }
                ++i;
            }
            HashMap<Storage, Storage> generatedFiles = new HashMap<Storage, Storage>();
            int i2 = 0;
            while (i2 < translators.size()) {
                Translator translator = (Translator)translators.get(i2);
                try {
                    UnifiedBuildSystem.mav$beginTranslator(UnifiedBuildSystem.this, translator);
                    translator.setProject(prj);
                    translator.setLog(ideLog);
                    if (this.isInterrupted()) {
                        return;
                    }
                    ArrayList<Storage> inputFiles = new ArrayList<Storage>();
                    int j = 0;
                    while (j < files.size()) {
                        Storage s = (Storage)files.get(j);
                        if (translator.canBuild(s)) {
                            inputFiles.add(s);
                            UnifiedBuildSystem.mav$markTranslateable(UnifiedBuildSystem.this, s);
                        } else if (translator.needToBuild(s)) {
                            inputFiles.add(s);
                        }
                        ++j;
                    }
                    if (inputFiles.size() > 0) {
                        int errCnt = ideLog.nerrors();
                        ArrayList results = new ArrayList();
                        translator.translate(prj, rebuild, inputFiles, results);
                        Assert.check((boolean)this.makeSureResultsAreStorageInstances(results));
                        int nerrors = ideLog.nerrors() - errCnt;
                        if (nerrors <= 0 && results.size() > 0) {
                            if (BuildGraph.isPreprocessor(translator)) {
                                int j2 = 0;
                                while (j2 < inputFiles.size()) {
                                    Storage inputFile = (Storage)inputFiles.get(j2);
                                    if (translator.canBuild(inputFile)) {
                                        if (results.contains(inputFile)) {
                                            results.remove(inputFile);
                                        } else {
                                            files.remove(inputFile);
                                        }
                                    }
                                    ++j2;
                                }
                            }
                            int j3 = 0;
                            while (j3 < results.size()) {
                                Storage s = (Storage)results.get(j3);
                                if (!$assertionsDisabled && !UnifiedBuildSystem.ra$LOG().trace("preprocess created {0}", (Object)s)) {
                                    throw new AssertionError();
                                }
                                s.setProperty(UnifiedBuildSystem.PREPROCESSOR_GENERATED_PROPERTY, (Object)Boolean.TRUE);
                                files.add(s);
                                generatedFiles.put(s, s);
                                ++j3;
                            }
                        }
                        if (nerrors > 0) {
                            int j4 = 0;
                            while (j4 < inputFiles.size()) {
                                Storage s = (Storage)inputFiles.get(j4);
                                if (generatedFiles.get(s) == s) {
                                    File f = new File(s.getPath());
                                    f.delete();
                                    generatedFiles.remove(s);
                                }
                                ++j4;
                            }
                            int j5 = 0;
                            while (j5 < results.size()) {
                                new File(((Storage)results.get(j5)).getPath()).delete();
                                ++j5;
                            }
                        }
                    }
                }
                finally {
                    translator.setProject(null);
                    translator.setLog(null);
                    UnifiedBuildSystem.mav$endTranslator(UnifiedBuildSystem.this, translator);
                }
                ++i2;
            }
        }

        int buildFilesInThread(Project prj, ArrayList files, boolean rebuild) {
            int errCnt = ideLog.nerrors();
            this.buildGraph(files, prj, rebuild);
            return ideLog.nerrors() - errCnt;
        }

        /*
         * Unable to fully structure code
         */
        private void buildProjectFiles(Workspace wsp, Project prj, Element[] elements) {
            if (this.projectsBuilt.contains(prj)) {
                return;
            }
            if (elements == null) {
                this.projectsBuilt.add(prj);
            }
            prj.getTransientProperties().put("rebuild", this.rebuild != false && elements == null);
            rebuild = this.rebuild | JCompiler.getInstance().forceRebuildOnProject(prj);
            if (rebuild && elements == null && this.cleanProjectBeforeRebuild && !this.autoClean) {
                if (UnifiedBuildSystem.showCompileProgress) {
                    cleanStr = CompArb.format(87, prj.getShortLabel());
                    JCompiler.getInstance().logOutMsg(cleanStr + "\n");
                }
                this.cleanProject(prj, true, false);
            }
            prevWsp = UnifiedBuildSystem.ideLog.getWorkspace();
            prevPrj = UnifiedBuildSystem.ideLog.getProject();
            try {
                block34: {
                    UnifiedBuildSystem.ideLog.setWorkspace(wsp);
                    UnifiedBuildSystem.ideLog.setProject(prj);
                    this.copyResSpec = JCompiler.getCopyRes(prj);
                    this.reverseCopy = JCompiler.getReverseCopyRes(prj);
                    files = new ArrayList<E>(64);
                    PerformanceLogger.get().startTiming(this.getClass().getName());
                    dupCache = new HashMap<K, V>();
                    if (elements != null) {
                        i = 0;
                        while (i < elements.length) {
                            element = elements[i];
                            if (element instanceof WorkingSetNode) {
                                n = (WorkingSetNode)element;
                                this.getProjectFileList(prj, null, n.getFilters(prj), files, dupCache);
                            } else if (element instanceof RelativeDirectoryContextFolder) {
                                rd = (RelativeDirectoryContextFolder)element;
                                this.getProjectFileList(prj, rd.getRelativePath(), null, files, dupCache);
                            } else {
                                if (element instanceof Locatable) {
                                    this.processElement(((Locatable)element).getURL(), files, dupCache);
                                }
                                if (element instanceof Folder) {
                                    this.getFolderFileList((Folder)element, files, dupCache);
                                }
                            }
                            ++i;
                        }
                    } else {
                        this.getProjectFileList(prj, files, dupCache);
                    }
                    dupCache.clear();
                    this.filesBuilt += files.size();
                    ** if (files.size() > 0) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        return;
                    }
lbl-1000:
                    // 1 sources

                    {
                        break block34;
                    }
                    finally {
                        PerformanceLogger.get().stopTiming(this.getClass().getName(), "Build System --> " + files.size() + " files to process");
                    }
                }
                if (elements == null) {
                    UnifiedBuildSystem.ideLog.clear(null);
                } else {
                    i = 0;
                    while (i < this.filesBuilt) {
                        stor = (Storage)files.get(i);
                        if (!stor.getPath().endsWith(".java")) {
                            UnifiedBuildSystem.ideLog.clear((Storage)files.get(i));
                        }
                        ++i;
                    }
                }
                if (JavaProject.getInstance((Project)prj).getOutputDirectory() == null) {
                    UnifiedBuildSystem.ideLog.error(null, 0, 0, 0, CompArb.getString(74));
                    return;
                }
                if (this.warnOnSourceNotInProject && files.size() == 1 && ((p = this.context.getProperty("disableFileNotInProjectWarning")) == null || p == Boolean.FALSE)) {
                    UnifiedBuildSystem.ideLog.warning(null, 0, 0, 0, CompArb.format(15, ((Storage)files.get(0)).getPath(), prj.getShortLabel()));
                }
                if (this.buildGraph == null || this.buildGraph.buildRoots == null || this.buildGraph.buildRoots.size() == 0) {
                    throw new Error("no compiler addins installed");
                }
                jspFiles = new ArrayList<Storage>(64);
                uixFiles = new ArrayList<Storage>(64);
                i = files.size() - 1;
                while (i >= 0) {
                    f = (Storage)files.get(i);
                    n = f.getName();
                    if (J2eeSettings.isCompilableJsp(n)) {
                        jspFiles.add(f);
                        files.remove(i);
                    } else if (n.endsWith(".uix") || n.endsWith(".uit")) {
                        uixFiles.add(f);
                        files.remove(i);
                    }
                    --i;
                }
                this.buildGraph(files, prj, rebuild);
                this.buildGraph(jspFiles, prj, rebuild);
                this.buildGraph(uixFiles, prj, rebuild);
            }
            finally {
                UnifiedBuildSystem.ideLog.setWorkspace(prevWsp);
                UnifiedBuildSystem.ideLog.setProject(prevPrj);
            }
        }

        private PrintWriter getBsfPrintWriter() {
            if (this.bsfPrintWriter == null) {
                this.bsfPrintWriter = Deployment.getLogPrintWriter();
            }
            return this.bsfPrintWriter;
        }

        private void buildDepProfile(Profile prf) {
            ProfileDependable[] dependables;
            DataContainer prj = prf.getDataContainer();
            if (this.deploymentProfileBuilt.get(prf) == prj) {
                return;
            }
            this.deploymentProfileBuilt.put(prf, prj);
            BuildSystemFacade bsf = new BuildSystemFacade();
            int errCnt = ideLog.nerrors();
            ProfileDependable[] profileDependableArray = dependables = (ProfileDependable[])DeployUtil.getDependables((Interdependency)prf, ProfileDependable.class);
            int n = 0;
            while (n < profileDependableArray.length) {
                ProfileDependable profileDep = profileDependableArray[n];
                Profile profile = profileDep.getProfile();
                if (profile != null) {
                    this.buildDepProfile(profile);
                }
                ++n;
            }
            if (prj instanceof Project) {
                this.buildProjectFiles(null, (Project)prj, null);
            }
            if (ideLog.nerrors() <= errCnt) {
                long startingTime = System.currentTimeMillis();
                boolean isAssembly = Boolean.TRUE.equals(this.context.getProperty("is-j2ee-application-assembly"));
                PrintWriter deployContextLog = (PrintWriter)this.context.getProperty("deploy-context-log");
                DeployUtil.setProfile(this.context, prf);
                bsf.deploy(isAssembly, deployContextLog != null ? deployContextLog : this.getBsfPrintWriter(), this.context);
                if (!$assertionsDisabled && !UnifiedBuildSystem.ra$LOG().trace("Deploy time in msec: " + (System.currentTimeMillis() - startingTime))) {
                    throw new AssertionError();
                }
            }
        }

        private void buildProject(Workspace wsp, Project prj) {
            for (Dependable dependable : DependencyConfiguration.getInstance((Project)prj).getAllDependenciesList()) {
                Element source = dependable.getSource();
                Folder owner = dependable.getSourceOwner();
                if (source instanceof Project) {
                    Workspace w = owner instanceof Workspace ? (Workspace)owner : null;
                    this.buildProjectFiles(w, (Project)source, null);
                    continue;
                }
                if (!(source instanceof Profile) || !(owner instanceof Project)) continue;
                this.buildDepProfile((Profile)source);
            }
            this.buildProjectFiles(wsp, prj, null);
        }

        private void buildWorkspace(Workspace wsp) {
            ideLog.setWorkspace(wsp);
            Iterator childIter = wsp.getChildren();
            while (childIter.hasNext()) {
                Project prj = (Project)childIter.next();
                this.buildProject(wsp, prj);
            }
        }

        private void buildAll(Element[] elements) {
            if (elements[0] instanceof Workspaces) {
                Iterator childIter = elements[0].getChildren();
                while (childIter.hasNext()) {
                    Workspace wsp = (Workspace)childIter.next();
                    this.buildWorkspace(wsp);
                }
            } else if (elements[0] instanceof Workspace) {
                int i = 0;
                while (i < elements.length) {
                    Element element = elements[i];
                    Assert.check((boolean)(element instanceof Workspace), (String)"not all elements in selection are Workspaces, they must be");
                    this.buildWorkspace((Workspace)element);
                    ++i;
                }
            } else if (elements[0] instanceof Project) {
                int i = 0;
                while (i < elements.length) {
                    Element element = elements[i];
                    Assert.check((boolean)(element instanceof Project), (String)"not all elements in selection are Projects, they must be");
                    this.buildProject(this.context.getWorkspace(), (Project)element);
                    ++i;
                }
            } else if (elements[0] instanceof WorkingSetNode) {
                this.buildProjectFiles(this.context.getWorkspace(), this.context.getProject(), elements);
            } else {
                Context c;
                if (elements.length == 1 && elements[0] instanceof Locatable && !elements[0].mayHaveChildren() && !CmJavaUtil.isCMUrl(((Locatable)elements[0]).getURL()) && !(this.warnOnSourceNotInProject = (c = EditorUtil.findNodeInContext((Element)elements[0], (Context)this.context)) == null)) {
                    this.context = c;
                }
                Project prj = this.context.getProject();
                Workspace wsp = this.context.getWorkspace();
                if (prj == null) {
                    prj = Ide.getActiveProject();
                    wsp = Ide.getActiveWorkspace();
                }
                if (prj == null) {
                    prj = Ide.getDefaultProject();
                    wsp = Ide.getDefaultWorkspace();
                }
                this.buildProjectFiles(wsp, prj, elements);
                this.warnOnSourceNotInProject = false;
            }
        }

        private boolean cleanAll(Element[] elements) {
            boolean res = true;
            if (elements[0] instanceof Workspaces) {
                Iterator childIter = elements[0].getChildren();
                while (childIter.hasNext()) {
                    res &= this.cleanAll(new Element[]{(Element)childIter.next()});
                }
            } else if (elements[0] instanceof Workspace) {
                int i = 0;
                while (i < elements.length) {
                    Assert.check((boolean)(elements[i] instanceof Workspace), (String)"not all elements in selection are Workspaces, they must be");
                    res &= this.cleanWorkspace((Workspace)elements[i]);
                    ++i;
                }
            } else if (elements[0] instanceof Project) {
                int i = 0;
                while (i < elements.length) {
                    Element element = elements[i];
                    Assert.check((boolean)(element instanceof Project), (String)"not all elements in selection are Projects, they must be");
                    int result = this.cleanProject((Project)element, this.autoClean, elements.length > 1);
                    res &= result == 1;
                    if (result == 3) {
                        return res;
                    }
                    ++i;
                }
            } else {
                Project prj = this.context.getProject();
                if (prj == null) {
                    prj = Ide.getActiveProject();
                }
                if (prj != null) {
                    int result = this.cleanProject(prj, this.autoClean, false);
                    res &= result == 1;
                }
            }
            return res;
        }

        private Element[] getElementsToBuild() {
            IdeAction compileAction;
            Element[] elements = this.context.getSelection();
            boolean nonBuildableElements = elements == null || elements.length == 0;
            int i = 0;
            while (!nonBuildableElements && i < elements.length) {
                Element element = elements[i];
                if (element == null) {
                    nonBuildableElements = true;
                } else {
                    Attributes attributes = element.getAttributes();
                    if (!attributes.isSet(ElementAttributes.BUILDABLE)) {
                        nonBuildableElements = true;
                    }
                }
                ++i;
            }
            if (nonBuildableElements && this.context.getNode() != null) {
                elements = new Element[]{this.context.getNode()};
            }
            if ((compileAction = CompilerContext.getCompileAction(this.context)) != null) {
                int cmdId = compileAction.getCommandId();
                Workspace wsp = Ide.getActiveWorkspace();
                Project prj = Ide.getActiveProject();
                if (wsp != null && (cmdId == JCompiler.MAKE_WORKSPACE_CMD_ID || cmdId == JCompiler.BUILD_WORKSPACE_CMD_ID)) {
                    elements = new Element[]{wsp};
                } else if (prj != null && (cmdId == JCompiler.MAKE_PROJECT_CMD_ID || cmdId == JCompiler.BUILD_PROJECT_CMD_ID)) {
                    elements = new Element[]{prj};
                } else if (prj != null && (cmdId == JCompiler.MAKE_WORKINGSET_CMD_ID || cmdId == JCompiler.BUILD_WORKINGSET_CMD_ID)) {
                    elements = new Element[]{new WorkingSetNode()};
                }
            }
            return elements;
        }

        public void run() {
            block21: {
                JCompiler ci = JCompiler.getInstance();
                boolean cleanAllResult = false;
                try {
                    boolean buildVetoThrown;
                    block22: {
                        Ojc.currentContext = this.context;
                        UnifiedBuildSystem.ra$translatedWorkspaces(UnifiedBuildSystem.this).clear();
                        UnifiedBuildSystem.ra$suppressedWorkspaces(UnifiedBuildSystem.this).clear();
                        Element[] elements = this.getElementsToBuild();
                        if (elements == null || elements.length == 0) {
                            Assert.println((String)"Nothing to build or clean, elements is null");
                            break block21;
                        }
                        ideLog.reinit();
                        if (Ide.getIdeArgs().getCreateUI()) {
                            JCompilerMenuItems.getInstance().enableCancelBuild(true);
                        }
                        if (!this.cleanAll) {
                            ci.logOutStartBuild();
                        }
                        buildVetoThrown = false;
                        try {
                            try {
                                if (this.cleanAll) {
                                    ci.invokeListenersCleanBegin(this.context, ideLog);
                                    try {
                                        cleanAllResult = this.cleanAll(elements);
                                    }
                                    catch (FailedDeleteError error) {
                                        String message = CompArb.format(93, UnifiedBuildSystem.ra$fileOfFailedDelete(UnifiedBuildSystem.this).getPath());
                                        ci.logOutMsg(message + "\n");
                                        message = CompArb.getString(19);
                                        ci.logOutMsg(message + "\n");
                                    }
                                } else {
                                    ci.invokeListenersBuildBegin(this.context, ideLog);
                                    this.buildAll(elements);
                                }
                            }
                            catch (BuildSystemVetoException e) {
                                buildVetoThrown = true;
                            }
                            catch (RuntimeException e) {
                                if (CompArb.getString(82).equals(e.getMessage())) {
                                    ideLog.error(null, 0, 0, 0, e.getMessage());
                                    break block22;
                                }
                                throw e;
                            }
                        }
                        finally {
                            this.deploymentProfileBuilt.clear();
                            this.projectsBuilt.clear();
                        }
                    }
                    Assert.println((String)"{0} completed [{1}ms]", (Object)(this.cleanAll ? "Clean All" : "Make"), (Object)Long.toString(System.currentTimeMillis() - this.startTime));
                    if (!$assertionsDisabled && !UnifiedBuildSystem.ra$LOG().trace("Build time in msec: " + (System.currentTimeMillis() - this.startTime))) {
                        throw new AssertionError();
                    }
                    if (!buildVetoThrown) {
                        if (this.cleanAll) {
                            ci.invokeListenersCleanFinish(this.context, ideLog);
                        } else {
                            ci.invokeListenersBuildFinish(ideLog);
                        }
                    }
                    UnifiedBuildSystem.ra$translatedWorkspaces(UnifiedBuildSystem.this).clear();
                    UnifiedBuildSystem.ra$suppressedWorkspaces(UnifiedBuildSystem.this).clear();
                    UnifiedBuildSystem.wa$translatedSources(UnifiedBuildSystem.this, null);
                    UnifiedBuildSystem.wa$suppressedSources(UnifiedBuildSystem.this, null);
                    ideLog.completed();
                    ci.logOutEndBuild(this.filesBuilt, this.cleanAll ? (cleanAllResult ? 1 : 2) : 0);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    ci.logOutMsg(CompArb.getString(62) + "\n");
                    ideLog = new IdeLog();
                    ideLog.completed();
                    String message = "Fatal exception during " + (this.cleanAll ? "cleaning" : "compiling") + " of project files";
                    FeedbackManager.reportException((String)message, (Throwable)t);
                }
            }
            if (Ide.getIdeArgs().getCreateUI()) {
                JCompilerMenuItems.getInstance().enableCancelBuild(false);
            }
            this.context = null;
            this.copyResSpec = null;
            this.reverseCopy = false;
        }

        CompileThread(boolean bl, Context context, BuildGraph buildGraph, boolean bl2, boolean bl3, boolean bl4, 1 var8_8) {
            this(bl, context, buildGraph, bl2, bl3, bl4);
        }

        private final class WorkingSetNode
        extends Node {
            WorkingSetNode() {
            }

            IntersectedFilters getFilters(Project prj) {
                WorkingSets workingSets = WorkingSets.getInstance((Workspace)Ide.getActiveWorkspace());
                WorkingSet curWorkingSet = workingSets.getCurrentWorkingSet();
                if (curWorkingSet == null) {
                    curWorkingSet = workingSets.getWorkingSet(WorkingSets.ALL_FILES_WORKING_SET_LABEL);
                }
                if (curWorkingSet == null) {
                    return null;
                }
                PatternFilters filters = curWorkingSet.getPatternFilters(prj);
                if (filters == null) {
                    return null;
                }
                return new IntersectedFilters(filters);
            }
        }

        private class FailedDeleteError
        extends RuntimeException {
            private FailedDeleteError() {
            }

            FailedDeleteError(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        public final class 1 {
        }
    }
}

