/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controller;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.CanceledException;
import oracle.javatools.util.ChangeSupport;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.javatools.util.TypeMap;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.controller.NodeActionControllerBundle;
import oracle.jdeveloper.controller.NodeActionDelegate;
import oracle.jdevimpl.audit.swing.DialogFactory;

public class NodeActionController
implements Controller {
    public static final String SINGLE_SELECTION_TEMPLATE_TEXT = "single-selection-template-text";
    public static final String MULTIPLE_SELECTION_TEXT = "multiple-selection-text";
    private TypeMap delegates;
    private static final Log LOG = new Log("controller");
    private static final FormatBundle bundle = new FormatBundle(NodeActionControllerBundle.class);

    private void $init$() {
        this.delegates = new TypeMap();
    }

    public void addDelegate(Class nodeClass, Class delegateClass) {
        if (!Node.class.isAssignableFrom(nodeClass)) {
            throw new IllegalArgumentException(nodeClass + " not instanceof Node");
        }
        if (!NodeActionDelegate.class.isAssignableFrom(delegateClass)) {
            throw new IllegalArgumentException(delegateClass + " not instanceof NodeActionDelegate");
        }
        if (this.delegates.get(nodeClass) != null) {
            throw new IllegalArgumentException("delegate for " + nodeClass + " already added");
        }
        this.delegates.put(nodeClass, (Object)delegateClass);
    }

    public boolean update(IdeAction action, Context context) {
        boolean enabled;
        boolean handled;
        LOG.trace("updating {0} for {1}", (Object)this, (Object)context);
        String name = (String)action.getValue("NoCtxName");
        if (name == null) {
            name = (String)action.getValue("Name");
            action.putValue("NoCtxName", (Object)name);
        }
        Node node = context.getNode();
        Element[] selection = context.getSelection();
        if (context.getView() instanceof CodeEditor) {
            String text = (String)action.getValue(SINGLE_SELECTION_TEMPLATE_TEXT);
            if (text != null) {
                name = MessageFormat.format(text, node.getShortLabel());
            }
            CodeEditor editor = (CodeEditor)context.getView();
            int[] textSelection = new int[]{editor.getSelectionStart(), editor.getSelectionEnd()};
            handled = this.isHandled(context);
            enabled = this.isEnabled(context, null, textSelection, action);
        } else if (selection.length >= 1) {
            if (selection.length > 1) {
                String text = (String)action.getValue(MULTIPLE_SELECTION_TEXT);
                if (text != null) {
                    name = text;
                }
            } else {
                String text = (String)action.getValue(SINGLE_SELECTION_TEMPLATE_TEXT);
                if (text != null) {
                    name = MessageFormat.format(text, selection[0].getShortLabel());
                }
            }
            if (this.isContainer(selection[0]) || selection[0] instanceof Node) {
                handled = true;
                enabled = true;
                Context childContext = new Context(context);
                int i = 0;
                while (i < selection.length) {
                    if (!this.isContainer(selection[i])) {
                        if (selection[i] instanceof Node) {
                            childContext.setNode((Node)selection[i]);
                            handled = this.isHandled(childContext);
                            enabled = enabled && this.isEnabled(childContext, null, null, action);
                        } else {
                            LOG.trace("element {0} not a container or node", i);
                            handled = false;
                            enabled = false;
                        }
                    }
                    if (handled) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                handled = node != null;
                int i = 0;
                while (handled && i < selection.length) {
                    if (this.isContainer(selection[i]) || selection[i] instanceof Node) {
                        handled = false;
                        LOG.trace("element {0} is a container or node", i);
                    }
                    ++i;
                }
                if (handled) {
                    handled = this.isHandled(context);
                    enabled = this.isEnabled(context, selection, null, action);
                } else {
                    enabled = false;
                }
            }
        } else if (node != null) {
            String text = (String)action.getValue(SINGLE_SELECTION_TEMPLATE_TEXT);
            if (text != null) {
                name = MessageFormat.format(text, node.getShortLabel());
            }
            handled = this.isHandled(context);
            enabled = this.isEnabled(context, null, null, action);
        } else {
            handled = false;
            enabled = false;
        }
        LOG.trace("action enabled {0}, label {1}", enabled, (Object)name);
        action.setEnabled(enabled);
        action.putValue("Name", (Object)name);
        return handled;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        VCSManager vcs;
        String commandName;
        LOG.trace("handling event for {0} on {1}", (Object)action, (Object)context);
        LinkedHashMap handlers = new LinkedHashMap();
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        Element[] selection = context.getSelection();
        if (context.getView() instanceof CodeEditor) {
            CodeEditor editor = (CodeEditor)context.getView();
            int[] textSelection = new int[]{editor.getSelectionStart(), editor.getSelectionEnd()};
            this.queueNode(context, null, textSelection, action, handlers);
        } else if (selection.length >= 1) {
            if (this.isContainer(selection[0]) || selection[0] instanceof Node) {
                int i = 0;
                while (i < selection.length) {
                    if (this.isContainer(selection[i])) {
                        this.queueContainer(selection[i], project, workspace, action, handlers);
                    } else if (selection[i] instanceof Node) {
                        Context childContext = new Context(context);
                        childContext.setNode((Node)selection[i]);
                        this.queueNode(childContext, null, null, action, handlers);
                    }
                    ++i;
                }
            } else {
                this.queueNode(context, selection, null, action, handlers);
            }
        } else if (context.getNode() != null) {
            this.queueNode(context, selection, null, action, handlers);
        }
        if (handlers.isEmpty()) {
            this.showMessageDialog("no-files", null, false);
            return true;
        }
        LinkedHashMap<URL, NodeHandler> readOnlyUnversioned = new LinkedHashMap<URL, NodeHandler>();
        LinkedHashMap<URL, NodeHandler> readOnlyVersioned = new LinkedHashMap<URL, NodeHandler>();
        Iterator i = handlers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            NodeHandler handler = (NodeHandler)entry.getValue();
            URL url = NodeHandler.ra$url(handler);
            if (URLFileSystem.isReadOnly((URL)url)) {
                VCSManager vcs2 = VCSManager.getVCSManager();
                if (vcs2 == null || !vcs2.isVersioned(url)) {
                    readOnlyUnversioned.put(url, handler);
                    i.remove();
                } else {
                    readOnlyVersioned.put(url, handler);
                }
            }
            NodeHandler.wa$dirty(handler, NodeHandler.ra$context(handler).getNode().isDirty());
        }
        LOG.trace("{0} read-only unversioned, {1} read-only versioned, {2} writable", readOnlyUnversioned.size(), readOnlyVersioned.size(), handlers.size());
        if (readOnlyVersioned.isEmpty() && handlers.isEmpty()) {
            this.showFileListDialog(readOnlyUnversioned, "no-mutable", false);
            return true;
        }
        if (!readOnlyUnversioned.isEmpty() && !this.showFileListDialog(readOnlyUnversioned, "skip-immutable", true)) {
            return true;
        }
        if (!readOnlyVersioned.isEmpty() && !this.showFileListDialog(readOnlyVersioned, "make-writable", true)) {
            return true;
        }
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null) {
            List editors = editorManager.getAllEditors();
            int i2 = 0;
            while (i2 < editors.size()) {
                CodeEditor codeEditor;
                Context editorContext;
                URL url;
                NodeHandler handler;
                Editor editor = (Editor)editors.get(i2);
                if (editor instanceof CodeEditor && (handler = (NodeHandler)handlers.get(url = (editorContext = (codeEditor = (CodeEditor)editor).getContext()).getNode().getURL())) != null) {
                    NodeHandler.wa$open(handler, true);
                    NodeHandler.wa$initialSelection(handler, new int[]{codeEditor.getSelectionStart(), codeEditor.getSelectionEnd()});
                }
                ++i2;
            }
        }
        if (!readOnlyVersioned.isEmpty() && context.getNode() != null && (commandName = (vcs = VCSManager.getVCSManager()).getCheckOutCommand(context.getNode())) != null) {
            for (NodeHandler handler : readOnlyVersioned.values()) {
                NodeHandler.wa$checkoutCommand(handler, CommandProcessor.createCommand((String)commandName, (Context)NodeHandler.ra$context(handler)));
            }
        }
        NodeActionCommand command = new NodeActionCommand((String)action.getValue("NoCtxName"), (String)action.getValue("Name"), context, handlers, readOnlyVersioned);
        try {
            CommandProcessor.getInstance().invoke((Command)command);
        }
        catch (Throwable e) {
            throw new UnexpectedExceptionError(e);
        }
        return true;
    }

    private boolean showFileListDialog(Map files, String prefix, boolean cancelable) {
        if (files.size() == 1) {
            URL url = (URL)files.keySet().iterator().next();
            String fileName = URLFileSystem.getFileName((URL)url);
            String directoryName = URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)url));
            return this.showMessageDialog(prefix, new Object[]{fileName, directoryName}, cancelable);
        }
        DialogFactory dialog = new DialogFactory();
        JButton okButton = dialog.addOkButton(null);
        if (cancelable) {
            dialog.addCancelButton(null);
        }
        JPanel content = new JPanel(new GridBagLayout());
        dialog.setContent((Component)content);
        dialog.setTitle(bundle.get(prefix + ".dialog.title"));
        content.setAlignmentX(0.0f);
        content.setAlignmentY(0.0f);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        String message = bundle.get(prefix + ".dialog.n.message", new Object[]{new Integer(files.size())});
        JComponent top = NodeActionController.createTextArea(message);
        content.add((Component)top, constraints);
        constraints.gridx = 1;
        content.add(Box.createHorizontalGlue(), constraints);
        constraints.gridx = 0;
        constraints.insets.top = 5;
        Object[] fileNames = files.keySet().toArray();
        int i = 0;
        while (i < fileNames.length) {
            fileNames[i] = URLFileSystem.getPlatformPathName((URL)((URL)fileNames[i]));
            ++i;
        }
        JList<Object> fileList = new JList<Object>(fileNames);
        fileList.setVisibleRowCount(8);
        JScrollPane fileScrollPane = new JScrollPane(fileList, 20, 31);
        ++constraints.gridy;
        content.add((Component)fileScrollPane, constraints);
        ++constraints.gridy;
        content.add(Box.createVerticalGlue(), constraints);
        return okButton == dialog.show();
    }

    private boolean showMessageDialog(String prefix, Object[] parameters, boolean cancelable) {
        if (!Ide.getIdeArgs().getCreateUI()) {
            return true;
        }
        DialogFactory dialog = new DialogFactory();
        JButton okButton = dialog.addOkButton(null);
        if (cancelable) {
            dialog.addCancelButton(null);
        }
        dialog.setTitle(bundle.get(prefix + ".dialog.title"));
        String message = bundle.get(prefix + ".dialog.message", parameters);
        JComponent content = NodeActionController.createTextArea(message);
        content.setAlignmentX(0.0f);
        content.setAlignmentY(0.0f);
        dialog.setContent((Component)content);
        dialog.setInitialFocus((Component)okButton);
        return okButton == dialog.show();
    }

    private static int showAbortDialog(String prefix, URL url, Throwable exception, String[] choices) {
        String fileName = null;
        String directoryName = null;
        if (url != null) {
            fileName = URLFileSystem.getFileName((URL)url);
            directoryName = URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)url));
        }
        DialogFactory dialog = new DialogFactory();
        dialog.setDefaultCloseButtonIgnored(true);
        JButton okButton = dialog.addOkButton(null);
        okButton.setEnabled(false);
        JPanel content = new JPanel(new GridBagLayout());
        dialog.setContent((Component)content);
        dialog.setTitle(bundle.get(prefix + ".dialog.title"));
        content.setAlignmentX(0.0f);
        content.setAlignmentY(0.0f);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        JComponent top = NodeActionController.createTextArea(bundle.get(prefix + ".dialog.message", new Object[]{fileName, directoryName, exception}));
        content.add((Component)top, constraints);
        constraints.gridx = 1;
        content.add(Box.createHorizontalGlue(), constraints);
        constraints.gridx = 0;
        constraints.insets.top = 5;
        constraints.fill = 2;
        JRadioButton[] buttons = new JRadioButton[choices.length];
        ButtonGroup group = new ButtonGroup();
        1 listener = new 1(buttons, okButton, dialog);
        int i = 0;
        while (i < buttons.length) {
            buttons[i] = new JRadioButton(bundle.get(choices[i], new Object[]{fileName}));
            ++constraints.gridy;
            content.add((Component)buttons[i], constraints);
            group.add(buttons[i]);
            buttons[i].addActionListener(listener);
            ++i;
        }
        ++constraints.gridy;
        content.add(Box.createVerticalGlue(), constraints);
        dialog.show();
        int i2 = 0;
        while (i2 < buttons.length) {
            if (buttons[i2].isSelected()) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private static JComponent createTextArea(String message) {
        JEditorPane textArea = new JEditorPane("text/html", "<html><body>" + message + "</body></html>");
        textArea.setEditable(false);
        textArea.setOpaque(false);
        textArea.setForeground(UIManager.getColor("Label.foreground"));
        textArea.setBackground(UIManager.getColor("Label.background"));
        Font font = textArea.getFont();
        int width = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
        StyleSheet stylesheet = ((HTMLDocument)textArea.getDocument()).getStyleSheet();
        stylesheet.addRule("body {font-size: " + font.getSize() + "pt;" + "font-family: " + font.getFamily() + ";" + "font-weight: " + (font.isBold() ? "bold" : "normal") + ";" + "font-style: " + (font.isItalic() ? "italic" : "normal") + ";" + "color: #" + Integer.toHexString(textArea.getForeground().getRGB() & 0xFFFFFF) + "width: " + width + "px;" + "max-width: " + width + "px;" + "}");
        textArea.setBorder(null);
        textArea.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        return textArea;
    }

    private boolean isContainer(Element element) {
        if (element instanceof Workspaces) {
            return true;
        }
        if (element instanceof Workspace) {
            return true;
        }
        if (element instanceof Project) {
            return true;
        }
        return element instanceof RelativeDirectoryContextFolder;
    }

    protected NodeActionDelegate getDelegate(Node node) {
        Class nodeClass = node.getClass();
        Class delegateClass = (Class)this.delegates.get(nodeClass);
        if (delegateClass == null) {
            LOG.trace("getting no delegate for {0}", (Object)nodeClass);
            return null;
        }
        try {
            LOG.trace("getting delegate {0} for {1}", (Object)delegateClass, (Object)nodeClass);
            NodeActionDelegate nodeActionDelegate = (NodeActionDelegate)delegateClass.newInstance();
            return nodeActionDelegate;
        }
        catch (InstantiationException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
    }

    private boolean isHandled(Context context) {
        return this.delegates.get(context.getNode().getClass()) != null;
    }

    private boolean isEnabled(Context context, Element[] elements, int[] text, IdeAction action) {
        boolean enabled = false;
        Node node = context.getNode();
        NodeActionDelegate delegate = this.getDelegate(node);
        if (delegate != null) {
            enabled = delegate.isEnabled(action, context, elements, text);
        }
        return enabled;
    }

    protected void queueContainer(Element element, Project project, Workspace workspace, IdeAction action, Map queue) {
        if (element instanceof Workspaces) {
            Iterator i = element.getChildren();
            while (i.hasNext()) {
                this.queueContainer((Element)i.next(), null, null, action, queue);
            }
        } else if (element instanceof Workspace) {
            Iterator i = element.getChildren();
            while (i.hasNext()) {
                this.queueContainer((Element)i.next(), null, (Workspace)element, action, queue);
            }
        } else if (element instanceof Project) {
            WorkingSets sets;
            WorkingSet ws;
            project = (Project)element;
            WorkingSet set = null;
            if (workspace != null && (ws = (sets = WorkingSets.getInstance((Workspace)workspace)).getCurrentWorkingSet()) != sets.getWorkingSet(WorkingSets.ALL_FILES_WORKING_SET_LABEL)) {
                set = ws;
            }
            Iterator iterator = set != null && set.getPatternFilters(project) != null ? ProjectContent.getInstance((PropertyStorage)project).getAllContents().nodeIterator("", new IntersectedFilters(set.getPatternFilters(project))) : project.getChildren();
            while (iterator.hasNext()) {
                this.queueContainer((Element)iterator.next(), project, workspace, action, queue);
            }
        } else if (element instanceof RelativeDirectoryContextFolder) {
            Iterator i = element.getChildren();
            while (i.hasNext()) {
                this.queueContainer((Element)i.next(), project, workspace, action, queue);
            }
        } else if (element instanceof Node) {
            Node node = (Node)element;
            Context context = new Context(null, workspace, project, node);
            this.queueNode(context, null, null, action, queue);
        }
    }

    private void queueNode(Context context, Element[] elements, int[] text, IdeAction action, Map queue) {
        NodeActionDelegate delegate;
        Node node = context.getNode();
        URL url = node.getURL();
        if (!queue.containsKey(url) && (delegate = this.getDelegate(node)) != null && delegate.isEnabled(action, context, elements, text)) {
            LOG.trace("queueing {0} delegating to {1}", (Object)url, (Object)delegate);
            NodeHandler handler = new NodeHandler(null);
            NodeHandler.wa$action(handler, action);
            NodeHandler.wa$elementSelection(handler, elements);
            NodeHandler.wa$textSelection(handler, text);
            NodeHandler.wa$context(handler, context);
            NodeHandler.wa$url(handler, url);
            NodeHandler.wa$delegate(handler, delegate);
            queue.put(url, handler);
        }
    }

    private void fireStructureChanged(Context context) {
        Node node = context.getNode();
        UpdateMessage message = new UpdateMessage(UpdateMessage.STRUCTURE_CHANGED, (Object)node);
        node.notifyObservers((Object)node, message);
    }

    public NodeActionController() {
        this.$init$();
    }

    static FormatBundle ra$bundle() {
        return bundle;
    }

    static Log ra$LOG() {
        return LOG;
    }

    static int maS$showAbortDialog(String string, URL uRL, Throwable throwable, String[] stringArray) {
        return NodeActionController.showAbortDialog(string, uRL, throwable, stringArray);
    }

    private static class NodeActionCommand
    extends Command {
        private String label;
        private Map handlersToCheckout;
        private Map handlersToDo;
        private Map handlersToUncheckout;
        private Map handlersToUndo;
        private Set handlersSkipped;
        private Node[] nodes;
        private ProgressMonitor progress;
        private ProgressModel model;
        private boolean reverting;
        private boolean vcsPhase;
        private boolean msgLogWindowLogging;

        private void $init$() {
            this.handlersToUncheckout = new LinkedHashMap();
            this.handlersToUndo = new LinkedHashMap();
            this.handlersSkipped = new LinkedHashSet();
        }

        public NodeActionCommand(String name, String label, Context context, Map handlers, Map readOnlyHandlers) {
            super(Ide.findOrCreateCmdID((String)name), 3, name);
            this.$init$();
            this.setContext(context);
            this.label = label;
            this.handlersToCheckout = readOnlyHandlers;
            this.handlersToDo = handlers;
            Node node = context.getNode();
            this.msgLogWindowLogging = node instanceof Project || node instanceof Workspace;
        }

        public Node[] getAffectedNodes() {
            if (this.nodes == null) {
                this.nodes = new Node[this.handlersToDo.size()];
                int index = 0;
                Iterator i = this.handlersToDo.values().iterator();
                while (i.hasNext()) {
                    this.nodes[index++] = NodeHandler.ra$context((NodeHandler)i.next()).getNode();
                }
            }
            return this.nodes;
        }

        private void advance(String major, String minor) {
            if (this.model.isCanceled()) {
                this.reverting = true;
                throw new CanceledException();
            }
            this.model.set(major, this.model.getProgress() + 1, minor);
        }

        private void revert(String major, String minor) {
            this.model.set(major, this.model.getProgress() - 1, minor);
        }

        private void log(String message) {
            if (Ide.getIdeArgs().getCreateUI()) {
                LogManager.getLogManager().getMsgPage().log((Object)(message + '\n'));
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public int doit() throws Exception {
            int status;
            void var1_2;
            this.getAffectedNodes();
            if (this.msgLogWindowLogging) {
                this.log(NodeActionController.ra$bundle().get("status.doing", new Object[]{this.label}));
            }
            this.reverting = false;
            this.handlersSkipped.clear();
            this.model = new ProgressModel();
            this.progress = new ProgressMonitor(this.label);
            this.progress.setSynchronous(this.handlersToCheckout.isEmpty() && this.handlersToDo.size() <= 1);
            Do do_ = new Do(null);
            block17: while (true) {
                NodeActionController.ra$LOG().trace("starting execution using {0}", (Object)var1_2);
                this.model.setCanceled(false);
                this.model.setMaximum(this.handlersToCheckout.size() + this.handlersToDo.size());
                Throwable exception = this.progress.execute((Runnable)var1_2, 0, this.model);
                if (exception == null) {
                    exception = var1_2.getException();
                }
                NodeActionController.ra$LOG().trace("completed execution, exception {0}", (Object)exception);
                if (exception == null) {
                    status = this.reverting ? 1 : 0;
                    break;
                }
                this.reverting = false;
                if (exception instanceof CanceledException) {
                    String[] choices = new String[]{"cancel.cancel.button.label", "cancel.stop.button.label", "cancel.continue.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("cancel", null, null, choices)) {
                        case 0: {
                            this.reverting = true;
                            Undo undo = new Undo(null);
                            break;
                        }
                        case 1: {
                            status = 0;
                            break block17;
                        }
                        case 2: {
                            break;
                        }
                    }
                } else if (this.vcsPhase) {
                    Iterator iterator = this.handlersToCheckout.keySet().iterator();
                    URL url = (URL)iterator.next();
                    String[] choices = new String[]{"checkout-failed.cancel.button.label", "checkout-failed.stop.button.label", "checkout-failed.skip.button.label", "checkout-failed.retry.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("checkout-failed", url, exception, choices)) {
                        case 0: {
                            this.reverting = true;
                            Undo undo = new Undo(null);
                            break;
                        }
                        case 1: {
                            status = 0;
                            break block17;
                        }
                        case 2: {
                            iterator.remove();
                            this.handlersSkipped.add(url);
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                } else {
                    Iterator iterator = this.handlersToDo.keySet().iterator();
                    URL url = (URL)iterator.next();
                    String[] choices = new String[]{"modification-failed.cancel.button.label", "modification-failed.stop.button.label", "modification-failed.skip.button.label", "modification-failed.retry.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("modification-failed", url, exception, choices)) {
                        case 0: {
                            this.reverting = true;
                            Undo undo = new Undo(null);
                            break;
                        }
                        case 1: {
                            status = 0;
                            break block17;
                        }
                        case 2: {
                            iterator.remove();
                            this.handlersSkipped.add(url);
                            break;
                        }
                        case 3: 
                    }
                }
                if (var1_2 instanceof Do) {
                    this.log(NodeActionController.ra$bundle().get("status.continuing", new Object[]{this.label}));
                    continue;
                }
                this.log(NodeActionController.ra$bundle().get("status.cancelling", new Object[]{this.label}));
            }
            if (var1_2 instanceof Do) {
                if (!this.msgLogWindowLogging) return status;
                this.log(NodeActionController.ra$bundle().get("status.completed", new Object[]{this.label}));
                return status;
            }
            this.log(NodeActionController.ra$bundle().get("status.cancelled", new Object[]{this.label}));
            return status;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public int undo() throws Exception {
            int status;
            void var1_2;
            if (this.msgLogWindowLogging) {
                this.log(NodeActionController.ra$bundle().get("status.undoing", new Object[]{this.label}));
            }
            this.reverting = false;
            this.handlersSkipped.clear();
            this.model = new ProgressModel();
            this.progress = new ProgressMonitor(this.label);
            this.progress.setSynchronous(this.handlersToUncheckout.isEmpty() && this.handlersToUndo.size() <= 1);
            Undo undo = new Undo(null);
            block17: while (true) {
                NodeActionController.ra$LOG().trace("starting execution using {0}", (Object)var1_2);
                this.model.setCanceled(false);
                this.model.setMaximum(this.handlersToUncheckout.size() + this.handlersToUndo.size());
                Throwable exception = this.progress.execute((Runnable)var1_2, 0, this.model);
                if (exception == null) {
                    exception = var1_2.getException();
                }
                NodeActionController.ra$LOG().trace("completed execution, exception {0}", (Object)exception);
                if (exception == null) {
                    status = this.reverting ? 1 : 0;
                    break;
                }
                this.reverting = false;
                if (exception instanceof CanceledException) {
                    String[] choices = new String[]{"cancel-undo.cancel.button.label", "cancel-undo.stop.button.label", "cancel-undo.continue.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("cancel-undo", null, null, choices)) {
                        case 0: {
                            this.reverting = true;
                            Do do_ = new Do(null);
                            break;
                        }
                        case 1: {
                            status = 0;
                            break block17;
                        }
                        case 2: {
                            break;
                        }
                    }
                } else if (this.vcsPhase) {
                    Iterator iterator = this.handlersToUncheckout.keySet().iterator();
                    URL url = (URL)iterator.next();
                    String[] choices = new String[]{"uncheckout-failed.cancel.button.label", "uncheckout-failed.stop.button.label", "uncheckout-failed.skip.button.label", "uncheckout-failed.retry.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("uncheckout-failed", url, exception, choices)) {
                        case 0: {
                            this.reverting = true;
                            Do do_ = new Do(null);
                            break;
                        }
                        case 1: {
                            status = 0;
                            break block17;
                        }
                        case 2: {
                            iterator.remove();
                            this.handlersSkipped.add(url);
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                } else {
                    Iterator iterator = this.handlersToUndo.keySet().iterator();
                    URL url = (URL)iterator.next();
                    String[] choices = new String[]{"unmodification-failed.cancel.button.label", "unmodification-failed.stop.button.label", "unmodification-failed.skip.button.label", "unmodification-failed.retry.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("unmodification-failed", url, exception, choices)) {
                        case 0: {
                            this.reverting = true;
                            Do do_ = new Do(null);
                            break;
                        }
                        case 1: {
                            status = 0;
                            break block17;
                        }
                        case 2: {
                            iterator.remove();
                            this.handlersSkipped.add(url);
                            break;
                        }
                        case 3: 
                    }
                }
                if (var1_2 instanceof Undo) {
                    this.log(NodeActionController.ra$bundle().get("status.continuing-undo", new Object[]{this.label}));
                    continue;
                }
                this.log(NodeActionController.ra$bundle().get("status.cancelling-undo", new Object[]{this.label}));
            }
            if (var1_2 instanceof Undo) {
                if (!this.msgLogWindowLogging) return status;
                this.log(NodeActionController.ra$bundle().get("status.completed-undo", new Object[]{this.label}));
                return status;
            }
            this.log(NodeActionController.ra$bundle().get("status.cancelled-undo", new Object[]{this.label}));
            return status;
        }

        static void wa$vcsPhase(NodeActionCommand nodeActionCommand, boolean bl) {
            nodeActionCommand.vcsPhase = bl;
        }

        static Map ra$handlersToCheckout(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.handlersToCheckout;
        }

        static Set ra$handlersSkipped(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.handlersSkipped;
        }

        static boolean ra$reverting(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.reverting;
        }

        static void mav$advance(NodeActionCommand nodeActionCommand, String string, String string2) {
            nodeActionCommand.advance(string, string2);
        }

        static void mav$revert(NodeActionCommand nodeActionCommand, String string, String string2) {
            nodeActionCommand.revert(string, string2);
        }

        static Map ra$handlersToUncheckout(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.handlersToUncheckout;
        }

        static void mav$log(NodeActionCommand nodeActionCommand, String string) {
            nodeActionCommand.log(string);
        }

        static Map ra$handlersToDo(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.handlersToDo;
        }

        static Map ra$handlersToUndo(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.handlersToUndo;
        }

        private abstract class Task
        implements Runnable {
            private Throwable exception;

            public final void run() {
                this.exception = null;
                try {
                    this.execute();
                }
                catch (Throwable e) {
                    this.exception = e;
                }
            }

            public Throwable getException() {
                return this.exception;
            }

            protected abstract void execute() throws Exception;

            private Task() {
            }

            Task(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private class Do
        extends Task {
            public void execute() throws Exception {
                NodeActionController.ra$LOG().trace("running Do phase 1");
                NodeActionCommand.wa$vcsPhase(NodeActionCommand.this, false);
                Iterator i = NodeActionCommand.ra$handlersToCheckout(NodeActionCommand.this).values().iterator();
                while (i.hasNext()) {
                    NodeActionCommand.wa$vcsPhase(NodeActionCommand.this, true);
                    NodeHandler handler = (NodeHandler)i.next();
                    URL url = NodeHandler.ra$url(handler);
                    if (NodeActionCommand.ra$handlersSkipped(NodeActionCommand.this).contains(url)) continue;
                    if (!NodeActionCommand.ra$reverting(NodeActionCommand.this)) {
                        NodeActionCommand.mav$advance(NodeActionCommand.this, NodeActionController.ra$bundle().get("do.make-writable.major.label"), NodeActionController.ra$bundle().get("do.make-writable.minor.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    } else {
                        NodeActionCommand.mav$revert(NodeActionCommand.this, NodeActionController.ra$bundle().get("do.make-writable.major.reverting, label"), NodeActionController.ra$bundle().get("do.make-writable.minor.reverting.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    }
                    NodeHandler.ra$checkoutCommand(handler).doit();
                    i.remove();
                    NodeActionCommand.ra$handlersToUncheckout(NodeActionCommand.this).put(url, handler);
                    NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.made-writable", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                }
                NodeActionCommand.wa$vcsPhase(NodeActionCommand.this, false);
                NodeActionController.ra$LOG().trace("running Do phase 2");
                URL url = null;
                Iterator i2 = NodeActionCommand.ra$handlersToDo(NodeActionCommand.this).values().iterator();
                while (i2.hasNext()) {
                    NodeHandler handler = (NodeHandler)i2.next();
                    url = NodeHandler.ra$url(handler);
                    if (NodeActionCommand.ra$handlersSkipped(NodeActionCommand.this).contains(url)) continue;
                    if (!NodeActionCommand.ra$reverting(NodeActionCommand.this)) {
                        NodeActionCommand.mav$advance(NodeActionCommand.this, NodeActionController.ra$bundle().get("do.process.major.label"), NodeActionController.ra$bundle().get("do.process.minor.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    } else {
                        NodeActionCommand.mav$revert(NodeActionCommand.this, NodeActionController.ra$bundle().get("do.process.major.reverting, label"), NodeActionController.ra$bundle().get("do.process.minor.reverting.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    }
                    NodeHandler.wa$saved(handler, false);
                    handler.doAction();
                    i2.remove();
                    NodeActionCommand.ra$handlersToUndo(NodeActionCommand.this).put(url, handler);
                    if (NodeHandler.ra$open(handler) || NodeHandler.ra$dirty(handler)) continue;
                    try {
                        NodeActionController.ra$LOG().trace("saving {0}", (Object)url);
                        NodeHandler.ra$context(handler).getNode().save();
                        NodeHandler.wa$saved(handler, true);
                        NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.saved", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    }
                    catch (IOException e) {
                        NodeActionController.ra$LOG().trace("exception saving {0}: {1}", (Object)url, (Object)e);
                        NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.save-failed", new Object[]{URLFileSystem.getPlatformPathName((URL)url), e}));
                    }
                }
            }

            private Do() {
                super(null);
            }

            Do(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private class Undo
        extends Task {
            public void execute() throws Exception {
                NodeActionController.ra$LOG().trace("running Do phase 1");
                NodeActionCommand.wa$vcsPhase(NodeActionCommand.this, false);
                URL url = null;
                Iterator i = NodeActionCommand.ra$handlersToUndo(NodeActionCommand.this).values().iterator();
                while (i.hasNext()) {
                    NodeHandler handler = (NodeHandler)i.next();
                    url = NodeHandler.ra$url(handler);
                    if (NodeActionCommand.ra$handlersSkipped(NodeActionCommand.this).contains(url)) continue;
                    if (!NodeActionCommand.ra$reverting(NodeActionCommand.this)) {
                        NodeActionCommand.mav$advance(NodeActionCommand.this, NodeActionController.ra$bundle().get("undo.process.major.label"), NodeActionController.ra$bundle().get("undo.process.minor.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    } else {
                        NodeActionCommand.mav$revert(NodeActionCommand.this, NodeActionController.ra$bundle().get("undo.process.major.reverting, label"), NodeActionController.ra$bundle().get("undo.process.minor.reverting.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    }
                    handler.undoAction();
                    i.remove();
                    NodeActionCommand.ra$handlersToDo(NodeActionCommand.this).put(url, handler);
                    if (!NodeHandler.ra$saved(handler)) continue;
                    try {
                        NodeHandler.ra$context(handler).getNode().save();
                        NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.saved", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    }
                    catch (IOException e) {
                        NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.save-failed", new Object[]{URLFileSystem.getPlatformPathName((URL)url), e}));
                    }
                    NodeHandler.wa$saved(handler, false);
                }
                NodeActionController.ra$LOG().trace("running Undo phase 2");
                Iterator i2 = NodeActionCommand.ra$handlersToUncheckout(NodeActionCommand.this).values().iterator();
                while (i2.hasNext()) {
                    NodeActionCommand.wa$vcsPhase(NodeActionCommand.this, true);
                    NodeHandler handler = (NodeHandler)i2.next();
                    url = NodeHandler.ra$url(handler);
                    if (NodeActionCommand.ra$handlersSkipped(NodeActionCommand.this).contains(url)) continue;
                    if (!NodeActionCommand.ra$reverting(NodeActionCommand.this)) {
                        NodeActionCommand.mav$advance(NodeActionCommand.this, NodeActionController.ra$bundle().get("undo.make-writable.major.label"), NodeActionController.ra$bundle().get("undo.make-writable.minor.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    } else {
                        NodeActionCommand.mav$revert(NodeActionCommand.this, NodeActionController.ra$bundle().get("undo.make-writable.major.reverting, label"), NodeActionController.ra$bundle().get("undo.make-writable.minor.reverting.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    }
                    NodeHandler.ra$checkoutCommand(handler).undo();
                    i2.remove();
                    NodeActionCommand.ra$handlersToCheckout(NodeActionCommand.this).put(NodeHandler.ra$url(handler), handler);
                    NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.restored", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                }
            }

            private Undo() {
                super(null);
            }

            Undo(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }

    private static class NodeHandler {
        private IdeAction action;
        private Context context;
        private URL url;
        private Element[] elementSelection;
        private int[] textSelection;
        private NodeActionDelegate delegate;
        private boolean open;
        private int[] initialSelection;
        private Command checkoutCommand;
        private boolean dirty;
        private boolean saved;

        private void $init$() {
            this.open = false;
            this.initialSelection = null;
            this.dirty = false;
            this.saved = false;
        }

        public void doAction() throws Exception {
            NodeActionController.ra$LOG().trace("invoking delegate {0} doAction for {1}", (Object)this.delegate, (Object)this.url);
            this.context.getNode().ensureOpen();
            int[] newSelection = this.delegate.doAction(this.context, this.elementSelection, this.textSelection, this.action);
            if (newSelection != null && newSelection.length == 2) {
                this.changeSelection(this.context.getWorkspace(), this.context.getProject(), this.url, newSelection[0], newSelection[1] - newSelection[0]);
            } else if (this.textSelection != null && this.textSelection.length == 2) {
                this.changeSelection(this.context.getWorkspace(), this.context.getProject(), this.url, this.textSelection[0], this.textSelection[1] - this.textSelection[0]);
            }
        }

        public void undoAction() {
            NodeActionController.ra$LOG().trace("invoking delegate {0} undoAction for {1}", (Object)this.delegate, (Object)this.url);
            this.context.getNode().ensureOpen();
            this.delegate.undoAction(this.context, this.elementSelection, this.textSelection, this.action);
            if (this.textSelection != null && this.textSelection.length == 2) {
                this.changeSelection(this.context.getWorkspace(), this.context.getProject(), this.url, this.textSelection[0], this.textSelection[1] - this.textSelection[0]);
            }
        }

        public String toString() {
            return "NodeHandler " + URLFileSystem.getFileName((URL)this.url);
        }

        private void changeSelection(Workspace workspace, Project project, URL url, int offset, int length) {
            Ide.setActiveWorkspace((Workspace)workspace);
            Ide.setActiveProject((Project)project);
            Node node = NodeFactory.find((URL)url);
            Context context = new Context(null, workspace, project, node);
            OffsetNavigationPoint point = new OffsetNavigationPoint(context, offset, length);
            try {
                NavigationManager navigator = NavigationManager.getNavigationManager();
                if (navigator != null) {
                    navigator.navigateTo((NavigationPoint)point);
                }
            }
            catch (Exception e) {
                Log.error((String)"opening {0} failed: {1}", (Object)context, (Object)e);
            }
        }

        private NodeHandler() {
            this.$init$();
        }

        NodeHandler(1 var1_1) {
            this();
        }

        static void wa$action(NodeHandler nodeHandler, IdeAction ideAction) {
            nodeHandler.action = ideAction;
        }

        static void wa$elementSelection(NodeHandler nodeHandler, Element[] elementArray) {
            nodeHandler.elementSelection = elementArray;
        }

        static void wa$textSelection(NodeHandler nodeHandler, int[] nArray) {
            nodeHandler.textSelection = nArray;
        }

        static void wa$context(NodeHandler nodeHandler, Context context) {
            nodeHandler.context = context;
        }

        static void wa$url(NodeHandler nodeHandler, URL uRL) {
            nodeHandler.url = uRL;
        }

        static void wa$delegate(NodeHandler nodeHandler, NodeActionDelegate nodeActionDelegate) {
            nodeHandler.delegate = nodeActionDelegate;
        }

        static URL ra$url(NodeHandler nodeHandler) {
            return nodeHandler.url;
        }

        static Context ra$context(NodeHandler nodeHandler) {
            return nodeHandler.context;
        }

        static void wa$dirty(NodeHandler nodeHandler, boolean bl) {
            nodeHandler.dirty = bl;
        }

        static void wa$open(NodeHandler nodeHandler, boolean bl) {
            nodeHandler.open = bl;
        }

        static void wa$initialSelection(NodeHandler nodeHandler, int[] nArray) {
            nodeHandler.initialSelection = nArray;
        }

        static void wa$checkoutCommand(NodeHandler nodeHandler, Command command) {
            nodeHandler.checkoutCommand = command;
        }

        static Command ra$checkoutCommand(NodeHandler nodeHandler) {
            return nodeHandler.checkoutCommand;
        }

        static void wa$saved(NodeHandler nodeHandler, boolean bl) {
            nodeHandler.saved = bl;
        }

        static boolean ra$open(NodeHandler nodeHandler) {
            return nodeHandler.open;
        }

        static boolean ra$dirty(NodeHandler nodeHandler) {
            return nodeHandler.dirty;
        }

        static boolean ra$saved(NodeHandler nodeHandler) {
            return nodeHandler.saved;
        }

        public final class 1 {
        }
    }

    static final class 1
    implements ActionListener {
        private final /* synthetic */ JRadioButton[] v$buttons;
        private final /* synthetic */ JButton v$okButton;
        private final /* synthetic */ DialogFactory v$dialog;

        public void actionPerformed(ActionEvent e) {
            boolean enabled = false;
            int i = 0;
            while (i < this.v$buttons.length) {
                enabled |= this.v$buttons[i].isSelected();
                ++i;
            }
            this.v$okButton.setEnabled(enabled);
            this.v$dialog.setDefaultCloseButtonIgnored(enabled ^ true);
        }

        public 1(JRadioButton[] jRadioButtonArray, JButton jButton, DialogFactory dialogFactory) {
            this.v$dialog = dialogFactory;
            this.v$okButton = jButton;
            this.v$buttons = jRadioButtonArray;
        }
    }

    private static class ProgressModel {
        private int minimum;
        private int maximum;
        private int progress;
        private String majorStep;
        private String minorStep;
        private ChangeSupport support;
        private boolean canceled;

        private void $init$() {
            this.maximum = 100;
            this.support = new ChangeSupport((Object)this);
        }

        public ProgressModel() {
            this.$init$();
        }

        public ProgressModel(int minimum, int maximum) {
            this.$init$();
            this.minimum = minimum;
            this.maximum = maximum;
            this.progress = minimum;
        }

        public void addChangeListener(ChangeListener listener) {
            this.support.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.support.removeChangeListener(listener);
        }

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public synchronized int getMinimum() {
            return this.minimum;
        }

        public synchronized void setMinimum(int minimum) {
            this.minimum = minimum;
            this.support.fireStateChanged();
        }

        public synchronized int getMaximum() {
            return this.maximum;
        }

        public synchronized void setMaximum(int maximum) {
            this.maximum = maximum;
            this.support.fireStateChanged();
        }

        public synchronized int getProgress() {
            return this.progress;
        }

        public synchronized void setProgress(int progress) {
            this.progress = progress;
            this.support.fireStateChanged();
        }

        public synchronized String getMajorStep() {
            return this.majorStep;
        }

        public synchronized void setMajorStep(String majorStep) {
            this.majorStep = majorStep;
            this.support.fireStateChanged();
        }

        public synchronized String getMinorStep() {
            return this.minorStep;
        }

        public synchronized void setMinorStep(String minorStep) {
            this.minorStep = minorStep;
            this.support.fireStateChanged();
        }

        public synchronized void set(String majorStep, int progress, String minorStep) {
            if (majorStep != null) {
                this.majorStep = majorStep;
            }
            if (progress >= this.minimum && progress < this.maximum) {
                this.progress = progress;
            }
            if (minorStep != null) {
                this.minorStep = minorStep;
            }
            this.support.fireStateChanged();
        }
    }

    private static class ProgressMonitor {
        private String title;
        private ProgressDialog dialog;
        private boolean synchronous;
        private Runnable task;
        private ProgressModel model;
        private Throwable exception;

        public ProgressMonitor(String title) {
            this.title = title;
        }

        public boolean isSynchronous() {
            return this.synchronous;
        }

        public void setSynchronous(boolean synchronous) {
            this.synchronous = synchronous;
        }

        public Throwable execute(Runnable task, int delay, ProgressModel model) {
            NodeActionController.ra$LOG().trace("monitor execute");
            this.task = task;
            this.model = model;
            this.exception = null;
            model.addChangeListener(new 1());
            if (this.synchronous) {
                this.execute();
            } else {
                SwingUtilities.invokeLater(new 2());
                this.start();
            }
            return this.exception;
        }

        private void modelChanged() {
            if (this.dialog != null) {
                this.dialog.setMajorLabelText(this.model.getMajorStep());
                this.dialog.setProgress(this.model.getProgress());
                this.dialog.setMinorLabelText(this.model.getMinorStep());
            }
        }

        private void execute() {
            NodeActionController.ra$LOG().trace("monitor execute  task");
            try {
                try {
                    this.task.run();
                    NodeActionController.ra$LOG().trace("task completed");
                }
                catch (Throwable e) {
                    this.exception = e;
                }
            }
            finally {
                EventQueue.invokeLater(new 3());
            }
        }

        private void start() {
            NodeActionController.ra$LOG().trace("monitor start, {0}", (Object)this.dialog);
            if (this.dialog == null) {
                this.dialog = new ProgressDialog(this.title, this.model.getMinimum(), this.model.getMaximum());
                this.dialog.setColumns(80);
                this.dialog.addCancelAction(new 4());
            }
            this.dialog.setMajorLabelText(this.model.getMajorStep());
            this.dialog.setProgress(this.model.getProgress());
            this.dialog.setMinorLabelText(this.model.getMinorStep());
            this.dialog.show();
        }

        private void cancel() {
            NodeActionController.ra$LOG().trace("monitor cancel");
            this.model.setCanceled(true);
        }

        private void finish() {
            NodeActionController.ra$LOG().trace("monitor finish");
            if (this.dialog != null) {
                this.dialog.hide();
            }
        }

        static void mav$cancel(ProgressMonitor progressMonitor) {
            progressMonitor.cancel();
        }

        static void mav$finish(ProgressMonitor progressMonitor) {
            progressMonitor.finish();
        }

        static void mav$modelChanged(ProgressMonitor progressMonitor) {
            progressMonitor.modelChanged();
        }

        static void mav$execute(ProgressMonitor progressMonitor) {
            progressMonitor.execute();
        }

        final class 1
        implements ChangeListener {
            public void stateChanged(ChangeEvent event) {
                ProgressMonitor.mav$modelChanged(ProgressMonitor.this);
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                ProgressMonitor.mav$execute(ProgressMonitor.this);
            }
        }

        final class 3
        implements Runnable {
            public void run() {
                ProgressMonitor.mav$finish(ProgressMonitor.this);
            }
        }

        final class 4
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                ProgressMonitor.mav$cancel(ProgressMonitor.this);
            }
        }
    }

    private static class ProgressDialog {
        private JLabel majorLabel = new JLabel("Initializing");
        private JProgressBar bar;
        private JLabel minorLabel;
        private DialogFactory dialog;

        public ProgressDialog(String title, int minimum, int maximum) {
            this.bar = new JProgressBar(minimum, maximum);
            this.minorLabel = new JLabel(" ");
            JPanel content = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 17;
            content.add((Component)this.majorLabel, constraints);
            ++constraints.gridy;
            content.add((Component)this.bar, constraints);
            ++constraints.gridy;
            content.add((Component)this.minorLabel, constraints);
            ++constraints.gridy;
            content.add(Box.createHorizontalStrut(450), constraints);
            this.dialog = new DialogFactory();
            this.dialog.setTitle(title);
            this.dialog.setContent((Component)content);
        }

        public void setColumns(int columns) {
            int em = this.majorLabel.getFontMetrics(this.majorLabel.getFont()).charWidth('m');
            Dimension size = new Dimension(columns * em, this.majorLabel.getPreferredSize().height);
            this.majorLabel.setPreferredSize(size);
            this.minorLabel.setPreferredSize(size);
        }

        public void setMajorLabelText(String text) {
            if (text != null) {
                this.majorLabel.setText(text);
            }
        }

        public void setProgress(int progress) {
            if (progress >= this.bar.getMinimum() && progress <= this.bar.getMaximum()) {
                this.bar.setValue(progress);
            }
        }

        public void setMinorLabelText(String text) {
            if (text != null) {
                this.minorLabel.setText(text);
            }
        }

        public void addCancelAction(ActionListener listener) {
            this.dialog.addCancelAction(listener);
        }

        public void show() {
            this.dialog.show();
        }

        public void hide() {
            this.dialog.hide();
        }
    }
}

