/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.controls.classpick.TextFieldAdapter;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;

public class ClassPopup
extends JTextField
implements ActionListener {
    private Project _proj;
    protected JavaManager _javaManager;
    protected BrowseHandler _browseHandler;
    protected AbstractPicker.PickerResultValidator validator;
    protected ClassBuilderModel cbModel;

    private void $init$() {
        this.validator = null;
        this.cbModel = null;
    }

    public ClassPopup() {
        this.$init$();
        this.addFocusListener(new SelectOnFocusListener(null));
    }

    public ClassPopup(Project proj) {
        this();
        this.setProject(proj);
    }

    public void setProject(Project proj) {
        this._proj = proj;
        this._javaManager = JavaManager.getJavaManager((Project)this._proj);
    }

    public Project getProject() {
        return this._proj;
    }

    public AbstractPicker.PickerResultValidator getValidator() {
        return this.validator;
    }

    public void setValidator(AbstractPicker.PickerResultValidator newValidator) {
        this.validator = newValidator;
    }

    public ClassBuilderModel getClassBuilderModel() {
        return this.cbModel;
    }

    public void setClassBuilderModel(ClassBuilderModel classBuilderModel) {
        this.cbModel = classBuilderModel;
        TextFieldAdapter textFieldAdapter = ClassPickerFactory.attach(this, this.cbModel.getContext(), 8);
    }

    public void actionPerformed(ActionEvent e) {
        this.doBrowse();
    }

    protected void doBrowse() {
        String initialSelection;
        String[] classes;
        Assert.println((this._proj == null ? 1 : 0) != 0, (String)"Attempting to browse for a class with no project set.");
        if (this._proj != null && (classes = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this._proj, 2, false, new ClassFilter(null), initialSelection = this.getText())).length > 0) {
            this.setBrowseResult(classes[0]);
        }
    }

    protected final void setBrowseResult(Object result) {
        if (this.validator == null || this.validator.isResultValid(result)) {
            Object value = this.cbModel != null ? this.cbModel.encodeValue(result) : result;
            this.setText(value.toString());
        }
    }

    private class ClassFilter
    implements ClassPackageBrowserFilterV2 {
        public boolean acceptPackage(String pkg) {
            return true;
        }

        public boolean acceptClass(JavaClass cls) {
            return ClassPopup.this.validator == null || ClassPopup.this.validator.isResultValid((Object)cls);
        }

        private ClassFilter() {
        }

        ClassFilter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SelectOnFocusListener
    implements FocusListener {
        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            ClassPopup.this.selectAll();
        }

        private SelectOnFocusListener() {
        }

        SelectOnFocusListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

