/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;

public class PackagePopup
extends JTextField
implements ActionListener {
    protected Project _project;
    protected JavaManager _javaManager;
    protected BrowseHandler _browseHandler;

    public PackagePopup() {
        this.addFocusListener(new SelectOnFocusListener(null));
    }

    public PackagePopup(Project project) {
        this();
        this.setProject(project);
    }

    public void setProject(Project project) {
        Assert.check((project != null ? 1 : 0) != 0);
        this._project = project;
        this._javaManager = JavaManager.getJavaManager((Project)this._project);
        this._browseHandler = BrowseHandler.createPackageBrowserPopup(this._javaManager, this, null);
    }

    public String getPackage() {
        return this._browseHandler != null ? this._browseHandler.getSelectedItem() : this.getText();
    }

    public void setPackage(String pkgName) {
        this.setText(pkgName);
    }

    public void actionPerformed(ActionEvent e) {
        this.doBrowse();
    }

    protected void doBrowse() {
        Assert.println((this._project == null ? 1 : 0) != 0, (String)"Cannot browse for a package without first setting the project.");
        int mode = 1;
        ClassPackageBrowserV2 browserDlg = new ClassPackageBrowserV2();
        String[] result = browserDlg.browseClassOrPackage(this._javaManager, mode, false, (ClassPackageBrowserFilterV2)null, this.getText());
        if (result.length > 0) {
            this.setBrowseResult(result[0]);
        }
    }

    protected final void setBrowseResult(Object result) {
        if (result != null && this.isResultValid(result)) {
            this.setPackage((String)result);
        }
    }

    private boolean isResultValid(Object value) {
        boolean result = false;
        if (value instanceof String) {
            result = IdeUtil.isPackageIdentifier((String)((String)value));
        }
        return result;
    }

    private class SelectOnFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            PackagePopup.this.selectAll();
        }

        public void focusLost(FocusEvent e) {
        }

        private SelectOnFocusListener() {
        }

        SelectOnFocusListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

