/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls.classpick;

import javax.swing.Icon;
import oracle.javatools.icons.OracleIcons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Entry
implements Comparable {
    public static final int TYPE_PACKAGE = 0;
    public static final int TYPE_CLASS = 10;
    public static final int TYPE_INTERFACE = 11;
    public static final int TYPE_DOTDOTDOT = 20;
    private int _type;
    private String _packageName;
    private String _className;
    private String _text;

    public Entry(int type, String packageName, String className, String text) {
        this._type = type;
        this._packageName = packageName;
        this._className = className;
        this._text = text;
    }

    public int compareTo(Object thatObject) {
        int ret = -1;
        if (thatObject instanceof Entry) {
            int thatType;
            Entry that = (Entry)thatObject;
            int thisType = this.getType();
            ret = thisType / 10 == (thatType = that.getType()) / 10 ? this.toString().compareTo(that.toString()) : thisType - thatType;
        }
        return ret;
    }

    static Entry createClassEntry(String packageName, String className) {
        return new Entry(10, packageName, className, className + " (" + packageName + ")");
    }

    static Entry createInterface(String packageName, String className) {
        return new Entry(11, packageName, className, className + " (" + packageName + ")");
    }

    static Entry createPackageEntry(String packageName) {
        return new Entry(0, packageName, null, packageName);
    }

    public static Entry createDotDotDotEntry() {
        return new Entry(20, null, null, "...");
    }

    public boolean isPackage() {
        return this._className == null;
    }

    public String getFqClassName() {
        if (this._packageName.length() != 0) {
            return this._packageName + "." + this._className;
        }
        return this._className;
    }

    public String getClassName() {
        return this._className;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public String getFullName() {
        if (this.isPackage()) {
            return this.getPackageName();
        }
        return this.getFqClassName();
    }

    public String toString() {
        return this._text;
    }

    public Icon getIcon() {
        switch (this._type) {
            case 0: {
                return OracleIcons.getIcon((String)"package.png");
            }
            case 10: {
                return OracleIcons.getIcon((String)"class.png");
            }
            case 11: {
                return OracleIcons.getIcon((String)"interface.png");
            }
        }
        return null;
    }

    public int getType() {
        return this._type;
    }
}

