/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls.classpick;

import java.util.regex.Pattern;
import oracle.jdeveloper.controls.classpick.DualFiter;

class SmartFilter
implements DualFiter {
    private String _packageName;
    private Pattern _pattern;

    public void setMatchName(String matchName) {
        String className;
        int dotPos = matchName.lastIndexOf(46);
        if (dotPos == -1) {
            className = matchName;
            this._packageName = null;
        } else {
            this._packageName = matchName.substring(0, dotPos);
            className = matchName.substring(dotPos + 1);
        }
        this._pattern = this.getPattern(className);
    }

    private Pattern getPattern(String matchName) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean isCaseSensitive = false;
        if (matchName.length() > 0) {
            char firstChar = matchName.charAt(0);
            if (Character.isUpperCase(firstChar)) {
                stringBuffer.append(firstChar);
                int i = 1;
                while (i < matchName.length()) {
                    char c = matchName.charAt(i);
                    if (!Character.isLowerCase(c)) {
                        stringBuffer.append("[a-z0-9_]*");
                    }
                    stringBuffer.append(c);
                    ++i;
                }
                isCaseSensitive = true;
            } else {
                stringBuffer.append(matchName);
            }
        }
        stringBuffer.append(".*");
        String patternText = stringBuffer.toString();
        return Pattern.compile(patternText, isCaseSensitive ? 0 : 2);
    }

    public boolean acceptPackageName(String packageName) {
        String matcherInput = null;
        if (this._packageName == null) {
            matcherInput = packageName;
        } else if (packageName.startsWith(this._packageName)) {
            String secondPart;
            int packLen = this._packageName.length();
            if (packageName.length() > packLen + 1 && packageName.charAt(packLen) == '.' && (secondPart = packageName.substring(packLen + 1)).indexOf(46) == -1) {
                matcherInput = secondPart;
            }
        }
        return matcherInput != null && this._pattern.matcher(matcherInput).matches();
    }

    public boolean acceptClassName(String className, String packagePrefix) {
        return (this._packageName == null || this._packageName.equals(packagePrefix)) && this._pattern.matcher(className).matches();
    }
}

