/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.net.URL;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveEntry
implements Comparable {
    protected final String entryName;
    protected final URL url;

    public ArchiveEntry(String entryName, URL url) {
        Assert.check((boolean)ModelUtil.hasLength((String)entryName), (String)"ArchiveEntry name cannot be null or empty");
        this.entryName = entryName;
        this.url = url;
    }

    public String getName() {
        return this.entryName;
    }

    public URL getURL() {
        return this.url;
    }

    public int hashCode() {
        return this.entryName == null ? 0 : this.entryName.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ArchiveEntry) || this.entryName == null) {
            return false;
        }
        return this.entryName.equals(((ArchiveEntry)o).entryName);
    }

    public String toString() {
        return this.entryName;
    }

    public int compareTo(Object o) {
        if (!(o instanceof ArchiveEntry)) {
            throw new IllegalArgumentException();
        }
        ArchiveEntry archiveEntry = (ArchiveEntry)o;
        if (this.entryName == null) {
            return archiveEntry.entryName == null ? 0 : -1;
        }
        if (archiveEntry.entryName == null) {
            return 1;
        }
        return this.entryName.compareTo(archiveEntry.entryName);
    }
}

