/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.io.PrintWriter;
import oracle.ide.Context;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.DeploymentViewManager;
import oracle.jdeveloper.deploy.dt.Deployment;

public class DefaultDeployShellFactory
implements DeployShellFactory {
    public DeployShell create(int deploySequenceId, Context context, DeployShell parent) {
        return this.create(deploySequenceId, context, parent, null);
    }

    public DeployShell create(int deploySequenceId, Context context, DeployShell parent, PrintWriter logPrintWriter) {
        DeployShell newShell;
        if (parent != null) {
            newShell = new DeployShell(parent);
            if (context != null) {
                newShell.setContext(context);
            }
        } else {
            Assert.check((context != null ? 1 : 0) != 0, (String)"Root DeployShell cannot be created with a null Context");
            newShell = new DeployShell(context);
            this.setDefaults(newShell, logPrintWriter);
        }
        return newShell;
    }

    private void setDefaults(DeployShell shell, PrintWriter logPrintWriter) {
        shell.setDeployShellFactory(this);
        DeploymentManager.setDeploymentInfo(shell);
        DeploymentViewManager.setDeploymentViewInfo(shell);
        try {
            shell.setLog(logPrintWriter != null ? logPrintWriter : Deployment.getLogPrintWriter());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

