/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.DefaultDirtyable;
import oracle.ide.model.Dirtyable;
import oracle.jdeveloper.deploy.LinkedDirtyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLinkedDirtyable
extends DefaultDirtyable
implements Comparable,
LinkedDirtyable {
    private transient ArrayList _containingDirtyables;
    private transient ArrayList _embeddedDirtyables;
    private final LinkedDirtyable _delegator;

    private void $init$() {
        this._containingDirtyables = null;
        this._embeddedDirtyables = null;
    }

    public DefaultLinkedDirtyable() {
        this(null);
    }

    public DefaultLinkedDirtyable(LinkedDirtyable delegator) {
        this.$init$();
        this._delegator = delegator;
    }

    public int compareTo(Object o) {
        String s1 = this.toString();
        String s2 = o != null ? o.toString() : null;
        return DefaultLinkedDirtyable.compare(s1, s2);
    }

    protected static final int compare(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public void markDirty(boolean dirty) {
        if (super.isDirty() == dirty) {
            return;
        }
        super.markDirty(dirty);
        List dirtyList = this.getDirtyList(dirty, false);
        if (dirtyList != null) {
            for (Dirtyable d : dirtyList) {
                d.markDirty(dirty);
            }
        }
    }

    public void setOwner(Dirtyable containing) {
        if (containing != null) {
            this.linkContainingDirtyable(containing);
        } else {
            List list = this.getDirtyList(true, false);
            if (list != null) {
                list.clear();
            }
        }
    }

    @Override
    public void linkContainingDirtyable(Dirtyable containing) {
        this.linkMarkDirty(true, containing);
    }

    @Override
    public void unlinkContainingDirtyable(Dirtyable containing) {
        this.unlinkMarkDirty(true, containing);
    }

    @Override
    public void linkEmbeddedDirtyable(Dirtyable embedded) {
        this.linkMarkDirty(false, embedded);
    }

    @Override
    public void unlinkEmbeddedDirtyable(Dirtyable embedded) {
        this.unlinkMarkDirty(false, embedded);
    }

    public void linkEmbeddedDirtyable(LinkedDirtyable embedded) {
        if (embedded != null) {
            this.linkMarkDirty(false, (Dirtyable)embedded);
            embedded.linkContainingDirtyable((Dirtyable)(this._delegator != null ? this._delegator : this));
        }
    }

    public void unlinkEmbeddedDirtyable(LinkedDirtyable embedded) {
        if (embedded != null) {
            this.unlinkMarkDirty(false, (Dirtyable)embedded);
            embedded.unlinkContainingDirtyable((Dirtyable)(this._delegator != null ? this._delegator : this));
        }
    }

    public void linkEmbeddedDirtyables(LinkedDirtyable[] embedded) {
        if (embedded != null) {
            int i = embedded.length - 1;
            while (i >= 0) {
                this.linkEmbeddedDirtyable(embedded[i]);
                --i;
            }
        }
    }

    public void unlinkEmbeddedDirtyables(LinkedDirtyable[] embedded) {
        if (embedded != null) {
            int i = embedded.length - 1;
            while (i >= 0) {
                this.unlinkEmbeddedDirtyable(embedded[i]);
                --i;
            }
        }
    }

    private void linkMarkDirty(boolean dirty, Dirtyable dirtyable) {
        if (dirtyable == null) {
            return;
        }
        List dirtyList = this.getDirtyList(dirty, true);
        if (!dirtyList.contains(dirtyable)) {
            dirtyList.add(dirtyable);
        }
    }

    private void unlinkMarkDirty(boolean dirty, Dirtyable dirtyable) {
        if (dirtyable == null) {
            return;
        }
        List dirtyList = this.getDirtyList(dirty, false);
        if (dirtyList != null) {
            dirtyList.remove(dirtyable);
        }
    }

    private List getDirtyList(boolean list, boolean createIfNull) {
        if (list) {
            if (createIfNull && this._containingDirtyables == null) {
                this._containingDirtyables = new ArrayList();
            }
            return this._containingDirtyables;
        }
        if (createIfNull && this._embeddedDirtyables == null) {
            this._embeddedDirtyables = new ArrayList();
        }
        return this._embeddedDirtyables;
    }
}

