/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.io.PrintWriter;
import oracle.ide.Context;
import oracle.ide.nulls.NullPrintWriter;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.meta.Platform;

public final class DeployShell
extends Namespace {
    private String _platformID;
    private String _connectionName;
    private static final String CONTEXT_KEY = Context.class.getName();
    private static final String DEPLOY_SHELL_FACTORY_KEY = DeployShellFactory.class.getName();
    private static final String DEPLOYMENT_MODULE_FACTORY_KEY = DeploymentModuleFactory.class.getName();
    private static final String DEPLOY_LOG_KEY = "Deploy.log";
    private static final String DEPLOY_EXCEPTION_KEY = "Deploy.Exception";
    private static final String PRINT_TIME_MESSAGES_KEY = "Deployment.printTimeMessages";
    static final String SEQUENCE_STACK_KEY = "Deployment.SequenceStack";

    private void $init$() {
        this._platformID = null;
        this._connectionName = null;
    }

    public DeployShell(Context context) {
        this(context, null);
    }

    public DeployShell(Context context, PrintWriter log) {
        this.$init$();
        this.setContext(context);
        this.setLog(log);
    }

    public DeployShell(DeployShell shell) {
        super((Namespace)shell);
        this.$init$();
    }

    @Deprecated
    public String getConnectionName() {
        return this._connectionName;
    }

    public boolean getFlag(String flag) {
        return Boolean.TRUE.equals(this.get(flag));
    }

    public boolean findFlag(String flag) {
        return Boolean.TRUE.equals(this.find(flag));
    }

    public void setContext(Context context) {
        this.put(CONTEXT_KEY, context);
    }

    public Context getContext() {
        Context context = (Context)this.find(CONTEXT_KEY);
        return context;
    }

    @Deprecated
    private void setConnectionName(String connectionName) {
        this._connectionName = connectionName;
    }

    @Deprecated
    public void setPlatformID(String platformID) {
        this._platformID = platformID;
    }

    @Deprecated
    public String getPlatformID() {
        return this._platformID;
    }

    public Platform getPlatform() {
        return DeployUtil.getPlatform(this.getContext());
    }

    public void setPlatform(Platform platform) {
        DeployUtil.setPlatform(this.getContext(), platform);
    }

    public void setDeployShellFactory(DeployShellFactory factory) {
        this.put(DEPLOY_SHELL_FACTORY_KEY, factory);
    }

    public DeployShellFactory getDeployShellFactory() {
        DeployShellFactory factory = (DeployShellFactory)this.find(DEPLOY_SHELL_FACTORY_KEY);
        Assert.check((factory != null ? 1 : 0) != 0, (String)"DeployShell should have a reference to its factory.");
        return factory;
    }

    public DeploymentModuleFactory getDeploymentModuleFactory() {
        return (DeploymentModuleFactory)this.find(DEPLOYMENT_MODULE_FACTORY_KEY);
    }

    public void setDeploymentModuleFactory(DeploymentModuleFactory factory) {
        Assert.check((this.getParent() == this ? 1 : 0) != 0, (String)"DeploymentModuleFactory not being set in top-levle shell");
        this.put(DEPLOYMENT_MODULE_FACTORY_KEY, factory);
    }

    public void setLog(PrintWriter log) {
        this.put(DEPLOY_LOG_KEY, log != null ? log : new NullPrintWriter());
    }

    public PrintWriter getLog() {
        return (PrintWriter)this.find(DEPLOY_LOG_KEY);
    }

    public void setDeployException(DeployException exc) {
        this.put(DEPLOY_EXCEPTION_KEY, exc);
    }

    public DeployException getDeployException() {
        return (DeployException)this.find(DEPLOY_EXCEPTION_KEY);
    }

    public void setPrintTimeMessages(boolean value) {
        this.put(PRINT_TIME_MESSAGES_KEY, value);
    }

    public boolean getPrintTimeMessages() {
        Boolean b = (Boolean)this.find(PRINT_TIME_MESSAGES_KEY);
        return b == null || b != false;
    }

    public SequenceStack getSequenceStack() {
        SequenceStack stack = (SequenceStack)this.find(SEQUENCE_STACK_KEY);
        if (stack == null) {
            stack = new SequenceStack();
            this.getRoot().put(SEQUENCE_STACK_KEY, (Object)stack);
        }
        return stack;
    }

    public boolean isDeploying(int sequence) {
        return this.getSequenceStack().find(sequence) >= 0;
    }

    public static class SequenceStack {
        static final int MAX_STACK_SIZE = 1024;
        int[] stack_;
        int len_;

        private void $init$() {
            this.stack_ = new int[256];
            this.len_ = 0;
        }

        public void push(int i) {
            if (this.len_ == this.stack_.length) {
                this.grow();
            }
            this.stack_[this.len_] = i;
            ++this.len_;
        }

        public int pop() {
            --this.len_;
            if (this.len_ < 0) {
                throw new ArrayIndexOutOfBoundsException("DeploySequence stack underflow");
            }
            return this.stack_[this.len_];
        }

        private void grow() {
            if (this.stack_.length == 1024) {
                throw new ArrayIndexOutOfBoundsException("DeploySequence stack overflow");
            }
            int[] newstack_ = new int[Math.min(this.len_ * 2, 1024)];
            System.arraycopy(this.stack_, 0, newstack_, 0, this.stack_.length);
            this.stack_ = newstack_;
        }

        public int find(int sequence) {
            int i = 0;
            while (i < this.len_) {
                if (this.stack_[i] == sequence) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int getLength() {
            return this.len_;
        }

        public int[] getStack() {
            int[] copy = new int[this.len_];
            System.arraycopy(this.stack_, 0, copy, 0, this.len_);
            return copy;
        }

        public SequenceStack() {
            this.$init$();
        }
    }
}

