/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.swing.Action;
import oracle.ide.Context;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryFailedException;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.jndi.Names;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.common.ArchiveElement;
import oracle.jdeveloper.deploy.common.Interdependency;
import oracle.jdeveloper.deploy.common.NodeDependable;
import oracle.jdeveloper.deploy.common.ProfileDependable;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentOptions;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdevimpl.jar.JarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeployUtil {
    private static final String GALLERY_FOLDER_JNDI_NAME = "deploy/gallery-folder";
    private static final String PROFILE_KEY = "Profile";
    private static final String DEPLOYMENT_MODULE_KEY = "Deployment.deploymentModule";
    private static String PROFILE_DATACONTAINER_KEY = "Profile.Data.Container";
    static final String PLATFORM_KEY = "DEPLOY_PLATFORM";

    private DeployUtil() {
    }

    public static List getGalleryList() {
        InitialContext ic = Names.newInitialContext();
        ArrayList children = (ArrayList)Names.lookup((javax.naming.Context)ic, (String)GALLERY_FOLDER_JNDI_NAME);
        if (children == null) {
            children = new ArrayList(10);
            Names.bind((javax.naming.Context)ic, (String)GALLERY_FOLDER_JNDI_NAME, children);
        }
        return children;
    }

    public static URL getDeployPathURL(URL projectURL, URL selectedURL) {
        URL deployDirURL = Deployment.getDeployOutputDir(projectURL);
        if (deployDirURL != null) {
            String fileName = URLFileSystem.getFileName((URL)selectedURL);
            return URLFactory.newURL((URL)deployDirURL, (String)fileName);
        }
        return selectedURL;
    }

    public static ProfileDependable[] getProfileDependables(DataContainer container, Interdependency profile) {
        ArrayList<ProfileDependable> deps = new ArrayList<ProfileDependable>();
        deps.addAll(Arrays.asList(DeployUtil.getContainerProfileDependables(container)));
        deps.addAll(Arrays.asList((ProfileDependable[])DeployUtil.getDependables((Interdependency)profile, ProfileDependable.class)));
        return deps.toArray(new ProfileDependable[deps.size()]);
    }

    public static ProfileDependable[] getContainerProfileDependables(DataContainer container) {
        DependencyConfiguration containerDependencies = DependencyConfiguration.getInstance((PropertyStorage)container);
        ArrayList<ProfileDependable> deps = new ArrayList<ProfileDependable>();
        Iterator iter = containerDependencies.getDependencies();
        while (iter.hasNext()) {
            Dependable dep = (Dependable)iter.next();
            if (!(dep instanceof ProfileDependable)) continue;
            deps.add((ProfileDependable)dep);
        }
        return deps.toArray(new ProfileDependable[deps.size()]);
    }

    public static <T extends Dependable> T[] getDependables(Interdependency interDep, Class<T> type) {
        List<Dependable> deps = DeployUtil.getDependablesList(interDep, type);
        Dependable[] ret = (Dependable[])Array.newInstance(type, deps.size());
        return deps.toArray(ret);
    }

    public static <T extends Dependable> List<T> getDependablesList(Interdependency interDep, Class<T> type) {
        ArrayList<Dependable> deps = new ArrayList<Dependable>();
        Iterator<Dependable> iter = interDep.getDependencies();
        while (iter.hasNext()) {
            Dependable dep = iter.next();
            if (!type.isAssignableFrom(dep.getClass())) continue;
            deps.add(dep);
        }
        return deps;
    }

    public static boolean isForceJarRewrite() {
        DeploymentOptions opts = Deployment.getDeploymentOptions();
        return opts != null ? opts.isForceJarRewrite() : false;
    }

    public static URL getProfileURL(DataContainer container, Profile profile) {
        Assert.check((boolean)DeploymentProfiles.profileExists(container, profile), (String)("Profile " + profile.getName() + " could not be found in Container."));
        return DeployUtil.getProfileURL(container.getURL(), profile);
    }

    public static URL getProfileURL(URL containerURL, Profile profile) {
        String refPart = profile.getParentProfileName() + "#" + profile.getName();
        return URLFactory.replaceRefPart((URL)containerURL, (String)profile.getName());
    }

    public static Profile findProfileInElement(URL profileURL, Element parent) {
        return DeployUtil.findProfileInElement(DeployUtil.getProfileName(profileURL), parent);
    }

    public static Profile findProfileInElement(String profileName, Element parent) {
        Profile profile;
        if (parent != null && parent.getData() instanceof DataContainer && (profile = DeployUtil.getProfile((DataContainer)parent.getData(), profileName)) != null) {
            return profile;
        }
        return null;
    }

    public static Profile getProfile(URL profileURL) {
        URL containerURL = DeployUtil.getContainerURL(profileURL);
        try {
            Node obj = NodeFactory.findOrCreate((URL)containerURL);
            if (obj instanceof DataContainer) {
                DataContainer container = (DataContainer)NodeFactory.findOrCreate((URL)containerURL);
                Profile profile = DeployUtil.getProfile(container, DeployUtil.getProfileName(profileURL));
                return profile;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Profile getProfile(DataContainer container, String profileName) {
        return DeploymentProfiles.getInstance(container).getProfileByName(profileName);
    }

    public static void setProfile(Context context, Profile profile) {
        context.setProperty(PROFILE_KEY, (Object)profile);
    }

    public static void setProfile(Context context, Profile profile, DataContainer container) {
        DeployUtil.setProfile(context, profile);
        DeployUtil.setProfileDataContainer(context, container);
    }

    public static Profile getProfile(Context context) {
        return (Profile)context.getProperty(PROFILE_KEY);
    }

    public static Profile getProfile(Action action) {
        return (Profile)action.getValue(PROFILE_KEY);
    }

    public static void setProfile(Action action, Profile profile) {
        action.putValue(PROFILE_KEY, profile);
    }

    public static Profile getProfile(DeployShell shell) {
        Context context = shell.getContext();
        Assert.check((context != null ? 1 : 0) != 0, (String)"Context not set in DeployShell");
        return DeployUtil.getProfile(context);
    }

    public static void setDeploymentModule(DeployShell shell, Profile profile, DeploymentModule module) {
        HashMap<Profile, DeploymentModule> profileModuleMap = (HashMap<Profile, DeploymentModule>)shell.get(DEPLOYMENT_MODULE_KEY);
        if (profileModuleMap == null) {
            profileModuleMap = new HashMap<Profile, DeploymentModule>();
            shell.getRoot().put(DEPLOYMENT_MODULE_KEY, profileModuleMap);
        }
        profileModuleMap.put(profile, module);
    }

    public static DeploymentModule getDeploymentModule(DeployShell shell, Profile profile) {
        HashMap profileModuleMap = (HashMap)shell.find(DEPLOYMENT_MODULE_KEY);
        if (profileModuleMap != null) {
            return (DeploymentModule)profileModuleMap.get(profile);
        }
        return null;
    }

    @Deprecated
    public static String getProfileName(URL profileURL) {
        return profileURL.getRef();
    }

    public static URL getContainerURL(URL profileURL) {
        return URLFactory.replaceRefPart((URL)profileURL, null);
    }

    @Deprecated
    public static void setProfileDataContainer(Context context, DataContainer container) {
        context.setProperty(PROFILE_DATACONTAINER_KEY, (Object)container);
    }

    @Deprecated
    public static DataContainer getProfileDataContainer(Context context) {
        return (DataContainer)context.getProperty(PROFILE_DATACONTAINER_KEY);
    }

    @Deprecated
    public static DataContainer getProfileDataContainer(DeployShell shell) {
        Assert.check((DeployUtil.getProfile(shell) != null ? 1 : 0) != 0, (String)"getProfile(shell) returns null");
        return DeployUtil.getProfile(shell).getDataContainer();
    }

    @Deprecated
    public static DataContainer getProfileDataContainer(Action action) {
        Assert.check((DeployUtil.getProfile(action) != null ? 1 : 0) != 0, (String)"getProfile(action) returns null");
        return DeployUtil.getProfile(action).getDataContainer();
    }

    @Deprecated
    public static void setProfileDataContainer(Action action, DataContainer container) {
        action.putValue(PROFILE_DATACONTAINER_KEY, container);
    }

    public static void setPlatform(Context context, Platform platform) {
        context.setProperty(PLATFORM_KEY, (Object)platform);
    }

    public static Platform getPlatform(Context context) {
        return (Platform)context.getProperty(PLATFORM_KEY);
    }

    public static Platform getPlatform(DeployShell shell) {
        return DeployUtil.getPlatform(shell.getContext());
    }

    public static ProfileDependable[] getProfileDependables(Profile profile, Class<? extends Profile> sourceClass) {
        ArrayList<ProfileDependable> ret = new ArrayList<ProfileDependable>();
        ProfileDependable[] profileDependableArray = (ProfileDependable[])DeployUtil.getDependables((Interdependency)profile, ProfileDependable.class);
        int n = 0;
        while (n < profileDependableArray.length) {
            Profile source;
            ProfileDependable profileDep = profileDependableArray[n];
            if (profileDep.doesExist() && sourceClass.isAssignableFrom((source = profileDep.getProfile()).getClass())) {
                ret.add(profileDep);
            }
            ++n;
        }
        return ret.toArray(new ProfileDependable[ret.size()]);
    }

    public static ArchiveEntry createArchiveEntry(NodeDependable nodeDependable, String prefix) {
        URL nodeURL = nodeDependable.getNodeURL();
        String fileName = URLFileSystem.getFileName((URL)nodeURL);
        String entryName = (prefix != null ? prefix : "") + fileName;
        return new ArchiveEntry(entryName, nodeURL);
    }

    public static ArchiveEntry createArchiveEntry(ProfileDependable profileDependable, String prefix) {
        Assert.check((boolean)(profileDependable.getProfile() instanceof ArchiveProfile), (String)"Profile should be an instance of ArchiveProfile");
        ArchiveProfile archiveProfile = (ArchiveProfile)profileDependable.getProfile();
        URL nodeURL = archiveProfile.getJarURL();
        String fileName = URLFileSystem.getFileName((URL)nodeURL);
        String path = null;
        if (profileDependable instanceof ArchiveElement) {
            path = ((ArchiveElement)((Object)profileDependable)).getPathInArchive();
        }
        String entryName = (path != null ? path : "") + (prefix != null ? prefix : "") + fileName;
        return new ArchiveEntry(entryName, nodeURL);
    }

    public static NodeDependable[] getJarDependables(Interdependency profile) {
        NodeDependable[] nodeDependables = (NodeDependable[])DeployUtil.getDependables((Interdependency)profile, NodeDependable.class);
        ArrayList<NodeDependable> jarNodeDependables = new ArrayList<NodeDependable>();
        NodeDependable[] nodeDependableArray = nodeDependables;
        int n = 0;
        while (n < nodeDependableArray.length) {
            NodeDependable nodeDep = nodeDependableArray[n];
            if (nodeDep.getNode() instanceof JarNode) {
                jarNodeDependables.add(nodeDep);
            }
            ++n;
        }
        return jarNodeDependables.toArray(new NodeDependable[jarNodeDependables.size()]);
    }

    public static NodeDependable[] getAllJarDependables(Interdependency interdep) {
        ArrayList<NodeDependable> seen = new ArrayList<NodeDependable>();
        ArrayList<Object> visitedNodes = new ArrayList<Object>();
        return DeployUtil.getAllJarDependablesImpl(interdep, seen, visitedNodes);
    }

    private static NodeDependable[] getAllJarDependablesImpl(Interdependency interdep, ArrayList<NodeDependable> seen, ArrayList<Object> visitedNodes) {
        Dependable[] dependables;
        NodeDependable[] jarDependables;
        NodeDependable[] nodeDependableArray = jarDependables = DeployUtil.getJarDependables(interdep);
        int n = 0;
        while (n < nodeDependableArray.length) {
            NodeDependable jarNodeDep = nodeDependableArray[n];
            if (!seen.contains(jarNodeDep)) {
                seen.add(jarNodeDep);
            }
            ++n;
        }
        Dependable[] dependableArray = dependables = DeployUtil.getDependables((Interdependency)interdep, Dependable.class);
        int n2 = 0;
        while (n2 < dependableArray.length) {
            Dependable dep = dependableArray[n2];
            Element src = dep.getSource();
            if (src instanceof Interdependency) {
                boolean bl = !visitedNodes.contains(src) && false;
            }
            ++n2;
        }
        return seen.toArray(new NodeDependable[seen.size()]);
    }

    public static boolean isDependableExist(Dependable dependable) {
        if (dependable instanceof ProfileDependable) {
            return ((ProfileDependable)dependable).doesExist();
        }
        if (dependable instanceof NodeDependable) {
            return ((NodeDependable)dependable).doesExist();
        }
        Element source = dependable.getSource();
        return source != null;
    }

    public static DeploymentOptions getDeploymentOptions(Context context) {
        DeploymentOptions options = null;
        if (context != null) {
            options = (DeploymentOptions)((Object)context.getProperty("deployment-options"));
        }
        if (options == null) {
            options = Deployment.getDeploymentOptions();
        }
        Assert.check((options != null ? 1 : 0) != 0, (String)"Deployment options could not be retrieved from the Context or IDE settings");
        return options;
    }

    public static void setDeploymentOptions(Context context, DeploymentOptions options) {
        context.setProperty("deployment-options", (Object)options);
    }

    public static <T extends Dependable> T[] clearDependencies(Interdependency interDep, Class<T> clazz) {
        Dependable[] allDependants;
        Dependable[] dependableArray = allDependants = DeployUtil.getDependables((Interdependency)interDep, clazz);
        int n = 0;
        while (n < dependableArray.length) {
            Dependable dep = dependableArray[n];
            interDep.removeDependency(dep);
            ++n;
        }
        return allDependants;
    }

    public static Dependable[] clearAllDependencies(Interdependency interDep) {
        return DeployUtil.clearDependencies((Interdependency)interDep, Dependable.class);
    }

    public static void setDependencies(Interdependency interDep, Dependable[] dependables) {
        DeployUtil.setDependencies((Interdependency)interDep, (Dependable[])dependables, Dependable.class);
    }

    public static <T extends Dependable> T[] setDependencies(Interdependency interDep, T[] dependables, Class<T> clazz) {
        Assert.check((interDep != null ? 1 : 0) != 0, (String)"InterDep cannot be null");
        Assert.check((dependables != null ? 1 : 0) != 0, (String)"Dependables cannot be null, use clearDependables() instead");
        Dependable[] cleared = DeployUtil.clearDependencies((Interdependency)interDep, clazz);
        T[] TArray = dependables;
        int n = 0;
        while (n < TArray.length) {
            T dep = TArray[n];
            interDep.addDependency((Dependable)dep);
            ++n;
        }
        return cleared;
    }

    public static Element getDeployElement(DeployShell shell) {
        Profile element = DeployUtil.getProfile(shell);
        if (element == null) {
            element = shell.getContext().getElement();
        }
        return element;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL[] findFast(Project project, String fileName, String extension) {
        Index index;
        block22: {
            if (extension.indexOf("*") >= 0) {
                throw new IllegalArgumentException("\\* not allowed in extension");
            }
            if (extension != null && !extension.startsWith(".")) {
                throw new IllegalArgumentException("Extension should start with .");
            }
            IndexManager indexMgr = IndexManager.getIndexManager();
            index = indexMgr.getIndex(project);
            try {
                QueryCriteria criteria = new QueryCriteria();
                String[] s = fileName.split("\\*");
                int i = 0;
                while (true) {
                    if (i >= s.length) {
                        if (extension != null) {
                            criteria.put((Object)"file.extension", (Object)extension);
                        }
                        index.lock();
                        URL[] uRLArray = index.blockingQuery(criteria);
                        break;
                        {
                            catch (Throwable throwable) {
                                index.unlock();
                                throw throwable;
                            }
                        }
                    }
                    if (s[i].length() != 0) {
                        if (i == 0 && fileName.startsWith(s[i])) {
                            criteria.put((Object)"file.name.starts.with", (Object)s[i]);
                        } else if (i == s.length - 1 && fileName.endsWith(s[i])) {
                            criteria.put((Object)"file.name.ends.with", (Object)s[i]);
                        } else {
                            criteria.put((Object)"file.name.contains", (Object)s[i]);
                        }
                    }
                    ++i;
                }
                index.unlock();
            }
            catch (QueryFailedException e) {
                Assert.println((String)("Index query failed for " + fileName + extension));
                Assert.printStackTrace((Throwable)e);
                break block22;
                catch (InterruptedException e2) {
                    Assert.printStackTrace((Throwable)e2);
                    break block22;
                }
                catch (LockFailedException e3) {
                    Assert.printStackTrace((Throwable)e3);
                }
            }
            finally {
                index.release();
            }
        }
        index.release();
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL[] findFastXml(Project project, String rootElem, String nameSpace) {
        Index index;
        block13: {
            Assert.precondition((boolean)ModelUtil.hasLength((String)rootElem), (String)"Root element is required");
            IndexManager indexMgr = IndexManager.getIndexManager();
            index = indexMgr.getIndex(project);
            try {
                QueryCriteria criteria = new QueryCriteria();
                criteria.put((Object)"xml.root.element", (Object)rootElem);
                if (ModelUtil.hasLength((String)nameSpace)) {
                    criteria.put((Object)"xml.root.namespace", (Object)nameSpace);
                }
                index.lock();
                URL[] uRLArray = index.blockingQuery(criteria);
                {
                    catch (Throwable throwable) {
                        index.unlock();
                        throw throwable;
                    }
                }
                index.unlock();
            }
            catch (LockFailedException e) {
                Assert.printStackTrace((Throwable)e);
                break block13;
                catch (InterruptedException e2) {
                    Assert.printStackTrace((Throwable)e2);
                    break block13;
                }
                catch (QueryFailedException e3) {
                    Assert.printStackTrace((Throwable)e3);
                }
            }
            finally {
                index.release();
            }
        }
        index.release();
        return null;
    }
}

