/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.deploy.DeploymentModuleEvent;
import oracle.jdeveloper.deploy.DeploymentModuleListener;

public class PatternFilter
implements DeploymentModuleListener {
    final oracle.ide.util.PatternFilter[] patterns_;
    final DeploymentModuleListener delegate_;

    public PatternFilter(String pattern, DeploymentModuleListener listener) {
        this(new String[]{pattern}, listener);
    }

    public PatternFilter(String[] patterns, DeploymentModuleListener listener) {
        this.delegate_ = listener;
        Assert.check((this.delegate_ != null ? 1 : 0) != 0, (String)"Listener passed into PatternFilter cannot be null");
        this.patterns_ = new oracle.ide.util.PatternFilter[patterns.length];
        int i = 0;
        while (i < this.patterns_.length) {
            this.patterns_[i] = oracle.ide.util.PatternFilter.newInclude((String)patterns[i]);
            ++i;
        }
    }

    public void moduleChanged(DeploymentModuleEvent deploymentModuleEvent) {
        int eventType = deploymentModuleEvent.getType();
        if (eventType == 6 || eventType == 7) {
            boolean fire = false;
            oracle.ide.util.PatternFilter[] patternFilterArray = this.patterns_;
            int n = 0;
            while (n < patternFilterArray.length) {
                oracle.ide.util.PatternFilter pattern = patternFilterArray[n];
                String entryName = deploymentModuleEvent.getArchiveEntry().getName();
                Assert.check((boolean)ModelUtil.hasLength((String)entryName), (String)"Archive entry name is null");
                if (pattern.matches(entryName)) {
                    fire = true;
                    break;
                }
                ++n;
            }
            if (fire) {
                this.delegate_.moduleChanged(deploymentModuleEvent);
            }
        }
    }
}

