/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.util.Arrays;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.common.AbstractDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;

public final class BatchDeployer
extends AbstractDeployer {
    private final Deployer[] deployers_;
    private final boolean[] deployerPrepared_;

    public BatchDeployer(int deploySequenceId, int[] deploySequenceIds) {
        super(deploySequenceId);
        Assert.check((deploySequenceIds != null ? 1 : 0) != 0, (String)"Illegal argument: Parameter deployers canot be null");
        this.deployers_ = new Deployer[deploySequenceIds.length];
        int i = 0;
        while (i < deploySequenceIds.length) {
            int id = deploySequenceIds[i];
            Assert.check((id != deploySequenceId ? 1 : 0) != 0, (String)"BatchDeployer Id cannot be same as its children.");
            this.deployers_[i] = new DynamicDeployer(deploySequenceIds[i]);
            ++i;
        }
        this.deployerPrepared_ = new boolean[this.deployers_.length];
    }

    public Deployer[] getDeployers() {
        return this.deployers_;
    }

    public void prepareImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        int i = 0;
        while (i < this.deployers_.length) {
            this.deployerPrepared_[i] = true;
            Assert.check((boolean)DeploymentManager.printDebug("deployer.prepare.begin", this + "(" + i + " of " + this.deployers_.length + ")"));
            this.deployers_[i].prepare(deploySequenceId, shell);
            Assert.check((boolean)DeploymentManager.printDebug("deployer.prepare.end", this + "(" + i + " of " + this.deployers_.length + ")"));
            ++i;
        }
    }

    public void deployImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        int i = 0;
        while (i < this.deployers_.length) {
            Assert.check((boolean)DeploymentManager.printDebug("deployer.deploy.begin", this + "(" + i + " of " + this.deployers_.length + ")"));
            this.deployers_[i].deploy(deploySequenceId, shell);
            Assert.check((boolean)DeploymentManager.printDebug("deployer.deploy.end", this + "(" + i + " of " + this.deployers_.length + ")"));
            ++i;
        }
    }

    public void finishImpl(int deploySequenceId, DeployShell shell) {
        int i = 0;
        while (i < this.deployers_.length) {
            if (this.deployerPrepared_[i]) {
                Assert.check((boolean)DeploymentManager.printDebug("deployer.finish.begin", this + "(" + i + " of " + this.deployers_.length + ")"));
                this.deployers_[i].finish(deploySequenceId, shell);
                Assert.check((boolean)DeploymentManager.printDebug("deployer.finish.end", this + "(" + i + " of " + this.deployers_.length + ")"));
            }
            ++i;
        }
    }

    public void cancelImpl(int deploySequenceId, DeployShell shell) {
        int i = this.deployers_.length - 1;
        while (i >= 0) {
            if (this.deployerPrepared_[i]) {
                Assert.check((boolean)DeploymentManager.printDebug("deployer.cancel.end", this + "(" + i + " of " + this.deployers_.length + ")"));
                this.deployers_[i].cancel(deploySequenceId, shell);
                Assert.check((boolean)DeploymentManager.printDebug("deployer.cancel.end", this + "(" + i + " of " + this.deployers_.length + ")"));
            }
            --i;
        }
    }

    public boolean canDeploy(int deploySequenceId) {
        boolean ret = super.canDeploy(deploySequenceId);
        if (!ret) {
            int i = 0;
            while (i < this.deployers_.length) {
                ret = this.deployers_[i].canDeploy(deploySequenceId);
                if (ret) break;
                ++i;
            }
        }
        return ret;
    }

    public String toString() {
        return super.toString() + " " + Arrays.toString(this.deployers_);
    }
}

