/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;
import oracle.jdevimpl.deploy.res.UtilArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CdaFilter
extends DefaultLinkedDirtyable
implements Copyable,
Comparable {
    public static final int INCLUDE = 0;
    public static final int EXCLUDE = 1;
    public static final int PACKAGE_TREE = 0;
    public static final int SINGLE_PACKAGE = 2;
    public static final int CLASS = 4;
    private static final String DEFAULT_NAME = "???";
    private HashStructure _hash;

    public CdaFilter() {
        this(HashStructure.newInstance());
        this.setName(DEFAULT_NAME);
    }

    public CdaFilter(HashStructure hash) {
        this._hash = hash;
    }

    public CdaFilter(int type, int scope, String name) {
        this();
        this.setType(type);
        this.setScope(scope);
        this.setName(name);
    }

    public static CdaFilter includePackageTree(String name) {
        return new CdaFilter(0, 0, name);
    }

    public static CdaFilter excludePackageTree(String name) {
        return new CdaFilter(1, 0, name);
    }

    public static CdaFilter includeSinglePackage(String name) {
        return new CdaFilter(0, 2, name);
    }

    public static CdaFilter excludeSinglePackage(String name) {
        return new CdaFilter(1, 2, name);
    }

    public static CdaFilter includeClass(String name) {
        return new CdaFilter(0, 4, name);
    }

    public static CdaFilter excludeClass(String name) {
        return new CdaFilter(1, 4, name);
    }

    public Object copyTo(Object object) {
        CdaFilter copy = object != null ? (CdaFilter)object : new CdaFilter();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(CdaFilter copy) {
        this._hash.copyTo(copy._hash);
    }

    @Override
    public int compareTo(Object o) {
        CdaFilter other = (CdaFilter)o;
        if (this.getScope() < other.getScope()) {
            return -1;
        }
        if (this.getScope() > other.getScope()) {
            return 1;
        }
        if (this.getScope() == 0) {
            return this.getName().compareTo(other.getName());
        }
        if (this.getType() < other.getType()) {
            return -1;
        }
        if (this.getType() > other.getType()) {
            return 1;
        }
        return this.getName().compareTo(other.getName());
    }

    public int getType() throws AttributeMarker {
        return this._hash.getInt("type");
    }

    public void setType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException();
        }
        if (this.getType() != type) {
            this._hash.putInt("type", type);
            this.markDirty(true);
        }
    }

    public int getScope() throws AttributeMarker {
        return this._hash.getInt("scope");
    }

    public void setScope(int scope) {
        if (scope != 0 && scope != 2 && scope != 4) {
            throw new IllegalArgumentException();
        }
        if (this.getScope() != scope) {
            this._hash.putInt("scope", scope);
            this.markDirty(true);
        }
    }

    public String getName() throws AttributeMarker {
        return this._hash.getString("name");
    }

    public void setName(String name) {
        if (name == null) {
            name = DEFAULT_NAME;
        }
        if (ModelUtil.areDifferent((Object)this.getName(), (Object)name)) {
            this._hash.putString("name", name);
            this.markDirty(true);
        }
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((CdaFilter)o);
    }

    protected final boolean equalsImpl(CdaFilter filter) {
        return this._hash.equals((Object)filter._hash);
    }

    public String toString() {
        int typeScope = this.getType() + this.getScope();
        switch (typeScope) {
            case 0: {
                return UtilArb.format(22, this.getName());
            }
            case 1: {
                return UtilArb.format(15, this.getName());
            }
            case 2: {
                return UtilArb.format(19, this.getName());
            }
            case 3: {
                return UtilArb.format(2, this.getName());
            }
            case 4: {
                return UtilArb.format(21, this.getName());
            }
            case 5: {
                return UtilArb.format(9, this.getName());
            }
        }
        return DEFAULT_NAME;
    }
}

