/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.util.Arrays;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;
import oracle.jdeveloper.deploy.LinkedDirtyable;
import oracle.jdeveloper.deploy.common.CdaFilter;

public class CdaFilters
extends DefaultLinkedDirtyable
implements Copyable {
    private HashStructure _hash;

    public CdaFilters() {
        this(HashStructure.newInstance());
    }

    public CdaFilters(HashStructure hash) {
        this._hash = hash;
    }

    public Object copyTo(Object object) {
        CdaFilters copy = object != null ? (CdaFilters)object : new CdaFilters();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(CdaFilters copy) {
        this._hash.copyTo(copy._hash);
    }

    public CdaFilter[] getFilters() {
        ListStructure list = this._hash.getListStructure("filters");
        if (list == null) {
            return null;
        }
        int n = list.size();
        CdaFilter[] cdaFilters = new CdaFilter[n];
        int i = 0;
        while (i < n) {
            HashStructure filterHash = (HashStructure)list.get(i);
            cdaFilters[i] = new CdaFilter(filterHash);
            ++i;
        }
        return cdaFilters;
    }

    public void setFilters(CdaFilter[] filters) {
        if (!Arrays.equals(this.getFilters(), filters)) {
            this.setFiltersImpl(filters);
            this.markDirty(true);
        }
    }

    private void setFiltersImpl(CdaFilter[] filters) {
        Object[] tmpFilters;
        this.unlinkEmbeddedDirtyables(this.getFilters());
        this._hash.remove("filters");
        if (filters != null) {
            ListStructure list = this._hash.getOrCreateListStructure("filters");
            int i = 0;
            while (i < filters.length) {
                CdaFilter cdaFilter = filters[i];
                HashStructure filterHash = cdaFilter.getHashStructure();
                list.add((Object)filterHash);
                ++i;
            }
            this._hash.putListStructure("filters", list);
        }
        if ((tmpFilters = this.getFilters()) != null) {
            Arrays.sort(tmpFilters);
            this.linkEmbeddedDirtyables((LinkedDirtyable[])tmpFilters);
        }
    }

    public void addFilter(CdaFilter filter) {
        Object[] filters = this.getFilters();
        if (filter != null) {
            if (filters != null) {
                if (Arrays.binarySearch(filters, filter) < 0) {
                    int n = filters.length;
                    CdaFilter[] newFilters = new CdaFilter[n + 1];
                    System.arraycopy(filters, 0, newFilters, 0, n);
                    newFilters[n] = filter;
                    this.setFiltersImpl(newFilters);
                    this.markDirty(true);
                }
            } else {
                this.setFiltersImpl(new CdaFilter[]{filter});
                this.markDirty(true);
            }
        }
    }

    public void addFilters(CdaFilter[] filters) {
        if (filters == null) {
            return;
        }
        int n = filters.length;
        int i = 0;
        while (i < n) {
            this.addFilter(filters[i]);
            ++i;
        }
    }

    public boolean isIncluded(String className) {
        CdaFilter[] filters = this.getFilters();
        if (filters == null || filters.length == 0) {
            return true;
        }
        int i = filters.length - 1;
        while (i >= 0) {
            CdaFilter filter = filters[i];
            if (filter.getScope() != 4) break;
            String filterName = filter.getName();
            if (filterName.equals(className)) {
                return filter.getType() == 0;
            }
            if (className.startsWith(filterName)) {
                int filterNameLen = filterName.length();
                if (className.length() > filterNameLen && className.charAt(filterNameLen) == '$') {
                    return filter.getType() == 0;
                }
            }
            --i;
        }
        while (i >= 0) {
            String theClass;
            CdaFilter filter = filters[i];
            if (filter.getScope() != 2) break;
            String packageName = filter.getName();
            if (className.startsWith(packageName) && (theClass = className.substring(packageName.length())).lastIndexOf(46) == 0) {
                return filter.getType() == 0;
            }
            --i;
        }
        String longestName = "";
        int longestLen = 0;
        int longestType = 0;
        while (i >= 0) {
            int packageNameLen;
            CdaFilter filter = filters[i];
            if (filter.getScope() != 0) break;
            String packageName = filter.getName();
            if (className.startsWith(packageName) && className.charAt(packageNameLen = packageName.length()) == '.' && longestName.length() <= packageNameLen) {
                longestName = packageName;
                longestLen = packageNameLen;
                longestType = filter.getType();
            }
            --i;
        }
        if (longestLen > 0) {
            return longestType == 0;
        }
        return true;
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((CdaFilters)o);
    }

    protected final boolean equalsImpl(CdaFilters cdaFilters) {
        return this._hash.equals((Object)cdaFilters._hash);
    }
}

