/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;
import oracle.jdeveloper.deploy.common.CdaFilters;
import oracle.jdeveloper.deploy.common.SelectedArchives;

public final class CdaSettings
extends DefaultLinkedDirtyable
implements Copyable {
    private HashStructure _hash;

    public CdaSettings() {
        this(HashStructure.newInstance());
        this.setSelectedArchives(new SelectedArchives());
    }

    public CdaSettings(HashStructure hash) {
        this._hash = hash;
    }

    public Object copyTo(Object object) {
        CdaSettings copy = object != null ? (CdaSettings)object : new CdaSettings();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(CdaSettings copy) {
        this._hash.copyTo(copy._hash);
    }

    public CdaFilters getBeforeFilters() {
        HashStructure filterHash = this._hash.getHashStructure("beforeFilters");
        if (filterHash == null) {
            return null;
        }
        return new CdaFilters(filterHash);
    }

    public void setBeforeFilters(CdaFilters beforeFilters) {
        if (ModelUtil.areDifferent((Object)this.getBeforeFilters(), (Object)beforeFilters)) {
            this.setBeforeFiltersImpl(beforeFilters);
            this.markDirty(true);
        }
    }

    private void setBeforeFiltersImpl(CdaFilters beforeFilters) {
        this.unlinkEmbeddedDirtyable(this.getBeforeFilters());
        if (beforeFilters == null) {
            this._hash.remove("beforeFilters");
        } else {
            this._hash.putHashStructure("beforeFilters", beforeFilters.getHashStructure());
        }
        this.linkEmbeddedDirtyable(this.getBeforeFilters());
    }

    public CdaFilters getDuringFilters() {
        HashStructure filterHash = this._hash.getHashStructure("duringFilters");
        if (filterHash == null) {
            return null;
        }
        return new CdaFilters(filterHash);
    }

    public void setDuringFilters(CdaFilters duringFilters) {
        if (ModelUtil.areDifferent((Object)this.getDuringFilters(), (Object)duringFilters)) {
            this.setDuringFiltersImpl(duringFilters);
            this.markDirty(true);
        }
    }

    private void setDuringFiltersImpl(CdaFilters duringFilters) {
        this.unlinkEmbeddedDirtyable(this.getDuringFilters());
        if (duringFilters == null) {
            this._hash.remove("duringFilters");
        } else {
            this._hash.putHashStructure("duringFilters", duringFilters.getHashStructure());
        }
        this.linkEmbeddedDirtyable(this.getDuringFilters());
    }

    public CdaFilters getAfterFilters() {
        HashStructure filterHash = this._hash.getHashStructure("afterFilters");
        if (filterHash == null) {
            return null;
        }
        return new CdaFilters(filterHash);
    }

    public void setAfterFilters(CdaFilters afterFilters) {
        if (ModelUtil.areDifferent((Object)this.getAfterFilters(), (Object)afterFilters)) {
            this.setAfterFiltersImpl(afterFilters);
            this.markDirty(true);
        }
    }

    private void setAfterFiltersImpl(CdaFilters afterFilters) {
        this.unlinkEmbeddedDirtyable(this.getAfterFilters());
        if (afterFilters == null) {
            this._hash.remove("afterFilters");
        } else {
            this._hash.putHashStructure("afterFilters", afterFilters.getHashStructure());
        }
        this.linkEmbeddedDirtyable(this.getAfterFilters());
    }

    public SelectedArchives getSelectedArchives() {
        HashStructure archiveHash = this._hash.getHashStructure("selectedArchives");
        if (archiveHash == null) {
            return null;
        }
        return new SelectedArchives(archiveHash);
    }

    public void setSelectedArchives(SelectedArchives selectedArchives) {
        if (ModelUtil.areDifferent((Object)this.getSelectedArchives(), (Object)selectedArchives)) {
            this.setSelectedArchivesImpl(selectedArchives);
            this.markDirty(true);
        }
    }

    private void setSelectedArchivesImpl(SelectedArchives selectedArchives) {
        this.unlinkEmbeddedDirtyable(this.getSelectedArchives());
        if (selectedArchives == null) {
            this._hash.remove("selectedArchives");
        } else {
            this._hash.putHashStructure("selectedArchives", selectedArchives.getHashStructure());
        }
        this.linkEmbeddedDirtyable(this.getSelectedArchives());
    }

    public URL[] getAdditionalArchives() {
        ListStructure list = this._hash.getOrCreateListStructure("additionalArchives");
        if (list == null) {
            return null;
        }
        return (URL[])list.toArray((Object[])new URL[list.size()]);
    }

    public void setAdditionalArchives(URL[] additionalArchives) {
        if (!Arrays.equals(this.getAdditionalArchives(), additionalArchives)) {
            ListStructure list = this._hash.getOrCreateListStructure("additionalArchives");
            list.clear();
            list.addAll(Arrays.asList(additionalArchives));
            this.markDirty(true);
        }
    }

    public URL[] getArchivesToInclude() {
        URL[] moreArchives;
        URL[] archives;
        int selectionMode;
        ArrayList<URL> archivesList = new ArrayList<URL>();
        SelectedArchives sa = this.getSelectedArchives();
        if (sa != null && ((selectionMode = sa.getSelectionMode()) == 0 || selectionMode == 1) && (archives = sa.getArchives()) != null) {
            archivesList.addAll(Arrays.asList(archives));
        }
        if ((moreArchives = this.getAdditionalArchives()) != null) {
            archivesList.addAll(Arrays.asList(moreArchives));
        }
        return archivesList.toArray(new URL[archivesList.size()]);
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((CdaSettings)o);
    }

    protected final boolean equalsImpl(CdaSettings cdas) {
        return this._hash.equals((Object)cdas._hash);
    }
}

