/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.net.URL;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.marshal.OmittedWhenNullMarker;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;

public final class Contributor
extends DefaultLinkedDirtyable
implements Copyable {
    public static final int UNDEFINED = 0;
    public static final int USER_SPECIFIED = 1;
    public static final int PROJECT_OUTPUT_DIRECTORY = 2;
    public static final int PROJECT_ADDITIONAL_CLASSPATH = 3;
    public static final int PROJECT_LIBRARY = 4;
    public static final int PROJECT_HTML_ROOT_DIR = 5;
    public static final int PROJECT_SOURCEPATH = 6;
    public static final int PROJECT_DEPENDENCIES = 7;
    public static final int PROFILE_DEPENDENCIES = 8;
    public static final int APPLICATION_SOURCEPATH = 9;
    public static final int ADF_SOURCE_DIRECTORY = 10;
    private HashStructure _hash;

    public Contributor() {
        this(HashStructure.newInstance());
    }

    public Contributor(HashStructure hash) {
        this._hash = hash;
    }

    public Contributor(int type, URL location) {
        this();
        this.setType(type);
        this.setLocation(location);
    }

    public Object copyTo(Object target) {
        Contributor copy = target != null ? (Contributor)target : new Contributor();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(Contributor copy) {
        this._hash.copyTo(copy._hash);
    }

    public int getType() throws AttributeMarker {
        return this._hash.getInt("type");
    }

    public void setType(int type) {
        if (this.getType() == 0) {
            this._hash.putInt("type", type);
            this.markDirty(true);
        }
    }

    public URL getLocation() throws OmittedWhenNullMarker {
        return this._hash.getURL("location");
    }

    public void setLocation(URL location) {
        if (ModelUtil.areDifferent((Object)this.getLocation(), (Object)location)) {
            this._hash.putURL("location", location);
            this.markDirty(true);
        }
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((Contributor)o);
    }

    protected final boolean equalsImpl(Contributor other) {
        return this._hash.equals((Object)other._hash);
    }
}

