/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.xml.XMLUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import org.xml.sax.SAXException;

public abstract class DescriptorIO {
    private final Class _descriptorClass;
    private final String _rootElem;
    private final String _publicID;
    private final String _systemID;

    protected DescriptorIO(Class descriptorClass, String rootElem, String publicID, String systemID) {
        this._descriptorClass = descriptorClass;
        this._rootElem = rootElem;
        this._publicID = publicID;
        this._systemID = systemID;
    }

    public Class getDescriptorClass() {
        return this._descriptorClass;
    }

    public String getRootElement() {
        return this._rootElem;
    }

    public String getPublicID() {
        return this._publicID;
    }

    public String getSystemID() {
        return this._systemID;
    }

    public void save(Object descriptor, URL url) throws IOException {
        XMLDocument xmlDocument = this.getXMLDocument(descriptor);
        XMLUtil.writeXML((XMLDocument)xmlDocument, (URL)url);
    }

    public void saveWithXMLDiff(Object descriptor, URL url) throws IOException {
        this.save(descriptor, url);
    }

    public void save(Object descriptor, PrintWriter printWriter) throws IOException {
        XMLDocument xmlDocument = this.getXMLDocument(descriptor);
        XMLUtil.writeXML((XMLDocument)xmlDocument, (PrintWriter)printWriter, (int)2);
    }

    public String toString(Object descriptor) {
        XMLDocument xmlDocument = this.getXMLDocument(descriptor);
        return XMLUtil.toString((XMLDocument)xmlDocument);
    }

    public Object load(URL url) throws IOException {
        Object2Dom o2d = this.newObject2Dom();
        return o2d.toObject(url, this.getDescriptorClass());
    }

    public Object load(Reader reader) throws IOException {
        Object2Dom o2d = this.newObject2Dom();
        return o2d.toObject(reader, this.getDescriptorClass());
    }

    public Object load(Reader reader, DTD dtd, int reportLevel, Object2DomLogger logger) throws IOException {
        Object2Dom o2d = this.newObject2Dom();
        if (dtd != null) {
            o2d.setDTD(dtd);
        }
        o2d.setLogger(reportLevel, logger);
        return o2d.toObject(reader, this.getDescriptorClass());
    }

    public XMLDocument getXMLDocument(Object descriptor) {
        return this.getXMLDocument(descriptor, true);
    }

    public XMLDocument getXMLDocument(Object descriptor, String encoding) {
        return this.getXMLDocument(descriptor, true, encoding);
    }

    public void setDoctype(XMLDocument xmlDocument) {
        xmlDocument.setDoctype(this.getRootElement(), this.getSystemID(), this.getPublicID());
    }

    public void checkDescriptorClass(Object descriptor) throws IllegalArgumentException {
        if (descriptor == null || descriptor.getClass() != this.getDescriptorClass()) {
            throw new IllegalArgumentException();
        }
    }

    public void maybeUpdateDoctype(XMLDocument doc, Object descriptor) {
        String minReqVer = this.getMinimumRequiredVersion(descriptor);
        if (this.compareVersions(minReqVer, this.getSystemID()) > 0) {
            DescriptorIO io = this.newDescriptorIO(minReqVer);
            doc.setDoctype(io.getRootElement(), io.getSystemID(), io.getPublicID());
        }
    }

    protected abstract String getMinimumRequiredVersion(Object var1);

    protected int compareVersions(String systemID1, String systemID2) {
        int id1 = this.mapVersionToInt(systemID1);
        int id2 = this.mapVersionToInt(systemID2);
        return id1 - id2;
    }

    protected abstract int mapVersionToInt(String var1);

    protected abstract DescriptorIO newDescriptorIO(String var1);

    protected XMLDocument loadXml(URL url) throws SAXException, IOException {
        DOMParser domParser = new DOMParser();
        domParser.setPreserveWhitespace(true);
        domParser.setDoctype(new DTD());
        InputStream in = null;
        in = URLFileSystem.openInputStream((URL)url);
        domParser.parse(in);
        XMLDocument xMLDocument = domParser.getDocument();
        try {
            return xMLDocument;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private XMLDocument getXMLDocument(Object descriptor, boolean maybeUpdateDoctype) {
        return this.getXMLDocument(descriptor, maybeUpdateDoctype, IdeUtil.getIdeIanaEncoding());
    }

    private XMLDocument getXMLDocument(Object descriptor, boolean maybeUpdateDoctype, String encoding) {
        Assert.precondition((encoding != null ? 1 : 0) != 0);
        this.checkDescriptorClass(descriptor);
        Object2Dom o2d = this.newObject2Dom();
        o2d.setEncoding(encoding);
        XMLDocument xmlDocument = o2d.toDocument(descriptor, this.getRootElement());
        this.setDoctype(xmlDocument);
        if (maybeUpdateDoctype) {
            this.maybeUpdateDoctype(xmlDocument, descriptor);
        }
        return xmlDocument;
    }

    private Object2Dom newObject2Dom() {
        return Object2Dom.newInstanceForSchemaCompiledBeans();
    }
}

