/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.util.Arrays;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.ProjectFileGroup;

public class FileGroups
extends DefaultLinkedDirtyable
implements Copyable {
    private HashStructure _hash;

    public FileGroups() {
        this(HashStructure.newInstance());
    }

    public FileGroups(HashStructure hash) {
        this._hash = hash;
    }

    public Object copyTo(Object target) {
        FileGroups copy = target != null ? (FileGroups)target : new FileGroups();
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(FileGroups copy) {
        this._hash.copyTo(copy._hash);
    }

    public FileGroup[] getGroups() {
        ListStructure list = this._hash.getListStructure("groups");
        if (list == null) {
            return null;
        }
        int n = list.size();
        FileGroup[] groups = new FileGroup[n];
        int i = 0;
        while (i < n) {
            HashStructure groupHash = (HashStructure)list.get(i);
            switch (groupHash.getInt("type")) {
                case 1: {
                    groups[i] = new PackagingFileGroup(groupHash);
                    break;
                }
                case 2: {
                    groups[i] = new ProjectFileGroup(groupHash);
                    break;
                }
                case 3: {
                    groups[i] = new LibraryFileGroup(groupHash);
                    break;
                }
                default: {
                    return null;
                }
            }
            ++i;
        }
        return groups;
    }

    public void setGroups(FileGroup[] groups) {
        if (!Arrays.equals(this.getGroups(), groups)) {
            this.setGroupsImpl(groups);
            this.markDirty(true);
        }
    }

    private void setGroupsImpl(FileGroup[] groups) {
        this.unlinkEmbeddedDirtyables(this.getGroups());
        this._hash.remove("groups");
        if (groups != null) {
            ListStructure list = this._hash.getOrCreateListStructure("groups");
            int i = 0;
            while (i < groups.length) {
                FileGroup fileGroup = groups[i];
                HashStructure groupHash = fileGroup.getHashStructure();
                groupHash.putInt("type", fileGroup.type());
                list.add((Object)groupHash);
                ++i;
            }
            this._hash.putListStructure("groups", list);
        }
        this.linkEmbeddedDirtyables(this.getGroups());
    }

    public void addFileGroup(FileGroup group) {
        FileGroup[] groups = this.getGroups();
        if (group != null) {
            if (groups != null) {
                int n = groups.length;
                FileGroup[] newGroups = new FileGroup[n + 1];
                System.arraycopy(groups, 0, newGroups, 0, n);
                newGroups[n] = group;
                this.setGroupsImpl(newGroups);
            } else {
                this.setGroupsImpl(new FileGroup[]{group});
            }
            this.markDirty(true);
        }
    }

    public PackagingFileGroup findPackagingFileGroup(String internalName) {
        return (PackagingFileGroup)this.findGroup(internalName, 1);
    }

    public ProjectFileGroup findProjectFileGroup(String internalName) {
        return (ProjectFileGroup)this.findGroup(internalName, 2);
    }

    public LibraryFileGroup findLibraryFileGroup(String internalName) {
        return (LibraryFileGroup)this.findGroup(internalName, 3);
    }

    private FileGroup findGroup(String internalName, int type) {
        FileGroup[] groups;
        if (internalName != null && (groups = this.getGroups()) != null) {
            int n = groups.length;
            int i = 0;
            while (i < n) {
                FileGroup group = groups[i];
                if (group != null && group.type() == type && internalName.equals(group.getInternalName())) {
                    return group;
                }
                ++i;
            }
        }
        return null;
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((FileGroups)o);
    }

    protected final boolean equalsImpl(FileGroups other) {
        return this._hash.equals((Object)other._hash);
    }
}

