/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.SelectionRules;
import oracle.jdevimpl.deploy.res.CommonArb;

public final class PackagingFileGroup
extends FileGroup {
    public static final String DEFAULT_INTERNAL_NAME = "project-output";

    public PackagingFileGroup() {
        this((String)null);
    }

    public PackagingFileGroup(HashStructure hash) {
        super(hash);
    }

    private PackagingFileGroup(String displayName) {
        this(displayName, null);
    }

    public PackagingFileGroup(String displayName, String internalName) {
        this(displayName, internalName, new SelectionRules());
    }

    private PackagingFileGroup(String displayName, String internalName, SelectionRules filters) {
        super(displayName, internalName);
        this.setFilters(filters);
    }

    public static PackagingFileGroup newDefaultGroup() {
        return PackagingFileGroup.newDefaultGroup(Project.class);
    }

    public static PackagingFileGroup newDefaultGroup(Class profileContainerClass) {
        String displayName = CommonArb.getString(121);
        String internalName = DEFAULT_INTERNAL_NAME;
        return PackagingFileGroup.newDefaultGroup(profileContainerClass, displayName, DEFAULT_INTERNAL_NAME);
    }

    public static PackagingFileGroup newDefaultGroup(String displayName, String internalName) {
        return PackagingFileGroup.newDefaultGroup(Project.class, displayName, internalName);
    }

    public static PackagingFileGroup newDefaultGroup(Class profileContainerClass, String displayName, String internalName) {
        PackagingFileGroup group = PackagingFileGroup.newEmptyGroup(displayName, internalName);
        if (profileContainerClass.isAssignableFrom(Workspace.class)) {
            group.addContributor(new Contributor(9, null));
            return group;
        }
        group.addContributor(new Contributor(2, null));
        group.addContributor(new Contributor(7, null));
        return group;
    }

    public static PackagingFileGroup newEmptyGroup(String displayName, String internalName) {
        SelectionRules filters = SelectionRules.newDefaultSelectionRules();
        return new PackagingFileGroup(displayName, internalName, filters);
    }

    public final int type() {
        return 1;
    }

    public Object copyTo(Object target) {
        PackagingFileGroup copy = target != null ? (PackagingFileGroup)target : new PackagingFileGroup();
        this.copyToImpl(copy);
        return copy;
    }

    public Contributor[] getContributors() {
        ListStructure list = this._hash.getOrCreateListStructure("contributors");
        int n = list.size();
        Contributor[] contributors = new Contributor[n];
        int i = 0;
        while (i < n) {
            HashStructure contributorHash = (HashStructure)list.get(i);
            contributors[i] = new Contributor(contributorHash);
            ++i;
        }
        return contributors;
    }

    public void setContributors(Contributor[] contributors) {
        if (!Arrays.equals(this.getContributors(), contributors)) {
            this.setContributorsImpl(contributors);
            this.markDirty(true);
        }
    }

    private void setContributorsImpl(Contributor[] contributors) {
        this.unlinkEmbeddedDirtyables(this.getContributors());
        this._hash.remove("contributors");
        if (contributors != null) {
            ListStructure list = this._hash.getOrCreateListStructure("contributors");
            int i = 0;
            while (i < contributors.length) {
                Contributor contributor = contributors[i];
                HashStructure contributorHash = contributor.getHashStructure();
                list.add((Object)contributorHash);
                ++i;
            }
            this._hash.putListStructure("contributors", list);
        }
        this.linkEmbeddedDirtyables(this.getContributors());
    }

    public void addContributor(Contributor contributor) {
        Contributor[] contributors = this.getContributors();
        if (contributor != null) {
            if (contributors != null) {
                List<Contributor> contribList = Arrays.asList(contributors);
                if (!contribList.contains(contributor)) {
                    int n = contributors.length;
                    Contributor[] newContributors = new Contributor[n + 1];
                    System.arraycopy(contributors, 0, newContributors, 0, n);
                    newContributors[n] = contributor;
                    this.setContributorsImpl(newContributors);
                }
            } else {
                this.setContributorsImpl(new Contributor[]{contributor});
            }
            this.markDirty(true);
        }
    }

    public List getContributorsByType(int type) {
        ArrayList<URL> list = new ArrayList<URL>();
        Contributor[] contribs = this.getContributors();
        if (contribs != null) {
            int n = contribs.length;
            int i = 0;
            while (i < n) {
                URL location;
                Contributor contrib = contribs[i];
                if (contrib != null && contrib.getType() == type && (location = contrib.getLocation()) != null) {
                    list.add(location);
                }
                ++i;
            }
        }
        return list;
    }

    public SelectionRules getFilters() {
        HashStructure filterHash = this._hash.getHashStructure("filters");
        if (filterHash == null) {
            return null;
        }
        return new SelectionRules(filterHash);
    }

    public void setFilters(SelectionRules filters) {
        if (ModelUtil.areDifferent((Object)this.getFilters(), (Object)filters)) {
            this.setFiltersImpl(filters);
            this.markDirty(true);
        }
    }

    private void setFiltersImpl(SelectionRules filters) {
        this.unlinkEmbeddedDirtyable(this.getFilters());
        this._hash.putHashStructure("filters", filters.getHashStructure());
        this.linkEmbeddedDirtyable(this.getFilters());
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((PackagingFileGroup)o);
    }
}

