/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.common.CdaSettings;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.SelectedProjectFiles;

public final class ProjectFileGroup
extends FileGroup {
    public static final String DEFAULT_INTERNAL_NAME = "legacy";

    public ProjectFileGroup() {
        this((String)null);
    }

    public ProjectFileGroup(HashStructure hash) {
        super(hash);
    }

    public ProjectFileGroup(String displayName) {
        this(displayName, null);
    }

    public ProjectFileGroup(String displayName, String internalName) {
        super(displayName, internalName);
        this.setContributors(new SelectedProjectFiles());
        this.setFilters(new CdaSettings());
    }

    public static ProjectFileGroup newLegacyGroup(String displayName) {
        return new ProjectFileGroup(displayName, DEFAULT_INTERNAL_NAME);
    }

    public final int type() {
        return 2;
    }

    public Object copyTo(Object target) {
        ProjectFileGroup copy = target != null ? (ProjectFileGroup)target : new ProjectFileGroup();
        this.copyToImpl(copy);
        return copy;
    }

    public SelectedProjectFiles getContributors() {
        HashStructure contributorHash = this._hash.getHashStructure("contributors");
        if (contributorHash == null) {
            return null;
        }
        return new SelectedProjectFiles(contributorHash);
    }

    public void setContributors(SelectedProjectFiles contributors) {
        if (ModelUtil.areDifferent((Object)this.getContributors(), (Object)contributors)) {
            this.setContributorsImpl(contributors);
            this.markDirty(true);
        }
    }

    private void setContributorsImpl(SelectedProjectFiles contributors) {
        this.unlinkEmbeddedDirtyable(this.getContributors());
        this._hash.putHashStructure("contributors", contributors.getHashStructure());
        this.linkEmbeddedDirtyable(this.getContributors());
    }

    public CdaSettings getFilters() {
        HashStructure filterHash = this._hash.getHashStructure("filters");
        if (filterHash == null) {
            return null;
        }
        return new CdaSettings(filterHash);
    }

    public void setFilters(CdaSettings filters) {
        if (ModelUtil.areDifferent((Object)this.getFilters(), (Object)filters)) {
            this.setFiltersImpl(filters);
            this.markDirty(true);
        }
    }

    private void setFiltersImpl(CdaSettings filters) {
        this.unlinkEmbeddedDirtyable(this.getFilters());
        this._hash.putHashStructure("filters", filters.getHashStructure());
        this.linkEmbeddedDirtyable(this.getFilters());
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((ProjectFileGroup)o);
    }
}

