/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.net.URL;
import java.util.Arrays;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;

public class SelectedArchives
extends DefaultLinkedDirtyable
implements Copyable {
    public static final int INCLUDED_IN_EXPANDED_FORM = 0;
    public static final int INCLUDED_IN_UNEXPANDED_FORM = 1;
    public static final int ADDED_TO_CLASS_PATH = 2;
    private HashStructure _hash;

    public SelectedArchives() {
        this(HashStructure.newInstance());
    }

    public SelectedArchives(HashStructure hash) {
        this._hash = hash;
    }

    public Object copyTo(Object object) {
        SelectedArchives copy = object != null ? (SelectedArchives)object : new SelectedArchives();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(SelectedArchives copy) {
        this._hash.copyTo(copy._hash);
    }

    public URL[] getArchives() {
        ListStructure list = this._hash.getListStructure("archives");
        if (list == null) {
            return null;
        }
        return (URL[])list.toArray((Object[])new URL[list.size()]);
    }

    public void setArchives(URL[] archives) {
        if (!Arrays.equals(this.getArchives(), archives)) {
            ListStructure list = this._hash.getOrCreateListStructure("archives");
            list.clear();
            list.addAll(Arrays.asList(archives));
            this.markDirty(true);
        }
    }

    public int getSelectionMode() {
        return this._hash.getInt("selectionMode");
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode < 0 || selectionMode > 2) {
            throw new IllegalArgumentException();
        }
        if (this.getSelectionMode() != selectionMode) {
            this._hash.putInt("selectionMode", selectionMode);
            this.markDirty(true);
        }
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((SelectedArchives)o);
    }

    protected final boolean equalsImpl(SelectedArchives sa) {
        return this._hash.equals((Object)sa._hash);
    }
}

