/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdevimpl.deploy.res.DtArb;

final class CreateProfilePanel
extends DefaultTraversablePanel {
    private final JTextField tfProfileName;
    private final URLTextField tfProfileDir;
    private Set usedNames;
    private boolean _isContainerProfile;

    private void $init$() {
        this.tfProfileName = new JTextField();
        this.tfProfileDir = new URLTextField();
        this.usedNames = null;
    }

    CreateProfilePanel(boolean isContainerProfile) {
        this.$init$();
        JLabel lblProfileName = new JLabel();
        ResourceUtils.resLabel((JLabel)lblProfileName, (Component)this.tfProfileName, (String)DtArb.getString(27));
        Dimension prefSize = this.tfProfileName.getPreferredSize();
        prefSize.width = 500;
        this.tfProfileName.setPreferredSize(prefSize);
        JLabel lblProfileDir = new JLabel();
        ResourceUtils.resLabel((JLabel)lblProfileDir, (Component)this.tfProfileDir, (String)DtArb.getString(63));
        JButton btnBrowse = new JButton();
        ResourceUtils.resButton((AbstractButton)btnBrowse, (String)DtArb.getString(25));
        btnBrowse.addActionListener((ActionListener)this.tfProfileDir);
        this.setLayout(new GridBagLayout());
        Insets in0550 = new Insets(0, 5, 5, 0);
        this.add(lblProfileName, this.gbc(0, 0, 2, 1, 0.0, 0.0, 17, 0, in0550));
        this.add(this.tfProfileName, this.gbc(0, 1, 2, 1, 1.0, 0.0, 17, 2, in0550));
        this._isContainerProfile = isContainerProfile;
        if (!isContainerProfile) {
            this.add(lblProfileDir, this.gbc(0, 2, 2, 1, 0.0, 0.0, 17, 0, in0550));
            this.add((Component)this.tfProfileDir, this.gbc(0, 3, 1, 1, 1.0, 0.0, 17, 2, in0550));
            this.add(btnBrowse, this.gbc(1, 3, 1, 1, 0.0, 0.0, 17, 0, in0550));
        }
        this.setHelpID("f1_depsavedepprof_html");
    }

    public void onEntry(TraversableContext tc) {
        String name;
        if (this._isContainerProfile) {
            this.usedNames = (Set)tc.find("usedNames");
            name = (String)tc.find("defaultProfileName");
        } else {
            URL url = (URL)tc.find("url");
            name = URLFileSystem.getName((URL)url);
            URL dir = URLFileSystem.getParent((URL)url);
            this.tfProfileDir.setURL(dir);
        }
        this.tfProfileName.setText(name);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        String name = this.tfProfileName.getText();
        if (name.length() < 3) {
            this.tfProfileName.requestFocus();
            throw new TraversalException(DtArb.getString(33));
        }
        if (this._isContainerProfile) {
            if (this.usedNames.contains(name)) {
                this.tfProfileName.requestFocus();
                throw new TraversalException(DtArb.format(109, name));
            }
        } else {
            URL dir = this.tfProfileDir.getURL();
            if (!URLFileSystem.isValid((URL)dir)) {
                this.tfProfileDir.requestFocus();
                throw new TraversalException(DtArb.getString(70));
            }
            URL url = URLFactory.newURL((URL)dir, (String)name);
            if (!URLFileSystem.isValid((URL)(url = URLFileSystem.ensureSuffix((URL)url, (String)((String)tc.find("suffix")))))) {
                this.tfProfileName.requestFocus();
                throw new TraversalException(DtArb.getString(79));
            }
            if (URLFileSystem.exists((URL)url) && !MessageDialog.confirm((Component)((Object)this), (Object)DtArb.getString(52), (String)BuilderArb.getString(76), null, (boolean)true)) {
                this.tfProfileName.requestFocus();
                throw new TraversalException(null);
            }
            tc.findAndReplace("url", (Object)url);
        }
        tc.findAndReplace("profileName", (Object)this.tfProfileName.getText());
    }
}

