/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;
import oracle.jdeveloper.deploy.LinkedDirtyable;

public class DeployFolder
extends DefaultFolder
implements Copyable,
Subject,
LinkedDirtyable {
    private final transient Subject _subject;
    private final transient DefaultLinkedDirtyable _linkedDirtyable;

    private void $init$() {
        this._subject = new IdeSubject();
        this._linkedDirtyable = new DefaultLinkedDirtyable(this);
    }

    public DeployFolder() {
        this.$init$();
    }

    public Object copyTo(Object object) {
        DeployFolder copy = object != null ? (DeployFolder)object : new DeployFolder();
        this.copyToImpl(copy);
        return copy;
    }

    public String getToolTipText() {
        return "";
    }

    public void attach(Observer observer) {
        this._subject.attach(observer);
    }

    public void detach(Observer observer) {
        this._subject.detach(observer);
    }

    public void notifyObservers(Object subject, UpdateMessage change) {
        this._subject.notifyObservers(subject, change);
    }

    public boolean isDirty() {
        if (this._linkedDirtyable.isDirty()) {
            return true;
        }
        Iterator iter = this.getChildren();
        while (iter.hasNext()) {
            Dirtyable dirtyable;
            Object next = iter.next();
            if (!(next instanceof Dirtyable) || !(dirtyable = (Dirtyable)next).isDirty()) continue;
            return true;
        }
        return false;
    }

    public void markDirty(boolean dirty) {
        Attributes attributes;
        this._linkedDirtyable.markDirty(dirty);
        if (!dirty) {
            Iterator iter = this.getChildren();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof Dirtyable)) continue;
                Dirtyable dirtyable = (Dirtyable)next;
                dirtyable.markDirty(false);
            }
        }
        if (dirty != (attributes = this.getAttributes()).isSet(ElementAttributes.DIRTY)) {
            Attributes oldAttributes = attributes.duplicate();
            if (dirty) {
                attributes.set(ElementAttributes.DIRTY);
            } else {
                attributes.unset(ElementAttributes.DIRTY);
            }
            UpdateMessage.fireAttributeChanged((Subject)this, (Attributes)oldAttributes);
        }
    }

    public void setOwner(Dirtyable containing) {
        this._linkedDirtyable.setOwner(containing);
    }

    public boolean add(Element child) {
        boolean result = super.add(child);
        if (result) {
            this.markDirty(true);
            if (child instanceof LinkedDirtyable) {
                this.linkEmbeddedDirtyable((LinkedDirtyable)child);
            }
        }
        return result;
    }

    public boolean remove(Element child) {
        boolean result = super.remove(child);
        if (result) {
            this.markDirty(true);
            if (child instanceof LinkedDirtyable) {
                this.unlinkEmbeddedDirtyable((LinkedDirtyable)child);
            }
        }
        return result;
    }

    public void removeAll() {
        int size = this.size();
        ArrayList children = new ArrayList(this._children);
        super.removeAll();
        if (this.size() != size) {
            int i = 0;
            while (i < size) {
                Object child = children.get(i);
                if (child instanceof LinkedDirtyable) {
                    this.unlinkEmbeddedDirtyable((LinkedDirtyable)child);
                }
                ++i;
            }
            this.markDirty(true);
        }
    }

    public void linkContainingDirtyable(Dirtyable containing) {
        this._linkedDirtyable.linkContainingDirtyable(containing);
    }

    public void unlinkContainingDirtyable(Dirtyable containing) {
        this._linkedDirtyable.unlinkContainingDirtyable(containing);
    }

    public void linkEmbeddedDirtyable(Dirtyable embedded) {
        this._linkedDirtyable.linkEmbeddedDirtyable(embedded);
    }

    public void unlinkEmbeddedDirtyable(Dirtyable embedded) {
        this._linkedDirtyable.unlinkEmbeddedDirtyable(embedded);
    }

    public void linkEmbeddedDirtyable(LinkedDirtyable embedded) {
        this._linkedDirtyable.linkEmbeddedDirtyable(embedded);
    }

    public void unlinkEmbeddedDirtyable(LinkedDirtyable embedded) {
        this._linkedDirtyable.unlinkEmbeddedDirtyable(embedded);
    }

    public List getListOfChildren() {
        return new ArrayList(this._children);
    }

    public void setListOfChildren(List list) {
        this._children.clear();
        if (list != null) {
            for (Object next : list) {
                if (!(next instanceof Element)) continue;
                this.add((Element)next);
            }
        }
    }
}

