/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt;

import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.wizard.Wizard;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.dt.DeployProfileDt;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.res.DtArb;

class DeployWizard
extends Wizard {
    private final DeployProfileDt _dpdt;

    DeployWizard(DeployProfileDt dpdt) {
        this._dpdt = dpdt;
    }

    public boolean isAvailable(Context context) {
        if (context == null) {
            return false;
        }
        Node node = context.getNode();
        if (node != null) {
            Object data = node.getData();
            if (data instanceof Workspace) {
                return this._dpdt.supportsApplicationLevelCreation();
            }
            if (data instanceof Project) {
                return this._dpdt.supportsProjectLevelCreation();
            }
        }
        if (context.getProject() != null) {
            return this._dpdt.supportsProjectLevelCreation();
        }
        return false;
    }

    public boolean invoke(Context context) {
        if (this._dpdt.isCreatedInContainer()) {
            Profile profile = this._dpdt.newContainerDeploymentProfile(context);
            DeployUtil.setProfile(context, profile);
        } else {
            this._dpdt.createDesignTimeNode(context);
        }
        return true;
    }

    public String getShortLabel() {
        String label;
        if (this._dpdt != null && (label = this._dpdt.getShortLabel()) != null) {
            return label;
        }
        return DtArb.getString(12);
    }

    public String getLongLabel() {
        return this._dpdt != null ? this._dpdt.getLongLabel() : super.getLongLabel();
    }

    public Icon getIcon() {
        return this._dpdt != null ? this._dpdt.getIcon() : DeployArb.getIcon(12);
    }

    public String getToolTipText() {
        return this._dpdt != null ? this._dpdt.getToolTipText() : super.getToolTipText();
    }

    public String toString() {
        return this._dpdt != null ? this._dpdt.toString() : super.toString();
    }
}

