/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogPrintStream;
import oracle.ide.log.LogPrintWriter;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableFactory;
import oracle.ide.model.DependableRecognizer;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeInfo;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.wizard.Wizard;
import oracle.ide.xml.NodeInfoLoader;
import oracle.ide.xml.XMLRecognizer;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.DeployAddin;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.dt.AbstractHashDependable;
import oracle.jdeveloper.deploy.dt.DeployDesignTime;
import oracle.jdeveloper.deploy.dt.DeployLogPage;
import oracle.jdeveloper.deploy.dt.DeployProfileDt;
import oracle.jdeveloper.deploy.dt.DeployWizard;
import oracle.jdeveloper.deploy.dt.DeploymentOptions;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdevimpl.deploy.res.DtArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Deployment {
    public static final String STORED_PROC_EXPORT_EXT = ".dbexport";
    public static final String DEPLOY_PROFILE_EXT = ".deploy";
    public static final String BCDEPLOY_PROFILE_EXT = ".bcdeploy";
    private static final String[] _profileSuffixes = new String[]{".deploy", ".bcdeploy"};
    private static Dt DT_INSTANCE;
    private static DeployLogPage logPage;
    private static final HashMap<Class, DeployDesignTime> _dtRegistry;
    private static final HashMap _wizRegistry;
    private static ArrayList _scheduled;
    public static final int BC_SDO_PROFILE_TYPE = 17;
    private static DependableFactory hashDependableFactory_;

    private Deployment() {
    }

    @Deprecated
    public static boolean isDeploymentProfile(Node node) {
        if (node != null) {
            return URLFileSystem.hasSuffix((URL)node.getURL(), (String[])_profileSuffixes);
        }
        return false;
    }

    @Deprecated
    public static boolean isDeploymentContainerProfile(Element elem) {
        Object data = elem.getData();
        if (elem instanceof Node) {
            return Deployment.isDeploymentProfile((Node)elem) && elem instanceof Folder;
        }
        if (data instanceof Profile) {
            return ((Profile)data).mayHaveChildren();
        }
        return false;
    }

    public static IdeAction createIdeAction(String key, String displayName) {
        return Deployment.createIdeAction(key, displayName, Deployment.getDT());
    }

    public static IdeAction createIdeAction(String key, String displayName, Controller controller) {
        String text = StringUtils.stripMnemonic((String)displayName);
        Integer mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)displayName));
        IdeAction action = IdeAction.get((int)Ide.findOrCreateCmdID((String)key), (String)key, (String)text, (String)null, (Integer)mnemonic, null, null, (boolean)true);
        action.addController(controller);
        return action;
    }

    public static void deploy(Context context) {
        Deployment.deploy(context, null);
    }

    public static boolean deploy(Context context, String command) {
        Dt dt = Deployment.getDT();
        IdeAction action = Dt.mav$getIdeAction(dt, command, context);
        if (action != null) {
            return dt.handleEvent(action, context);
        }
        return false;
    }

    public static void invokeNewDeploymentProfileWizard(Class dataClass, Context context) {
        Wizard wiz = (Wizard)_wizRegistry.get(dataClass);
        wiz.invoke(context);
    }

    public static void registerDeployDesignTime(Class dataClass, DeployDesignTime ddt) {
        Deployment.registerDeployDesignTime(dataClass, ddt, null, null);
    }

    public static void registerDeployDesignTime(Class dataClass, DeployDesignTime ddt, String category, String folder) {
        Assert.check((dataClass != null ? 1 : 0) != 0, (String)"Valid deploy data Class required");
        1 deployAddin = new 1(ddt, dataClass, category, folder);
        Deployment.loadDeployAddin(deployAddin);
    }

    private static void registerDeployDesignTime(Class dataClass, DeployDesignTime ddt, Wizard wiz, String category, String folder) {
        Assert.check((dataClass != null && ddt != null ? 1 : 0) != 0);
        _dtRegistry.put(dataClass, ddt);
        Wizard wizard = wiz == null && ddt instanceof DeployProfileDt ? new DeployWizard((DeployProfileDt)ddt) : wiz;
        try {
            GalleryManager gm = GalleryManager.getGalleryManager();
            if (gm != null && category != null && folder != null) {
                _wizRegistry.put(dataClass, wizard);
                ElementInfo eInfo = new ElementInfo(category, folder, wizard, null, null, null, null, false);
                if (ddt instanceof DeployProfileDt) {
                    eInfo.setTechnologyKeys(((DeployProfileDt)ddt).getTechnologyKeys());
                }
                gm.registerGalleryElement(eInfo);
            }
            if (ddt instanceof DeployProfileDt) {
                XMLRecognizer.registerNodeInfo((NodeInfo)((DeployProfileDt)ddt));
            }
        }
        catch (Exception e) {
            if (ddt != null) {
                Assert.println((String)DtArb.format(64, ddt.getClass()));
            }
            e.printStackTrace();
        }
    }

    public static void registerProfileDesignTime(Class<? extends Profile> profileClass, DeployProfileDt pdt) {
        Deployment.registerProfileDesignTime(profileClass, pdt, null);
    }

    public static void registerProfileDesignTime(Class<? extends Profile> profileClass, DeployProfileDt dpdt, Wizard wiz) {
        2 deployAddin = new 2(wiz, dpdt, profileClass);
        Deployment.loadDeployAddin(deployAddin);
    }

    public static DeploymentOptions getDeploymentOptions() {
        IdeSettings settings = Ide.getSettings();
        DeploymentOptions options = (DeploymentOptions)((Object)settings.getData("deployment-options"));
        Assert.println((options == null ? 1 : 0) != 0, (String)"Deployment options could not be retrieved from IdeSettings");
        return options != null ? options : new DeploymentOptions();
    }

    public static URL getDeployOutputDir(URL projectURL) {
        return Deployment.getDeployOutputDir(projectURL, Project.class);
    }

    public static URL getDeployOutputDir(URL containerURL, Class<? extends DataContainer> profileContainerClass) {
        IdeSettings settings = Ide.getSettings();
        DeploymentOptions opts = (DeploymentOptions)((Object)settings.getData("deployment-options"));
        String deployDir = null;
        if (opts != null) {
            URL absoluteURL;
            URL uRL = absoluteURL = profileContainerClass.isAssignableFrom(Workspace.class) ? opts.getApplicationAbsoluteOutputURL() : opts.getDeployOutputURL();
            if (absoluteURL != null) {
                return absoluteURL;
            }
            String string = deployDir = profileContainerClass.isAssignableFrom(Workspace.class) ? opts.getApplicationRelativeOutputFolder() : opts.getDeployOutputFolder();
        }
        if (deployDir == null) {
            deployDir = "deploy";
        }
        URL containerDir = URLFileSystem.getParent((URL)containerURL);
        return URLFactory.newDirURL((URL)containerDir, (String)deployDir);
    }

    public static LogPage getLogPage() {
        if (Ide.getMainWindow() != null) {
            Deployment.maybeInitLogPage();
            return logPage;
        }
        return null;
    }

    public static void maybeShowLogPage() {
        DeployLogPage deployLogPage = (DeployLogPage)Deployment.getLogPage();
        if (deployLogPage != null) {
            deployLogPage.show();
        }
    }

    public static LogPrintWriter getLogPrintWriter() {
        return new LogPrintWriter(Deployment.getLogPage());
    }

    public static LogPrintStream getLogPrintStream() {
        return new LogPrintStream(Deployment.getLogPage());
    }

    public static URL convertSuffix(URL deployProfileURL, String newSuffix) {
        return URLFileSystem.convertSuffix((URL)deployProfileURL, (String)DEPLOY_PROFILE_EXT, (String)newSuffix);
    }

    public static synchronized void loadDeployAddin(String className) {
        if (className != null && className.length() > 0) {
            if (_scheduled != null) {
                _scheduled.add(className);
            } else {
                try {
                    Deployment.loadDeployAddinImpl(className);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Deployment.loadFailureError(className, e.getMessage());
                }
            }
        }
    }

    public static synchronized void processLoad() {
        if (_scheduled != null) {
            Iterator iter = _scheduled.iterator();
            _scheduled = null;
            while (iter.hasNext()) {
                Object next = iter.next();
                try {
                    if (next instanceof DeployAddin) {
                        ((DeployAddin)next).startup();
                        continue;
                    }
                    String className = next.toString();
                    Deployment.loadDeployAddinImpl(className);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Deployment.loadFailureError(next.getClass().getName(), e.getMessage());
                }
            }
        }
    }

    public static void init() {
        Deployment.getDT();
    }

    public static DeployProfileDt getProfileDesignTime(Class profileClass) {
        Deployment.processLoad();
        return (DeployProfileDt)_dtRegistry.get(profileClass);
    }

    public static List<DeployProfileDt> getProfileDesignTimeList() {
        ArrayList<DeployProfileDt> result = new ArrayList<DeployProfileDt>();
        Deployment.processLoad();
        for (DeployDesignTime deployDesignTime : _dtRegistry.values()) {
            DeployProfileDt dt;
            if (!(deployDesignTime instanceof DeployProfileDt) || !Profile.class.isAssignableFrom((dt = (DeployProfileDt)deployDesignTime).getDataClass())) continue;
            result.add(dt);
        }
        return result;
    }

    public static Map getProjectProfiles(Project project) {
        DeploymentProfiles profiles = DeploymentProfiles.getInstance((DataContainer)project);
        return profiles.getDefinedProfiles(true);
    }

    public static Map getWorkspaceProfiles(Workspace workspace) {
        HashMap profiles = new HashMap();
        Iterator wspIter = workspace.getChildren();
        while (wspIter.hasNext()) {
            Map projectMap;
            Node project = (Node)wspIter.next();
            if (!(project instanceof Project) || (projectMap = Deployment.getProjectProfiles((Project)project)) == null) continue;
            profiles.putAll(projectMap);
        }
        return profiles;
    }

    public static <T extends Profile> T createDeploymentProfile(DataContainer container, String profileName, Class<T> profileClass) {
        DeployProfileDt dt = Deployment.getProfileDesignTime(profileClass);
        Profile profile = dt.newProfileInstance(container, profileName);
        if (profile != null && profile.getDataContainer() == null) {
            profile.setDataContainer(container);
        }
        return (T)profile;
    }

    public static Profile createDeploymentProfile(HashStructure hash, DataContainer container) throws InstantiationException {
        try {
            Assert.check((hash != null ? 1 : 0) != 0, (String)"HashStructure cannot be null");
            Class profileClass = Profile.getProfileClass(hash, null);
            Constructor profileConstructor = profileClass.getDeclaredConstructor(HashStructure.class);
            Profile typedProfile = (Profile)profileConstructor.newInstance(hash);
            typedProfile.setDataContainer(container);
            Profile profile = typedProfile;
            return profile;
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    static Dt getDT() {
        if (DT_INSTANCE == null) {
            DT_INSTANCE = new Dt();
        }
        return DT_INSTANCE;
    }

    private static synchronized void loadDeployAddin(DeployAddin deployAddin) {
        if (deployAddin != null) {
            if (_scheduled != null) {
                _scheduled.add(deployAddin);
            } else {
                try {
                    deployAddin.startup();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Deployment.loadFailureError(deployAddin.getClass().getName(), e.getMessage());
                }
            }
        }
    }

    private static void loadDeployAddinImpl(String className) throws Exception {
        Class<?> cls = Class.forName(className);
        Deployment.loadDeployAddinImpl(cls);
    }

    private static void loadDeployAddinImpl(Class cls) throws Exception {
        if (cls != null) {
            DeployAddin deployAddin = (DeployAddin)cls.newInstance();
            deployAddin.startup();
        }
    }

    private static void loadFailureError(String className, String reason) {
        System.err.println(DtArb.format(87, className, reason));
    }

    private static DeployDesignTime getDeployDesignTime(Element element) {
        Object data = element.getData();
        if (data == null) {
            return null;
        }
        Class<?> dataClass = data.getClass();
        Deployment.processLoad();
        return Deployment.getDeployDesignTime(dataClass);
    }

    private static DeployDesignTime getDeployDesignTime(Context context) {
        if (context == null) {
            return null;
        }
        Element element = context.getElement();
        if (element == null) {
            return null;
        }
        return Deployment.getDeployDesignTime(element);
    }

    private static DeployDesignTime getDeployDesignTime(Class clazz) {
        Class superClass;
        DeployDesignTime dt = _dtRegistry.get(clazz);
        if (dt == null && (superClass = clazz.getSuperclass()) != null) {
            return Deployment.getDeployDesignTime(superClass);
        }
        return dt;
    }

    private static void maybeInitLogPage() {
        if (logPage == null) {
            logPage = new DeployLogPage();
        }
    }

    public static DependableFactory getDependableFactory() {
        return hashDependableFactory_;
    }

    public void registerDependableFactory(DependableRecognizer recognizer) {
        hashDependableFactory_.registerFactory(recognizer);
    }

    public void removeDependableFactory(DependableRecognizer recognizer) {
        hashDependableFactory_.removeFactory(recognizer);
    }

    static {
        _dtRegistry = new HashMap(23);
        _wizRegistry = new HashMap(23);
        _scheduled = new ArrayList(10);
        hashDependableFactory_ = new HashDependableFactory(null);
    }

    static DeployDesignTime maS$getDeployDesignTime(Context context) {
        return Deployment.getDeployDesignTime(context);
    }

    static DeployDesignTime maS$getDeployDesignTime(Element element) {
        return Deployment.getDeployDesignTime(element);
    }

    static void maS$registerDeployDesignTime(Class clazz, DeployDesignTime deployDesignTime, Wizard wizard, String string, String string2) {
        Deployment.registerDeployDesignTime(clazz, deployDesignTime, wizard, string, string2);
    }

    static final class 1
    implements DeployAddin {
        private final /* synthetic */ DeployDesignTime v$ddt;
        private final /* synthetic */ Class v$dataClass;
        private final /* synthetic */ String v$category;
        private final /* synthetic */ String v$folder;

        public void startup() {
            DeployWizard wizard = this.v$ddt instanceof DeployProfileDt ? new DeployWizard((DeployProfileDt)this.v$ddt) : null;
            Deployment.maS$registerDeployDesignTime(this.v$dataClass, this.v$ddt, wizard, this.v$category, this.v$folder);
        }

        public 1(DeployDesignTime deployDesignTime, Class clazz, String string, String string2) {
            this.v$folder = string2;
            this.v$category = string;
            this.v$dataClass = clazz;
            this.v$ddt = deployDesignTime;
        }
    }

    static final class 2
    implements DeployAddin {
        private final /* synthetic */ Wizard v$wiz;
        private final /* synthetic */ DeployProfileDt v$dpdt;
        private final /* synthetic */ Class v$profileClass;

        public void startup() {
            Wizard wizard = this.v$wiz != null ? this.v$wiz : new DeployWizard(this.v$dpdt);
            Deployment.maS$registerDeployDesignTime(this.v$profileClass, this.v$dpdt, wizard, "General", DtArb.getString(17));
        }

        public 2(Wizard wizard, DeployProfileDt deployProfileDt, Class clazz) {
            this.v$profileClass = clazz;
            this.v$dpdt = deployProfileDt;
            this.v$wiz = wizard;
        }
    }

    private static class Dt
    implements Controller,
    ContextMenuListener,
    NodeInfoLoader,
    MenuListener {
        Dt() {
            NavigatorManager navMan = NavigatorManager.getWorkspaceNavigatorManager();
            if (navMan != null) {
                navMan.addContextMenuListener((ContextMenuListener)this, null);
            }
            XMLRecognizer.treatExtensionAsXML((String)Deployment.DEPLOY_PROFILE_EXT, (NodeInfoLoader)this);
            XMLRecognizer.treatExtensionAsXML((String)Deployment.STORED_PROC_EXPORT_EXT, (NodeInfoLoader)this);
        }

        private IdeAction getIdeAction(String command, Context context) {
            DeployDesignTime ddt = Deployment.maS$getDeployDesignTime(context);
            return ddt != null ? ddt.findOrCreateIdeAction(command) : null;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            Element element = this.getDeployElement(action, context);
            if (element == null) {
                return false;
            }
            DeployDesignTime ddt = Deployment.maS$getDeployDesignTime(element);
            Assert.check((ddt != null ? 1 : 0) != 0, (String)("Cannot handle deploy events for objects of class " + element.getClass()));
            return ddt.handleEvent(action, context);
        }

        public boolean update(IdeAction action, Context context) {
            DeployDesignTime ddt = Deployment.maS$getDeployDesignTime(context);
            return ddt != null ? ddt.update(action, context) : false;
        }

        private Element getDeployElement(IdeAction action, Context context) {
            Profile element;
            if (context == null) {
                Assert.printStackTrace((boolean)false, (String)"Context is null");
                return null;
            }
            Profile profile = DeployUtil.getProfile(context);
            if (profile == null && (profile = DeployUtil.getProfile((Action)action)) != null) {
                DeployUtil.setProfile(context, profile);
            }
            Profile profile2 = element = profile != null ? profile : context.getElement();
            if (element == null) {
                Assert.printStackTrace((boolean)false, (String)"Nothing to deploy");
                return null;
            }
            return element;
        }

        public void menuWillShow(ContextMenu popup) {
            Object nodeData;
            DeployDesignTime ddt;
            Context context = popup.getContext();
            if (DeployDesignTime.isInSupportedNavigator(popup) && (ddt = Deployment.maS$getDeployDesignTime(context)) != null) {
                ddt.menuWillShow(popup);
            }
            DataContainer dc = null;
            Node node = context.getNode();
            if (node != null && (nodeData = node.getData()) != null && (nodeData instanceof Project || nodeData instanceof Workspace)) {
                dc = (DataContainer)nodeData;
            }
            if (dc != null) {
                this.setupDeploymentMenu(popup, dc);
            }
        }

        private void setupDeploymentMenu(ContextMenu contextMenu, DataContainer dc) {
            Profile[] profiles;
            JMenu submenu = contextMenu.createSubMenu(DtArb.getString(127), DtArb.getInteger(75));
            DeploymentProfiles deploymentProfiles = DeploymentProfiles.getInstance(dc);
            Profile[] profileArray = profiles = deploymentProfiles.toSortedArray();
            int n = 0;
            while (n < profileArray.length) {
                Profile profile = profileArray[n];
                String profileName = profile.getShortLabel();
                JMenu profileSubmenu = contextMenu.createSubMenu(profileName, DtArb.getInteger(31));
                profileSubmenu.addMenuListener(this);
                DeployProfileDt profileDt = Deployment.getProfileDesignTime(profile.getClass());
                DeployUtil.setProfile(contextMenu.getContext(), profile);
                profileDt.addDeploymentSubmenu(contextMenu, profileSubmenu);
                submenu.add(profileSubmenu);
                ++n;
            }
            if (submenu.getItemCount() == 0) {
                JMenuItem noDeploy = new JMenuItem(DtArb.getString(20));
                noDeploy.setEnabled(false);
                submenu.add(noDeploy);
            }
            contextMenu.add((Component)submenu, MenuConstants.SECTION_RUN_CTXT_MENU);
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            if (DeployDesignTime.isInSupportedNavigator(context)) {
                DeployDesignTime ddt = Deployment.maS$getDeployDesignTime(context);
                return ddt != null ? ddt.handleDefaultAction(context) : false;
            }
            return false;
        }

        public void loadNodeInfos() {
            Deployment.processLoad();
        }

        public void menuSelected(MenuEvent e) {
            Object object = e.getSource();
            if (object instanceof JMenu) {
                JMenu profileSubmenu = (JMenu)object;
                profileSubmenu.getAccessibleContext().firePropertyChange("AccessibleName", "", profileSubmenu.getText());
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }

        static IdeAction mav$getIdeAction(Dt dt, String string, Context context) {
            return dt.getIdeAction(string, context);
        }
    }

    private static class HashDependableFactory
    extends DependableFactory {
        public Dependable findOrCreate(Element source, Folder owner) throws IllegalAccessException, InstantiationException {
            Dependable dependable = super.findOrCreate(source, owner);
            if (dependable != null && !(dependable instanceof AbstractHashDependable)) {
                this.uncache(dependable);
                throw new InstantiationException("Dependable should derive from AbstractHashDependable");
            }
            return dependable;
        }

        private HashDependableFactory() {
        }

        HashDependableFactory(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

