/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.dt.DeployProfileDt;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdevimpl.deploy.res.DtArb;

final class DeploymentPanelContent
implements ActionListener {
    private JPanel _panel;
    private DataContainer _dc;
    private JButton editButton;
    private JButton newButton;
    private JButton deleteButton;
    private JButton setDefaultButton;
    private Profile _defaultProfile;
    private JTreeCellData _defaultProfileCellData;
    private JMutableTreeNode _root;
    private DefaultTreeModel _treeModel;
    private CustomJTree _tree;
    private JScrollPane profileTreePane;
    private Set usedNames;
    private List newlyCreatedProfiles;
    private DeploymentProfiles _deploymentProfiles;
    private TraversableContext _tc;

    private void $init$() {
        this._root = new JMutableTreeNode(new JTreeCellData(""));
        this._treeModel = new DefaultTreeModel((TreeNode)this._root);
        this._tree = new CustomJTree((TreeModel)this._treeModel);
        this.profileTreePane = new JScrollPane();
        this.usedNames = new TreeSet();
        this.newlyCreatedProfiles = new ArrayList();
    }

    public DeploymentPanelContent(JPanel panel) {
        this.$init$();
        this._panel = panel;
        this._tree.setRootVisible(false);
        this.profileTreePane.getViewport().add((Component)this._tree, null);
        JLabel profilesLabel = new JLabel();
        this.editButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.setDefaultButton = new JButton();
        ResourceUtils.resLabel((JLabel)profilesLabel, (Component)this._tree, (String)DtArb.getString(13));
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)DtArb.getString(16));
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)DtArb.getString(124));
        ResourceUtils.resButton((AbstractButton)this.deleteButton, (String)DtArb.getString(81));
        ResourceUtils.resButton((AbstractButton)this.setDefaultButton, (String)DtArb.getString(72));
        this._tree.addTreeSelectionListener((TreeSelectionListener)new 1());
        this._tree.addMouseListener((MouseListener)new 2());
        this.editButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.setDefaultButton.addActionListener(this);
        this._panel.setLayout(new GridBagLayout());
        int x = 0;
        int y = 0;
        this._panel.add((Component)profilesLabel, new GridBagConstraints(x, y, 0, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 2, 0), 0, 0));
        this._panel.add((Component)this.profileTreePane, new GridBagConstraints(x, ++y, 1, 0, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._panel.add((Component)this.editButton, new GridBagConstraints(++x, y, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this._panel.add((Component)this.newButton, new GridBagConstraints(x, ++y, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this._panel.add((Component)this.deleteButton, new GridBagConstraints(x, ++y, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
    }

    protected JMutableTreeNode addProfileToTree(Profile profile, JMutableTreeNode parentTreeNode) {
        JTreeCellData cellData = this.createJTreeCellData(profile);
        if (cellData != null) {
            cellData.setUserObject((Object)profile);
            JMutableTreeNode childTreeNode = new JMutableTreeNode(cellData);
            parentTreeNode.add((MutableTreeNode)childTreeNode);
            Iterator iter = profile.getChildren();
            if (iter != null) {
                ArrayList<JMutableTreeNode> childrenToAdd = new ArrayList<JMutableTreeNode>();
                while (iter.hasNext()) {
                    Profile childProfile = (Profile)iter.next();
                    JTreeCellData childCellData = this.createJTreeCellData(childProfile);
                    if (childCellData == null) continue;
                    childCellData.setUserObject((Object)childProfile);
                    childrenToAdd.add(new JMutableTreeNode(childCellData));
                }
                if (childrenToAdd.size() > 0) {
                    Collections.sort(childrenToAdd, new JMTNComparator());
                    Iterator addIter = childrenToAdd.iterator();
                    while (addIter.hasNext()) {
                        childTreeNode.add((MutableTreeNode)((JMutableTreeNode)addIter.next()));
                    }
                }
            }
            return childTreeNode;
        }
        return null;
    }

    protected void addChildren(Element parentElem, JMutableTreeNode parentTreeNode) {
        Iterator iter = parentElem.getChildren();
        ArrayList<JMutableTreeNode> childrenToAdd = new ArrayList<JMutableTreeNode>();
        if (iter != null) {
            while (iter.hasNext()) {
                Object child = iter.next();
                Profile profile = (Profile)child;
                JTreeCellData cellData = this.createJTreeCellData(profile);
                if (cellData == null) continue;
                cellData.setUserObject((Object)profile);
                JMutableTreeNode childTreeNode = new JMutableTreeNode(cellData);
                childrenToAdd.add(childTreeNode);
                if (!profile.mayHaveChildren()) continue;
                this.addChildren(profile, childTreeNode);
            }
        }
        if (childrenToAdd.size() > 0) {
            Collections.sort(childrenToAdd, new JMTNComparator());
            Iterator addIter = childrenToAdd.iterator();
            while (addIter.hasNext()) {
                parentTreeNode.add((MutableTreeNode)((JMutableTreeNode)addIter.next()));
            }
        }
    }

    protected JTreeCellData createJTreeCellData(Element elem) {
        JTreeCellData treeCellData = new JTreeCellData(elem.getIcon(), this.getElementDisplayLabel(elem), false);
        treeCellData.setToolTipText(elem.getToolTipText());
        if (this.isDefaultProfile(elem)) {
            this._defaultProfileCellData = treeCellData;
        }
        return treeCellData;
    }

    private Profile getSelectedProfile() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        JTreeCellData cellData = (JTreeCellData)node.getUserObject();
        return (Profile)cellData.getUserObject();
    }

    private boolean isSelectedProfileaChild() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        return node.getLevel() > 1;
    }

    public void setTraversableContext(TraversableContext tc) {
        this._tc = tc;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.editButton) {
            this.editProfile();
        } else if (source == this.newButton) {
            this.newProfile();
        } else if (source == this.deleteButton) {
            this.deleteProfile();
        } else if (source == this.setDefaultButton) {
            this.setDefaultProfile();
        }
    }

    void setSelectionRow() {
        Profile editedProfile;
        this._tree.setSelectionRow(0);
        Context context = (Context)this._tc.find(Context.class);
        if (context != null && (editedProfile = (Profile)context.getProperty("edited-profile")) != null) {
            TreeModel model = this._tree.getModel();
            Object root = model.getRoot();
            int i = 0;
            while (i < model.getChildCount(root)) {
                Object object = model.getChild(root, i);
                JMutableTreeNode treeNode = (JMutableTreeNode)model.getChild(root, i);
                JTreeCellData cellData = (JTreeCellData)treeNode.getUserObject();
                if (cellData.getUserObject().equals(editedProfile)) {
                    this._tree.setSelectionRow(i);
                    break;
                }
                ++i;
            }
        }
    }

    void loadFrom(DataContainer dc) {
        this._dc = dc;
        this._deploymentProfiles = DeploymentProfiles.getInstance(this._dc);
        this._root.removeAllChildren();
        this._defaultProfile = this._deploymentProfiles.getDefaultDeploymentProfile();
        this.addChildren(this._deploymentProfiles, this._root);
        this.updateButtons();
        this.usedNames = this._deploymentProfiles.getProfileNames();
        this._tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)this._root));
        this.setSelectionRow();
    }

    void commitTo() {
        Enumeration e = this._root.children();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        while (e.hasMoreElements()) {
            JMutableTreeNode treeNode = (JMutableTreeNode)e.nextElement();
            JTreeCellData cellData = (JTreeCellData)treeNode.getUserObject();
            profiles.add((Profile)cellData.getUserObject());
        }
        this._deploymentProfiles.setDeploymentProfiles(profiles.toArray(new Profile[0]));
        if (this._defaultProfile != null) {
            this._deploymentProfiles.setDefaultDeploymentProfile(this._defaultProfile);
        }
    }

    private void updateButtons() {
        Profile profile = this.getSelectedProfile();
        if (profile == null) {
            this.newButton.setEnabled(true);
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
        } else if (this.isSelectedProfileaChild()) {
            this.newButton.setEnabled(false);
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
        } else {
            this.newButton.setEnabled(true);
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.setDefaultButton.setEnabled(true);
        }
    }

    private void editProfile() {
        Profile profile = this.getSelectedProfile();
        if (profile != null) {
            this.editProfile(profile);
        }
    }

    private void editProfile(Profile profile) {
        try {
            DeployProfileDt dt = Deployment.getProfileDesignTime(profile.getClass());
            dt.launchDialog(this.getContext(), profile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void newProfile() {
        Object newProfile;
        NewDialog newDialog = new NewDialog(this.usedNames);
        ProfileInfo profileInfo = newDialog.showDialog();
        if (profileInfo != null && (newProfile = Deployment.createDeploymentProfile(this._dc, profileInfo.profileName, profileInfo.profileDt.getDataClass())) != null) {
            JMutableTreeNode newNode = this.addProfileToTree((Profile)newProfile, this._root);
            TreePath path = new TreePath(((DefaultMutableTreeNode)newNode).getPath());
            this._tree.setSelectionPath(path);
            this._tree.updateUI();
            this.updateButtons();
            this.usedNames.add(profileInfo.profileName);
            this.newlyCreatedProfiles.add(newProfile);
            this.commitTo();
        }
    }

    private boolean isDefaultProfile(Element elem) {
        Profile profile;
        return elem instanceof Profile && (profile = (Profile)elem).equals(this._defaultProfile);
    }

    private String getElementDisplayLabel(Element elem) {
        String label = elem.getShortLabel();
        if (this.isDefaultProfile(elem)) {
            label = label + " " + DtArb.getString(21);
        }
        return label;
    }

    private void setDefaultProfile() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        JTreeCellData cellData = (JTreeCellData)node.getUserObject();
        Profile profile = (Profile)cellData.getUserObject();
        if (profile == null) {
            return;
        }
        this._defaultProfile = profile;
        if (this._defaultProfileCellData != null) {
            this._defaultProfileCellData.setText(this.getElementDisplayLabel((Element)this._defaultProfileCellData.getUserObject()));
        }
        this._defaultProfileCellData = cellData;
        this._defaultProfileCellData.setText(this.getElementDisplayLabel((Element)this._defaultProfileCellData.getUserObject()));
        this._tree.updateUI();
    }

    private void deleteProfile() {
        int selectedRow = -1;
        TreePath currentSelection = this._tree.getSelectionPath();
        if (currentSelection != null) {
            selectedRow = this._tree.getMinSelectionRow();
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
            JMutableTreeNode parent = (JMutableTreeNode)currentNode.getParent();
            if (parent != null) {
                Profile profile = this.getSelectedProfile();
                String profileName = profile.getName();
                this._treeModel.removeNodeFromParent(currentNode);
                if (selectedRow + 1 < this._tree.getRowCount()) {
                    this._tree.setSelectionRow(selectedRow + 1);
                } else if (selectedRow - 1 >= -1) {
                    this._tree.setSelectionRow(selectedRow - 1);
                }
                this._tree.updateUI();
                this.updateButtons();
                this.usedNames.remove(profileName);
                if (this.newlyCreatedProfiles.contains(profile)) {
                    this.newlyCreatedProfiles.remove(profile);
                }
                if (profile.equals(this._defaultProfile)) {
                    this._defaultProfile = null;
                }
                this.commitTo();
            }
        }
    }

    public void finishNewProfileCreation() {
        Iterator iter = this.newlyCreatedProfiles.iterator();
        Context context = this.getContext();
        while (iter.hasNext()) {
            Profile newProfile = (Profile)iter.next();
            DeployProfileDt dt = Deployment.getProfileDesignTime(newProfile.getClass());
            dt.finishCreation(context, newProfile);
        }
    }

    private Context getContext() {
        Context context = Context.newIdeContext();
        if (this._dc instanceof Project) {
            context.setProject((Project)this._dc);
        } else if (this._dc instanceof Workspace) {
            context.setWorkspace((Workspace)this._dc);
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (selectedNode != null) {
            JTreeCellData selectedCell = (JTreeCellData)selectedNode.getUserObject();
            Profile selectedProfile = (Profile)selectedCell.getUserObject();
            context.setProperty("edited-profile", (Object)selectedProfile);
        }
        if (this._dc != null) {
            DeployUtil.setProfileDataContainer(context, this._dc);
        }
        return context;
    }

    static DataContainer ra$_dc(DeploymentPanelContent deploymentPanelContent) {
        return deploymentPanelContent._dc;
    }

    static void mav$updateButtons(DeploymentPanelContent deploymentPanelContent) {
        deploymentPanelContent.updateButtons();
    }

    static CustomJTree ra$_tree(DeploymentPanelContent deploymentPanelContent) {
        return deploymentPanelContent._tree;
    }

    static void mav$editProfile(DeploymentPanelContent deploymentPanelContent) {
        deploymentPanelContent.editProfile();
    }

    final class 1
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            DeploymentPanelContent.mav$updateButtons(DeploymentPanelContent.this);
        }
    }

    final class 2
    extends MouseAdapter {
        DefaultMutableTreeNode node;

        public void mousePressed(MouseEvent e) {
            TreePath path = DeploymentPanelContent.ra$_tree(DeploymentPanelContent.this).getPathForLocation(e.getX(), e.getY());
            if (path != null && e.getClickCount() == 2) {
                DeploymentPanelContent.mav$editProfile(DeploymentPanelContent.this);
            }
        }
    }

    class NewDialog
    extends JPanel
    implements DocumentListener,
    ActionListener {
        private JTextField nameTextField;
        private DescriptionScrollPane descrScrollPane;
        private JComboBox archiveTypeComboBox;
        private JEWTDialog dlg;
        private Set usedNames;
        private HashMap profileNameClassPair;
        private ProfileInfo profileInfo;
        private boolean _nameModifiedByUser;

        private void $init$() {
            this.descrScrollPane = new DescriptionScrollPane();
            this.profileNameClassPair = new HashMap();
            this.profileInfo = new ProfileInfo();
            this._nameModifiedByUser = false;
        }

        NewDialog(Set usedNames) {
            super(new GridBagLayout());
            this.$init$();
            Dimension dim = new Dimension(300, 200);
            this.setPreferredSize(dim);
            this.usedNames = usedNames;
            JLabel nameLabel = new JLabel();
            this.nameTextField = new JTextField();
            JLabel archiveTypeLabel = new JLabel();
            JLabel descrLabel = new JLabel();
            List<DeployProfileDt> profileDtList = Deployment.getProfileDesignTimeList();
            ArrayList<String> archiveTypeArray = new ArrayList<String>();
            String defaultType = "";
            int i = 0;
            while (i < profileDtList.size()) {
                DeployProfileDt profileDt = profileDtList.get(i);
                if (DeploymentPanelContent.ra$_dc(DeploymentPanelContent.this) instanceof Workspace && profileDt.supportsApplicationLevelCreation() || DeploymentPanelContent.ra$_dc(DeploymentPanelContent.this) instanceof Project && profileDt.supportsProjectLevelCreation()) {
                    archiveTypeArray.add(profileDt.getDisplayName());
                    boolean isDefaultProfileType = false;
                    if (defaultType == null || defaultType.length() == 0) {
                        if (DeploymentPanelContent.ra$_dc(DeploymentPanelContent.this) instanceof Workspace && profileDt.getDataClass().getSimpleName().equals("EarProfile")) {
                            isDefaultProfileType = true;
                        } else if (DeploymentPanelContent.ra$_dc(DeploymentPanelContent.this) instanceof Project && profileDt.getDataClass().getSimpleName().equals("ArchiveProfile")) {
                            isDefaultProfileType = true;
                        }
                    }
                    if (isDefaultProfileType) {
                        defaultType = profileDt.getDisplayName();
                        this.profileInfo.profileDt = profileDt;
                        this.nameTextField.setText(profileDt.getUniqueName(usedNames));
                        this.descrScrollPane.setText(profileDt.getLongLabel());
                    }
                    this.profileNameClassPair.put(profileDt.getDisplayName(), profileDt);
                }
                ++i;
            }
            Collections.sort(archiveTypeArray);
            this.archiveTypeComboBox = new JComboBox(new NonNullableComboBoxModel(archiveTypeArray.toArray()));
            this.archiveTypeComboBox.setSelectedItem(defaultType);
            this.archiveTypeComboBox.addActionListener(this);
            ResourceUtils.resLabel((JLabel)descrLabel, (Component)this.descrScrollPane.getLabelComponent(), (String)DtArb.getString(98));
            ResourceUtils.resLabel((JLabel)nameLabel, (Component)this.nameTextField, (String)DtArb.getString(130));
            ResourceUtils.resLabel((JLabel)archiveTypeLabel, (Component)this.archiveTypeComboBox, (String)DtArb.getString(113));
            this.nameTextField.getDocument().addDocumentListener(this);
            int y = 0;
            this.add((Component)archiveTypeLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.archiveTypeComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)nameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            this.add((Component)this.nameTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)descrLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            this.add((Component)this.descrScrollPane, new GridBagConstraints(0, y++, 0, 0, 1.0, 0.0, 17, 1, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        ProfileInfo showDialog() {
            String title = DtArb.getString(1);
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.nameTextField, (String)title);
            this.setJEWTDialog(dlg);
            dlg.setOKButtonEnabled(this.canOk());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_newdeploymentprofile_html");
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                this.profileInfo.profileName = this.getNewName();
                return this.profileInfo;
            }
            return null;
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
            dlg.addVetoableChangeListener((VetoableChangeListener)new 1());
        }

        public void actionPerformed(ActionEvent e) {
            DeployProfileDt dt;
            JComboBox cb = (JComboBox)e.getSource();
            String archiveType = (String)cb.getSelectedItem();
            this.profileInfo.profileDt = dt = (DeployProfileDt)this.profileNameClassPair.get(archiveType);
            if (!this._nameModifiedByUser) {
                this.nameTextField.getDocument().removeDocumentListener(this);
                this.nameTextField.setText(dt.getUniqueName(this.usedNames));
                this.nameTextField.getDocument().addDocumentListener(this);
            }
            this.descrScrollPane.setText(dt.getLongLabel());
        }

        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            this._nameModifiedByUser = true;
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        private boolean canOk() {
            return this.nameTextField.getText().length() > 0;
        }

        private boolean veto() {
            String name = this.nameTextField.getText();
            if (this.usedNames.contains(name)) {
                MessageDialog.error((Component)this, (Object)DtArb.format(109, name), (String)DtArb.format(38, this.dlg.getTitle()), null);
                return true;
            }
            if (name.length() < 3) {
                MessageDialog.error((Component)this, (Object)DtArb.getString(33), (String)DtArb.format(38, this.dlg.getTitle()), null);
                return true;
            }
            return false;
        }

        private String getNewName() {
            return this.nameTextField.getText();
        }

        static boolean mav$veto(NewDialog newDialog) {
            return newDialog.veto();
        }

        final class 1
        implements VetoableChangeListener {
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && NewDialog.mav$veto(NewDialog.this)) {
                    throw new PropertyVetoException("no", evt);
                }
            }
        }
    }

    class ProfileInfo {
        public String profileName;
        public DeployProfileDt profileDt;

        ProfileInfo() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JMTNComparator
    implements Comparator {
        private final Collator _collator;

        private void $init$() {
            this._collator = Collator.getInstance();
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            JMutableTreeNode node1 = (JMutableTreeNode)o1;
            JMutableTreeNode node2 = (JMutableTreeNode)o2;
            return this._collator.compare(node1.getModel().getText(), node2.getModel().getText());
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o.getClass() == this.getClass();
        }

        protected JMTNComparator() {
            this.$init$();
        }
    }
}

